/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.AbstractCurrentPortOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateCurrentPortOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.CreateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICreateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.common.IContentChangeDetail;
import com.ibm.team.filesystem.common.IEncodingChangeDetail;
import com.ibm.team.filesystem.common.ILineDelimiterChangeDetail;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatchInput;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CreateCurrentPatchOperation
extends AbstractCurrentPortOperation
implements ICreateCurrentPatchOperation {
    private ICurrentPatchInput input;
    private Map<UUID, Map<UUID, IFolderHandle>> subtreesToAdd = new HashMap<UUID, Map<UUID, IFolderHandle>>();

    public CreateCurrentPatchOperation(CreateCurrentPatchDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    @Override
    public void setContext(IWorkspaceConnection connection, IComponentHandle component) {
        super.setContext(connection, component);
        this.input = connection.getCurrentPatchOperationFactory().createCurrentPatchInput();
    }

    @Override
    protected String getOperationLabel() {
        return Messages.ApplyAsPatchOperation_0;
    }

    @Override
    public void applyStateChange(IVersionableHandle item, UUID before, UUID after) {
        this.input.applyStateChange(item, before, after);
    }

    private boolean hasStateChange(IVersionableHandle versionable) {
        return this.input.hasStateChange(versionable);
    }

    @Override
    public void applyConflict(ILogicalChange conflict) throws TeamRepositoryException {
        if (conflict.kind() == 3 && conflict.isChangeType(2)) {
            return;
        }
        if (this.isIncomingCrossComponentMove(conflict)) {
            ILogicalConflict lc;
            if (conflict instanceof ILogicalConflict && (lc = (ILogicalConflict)conflict).conflictType() == 3) {
                for (Object o : lc.conflictingItems()) {
                    IVersionableHandle conflictingItem = (IVersionableHandle)o;
                    if (conflictingItem instanceof IFolderHandle) {
                        IFolderHandle folderHandle = (IFolderHandle)conflictingItem;
                        this.applyAddSubtree(lc.component(), folderHandle);
                        continue;
                    }
                    this.applyStateChange(conflictingItem, null, conflictingItem.getStateId());
                }
                return;
            }
            IItemConflictReport itemConflict = this.findUnderlyingConflict(this.getConnection(), conflict);
            this.applyStateChange(itemConflict.item(), itemConflict.getCommonAncestorState() == null ? null : itemConflict.getCommonAncestorState().getStateId(), itemConflict.getSelectedContributorState() == null ? null : itemConflict.getSelectedContributorState().getStateId());
        } else if (this.isMoveToMissingParent(conflict)) {
            this.applyStateChange(conflict);
            if (conflict.item() instanceof IFolderHandle) {
                IFolderHandle folderHandle = (IFolderHandle)conflict.item();
                this.applyAddSubtree(conflict.component(), folderHandle);
            }
        } else {
            this.applyStateChange(conflict);
        }
    }

    private void applyStateChange(ILogicalChange conflict) {
        this.applyStateChange(conflict.item(), conflict.beforeState() == null ? null : conflict.beforeState().getStateId(), conflict.afterState() == null ? null : conflict.afterState().getStateId());
    }

    private boolean isMoveToMissingParent(ILogicalChange change) {
        if (change.kind() == 1) {
            ILogicalConflict lc = (ILogicalConflict)change;
            return lc.conflictType() == 8;
        }
        return false;
    }

    private void applyAddSubtree(IComponentHandle componentHandle, IFolderHandle conflictingItem) {
        Map<UUID, IFolderHandle> componentSubtrees = this.subtreesToAdd.get(componentHandle.getItemId());
        if (componentSubtrees == null) {
            componentSubtrees = new HashMap<UUID, IFolderHandle>();
            this.subtreesToAdd.put(componentHandle.getItemId(), componentSubtrees);
        }
        componentSubtrees.put(conflictingItem.getItemId(), conflictingItem);
    }

    private boolean isIncomingCrossComponentMove(ILogicalChange change) {
        if (change.kind() == 1) {
            ILogicalConflict lc = (ILogicalConflict)change;
            return lc.conflictType() == 5 || lc.conflictType() == 3 || lc.conflictType() == 4;
        }
        return false;
    }

    private IItemConflictReport findUnderlyingConflict(IWorkspaceConnection sourceWorkspace, ILogicalChange conflict) throws TeamRepositoryException {
        IUpdateReport report = sourceWorkspace.conflictReport(conflict.component());
        for (IItemConflictReport icr : report.conflicts()) {
            if (!icr.item().sameItemId((IItemHandle)conflict.item())) continue;
            return icr;
        }
        return null;
    }

    @Override
    protected void doExecute(HashSet<ConfigurationFacade> configurationsToLock, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        if (configurationsToLock.size() > 0) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(3 + this.subtreesToAdd.size()));
            for (ConfigurationFacade configurationFacade : configurationsToLock) {
                IWorkspaceConnection wc = (IWorkspaceConnection)configurationFacade.getCachedConnection();
                if (wc == null) continue;
                IComponentHandle componentHandle = configurationFacade.getComponentHandle();
                for (Map.Entry<UUID, Map<UUID, IFolderHandle>> entry : this.subtreesToAdd.entrySet()) {
                    IComponentHandle conflictComponent = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(entry.getKey(), null);
                    IConfiguration configuration = wc.configuration(conflictComponent);
                    for (IFolderHandle folderHandle : entry.getValue().values()) {
                        this.addSubtreeToInput(configuration, (IVersionableHandle)folderHandle, (IProgressMonitor)progress);
                    }
                }
                IUpdateReport report = wc.createCurrentPatch(this.getComponent(), this.input, (IProgressMonitor)progress.newChild(1));
                UpdateOperation updateOperation = new UpdateOperation(this.getConnection(), Collections.singletonList(report), 3, this.getUpdateDilemmaHandler(), null);
                this.disableVerifyInSync(updateOperation);
                updateOperation.run((IProgressMonitor)progress.newChild(1));
                if (!this.isLoaded(configurationFacade, (IProgressMonitor)progress.newChild(1))) continue;
                this.performContentChanges(wc, componentHandle, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    private void addSubtreeToInput(IConfiguration configuration, IVersionableHandle versionable, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.hasStateChange(versionable)) {
            this.applyStateChange(versionable, null, versionable.getStateId());
        }
        if (versionable instanceof IFolderHandle) {
            IFolderHandle folder = (IFolderHandle)versionable;
            try {
                Map childEntries = configuration.childEntries(folder, monitor);
                for (Object o : childEntries.values()) {
                    this.addSubtreeToInput(configuration, (IVersionableHandle)o, monitor);
                }
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
    }

    private boolean isLoaded(ConfigurationFacade configuration, IProgressMonitor monitor) throws FileSystemException {
        ICopyFileAreaManager copyFileAreaManager = ICopyFileAreaManager.instance;
        Collection<ICopyFileArea> copyFileAreas = copyFileAreaManager.getCopyFileAreasForConfiguration(configuration, monitor);
        return !copyFileAreas.isEmpty();
    }

    private void performContentChanges(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IProgressMonitor progress) {
        UpdateCurrentPortOperation updateOperation = (UpdateCurrentPortOperation)IOperationFactory.instance.getUpdateCurrentPortOperation(this.getApplyAsPatchDilemmaHandler().getUpdateCurrentPortDilemmaHandler());
        updateOperation.setFileContentMerger(this.getFileContentMerger());
        updateOperation.setContext(workspaceConnection, componentHandle);
        if (updateOperation.autoResolveChanges(IContentChangeDetail.class, true)) {
            try {
                updateOperation.run(progress);
            }
            catch (TeamRepositoryException e) {
                this.handleProblem(e);
            }
        }
        this.performPostContentChangeEncodingChanges(workspaceConnection, componentHandle, progress);
    }

    private CreateCurrentPatchDilemmaHandler getApplyAsPatchDilemmaHandler() {
        return (CreateCurrentPatchDilemmaHandler)this.getDilemmaHandler();
    }

    private void performPostContentChangeEncodingChanges(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IProgressMonitor progress) {
        UpdateCurrentPortOperation updateOperation = (UpdateCurrentPortOperation)IOperationFactory.instance.getUpdateCurrentPortOperation(UpdateCurrentPatchDilemmaHandler.getDefault());
        updateOperation.setFileContentMerger(this.getFileContentMerger());
        updateOperation.setContext(workspaceConnection, componentHandle);
        boolean hasMoreChanges = updateOperation.autoResolveChanges(IEncodingChangeDetail.class, true);
        if (hasMoreChanges |= updateOperation.autoResolveChanges(ILineDelimiterChangeDetail.class, true)) {
            try {
                updateOperation.run(progress);
            }
            catch (TeamRepositoryException e) {
                this.handleProblem(e);
            }
        }
    }

    private void handleProblem(TeamRepositoryException e) {
        this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
    }
}

