/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.CloseChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICloseChangeSetsOperation;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class CloseChangeSetsOperation
extends FileSystemOperation
implements ICloseChangeSetsOperation {
    private IWorkspaceConnection workspaceConnection;
    private Map<UUID, IChangeSetHandle> changeSets = new HashMap<UUID, IChangeSetHandle>();

    public CloseChangeSetsOperation(DilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? CloseChangeSetsDilemmaHandler.getDefault() : dilemmaHandler);
    }

    private CloseChangeSetsDilemmaHandler getCloseChangeSetDilemmaHandler() {
        return (CloseChangeSetsDilemmaHandler)this.getDilemmaHandler();
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (this.workspaceConnection == null) {
            throw new IllegalStateException("Caller must configure the workspace connection before running the operation.");
        }
        Map<UUID, IChangeSet> targetChangeSets = this.findTargetChangeSets(monitor);
        if (!targetChangeSets.isEmpty()) {
            int instruction = this.getCloseChangeSetDilemmaHandler().portsInProgress(new ArrayList<IChangeSet>(targetChangeSets.values()));
            switch (instruction) {
                case 0: {
                    for (IChangeSet changeSet : targetChangeSets.values()) {
                        this.changeSets.remove(changeSet.getItemId());
                    }
                    break;
                }
                case 1: {
                    throw new OperationCanceledException();
                }
                default: {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.CloseChangeSetsOperation_PendingGapResolution, (Object)this.workspaceConnection.getName(), (Object[])new Object[0]));
                }
            }
        }
        this.workspaceConnection.ensureClosed(this.changeSets.values(), monitor);
    }

    private Map<UUID, IChangeSet> findTargetChangeSets(IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, IChangeSet> result = new HashMap<UUID, IChangeSet>();
        HashSet<UUID> targets = new HashSet<UUID>();
        for (Object o : this.workspaceConnection.getComponents()) {
            IComponentHandle component;
            ICurrentPatch cp;
            if (!(o instanceof IComponentHandle) || (cp = this.workspaceConnection.getCurrentPatch(component = (IComponentHandle)o)) == null || cp.getTargetChangeSet() == null) continue;
            targets.add(cp.getTargetChangeSet().getItemId());
        }
        for (IChangeSetHandle changeSetHandle : this.changeSets.values()) {
            if (!targets.contains(changeSetHandle.getItemId())) continue;
            IChangeSet changeSet = (IChangeSet)this.workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 0, monitor);
            result.put(changeSet.getItemId(), changeSet);
        }
        return result;
    }

    @Override
    public void ensureClosed(List<IChangeSetHandle> newChangeSets) {
        for (IChangeSetHandle changeSetHandle : newChangeSets) {
            this.changeSets.put(changeSetHandle.getItemId(), changeSetHandle);
        }
    }

    @Override
    public void setContext(IWorkspaceConnection workspaceConnection) {
        this.workspaceConnection = workspaceConnection;
    }
}

