/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public abstract class ChangeHistoryChangeSetsOperation
extends FileSystemOperation
implements IRefreshingOperation,
ICheckinOptions {
    private boolean refreshBeforeRun = false;
    protected boolean nonAtomicCommitIsAnOption = true;
    protected int nonAtomicCommitFileUploadLimit = 200;

    protected ChangeHistoryChangeSetsOperation(ChangeHistoryChangeSetsDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    @Override
    public final void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    @Override
    public final boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    protected abstract void refreshLocal(IFilesystemRefresher var1, Map<ISandbox, Set<ConfigurationFacade>> var2, IProgressMonitor var3) throws FileSystemException, TeamRepositoryException;

    protected void checkinPendingChanges(Set<ConfigurationFacade> affectedConfigurations, ChangeHistoryChangeSetsDilemmaHandler problemHandler, boolean locksAcquired, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        this.checkinPendingChanges(affectedConfigurations, problemHandler, locksAcquired, false, progress);
    }

    protected void checkinPendingChanges(final Set<ConfigurationFacade> affectedConfigurations, final ChangeHistoryChangeSetsDilemmaHandler problemHandler, boolean locksAcquired, final boolean forSubcomponents, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        if (locksAcquired) {
            this.checkinPendingChanges(forSubcomponents, affectedConfigurations, problemHandler, monitor);
        } else {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
                    try {
                        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            ChangeHistoryChangeSetsOperation.this.checkinPendingChanges(forSubcomponents, affectedConfigurations, problemHandler, (IProgressMonitor)progress.newChild(98));
                        }
                        finally {
                            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.ChangeHistoryChangeSetsOperation_1, monitor);
        }
    }

    private void checkinPendingChanges(boolean forSubcomponents, Set<ConfigurationFacade> affectedConfigurations, ChangeHistoryChangeSetsDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        HashMap<ConfigurationFacade, Collection<ILocalChange>> checkin = new HashMap<ConfigurationFacade, Collection<ILocalChange>>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)150);
        Map<ISandbox, Set<ConfigurationFacade>> affectedAreas = this.getCopyFileAreasAffected(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        if (this.getRefreshBeforeRun()) {
            progress.setTaskName(Messages.ChangeHistoryChangeSetsOperation_REFRESHING_FILESYSTEM);
            Refresher refresher = new Refresher();
            this.refreshLocal(refresher, affectedAreas, (IProgressMonitor)progress.newChild(10));
            List<IShareable> shareables = ChangeSetRefreshUtils.rationalizeRefreshTree(refresher.shareables);
            progress.setWorkRemaining(110 + shareables.size() * 2);
            for (IShareable shareable : shareables) {
                ((Shareable)shareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(1));
            }
            LocalChangeManager.getInstance().refreshChanges(shareables, (IProgressMonitor)progress.newChild(shareables.size()));
            SubMonitor syncMon = progress.newChild(10);
            syncMon.setWorkRemaining(affectedAreas.size());
            for (Map.Entry<ISandbox, Set<ConfigurationFacade>> area : affectedAreas.entrySet()) {
                SubMonitor descMon = syncMon.newChild(1);
                descMon.setWorkRemaining(area.getValue().size());
                for (ConfigurationFacade desc : area.getValue()) {
                    LocalChangeManager.getInstance().syncPendingChanges(desc.getConnectionHandle(), desc.getComponentHandle(), area.getKey(), (IProgressMonitor)descMon.newChild(1));
                }
            }
        }
        progress.setWorkRemaining(100);
        SubMonitor iterProgress = progress.newChild(5).setWorkRemaining(affectedAreas.size());
        for (Map.Entry<ISandbox, Set<ConfigurationFacade>> entry : affectedAreas.entrySet()) {
            ISandbox sandbox = entry.getKey();
            Set<ConfigurationFacade> configurationsForCFA = entry.getValue();
            SubMonitor subIterProgress = iterProgress.newChild(1).setWorkRemaining(configurationsForCFA.size() * 2);
            for (ConfigurationFacade descriptor : configurationsForCFA) {
                ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
                lcm.syncPendingChanges(descriptor.getConnectionHandle(), descriptor.getComponentHandle(), sandbox, (IProgressMonitor)subIterProgress.newChild(1));
                ILocalChange[] localChanges = lcm.getPendingChanges(descriptor.getConnectionHandle(), descriptor.getComponentHandle(), sandbox);
                if (this.refreshBeforeRun && localChanges.length > 0) {
                    ArrayList<IShareable> shareables = new ArrayList<IShareable>();
                    ILocalChange[] iLocalChangeArray = localChanges;
                    int n = localChanges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILocalChange change = iLocalChangeArray[n2];
                        IShareable shareable = change.getShareable();
                        if (shareable != null) {
                            shareables.add(shareable);
                        }
                        ++n2;
                    }
                    lcm.refreshChanges(shareables, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)subIterProgress.newChild(1));
                    localChanges = lcm.getPendingChanges(descriptor.getConnectionHandle(), descriptor.getComponentHandle(), sandbox);
                }
                if (localChanges.length <= 0) continue;
                List<ILocalChange> changes = Arrays.asList(localChanges);
                changes = Collections.unmodifiableList(changes);
                checkin.put(descriptor, changes);
            }
        }
        this.processLocalChanges(problemHandler, checkin, forSubcomponents, progress);
        progress.done();
    }

    protected void processLocalChanges(ChangeHistoryChangeSetsDilemmaHandler problemHandler, HashMap<ConfigurationFacade, Collection<ILocalChange>> checkin, boolean forSubcomponents, SubMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (!checkin.isEmpty()) {
            int result;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            int n = result = forSubcomponents ? problemHandler.uncheckedInChangesInSubcomponents(Collections.unmodifiableMap(checkin), (IProgressMonitor)progress.newChild(10)) : problemHandler.uncheckedInChanges(Collections.unmodifiableMap(checkin));
            if (result == 0) {
                progress.setWorkRemaining(90 + checkin.size() * 2);
                ICheckinOperation op = IOperationFactory.instance.getCheckinOperation(problemHandler.getCommitDilemmaHandler(), this.getRepositoryResolver(checkin.keySet()));
                if (this.nonAtomicCommitIsAnOption) {
                    op.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                } else {
                    op.disableNonAtomicCommit();
                }
                op.setRefreshBeforeRun(false);
                for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : checkin.entrySet()) {
                    Collection<ILocalChange> changesToCheckin = entry.getValue();
                    ILocalChange[] changes = changesToCheckin.toArray(new ILocalChange[changesToCheckin.size()]);
                    if (changesToCheckin.isEmpty()) continue;
                    op.requestCheckin(changes, null, "", (IProgressMonitor)progress.newChild(1));
                }
                this.disableVerifyInSync(op);
                op.run((IProgressMonitor)progress.newChild(90));
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                if (result != 3) {
                    throw new FileSystemException(Messages.ChangeHistoryChangeSetsOperation_0);
                }
            }
        }
    }

    private IRepositoryResolver getRepositoryResolver(Set<ConfigurationFacade> configurations) {
        final HashMap<UUID, ITeamRepository> repos = new HashMap<UUID, ITeamRepository>();
        for (ConfigurationFacade configuration : configurations) {
            ITeamRepository teamRepository = null;
            try {
                teamRepository = configuration.getTeamRepository();
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
            if (teamRepository == null) continue;
            repos.put(configuration.getRepositoryId(), teamRepository);
        }
        return new IRepositoryResolver(){

            @Override
            public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                return (ITeamRepository)repos.get(id);
            }
        };
    }

    protected final Map<ISandbox, Set<ConfigurationFacade>> getCopyFileAreasAffected(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws FileSystemException {
        HashMap<ISandbox, Set<ConfigurationFacade>> result = new HashMap<ISandbox, Set<ConfigurationFacade>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)affectedConfigurations.size());
        ICopyFileAreaManager copyFileAreaManager = ICopyFileAreaManager.instance;
        for (ConfigurationFacade configuration : affectedConfigurations) {
            Collection<ICopyFileArea> copyFileAreas = copyFileAreaManager.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)monitor.newChild(1));
            for (ICopyFileArea cfa : copyFileAreas) {
                Sandbox sandbox = new Sandbox(cfa);
                HashSet<ConfigurationFacade> configurations = (HashSet<ConfigurationFacade>)result.get(sandbox);
                if (configurations == null) {
                    configurations = new HashSet<ConfigurationFacade>();
                    result.put(sandbox, configurations);
                }
                configurations.add(configuration);
            }
        }
        return result;
    }

    @Override
    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    @Override
    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }

    private static class Refresher
    implements IFilesystemRefresher {
        private List<IShareable> shareables = new LinkedList<IShareable>();
        private Map<ISandbox, Map<UUID, Set<UUID>>> fullyRefreshedComponents = new HashMap<ISandbox, Map<UUID, Set<UUID>>>();

        private Refresher() {
        }

        @Override
        public void addToRefresh(IShareable toAdd) {
            this.shareables.add(toAdd);
        }

        @Override
        public void addToRefresh(Collection<IShareable> toAdd) {
            this.shareables.addAll(toAdd);
        }

        @Override
        public void addToRefresh(Collection<ISandbox> affectedAreas, IContextHandle contextHandle, IComponentHandle component, IProgressMonitor progress) throws FileSystemException {
            SubMonitor sbMon = SubMonitor.convert((IProgressMonitor)progress);
            sbMon.setWorkRemaining(affectedAreas.size());
            for (ISandbox sandbox : affectedAreas) {
                if (!this.shouldRefreshComponent(sandbox, contextHandle, component)) continue;
                IShare[] iShareArray = SharingManager.getInstance().allShares(sandbox.getRoot(), contextHandle, component, (IProgressMonitor)sbMon.newChild(1));
                int n = iShareArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IShare share = iShareArray[n2];
                    this.addToRefresh(share.getShareable());
                    ++n2;
                }
            }
        }

        private boolean shouldRefreshComponent(ISandbox sandbox, IContextHandle context, IComponentHandle component) {
            Set<UUID> refreshedComponents;
            Map<UUID, Set<UUID>> refreshedContexts = this.fullyRefreshedComponents.get(sandbox);
            if (refreshedContexts == null) {
                refreshedContexts = new HashMap<UUID, Set<UUID>>();
                this.fullyRefreshedComponents.put(sandbox, refreshedContexts);
            }
            if ((refreshedComponents = refreshedContexts.get(context.getItemId())) == null) {
                refreshedComponents = new HashSet<UUID>();
                refreshedContexts.put(context.getItemId(), refreshedComponents);
            }
            return refreshedComponents.add(component.getItemId());
        }
    }
}

