/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IApplyAcceptedOperation;
import com.ibm.team.filesystem.client.IMarkAsMergedOperation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.checkin.ChangeSetChooser;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FailedAutoResolveRequest;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.RemoteAutoResolver;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.client.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.linktypes.client.ILinkTypeClientLibrary;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.ProducesOrphansInConfigurationException;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.gc.ExternalLink;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.gc.ExternalLinksVisitor;
import com.ibm.team.scm.common.internal.gc.LinkDiffReport;
import com.ibm.team.scm.common.internal.gc.LinkUtils;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.links.LinkTypeIdentifier;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class AutoResolveOperation
extends FileSystemOperation
implements IAutoResolveConflictsOperation {
    private final AutoResolveConflictsDilemmaHandler problemHandler;
    private ApplyAcceptedDilemmaHandler applyAcceptedDilemmaHandler;
    private MarkAsMergedDilemmaHandler markAsMergedDilemmaHandler;
    private OutOfSyncDilemmaHandler outOfSyncDilemmaHandler;
    private int conflictsResolvedCount;
    private Shed shed;
    private final HashMap<UUID, IWorkspaceConnection> workspaces = new HashMap();
    private final HashMap<UUID, List<AutoResolveRequest>> contentConflicts;
    private final HashMap<UUID, List<AutoResolveRequest>> autoMergeableConflicts;
    private final HashMap<UUID, List<AutoResolveRequest>> evilTwinConflicts;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;
    private final IRepositoryResolver resolver;

    public AutoResolveOperation(AutoResolveConflictsDilemmaHandler dilemmaHandler, IRepositoryResolver resolver) {
        super(dilemmaHandler == null ? AutoResolveConflictsDilemmaHandler.getDefault() : dilemmaHandler);
        this.resolver = resolver;
        this.problemHandler = dilemmaHandler == null ? AutoResolveConflictsDilemmaHandler.getDefault() : dilemmaHandler;
        this.applyAcceptedDilemmaHandler = this.problemHandler.getApplyAcceptedDilemmaHandler();
        if (this.applyAcceptedDilemmaHandler == null) {
            this.applyAcceptedDilemmaHandler = ApplyAcceptedDilemmaHandler.getDefault();
        }
        this.markAsMergedDilemmaHandler = this.problemHandler.getMarkAsMergedDilemmaHandler();
        if (this.markAsMergedDilemmaHandler == null) {
            this.markAsMergedDilemmaHandler = MarkAsMergedDilemmaHandler.getDefault();
        }
        this.outOfSyncDilemmaHandler = this.problemHandler.getOutOfSyncDilemmaHandler();
        if (this.outOfSyncDilemmaHandler == null) {
            this.outOfSyncDilemmaHandler = OutOfSyncDilemmaHandler.getDefault();
        }
        this.contentConflicts = new HashMap();
        this.autoMergeableConflicts = new HashMap();
        this.evilTwinConflicts = new HashMap();
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
        this.conflictsResolvedCount = 0;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations();
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        if (AutoResolveOperation.this.verifyInSyncEnabled() && !AutoResolveOperation.this.outOfSyncDilemmaHandler.willIgnoreAllSharesOutOfSync()) {
                            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(AutoResolveOperation.this.outOfSyncDilemmaHandler);
                            for (ConfigurationFacade configuration : affectedConfigurations) {
                                verifyOp.addToVerify(configuration.getConnection(null), configuration.getComponentHandle());
                            }
                            verifyOp.run((IProgressMonitor)progress.newChild(7));
                        }
                        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
                        ICopyFileAreaLockRequest lockRequest = cfaManager.lockRequestFactory().getLockRequest(affectedConfigurations, true);
                        ICopyFileAreasLock lock = cfaManager.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            Map sandboxes = AutoResolveOperation.this.getAffectedCFA(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
                            AutoResolveOperation autoResolveOperation = AutoResolveOperation.this;
                            autoResolveOperation.conflictsResolvedCount = autoResolveOperation.conflictsResolvedCount + AutoResolveOperation.this.performAutoMerge(sandboxes, (IProgressMonitor)progress.newChild(90));
                        }
                        finally {
                            lock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(op, Messages.AutoResolveOperation_2, (IProgressMonitor)progress.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.done();
    }

    private Set<ConfigurationFacade> getAffectedConfigurations() throws FileSystemException {
        HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>();
        this.getAffectedConfigurations(this.contentConflicts, configurations);
        this.getAffectedConfigurations(this.autoMergeableConflicts, configurations);
        this.getAffectedConfigurations(this.evilTwinConflicts, configurations);
        return configurations;
    }

    private Map<ConfigurationFacade, List<ISandbox>> getAffectedCFA(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)affectedConfigurations.size());
        HashMap<ConfigurationFacade, List<ISandbox>> result = new HashMap<ConfigurationFacade, List<ISandbox>>();
        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
        for (ConfigurationFacade descriptor : affectedConfigurations) {
            ArrayList<Sandbox> sandboxes = new ArrayList<Sandbox>(2);
            result.put(descriptor, sandboxes);
            Collection<ICopyFileArea> cfas = cfaManager.getCopyFileAreasForConfiguration(descriptor, (IProgressMonitor)progress.newChild(1));
            for (ICopyFileArea cfa : cfas) {
                sandboxes.add(new Sandbox(cfa));
            }
        }
        return result;
    }

    private void getAffectedConfigurations(HashMap<UUID, List<AutoResolveRequest>> requests, HashSet<ConfigurationFacade> configurations) {
        for (List<AutoResolveRequest> requestByReport : requests.values()) {
            for (AutoResolveRequest request : requestByReport) {
                configurations.add(request.getAffectedConfiguation());
            }
        }
    }

    @Override
    public int numberOfConflictsResolved() {
        return this.conflictsResolvedCount;
    }

    private int performAutoMerge(Map<ConfigurationFacade, List<ISandbox>> affectedCFA, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.contentConflicts.size() + this.autoMergeableConflicts.size() + this.evilTwinConflicts.size()));
        int mergeCount = 0;
        mergeCount += this.performEvilTwinAutoMerge(affectedCFA, progress.newChild(this.evilTwinConflicts.size()));
        mergeCount += this.performStructuralAutoMerge((IProgressMonitor)progress.newChild(this.autoMergeableConflicts.size()));
        return mergeCount += this.performContentAutoMerge(affectedCFA, progress.newChild(this.contentConflicts.size()));
    }

    private int performContentAutoMerge(Map<ConfigurationFacade, List<ISandbox>> affectedCFA, SubMonitor progress) throws TeamRepositoryException, FileSystemException {
        int mergeCount = 0;
        for (Map.Entry<UUID, List<AutoResolveRequest>> requestsByContext : this.contentConflicts.entrySet()) {
            SubMonitor contextProgress = progress.newChild(1);
            contextProgress.setWorkRemaining(101);
            ArrayList<IVersionableHandle> itemsToFetch = new ArrayList<IVersionableHandle>();
            IWorkspaceConnection wc = this.workspaces.get(requestsByContext.getKey());
            int workRemaining = 0;
            for (AutoResolveRequest request : requestsByContext.getValue()) {
                if (!this.isStillInConflict(request) || this.isMissingDetails(request) || this.isUnknownConflictType(request)) continue;
                if (request.getCommonAncestorState() != null) {
                    itemsToFetch.add(request.getCommonAncestorState());
                }
                if (request.getProposedContributorState() != null) {
                    itemsToFetch.add(request.getProposedContributorState());
                }
                if (this.isSameFolderAddAddConflict(request.logicalChange) && request.getSelectedContributorState() != null) {
                    itemsToFetch.add(request.getSelectedContributorState());
                }
                ++workRemaining;
            }
            Map<UUID, IVersionable> fetched = AutoResolveOperation.fetchItems(wc, itemsToFetch, (IProgressMonitor)contextProgress.newChild(25));
            ArrayList<FailedAutoResolveRequest> unknownTypes = new ArrayList<FailedAutoResolveRequest>();
            ArrayList<FailedAutoResolveRequest> itemsWithNoHandlers = new ArrayList<FailedAutoResolveRequest>();
            ArrayList<AutoResolveRequest> resolvedConflicts = new ArrayList<AutoResolveRequest>();
            ArrayList<AutoResolveRequest> conflictsWithNoShareable = new ArrayList<AutoResolveRequest>();
            SubMonitor subProgress = contextProgress.newChild(25).setWorkRemaining(workRemaining);
            for (AutoResolveRequest conflict : requestsByContext.getValue()) {
                IVersionable proposedItem;
                IVersionableHandle iVersionableHandle = conflict.getCommonAncestorState();
                IVersionableHandle proposed = conflict.getProposedContributorState();
                if (proposed == null) continue;
                IVersionable commonAncestorItem = null;
                if (iVersionableHandle != null) {
                    commonAncestorItem = fetched.get(iVersionableHandle.getStateId());
                }
                if ((proposedItem = fetched.get(proposed.getStateId())) == null) continue;
                try {
                    List<ISandbox> sandboxes = affectedCFA.get((Object)conflict.configurationDescriptor);
                    SubMonitor itemProgress = subProgress.newChild(1).setWorkRemaining(sandboxes.size());
                    boolean conflictFoundInSandbox = false;
                    for (ISandbox sandbox : sandboxes) {
                        File file;
                        SubMonitor sandboxItemProgress = itemProgress.newChild(1).setWorkRemaining(100);
                        Shareable shareable = (Shareable)sandbox.findShareable(conflict.connection.getContextHandle(), conflict.configurationDescriptor.getComponentHandle(), conflict.logicalChange.item(), (IProgressMonitor)sandboxItemProgress.newChild(2));
                        if (shareable == null) continue;
                        conflictFoundInSandbox = true;
                        ResourceType type = shareable.getResourceType((IProgressMonitor)sandboxItemProgress.newChild(1));
                        IVersionableHandle shareableVersionable = shareable.getVersionable((IProgressMonitor)sandboxItemProgress.newChild(1));
                        AutoResolveState resolveState = new AutoResolveState(conflict.logicalChange.item());
                        if (!conflict.logicalChange.isChangeType(1)) {
                            resolveState.addMerged = true;
                        }
                        resolveState.userPropertiesMerged = this.isSameItemAddAddChange(conflict.logicalChange) ? this.isSameProperties(proposedItem, shareable, (IProgressMonitor)sandboxItemProgress.newChild(3)) : this.performUserPropertyAutoMerge(commonAncestorItem, proposedItem, shareable, (IProgressMonitor)sandboxItemProgress.newChild(3));
                        resolveState.externalDataMerged = this.performExternalDataMerge(wc, commonAncestorItem, proposedItem, shareable, (IProgressMonitor)sandboxItemProgress.newChild(3));
                        if (type == ResourceType.FOLDER && ResourceType.getResourceType(shareableVersionable) == ResourceType.FOLDER) {
                            IVersionable selectedItem;
                            if (this.isSameFolderAddAddConflict(conflict.logicalChange) && (selectedItem = fetched.get(conflict.getSelectedContributorState().getStateId())) != null && selectedItem.getName().equals(proposedItem.getName()) && shareable.getLocalPath().getName().equals(proposedItem.getName()) && selectedItem.getParent().sameItemId((IItemHandle)proposedItem.getParent())) {
                                if (!shareable.isShare((IProgressMonitor)sandboxItemProgress.newChild(45))) {
                                    if (proposedItem.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)sandboxItemProgress.newChild(45)))) {
                                        resolveState.addMerged = true;
                                    }
                                } else {
                                    resolveState.addMerged = true;
                                }
                            }
                        } else if (type == ResourceType.FILE && ResourceType.getResourceType(shareableVersionable) == ResourceType.FILE) {
                            resolveState.executableMerged = this.performExecutablePropertyMerge((IFileItem)commonAncestorItem, (IFileItem)proposedItem, shareable, (IProgressMonitor)sandboxItemProgress.newChild(1));
                            resolveState.propertiesMerged = this.performFilePropertyAutoMerge((IFileItem)commonAncestorItem, (IFileItem)proposedItem, shareable, sandboxItemProgress.newChild(3));
                            if (conflict.logicalChange.isChangeType(4) && !conflict.logicalChange.isModificationChange(4)) {
                                resolveState.contentMerged = true;
                            }
                            if (!(!resolveState.propertiesMerged || resolveState.contentMerged && resolveState.addMerged)) {
                                boolean resetToReadOnly = false;
                                file = (File)shareable.getAdapter(File.class);
                                try {
                                    IStatus status;
                                    if (file.exists() && !file.canWrite()) {
                                        resetToReadOnly = file.setWritable(true);
                                    }
                                    if ((status = this.getFileContentMerger().performAutoMerge(wc.teamRepository(), (IFileItem)commonAncestorItem, (IFileItem)proposedItem, shareable, null, this.shed, (IProgressMonitor)sandboxItemProgress.newChild(83))).isOK()) {
                                        resolveState.contentMerged = true;
                                    } else if (status.getCode() == 1002) {
                                        unknownTypes.add(new FailedAutoResolveRequest(conflict, 1002, shareable, shareable.getLocalPath(), conflict.configurationDescriptor.getComponentHandle(), shareableVersionable, true, resolveState));
                                    } else if (status.getCode() == 1001) {
                                        itemsWithNoHandlers.add(new FailedAutoResolveRequest(conflict, 1001, shareable, shareable.getLocalPath(), conflict.configurationDescriptor.getComponentHandle(), shareableVersionable, true, resolveState));
                                    }
                                }
                                finally {
                                    if (resetToReadOnly) {
                                        file.setWritable(false);
                                    }
                                }
                            }
                            if (this.isSameItemAddAddChange(conflict.logicalChange) && proposedItem.getName().equals(shareable.getLocalPath().getName())) {
                                if (shareable.isShare((IProgressMonitor)sandboxItemProgress.newChild(2))) {
                                    if (proposedItem.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)sandboxItemProgress.newChild(1)))) {
                                        resolveState.addMerged = true;
                                    }
                                } else {
                                    resolveState.addMerged = true;
                                }
                            }
                        } else if (type == ResourceType.SYMBOLIC_LINK && ResourceType.getResourceType(shareableVersionable) == ResourceType.SYMBOLIC_LINK) {
                            if (conflict.logicalChange.isChangeType(4) && !conflict.logicalChange.isModificationChange(4)) {
                                resolveState.contentMerged = true;
                            }
                            if (!(!resolveState.userPropertiesMerged || resolveState.contentMerged && resolveState.addMerged)) {
                                boolean resetToReadOnly = false;
                                file = (File)shareable.getAdapter(File.class);
                                try {
                                    boolean localIsDirectoryLink;
                                    if (file.exists() && !file.canWrite()) {
                                        resetToReadOnly = file.setWritable(true);
                                    }
                                    ISymbolicLink remoteLink = (ISymbolicLink)proposedItem;
                                    String remoteTarget = remoteLink.getTarget();
                                    remoteTarget = shareable.getFileStorage().convertTargetIntoLocalForm(remoteTarget);
                                    boolean remoteIsDirectoryLink = remoteLink.isDirectoryLink();
                                    LinkInfo info = shareable.getFileStorage().getLinkInfo(null);
                                    String localTarget = info.getTarget();
                                    boolean bl = info.getType() == LinkType.NONE ? shareable.getFileItemInfo(null).isDirectoryLink() : (localIsDirectoryLink = info.getType() == LinkType.DIRECTORY);
                                    if (remoteTarget.equals(localTarget) && remoteIsDirectoryLink == localIsDirectoryLink) {
                                        resolveState.contentMerged = true;
                                    }
                                }
                                finally {
                                    if (resetToReadOnly) {
                                        file.setWritable(false);
                                    }
                                }
                            }
                            if (this.isSameItemAddAddChange(conflict.logicalChange) && proposedItem.getName().equals(shareable.getLocalPath().getName())) {
                                if (shareable.isShare((IProgressMonitor)sandboxItemProgress.newChild(89))) {
                                    if (proposedItem.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)sandboxItemProgress.newChild(1)))) {
                                        resolveState.addMerged = true;
                                    }
                                } else {
                                    resolveState.addMerged = true;
                                }
                            }
                        }
                        if (!resolveState.isMerged()) continue;
                        resolvedConflicts.add(conflict);
                    }
                    if (conflictFoundInSandbox) continue;
                    conflictsWithNoShareable.add(conflict);
                }
                catch (Exception e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                }
            }
            int directive = 0;
            if (!itemsWithNoHandlers.isEmpty() || !unknownTypes.isEmpty()) {
                subProgress = contextProgress.newChild(25).setWorkRemaining(100);
                directive = this.problemHandler.missingStorageMerger(Collections.unmodifiableCollection(unknownTypes), Collections.unmodifiableCollection(itemsWithNoHandlers), (IProgressMonitor)subProgress.newChild(5));
                if (directive == 0) {
                    FailedAutoResolveRequest failedRequest;
                    SubMonitor itemProgress;
                    ITeamRepository teamRepository = wc.teamRepository();
                    subProgress.setWorkRemaining(unknownTypes.size() + itemsWithNoHandlers.size());
                    for (IFailedAutoResolveRequest iFailedAutoResolveRequest : unknownTypes) {
                        itemProgress = subProgress.newChild(1).setWorkRemaining(100);
                        failedRequest = (FailedAutoResolveRequest)iFailedAutoResolveRequest;
                        if (!failedRequest.isRetryMerge()) continue;
                        this.retryFileContentMerge(teamRepository, failedRequest, fetched, resolvedConflicts, (IProgressMonitor)itemProgress);
                    }
                    for (IFailedAutoResolveRequest iFailedAutoResolveRequest : itemsWithNoHandlers) {
                        itemProgress = subProgress.newChild(1).setWorkRemaining(100);
                        failedRequest = (FailedAutoResolveRequest)iFailedAutoResolveRequest;
                        if (!failedRequest.isRetryMerge()) continue;
                        this.retryFileContentMerge(teamRepository, failedRequest, fetched, resolvedConflicts, (IProgressMonitor)itemProgress);
                    }
                }
            }
            contextProgress.setWorkRemaining(resolvedConflicts.size() + conflictsWithNoShareable.size());
            Map<ILogicalConflictReport, List<AutoResolveRequest>> requestsByReport = this.groupRequestsByReport(resolvedConflicts);
            for (Map.Entry<ILogicalConflictReport, List<AutoResolveRequest>> entry : requestsByReport.entrySet()) {
                try {
                    ArrayList<ILogicalChange> conflictsToAutoResolve = new ArrayList<ILogicalChange>();
                    for (AutoResolveRequest request : entry.getValue()) {
                        conflictsToAutoResolve.add(request.logicalChange);
                    }
                    IMarkAsMergedOperation mergedOp = IOperationFactory.instance.getMarkAsMergedOperation(this.markAsMergedDilemmaHandler);
                    mergedOp.setContext(wc, entry.getKey());
                    mergedOp.addChangesToResolve(conflictsToAutoResolve);
                    this.disableVerifyInSync(mergedOp);
                    if (this.nonAtomicCommitIsAnOption) {
                        mergedOp.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                    } else {
                        mergedOp.disableNonAtomicCommit();
                    }
                    mergedOp.run((IProgressMonitor)contextProgress.newChild(1));
                    mergeCount += entry.getValue().size();
                }
                catch (Exception e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                }
            }
            if (directive == 1) {
                throw new OperationCanceledException();
            }
            if (directive == 2) {
                throw new FileSystemException(Messages.AutoResolveOperation_0);
            }
            if (conflictsWithNoShareable.isEmpty()) continue;
            mergeCount += this.performContentAutoMergeForUnloaded(wc, conflictsWithNoShareable, fetched, contextProgress.newChild(conflictsWithNoShareable.size()));
        }
        return mergeCount;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private int performContentAutoMergeForUnloaded(IWorkspaceConnection workspace, List<AutoResolveRequest> conflictsWithNoShareable, Map<UUID, IVersionable> fetched, SubMonitor monitor) throws TeamRepositoryException {
        mergeCount = 0;
        findStatesFor = new HashMap<ItemId, ArrayList<IVersionableHandle>>();
        for (AutoResolveRequest autoResolveRequest : conflictsWithNoShareable) {
            versionableHandle = AutoResolveRequest.access$3(autoResolveRequest).item();
            component = AutoResolveRequest.access$3(autoResolveRequest).getComponent();
            componentId = new ItemId((IItemHandle)component);
            handles = (ArrayList<IVersionableHandle>)findStatesFor.get(componentId);
            if (handles == null) {
                handles = new ArrayList<IVersionableHandle>();
                findStatesFor.put(componentId, handles);
            }
            handles.add(versionableHandle);
        }
        fetchMonitor = monitor.newChild(1);
        fetchMonitor.setWorkRemaining(findStatesFor.size());
        selected = new HashMap<ItemId, HashMap<UUID, IVersionable>>();
        for (Map.Entry entry : findStatesFor.entrySet()) {
            configuration = workspace.configuration((IComponentHandle)((ItemId)entry.getKey()).toHandle());
            fetchedItems = configuration.fetchCompleteItems((List)entry.getValue(), (IProgressMonitor)fetchMonitor.newChild(1));
            for (AutoResolveRequest object : fetchedItems) {
                versionable = (IVersionable)object;
                if (versionable == null) continue;
                fetched.put(versionable.getStateId(), versionable);
                selectedForComponent = (HashMap<UUID, IVersionable>)selected.get(entry.getKey());
                if (selectedForComponent == null) {
                    selectedForComponent = new HashMap<UUID, IVersionable>();
                    selected.put((ItemId)entry.getKey(), selectedForComponent);
                }
                selectedForComponent.put(versionable.getItemId(), versionable);
            }
        }
        resolveMonitor = monitor.newChild(1);
        resolveMonitor.setWorkRemaining(conflictsWithNoShareable.size());
        results = new ArrayList<RemoteAutoResolver>();
        try {
            numUploads = 0;
            toRetry = new ArrayList<RemoteAutoResolver>();
            for (AutoResolveRequest conflict : conflictsWithNoShareable) {
                versionableHandle = AutoResolveRequest.access$3(conflict).item();
                component = AutoResolveRequest.access$3(conflict).getComponent();
                componentId = new ItemId((IItemHandle)component);
                selectedByComponent = (Map)selected.get(componentId);
                if (selectedByComponent == null || (current = (IVersionable)selectedByComponent.get(versionableHandle.getItemId())) == null || (proposed = conflict.getProposedContributorState()) == null || (proposedItem = fetched.get(proposed.getStateId())) == null) continue;
                commonAncestor = conflict.getCommonAncestorState();
                commonAncestorItem = null;
                if (commonAncestor != null) {
                    commonAncestorItem = fetched.get(commonAncestor.getStateId());
                }
                remoteAutoResolver = new RemoteAutoResolver(workspace, conflict, component, current, commonAncestorItem, proposedItem);
                results.add(remoteAutoResolver);
                try {
                    if (remoteAutoResolver.mergeContent(this.getFileContentMerger(), (IProgressMonitor)resolveMonitor.newChild(1))) {
                        ++numUploads;
                        continue;
                    }
                    if (remoteAutoResolver.getFailureReport() == null) continue;
                    toRetry.add(remoteAutoResolver);
                }
                catch (IOException e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                }
            }
            directive = 0;
            if (!toRetry.isEmpty()) {
                reresolveMonitor = monitor.newChild(1);
                reresolveMonitor.setWorkRemaining(2);
                unknownTypes = new ArrayList<FailedAutoResolveRequest>();
                itemsWithNoHandlers = new ArrayList<E>();
                for (RemoteAutoResolver rar : toRetry) {
                    failureReport = rar.getFailureReport();
                    if (failureReport.getReason() == 1001) {
                        itemsWithNoHandlers.add(failureReport);
                        continue;
                    }
                    unknownTypes.add(failureReport);
                }
                if (!itemsWithNoHandlers.isEmpty() || !unknownTypes.isEmpty()) {
                    directive = this.problemHandler.missingStorageMerger(Collections.unmodifiableCollection(unknownTypes), Collections.unmodifiableCollection(itemsWithNoHandlers), (IProgressMonitor)reresolveMonitor.newChild(1));
                    if (directive == 0) {
                        reresolveMonitor.setWorkRemaining(itemsWithNoHandlers.size() + unknownTypes.size());
                        for (IFailedAutoResolveRequest request : unknownTypes) {
                            try {
                                failedRequest = (FailedAutoResolveRequest)request;
                                if (failedRequest.isRetryMerge()) {
                                    if (!((RemoteAutoResolver)failedRequest.getResolveState()).mergeContent(this.getFileContentMerger(), (IProgressMonitor)reresolveMonitor.newChild(1))) continue;
                                    ++numUploads;
                                    continue;
                                }
                                ((RemoteAutoResolver)failedRequest.getResolveState()).setCanResolve(false);
                            }
                            catch (IOException e) {
                                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                            }
                        }
                        selectedByComponent = itemsWithNoHandlers.iterator();
                        while (selectedByComponent.hasNext()) {
                            request = (IFailedAutoResolveRequest)selectedByComponent.next();
                            try {
                                failedRequest = (FailedAutoResolveRequest)request;
                                if (failedRequest.isRetryMerge()) {
                                    if (!((RemoteAutoResolver)failedRequest.getResolveState()).mergeContent(this.getFileContentMerger(), (IProgressMonitor)reresolveMonitor.newChild(1))) continue;
                                    ++numUploads;
                                    continue;
                                }
                                ((RemoteAutoResolver)failedRequest.getResolveState()).setCanResolve(false);
                            }
                            catch (IOException e) {
                                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                            }
                        }
                    } else {
                        for (IFailedAutoResolveRequest request : unknownTypes) {
                            failedRequest = (FailedAutoResolveRequest)request;
                            ((RemoteAutoResolver)failedRequest.getResolveState()).setCanResolve(false);
                        }
                        selectedByComponent = itemsWithNoHandlers.iterator();
                        while (selectedByComponent.hasNext()) {
                            request = (IFailedAutoResolveRequest)selectedByComponent.next();
                            failedRequest = (FailedAutoResolveRequest)request;
                            ((RemoteAutoResolver)failedRequest.getResolveState()).setCanResolve(false);
                        }
                    }
                }
            }
            if (numUploads > 0) {
                session = FileSystemCore.getContentManager(workspace.teamRepository()).createSession(NLS.bind((String)Messages.NewCheckInOperation_3, (Object)workspace.getName(), (Object[])new Object[0]), true, numUploads, (IProgressMonitor)monitor.newChild(1));
                for (RemoteAutoResolver remoteAutoResolver : results) {
                    if (!remoteAutoResolver.hasContentToUpload()) continue;
                    try {
                        remoteAutoResolver.uploadContent(session);
                    }
                    catch (TeamRepositoryException request) {
                        // empty catch block
                    }
                }
                session.join();
                if (session.getErrorStatus().length > 0) {
                    RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, session.getErrorStatus());
                }
            }
            hasChangeToCommit = false;
            toMarkAsMerged = new ArrayList<RemoteAutoResolver>();
            prepareCommitMonitor = monitor.newChild(1);
            prepareCommitMonitor.setWorkRemaining(conflictsWithNoShareable.size());
            changeSetChooser = new ChangeSetChooser(workspace, null, Messages.MarkAsMergedOperation_ChangeSetDefaultComment);
            for (RemoteAutoResolver remoteAutoResolver : results) {
                hasChangeToCommit |= remoteAutoResolver.prepareCommit(changeSetChooser, (IProgressMonitor)prepareCommitMonitor.newChild(1));
                if (!remoteAutoResolver.canBeResolved()) continue;
                toMarkAsMerged.add(remoteAutoResolver);
            }
            if (hasChangeToCommit) {
                changeSetChooser.commit((IProgressMonitor)monitor.newChild(1));
            }
            if (!toMarkAsMerged.isEmpty()) {
                requestsByReport = this.groupRemoteRequestsByReport(toMarkAsMerged);
                for (Map.Entry<ILogicalConflictReport, List<RemoteAutoResolver>> entry : requestsByReport.entrySet()) {
                    try {
                        conflictsToAutoResolve = new ArrayList<ILogicalChange>();
                        for (RemoteAutoResolver request : entry.getValue()) {
                            conflictsToAutoResolve.add(request.getLogicalChange());
                        }
                        mergedOp = IOperationFactory.instance.getMarkAsMergedOperation(this.markAsMergedDilemmaHandler);
                        mergedOp.setContext(workspace, entry.getKey());
                        mergedOp.addChangesToResolve(conflictsToAutoResolve);
                        this.disableVerifyInSync(mergedOp);
                        if (this.nonAtomicCommitIsAnOption) {
                            mergedOp.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                        } else {
                            mergedOp.disableNonAtomicCommit();
                        }
                        mergedOp.run((IProgressMonitor)monitor.newChild(1));
                        mergeCount += toMarkAsMerged.size();
                    }
                    catch (Exception e) {
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                    }
                }
            }
            if (directive == 1) {
                throw new OperationCanceledException();
            }
            if (directive == 2) {
                throw new FileSystemException(Messages.AutoResolveOperation_0);
            }
        }
        finally {
            var28_35 = results.iterator();
            if (true) ** GOTO lbl189
        }
        {
        }
        do {
            remoteAutoResolver = (RemoteAutoResolver)var28_35.next();
            remoteAutoResolver.dispose();
lbl189:
            // 2 sources

        } while (var28_35.hasNext());
        return mergeCount;
    }

    private boolean isUnknownConflictType(AutoResolveRequest request) {
        return request.logicalChange.kind() == 1 && ((ILogicalConflict)request.logicalChange).conflictType() == 11;
    }

    private boolean isMissingDetails(AutoResolveRequest request) {
        return request.logicalChange.isChangeType(32);
    }

    private boolean isStillInConflict(AutoResolveRequest request) throws TeamRepositoryException {
        IWorkspaceConnection wc = request.connection;
        IVersionableHandle one = request.getCommonAncestorState();
        IUpdateReport conflictReport = wc.conflictReport(request.getAffectedConfiguation().getComponentHandle());
        Iterator iter = conflictReport.conflicts().iterator();
        while (iter.hasNext()) {
            IVersionableHandle two = ((IItemConflictReport)iter.next()).getCommonAncestorState();
            if (one != null && two != null && !one.getItemId().equals((Object)two.getItemId())) continue;
            return true;
        }
        return false;
    }

    private int performEvilTwinAutoMerge(Map<ConfigurationFacade, List<ISandbox>> affectedCFA, SubMonitor monitor) throws TeamRepositoryException {
        monitor.setWorkRemaining(this.evilTwinConflicts.size() * 3);
        int merged = 0;
        for (Map.Entry<UUID, List<AutoResolveRequest>> requestsByContext : this.evilTwinConflicts.entrySet()) {
            ArrayList<IVersionableHandle> itemsToFetch = new ArrayList<IVersionableHandle>();
            IWorkspaceConnection wc = this.workspaces.get(requestsByContext.getKey());
            for (AutoResolveRequest request : requestsByContext.getValue()) {
                ILogicalConflict log = (ILogicalConflict)request.logicalChange;
                itemsToFetch.add(log.afterState());
                List<ILogicalChange> dependentChanges = request.computeFlattenedDependencies();
                for (ILogicalChange dep : dependentChanges) {
                    if (dep.afterState() != null) {
                        itemsToFetch.add(dep.afterState());
                    }
                    if (dep.beforeState() == null) continue;
                    itemsToFetch.add(dep.beforeState());
                }
                IVersionableHandle local = (IVersionableHandle)log.conflictingItems().iterator().next();
                List<ISandbox> sandboxes = affectedCFA.get((Object)request.configurationDescriptor);
                SubMonitor sbMonitor = monitor.newChild(1);
                sbMonitor.setWorkRemaining(sandboxes.size() * 2);
                for (ISandbox sb : sandboxes) {
                    IShareable shareable = sb.findShareable(request.configurationDescriptor.getConnectionHandle(), request.configurationDescriptor.getComponentHandle(), local, (IProgressMonitor)sbMonitor.newChild(1));
                    if (shareable == null) continue;
                    itemsToFetch.add(shareable.getRemote((IProgressMonitor)sbMonitor.newChild(1)));
                }
            }
            Map<UUID, IVersionable> fetched = AutoResolveOperation.fetchItems(wc, itemsToFetch, (IProgressMonitor)monitor.newChild(1));
            SubMonitor contextProgress = monitor.newChild(1);
            contextProgress.setWorkRemaining(requestsByContext.getValue().size());
            for (AutoResolveRequest conflict : requestsByContext.getValue()) {
                List<ISandbox> sandboxes = affectedCFA.get((Object)conflict.configurationDescriptor);
                SubMonitor sbProgress = contextProgress.newChild(1);
                sbProgress.setWorkRemaining(sandboxes.size());
                for (ISandbox sandbox : sandboxes) {
                    merged += this.mergeEvilTwinFolderConflict(conflict, sandbox, fetched, sbProgress.newChild(1));
                }
            }
        }
        return merged;
    }

    protected boolean isEvilTwinResolvable(AutoResolveRequest conflict) {
        if (!(conflict.logicalChange instanceof ILogicalConflict)) {
            return false;
        }
        ILogicalConflict lc = (ILogicalConflict)conflict.logicalChange;
        Collection others = lc.conflictingItems();
        if (lc.conflictType() == 1 && conflict.logicalChange.item() instanceof IFolderHandle && others.size() == 1 && !lc.item().sameItemId((IItemHandle)others.iterator().next())) {
            return others.iterator().next() instanceof IFolderHandle;
        }
        return false;
    }

    private int mergeEvilTwinFolderConflict(AutoResolveRequest conflict, ISandbox sandbox, Map<UUID, IVersionable> fetched, SubMonitor monitor) throws TeamRepositoryException {
        monitor.setWorkRemaining(10);
        IFolderHandle current = (IFolderHandle)((ILogicalConflict)conflict.logicalChange).conflictingItems().iterator().next();
        if (current.getStateId() == null) {
            IShareable shareable = SharingManager.getInstance().findShareable(sandbox.getRoot(), conflict.configurationDescriptor.getConnectionHandle(), conflict.configurationDescriptor.getComponentHandle(), (IVersionableHandle)current, (IProgressMonitor)monitor.newChild(1));
            current = (IFolderHandle)shareable.getRemote((IProgressMonitor)monitor.newChild(1));
        } else {
            monitor.worked(2);
        }
        IFolderHandle proposed = (IFolderHandle)conflict.conflict.getProposedContributorState();
        if (!this.isMergeableWithEvilTwin((IFolder)fetched.get(current.getStateId()), (IFolder)fetched.get(proposed.getStateId()))) {
            return 0;
        }
        ChangeSetChooser chooser = new ChangeSetChooser(conflict.connection, null, Messages.MarkAsMergedOperation_ChangeSetDefaultComment);
        int resolved = this.mergeEvilTwinHierarchy(conflict, sandbox, current, proposed, fetched, chooser, monitor.newChild(1));
        IUpdateReport updateReport = null;
        try {
            updateReport = chooser.commit((IProgressMonitor)monitor.newChild(1));
        }
        catch (ProducesOrphansInConfigurationException e) {
            return 0;
        }
        UpdateOperation op = new UpdateOperation(conflict.connection, Collections.singletonList(updateReport), 3, this.applyAcceptedDilemmaHandler, null);
        this.disableVerifyInSync(op);
        monitor.setWorkRemaining(1);
        op.run((IProgressMonitor)monitor.newChild(1));
        return resolved;
    }

    private boolean chooseEvilTwinWinner(AutoResolveRequest conflict, IVersionableHandle current, IVersionableHandle proposed, SubMonitor monitor) throws TeamRepositoryException {
        ITeamRepository targetRepo;
        IContextHandle targetCtx;
        monitor.setWorkRemaining(1);
        IWorkspaceConnection wsConn = conflict.connection;
        ConnectionDescriptor desc = FlowTableUtil.getCurrentIncomingCollaborationDescriptor(wsConn, conflict.configurationDescriptor.getComponentHandle());
        if (desc == null) {
            ConnectionDescriptor target = FlowTableUtil.getDefaultIncomingCollaborationDescriptor(wsConn);
            if (target == null) {
                return true;
            }
            targetCtx = target.connectionHandle;
            targetRepo = wsConn.teamRepository();
        } else {
            targetCtx = desc.connectionHandle;
            targetRepo = this.resolver.getRepoFor(desc.uri, desc.id);
        }
        IChangeSetSearchCriteria crit = IChangeSetSearchCriteria.FACTORY.newInstance();
        crit.setItem(proposed);
        crit.setContext(targetCtx);
        List targetChangeSets = SCMPlatform.getWorkspaceManager((ITeamRepository)targetRepo).findChangeSets(crit, 1, (IProgressMonitor)monitor.newChild(1));
        return targetChangeSets.isEmpty();
    }

    private int mergeEvilTwinHierarchy(AutoResolveRequest req, ISandbox sandbox, IFolderHandle current, IFolderHandle proposedHandle, Map<UUID, IVersionable> fetched, ChangeSetChooser chooser, SubMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection.IConfigurationOpFactory opFactory = req.connection.configurationOpFactory();
        DeferredReparentingOperands reparenting = new DeferredReparentingOperands();
        HashMap<UUID, IFolderHandle> parentMapping = new HashMap<UUID, IFolderHandle>();
        IFolderHandle parent = fetched.get(current.getStateId()).getParent();
        parentMapping.put(parent.getItemId(), parent);
        int fixed = 0;
        HashSet<UUID> processedItems = new HashSet<UUID>();
        LinkedList<ILogicalChange> toProcess = new LinkedList<ILogicalChange>();
        toProcess.add(req.logicalChange);
        boolean useCurrent = this.chooseEvilTwinWinner(req, (IVersionableHandle)current, (IVersionableHandle)proposedHandle, monitor);
        while (!toProcess.isEmpty()) {
            IShareable shareable;
            ILogicalChange chg = (ILogicalChange)toProcess.remove(0);
            if (processedItems.contains(chg.item().getItemId())) continue;
            processedItems.add(chg.item().getItemId());
            IVersionableHandle afterState = chg.afterState();
            if (afterState == null) continue;
            IVersionable remoteItem = fetched.get(afterState.getStateId());
            if (remoteItem == null) {
                if (fetched.containsKey(afterState.getStateId())) continue;
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Progamming error - failed to fetch " + afterState.getItemId() + "/" + afterState.getStateId()));
                continue;
            }
            IItemConflictReport rpt = this.findItemConflictReport(req, (IVersionableHandle)remoteItem);
            IFolderHandle mappedParent = (IFolderHandle)parentMapping.get(remoteItem.getParent().getItemId());
            IVersionableHandle localVer = null;
            if (mappedParent != null && (shareable = this.localChildEntryShareable(req, sandbox, mappedParent, remoteItem.getName(), monitor.newChild(1))) != null && (localVer = shareable.getRemote((IProgressMonitor)monitor.newChild(1))) != null && (!remoteItem.getItemType().equals(localVer.getItemType()) || !this.isSameProperties(remoteItem, shareable, (IProgressMonitor)monitor.newChild(1)))) continue;
            if (useCurrent) {
                if (localVer == null) {
                    if (mappedParent == null) {
                        mappedParent = remoteItem.getParent();
                    }
                    IVersionable toReparent = (IVersionable)remoteItem.getWorkingCopy();
                    toReparent.setParent(mappedParent);
                    this.saveAndMerge(req, opFactory, rpt, toReparent, chooser, reparenting, monitor);
                } else {
                    IWorkspaceConnection.IMarkAsMergedOp mergeOp = opFactory.markAsMerged((IVersionableHandle)remoteItem, rpt.getOriginalSelectedContributorState(), rpt.getProposedContributorState());
                    chooser.toCommit(req.configurationDescriptor.getComponentHandle(), (IVersionableHandle)remoteItem, (IWorkspaceConnection.IConfigurationOp)mergeOp, (IProgressMonitor)monitor.newChild(1));
                    if (localVer instanceof IFolderHandle) {
                        parentMapping.put(remoteItem.getItemId(), (IFolderHandle)localVer);
                    }
                }
            } else if (localVer == null) {
                if (mappedParent == null) {
                    mappedParent = remoteItem.getParent();
                }
                this.saveAndMerge(req, opFactory, rpt, (IVersionable)remoteItem.getWorkingCopy(), chooser, reparenting, monitor);
            } else if (remoteItem.sameItemId(localVer)) {
                this.saveAndMerge(req, opFactory, rpt, (IVersionable)remoteItem.getWorkingCopy(), chooser, reparenting, monitor);
            } else {
                IWorkspaceConnection.IDeleteOp delOp = opFactory.delete(localVer);
                chooser.toCommit(req.configurationDescriptor.getComponentHandle(), (IVersionableHandle)remoteItem, (IWorkspaceConnection.IConfigurationOp)delOp, (IProgressMonitor)monitor.newChild(1));
                reparenting.exclude(localVer);
                if (localVer instanceof IFolderHandle && remoteItem instanceof IFolderHandle) {
                    reparenting.add((IFolderHandle)localVer, (IFolderHandle)remoteItem);
                    parentMapping.put(remoteItem.getItemId(), (IFolderHandle)localVer);
                }
            }
            ++fixed;
            toProcess.addAll(req.conflictReport.getDependentChanges(chg));
        }
        reparenting.run(req, sandbox, chooser, monitor.newChild(1));
        return fixed;
    }

    protected void saveAndMerge(AutoResolveRequest req, IWorkspaceConnection.IConfigurationOpFactory opFactory, IItemConflictReport rpt, IVersionable toSave, ChangeSetChooser chooser, DeferredReparentingOperands reparenting, SubMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection.IMergeOp mergeOp = opFactory.merge((IWorkspaceConnection.IMergeResultOp)opFactory.save(toSave), rpt.getOriginalSelectedContributorState(), rpt.getProposedContributorState());
        chooser.toCommit(req.configurationDescriptor.getComponentHandle(), (IVersionableHandle)toSave, (IWorkspaceConnection.IConfigurationOp)mergeOp, (IProgressMonitor)monitor.newChild(1));
        reparenting.exclude((IVersionableHandle)toSave);
    }

    protected void addConflictsToQueue(AutoResolveRequest req, List<ILogicalChange> toProcess, ILogicalChange chg) {
        toProcess.addAll(req.conflictReport.getDependentChanges(chg));
    }

    private IShareable localChildEntryShareable(AutoResolveRequest conflict, ISandbox sandbox, IFolderHandle parentToUse, String name, SubMonitor monitor) throws FileSystemException {
        monitor.setWorkRemaining(10);
        Shareable shareable = (Shareable)sandbox.findShareable(conflict.configurationDescriptor.getConnectionHandle(), conflict.configurationDescriptor.getComponentHandle(), (IVersionableHandle)parentToUse, (IProgressMonitor)monitor.newChild(1));
        if (shareable == null) {
            return null;
        }
        IFileStorage storage = shareable.getFileStorage();
        IFileStorage child = storage.getChild(name, (IProgressMonitor)monitor.newChild(1));
        if (child == null) {
            return null;
        }
        return child.getShareable();
    }

    protected boolean isMergeableEvilTwinFolder(AutoResolveRequest conflict, ISandbox sandbox, IVersionable remote, IItemConflictReport rpt, IVersionableHandle local, SubMonitor monitor) throws FileSystemException {
        if (remote instanceof IFolderHandle && local instanceof IFolderHandle) {
            Shareable s = (Shareable)sandbox.findShareable(conflict.configurationDescriptor.getConnectionHandle(), conflict.configurationDescriptor.getComponentHandle(), local, (IProgressMonitor)monitor.newChild(1));
            if (s == null) {
                throw new IllegalStateException("Missing " + rpt);
            }
            return this.isSameProperties(remote, s, (IProgressMonitor)monitor.newChild(1));
        }
        return false;
    }

    private IItemConflictReport findItemConflictReport(AutoResolveRequest conflict, IVersionableHandle toParent) {
        for (IItemConflictReport report : conflict.conflictReport.conflictReport().getConflictsForComponent(conflict.configurationDescriptor.getComponentHandle())) {
            if (!report.item().sameItemId((IItemHandle)toParent)) continue;
            return report;
        }
        return null;
    }

    private boolean isMergeableWithEvilTwin(IFolder current, IFolder proposed) {
        return current != null && proposed != null && current.getName().equals(proposed.getName()) && MetadataProperties.calcPropertyChanges(current.getUserProperties(), proposed.getUserProperties()).isEmpty();
    }

    private boolean isSameProperties(IVersionable proposedItem, IShareable shareable, IProgressMonitor progress) {
        Map<String, String> current;
        Map proposed = proposedItem.getUserProperties();
        try {
            current = shareable.getMetadataProperties(progress).getCurrentProperties();
        }
        catch (FileSystemException e) {
            return false;
        }
        if (proposed.size() != current.size()) {
            return false;
        }
        return MetadataProperties.calcPropertyChanges(current, proposed).isEmpty();
    }

    private boolean performUserPropertyAutoMerge(IVersionable commonAncestorItem, IVersionable proposedItem, Shareable shareable, IProgressMonitor progress) throws TeamRepositoryException {
        HashMap<String, String> currentProperties;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        Map commonProperties = commonAncestorItem == null ? Collections.EMPTY_MAP : commonAncestorItem.getUserProperties();
        Map proposedProperties = proposedItem.getUserProperties();
        try {
            currentProperties = new HashMap<String, String>(shareable.getMetadataProperties((IProgressMonitor)monitor.newChild(5)).getCurrentProperties());
        }
        catch (FileSystemException e) {
            return false;
        }
        MetadataProperties proposedDelta = new MetadataProperties((Map<String, String>)commonProperties, proposedProperties);
        boolean unmergedChanges = false;
        boolean changeProperties = false;
        for (Map.Entry<String, String> proposedEntry : proposedDelta.getChangedProperties().entrySet()) {
            String currentValue;
            String propertyName = proposedEntry.getKey();
            String proposedValue = proposedEntry.getValue();
            if (proposedValue.equals(currentValue = (String)currentProperties.get(propertyName))) continue;
            String commonValue = (String)commonProperties.get(propertyName);
            if (commonValue == null && currentValue == null) {
                currentProperties.put(propertyName, proposedValue);
                changeProperties = true;
                continue;
            }
            if (commonValue != null && commonValue.equals(currentValue)) {
                currentProperties.put(propertyName, proposedValue);
                changeProperties = true;
                continue;
            }
            unmergedChanges = true;
        }
        for (String propertyName : proposedDelta.getRemovedProperties()) {
            String currentValue = (String)currentProperties.get(propertyName);
            if (currentValue == null) continue;
            String commonValue = (String)commonProperties.get(propertyName);
            if (!currentValue.equals(commonValue)) {
                unmergedChanges = true;
                continue;
            }
            currentProperties.remove(propertyName);
            changeProperties = true;
        }
        if (changeProperties) {
            ChangePropertiesDilemmaHandler dilemmaHandler = new ChangePropertiesDilemmaHandler(){

                @Override
                public int invalidContentTypes(List<? extends IChangePropertiesRequest> invalidContentTypeChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                    return 0;
                }

                @Override
                public BackupDilemmaHandler getBackupDilemmaHandler() {
                    return AutoResolveOperation.this.problemHandler.getBackupDilemmaHandler();
                }
            };
            IChangePropertiesOperation changePropertiesOp = IOperationFactory.instance.getChangePropertiesOperation(dilemmaHandler);
            changePropertiesOp.setProperties(shareable, currentProperties);
            this.disableVerifyInSync(changePropertiesOp);
            changePropertiesOp.run((IProgressMonitor)monitor.newChild(95));
        }
        return !unmergedChanges;
    }

    private boolean performExternalDataMerge(IWorkspaceConnection wc, IVersionable commonAncestorItem, IVersionable proposedItem, Shareable shareable, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        WorkspaceManager manager = (WorkspaceManager)SCMPlatform.getWorkspaceManager((ITeamRepository)wc.teamRepository());
        IScmService service = manager.getServerConfigurationService();
        ExternalLinks commonAncestorLinks = LinkUtils.getLinks((IVersionableHandle)commonAncestorItem, (IScmService)service, (IProgressMonitor)monitor.newChild(1));
        ExternalLinks proposedLinks = LinkUtils.getLinks((IVersionableHandle)proposedItem, (IScmService)service, (IProgressMonitor)monitor.newChild(1));
        FileItemInfo selectedInfo = shareable.getFileItemInfo((IProgressMonitor)monitor.newChild(1));
        ExternalLinks selectedExternalLinks = selectedInfo.getExternalLinks();
        ExternalLinks selectedLinks = selectedExternalLinks != null ? selectedExternalLinks : ExternalLinks.create();
        ITeamRepository repo = wc.teamRepository();
        ExternalLinks mergedLinks = this.autoMergeLinks(commonAncestorLinks, selectedLinks, proposedLinks, repo);
        ChangePropertiesDilemmaHandler dilemmaHandler = new ChangePropertiesDilemmaHandler(){

            @Override
            public int invalidContentTypes(List<? extends IChangePropertiesRequest> invalidContentTypeChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                return 0;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return AutoResolveOperation.this.problemHandler.getBackupDilemmaHandler();
            }
        };
        IChangePropertiesOperation changeFileLinksOp = IOperationFactory.instance.getChangePropertiesOperation(dilemmaHandler);
        changeFileLinksOp.setExternalLink(shareable, mergedLinks);
        this.disableVerifyInSync(changeFileLinksOp);
        changeFileLinksOp.run((IProgressMonitor)monitor.newChild(95));
        return true;
    }

    private ExternalLinks autoMergeLinks(ExternalLinks commonAncestorLinks, ExternalLinks selectedLinks, ExternalLinks proposedLinks, ITeamRepository repo) throws TeamRepositoryException {
        ExternalLinks removedSelected = LinkUtils.difference((ExternalLinks)commonAncestorLinks, (ExternalLinks)selectedLinks);
        ExternalLinks removedProposed = LinkUtils.difference((ExternalLinks)commonAncestorLinks, (ExternalLinks)proposedLinks);
        ExternalLinks allRemoved = LinkUtils.union((ExternalLinks)removedSelected, (ExternalLinks)removedProposed);
        ExternalLinks allLinks = LinkUtils.union((ExternalLinks)selectedLinks, (ExternalLinks)proposedLinks);
        final Collection mergedLinks = LinkUtils.difference((ExternalLinks)allLinks, (ExternalLinks)allRemoved).getAllExternalLinks();
        ExternalLinks linksWithCurrentInstance = this.findInstanceChanges(selectedLinks, ExternalLinks.createFromExternalLinkCollection((Collection)mergedLinks), repo);
        linksWithCurrentInstance.visitAllExternalLinks(new ExternalLinksVisitor(){

            public void visitLink(ExternalLink link) throws TeamRepositoryException {
                mergedLinks.add(ExternalLink.create((LinkTypeIdentifier)link.getLinkTypeId(), (URI)link.getUri()));
            }
        });
        return ExternalLinks.createFromExternalLinkCollection((Collection)mergedLinks);
    }

    private ExternalLinks findInstanceChanges(ExternalLinks originalLinks, ExternalLinks mergedLinks, final ITeamRepository repo) throws TeamRepositoryException {
        LinkDiffReport differences = LinkUtils.makeDifferenceReport((ExternalLinks)originalLinks, (ExternalLinks)mergedLinks);
        ExternalLinks needToRemove = differences.getDeletions();
        ExternalLinks needToAdd = differences.getAdditions();
        final ArrayList instanceChanges = NewCollection.arrayList();
        final HashMap removalsByTypeId = NewCollection.hashMap();
        needToRemove.visitAllExternalLinks(new ExternalLinksVisitor(){

            public void visitLink(ExternalLink link) {
                String id = link.getLinkTypeId().toLinkServiceId();
                Collection linksForTypeId = (Collection)removalsByTypeId.get(id);
                if (linksForTypeId == null) {
                    linksForTypeId = NewCollection.hashSet();
                    removalsByTypeId.put(id, linksForTypeId);
                }
                linksForTypeId.add(link.getUri());
            }
        });
        needToAdd.visitAllExternalLinks(new ExternalLinksVisitor(){

            public void visitLink(ExternalLink link) throws TeamRepositoryException {
                ExternalLink mergedLink;
                String id = link.getLinkTypeId().toLinkServiceId();
                Collection linksForTypeId = (Collection)removalsByTypeId.get(id);
                if (linksForTypeId != null && linksForTypeId.contains(link.getUri()) && (mergedLink = AutoResolveOperation.this.createMergedLink(link, repo)) != null) {
                    instanceChanges.add(mergedLink);
                }
            }
        });
        return ExternalLinks.createFromExternalLinkCollection((Collection)instanceChanges);
    }

    private ExternalLink createMergedLink(ExternalLink link, ITeamRepository repo) throws TeamRepositoryException {
        ILinkTypeClientLibrary library = (ILinkTypeClientLibrary)repo.getClientLibrary(ILinkTypeClientLibrary.class);
        ILinkType mergedType = library.getLatestLinkTypeForLinkTypeId(link.getLinkTypeId().toLinkServiceId());
        if (mergedType == null) {
            return null;
        }
        LinkTypeIdentifier mergedId = LinkTypeIdentifier.create((ILinkType)mergedType);
        return ExternalLink.create((LinkTypeIdentifier)mergedId, (URI)link.getUri());
    }

    private boolean isSameFolderAddAddConflict(ILogicalChange change) {
        return change.item() instanceof IFolderHandle && this.isSameItemAddAddChange(change);
    }

    private boolean isSameItemAddAddChange(ILogicalChange change) {
        IVersionableHandle versionableConflictedWith;
        ILogicalConflict conflict;
        return change.kind() == 1 && ((ILogicalConflict)change).conflictType() == 1 && (conflict = (ILogicalConflict)change).conflictingItems().size() == 1 && (versionableConflictedWith = (IVersionableHandle)conflict.conflictingItems().iterator().next()).sameItemId((IItemHandle)conflict.item());
    }

    private boolean performExecutablePropertyMerge(IFileItem commonAncestorItem, IFileItem proposedItem, IShareable selectedItem, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (proposedItem.isExecutable() == ((Shareable)selectedItem).getFileStorage().isExecutable((IProgressMonitor)monitor.newChild(30))) {
            return true;
        }
        if (commonAncestorItem == null) {
            return false;
        }
        if (proposedItem.isExecutable() == commonAncestorItem.isExecutable()) {
            return true;
        }
        boolean merged = ((Shareable)selectedItem).getFileStorage().setExecutable(proposedItem.isExecutable(), (IProgressMonitor)monitor.newChild(65));
        if (merged) {
            LocalChangeManager.getInstance().computeChanges(selectedItem, (IProgressMonitor)monitor.newChild(5));
        }
        return merged;
    }

    private void retryFileContentMerge(ITeamRepository teamRepository, FailedAutoResolveRequest request, Map<UUID, IVersionable> fetched, List<AutoResolveRequest> resolvedConflicts, IProgressMonitor progress) {
        SubMonitor itemProgress = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        AutoResolveRequest modModConflict = request.getRequest();
        IVersionableHandle commonAncestor = modModConflict.getCommonAncestorState();
        IVersionableHandle proposed = modModConflict.getProposedContributorState();
        if (!(modModConflict.logicalChange.item() instanceof IFileItemHandle)) {
            return;
        }
        IFileItem commonAncestorItem = (IFileItem)fetched.get(commonAncestor.getStateId());
        IFileItem proposedItem = (IFileItem)fetched.get(proposed.getStateId());
        if (proposedItem == null) {
            return;
        }
        try {
            IStatus status;
            IShareable shareable = request.getConflictedShareable();
            ResourceType type = shareable.getResourceType((IProgressMonitor)itemProgress.newChild(1));
            if (type == ResourceType.FILE && (status = this.getFileContentMerger().performAutoMerge(teamRepository, commonAncestorItem, proposedItem, shareable, request.getDefaultContentTypeMerger(), this.shed, (IProgressMonitor)itemProgress.newChild(94))).isOK()) {
                ((AutoResolveState)request.getResolveState()).contentMerged = true;
                LocalChangeManager.getInstance().computeChanges(shareable, (IProgressMonitor)itemProgress.newChild(5));
                if (((AutoResolveState)request.getResolveState()).isMerged()) {
                    resolvedConflicts.add(modModConflict);
                }
            }
        }
        catch (Exception e) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
        }
    }

    private int performStructuralAutoMerge(IProgressMonitor progress) {
        int mergeCount = 0;
        for (Map.Entry<UUID, List<AutoResolveRequest>> requestsByContext : this.autoMergeableConflicts.entrySet()) {
            IWorkspaceConnection wc = this.workspaces.get(requestsByContext.getKey());
            Map<ILogicalConflictReport, List<AutoResolveRequest>> requestsByReport = this.groupRequestsByReport(requestsByContext.getValue());
            for (Map.Entry<ILogicalConflictReport, List<AutoResolveRequest>> entry : requestsByReport.entrySet()) {
                ILogicalConflictReport conflictReport = entry.getKey();
                ArrayList<ILogicalChange> conflictsToAutoResolve = new ArrayList<ILogicalChange>();
                for (AutoResolveRequest request : entry.getValue()) {
                    conflictsToAutoResolve.add(request.logicalChange);
                }
                try {
                    IApplyAcceptedOperation op = IOperationFactory.instance.getApplyAcceptedOperation(this.applyAcceptedDilemmaHandler);
                    op.setContext(wc, conflictReport);
                    op.addChangesToResolve(conflictsToAutoResolve);
                    this.disableVerifyInSync(op);
                    op.run(progress);
                    mergeCount += op.numChangesResolved();
                }
                catch (Exception e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, Messages.AutoResolveOperation_1, e));
                }
            }
        }
        return mergeCount;
    }

    private Map<ILogicalConflictReport, List<AutoResolveRequest>> groupRequestsByReport(List<AutoResolveRequest> requests) {
        HashMap<ILogicalConflictReport, List<AutoResolveRequest>> result = new HashMap<ILogicalConflictReport, List<AutoResolveRequest>>();
        for (AutoResolveRequest autoResolveRequest : requests) {
            ArrayList<AutoResolveRequest> grouping = (ArrayList<AutoResolveRequest>)result.get(autoResolveRequest.getLogicalConflictReport());
            if (grouping == null) {
                grouping = new ArrayList<AutoResolveRequest>();
                result.put(autoResolveRequest.getLogicalConflictReport(), grouping);
            }
            grouping.add(autoResolveRequest);
        }
        return result;
    }

    private Map<ILogicalConflictReport, List<RemoteAutoResolver>> groupRemoteRequestsByReport(List<RemoteAutoResolver> requests) {
        HashMap<ILogicalConflictReport, List<RemoteAutoResolver>> result = new HashMap<ILogicalConflictReport, List<RemoteAutoResolver>>();
        for (RemoteAutoResolver request : requests) {
            ArrayList<RemoteAutoResolver> grouping = (ArrayList<RemoteAutoResolver>)result.get(request.getLogicalConflictReport());
            if (grouping == null) {
                grouping = new ArrayList<RemoteAutoResolver>();
                result.put(request.getLogicalConflictReport(), grouping);
            }
            grouping.add(request);
        }
        return result;
    }

    private static Map<UUID, IVersionable> fetchItems(IWorkspaceConnection wc, List<IVersionableHandle> toFetch, IProgressMonitor progress) throws TeamRepositoryException {
        HashMap<UUID, IVersionable> result = new HashMap<UUID, IVersionable>();
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)wc.teamRepository());
        if (!toFetch.isEmpty()) {
            List fetched = manager.versionableManager().fetchCompleteStates(toFetch, progress);
            for (IVersionable item : fetched) {
                if (item == null) continue;
                result.put(item.getStateId(), item);
            }
        }
        return result;
    }

    private boolean performFilePropertyAutoMerge(IFileItem commonAncestorItem, IFileItem proposedItem, Shareable shareable, SubMonitor progress) throws FileSystemException, TeamRepositoryException {
        final boolean[] success = new boolean[]{true};
        ChangePropertiesDilemmaHandler changePropertiesDilemmaHandler = new ChangePropertiesDilemmaHandler(){

            @Override
            public int invalidContentTypes(List<? extends IChangePropertiesRequest> invalidContentTypeChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                return 0;
            }

            @Override
            public int inconsistentLineDelimiters(List<? extends IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) throws FileSystemException {
                success[0] = false;
                return AutoResolveOperation.this.problemHandler.getChangePropertiesDilemmaHandler().inconsistentLineDelimiters(inconsistentDelimiters, monitor);
            }

            @Override
            public int invalidProperties(List<? extends IChangePropertiesRequest> invalidPropertyChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                success[0] = false;
                return AutoResolveOperation.this.problemHandler.getChangePropertiesDilemmaHandler().invalidProperties(invalidPropertyChangeRequests, monitor);
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return AutoResolveOperation.this.problemHandler.getBackupDilemmaHandler();
            }
        };
        IChangePropertiesOperation op = null;
        IFileContent proposedContent = proposedItem.getContent();
        IFileContent commonAncestorContent = null;
        if (commonAncestorItem != null) {
            commonAncestorContent = commonAncestorItem.getContent();
        }
        progress.setWorkRemaining(100);
        String currentContentType = shareable.getContentType((IProgressMonitor)progress.newChild(10));
        String proposedContentType = proposedItem.getContentType();
        String commonAncestorContentType = "";
        if (commonAncestorItem != null) {
            commonAncestorContentType = commonAncestorItem.getContentType();
        }
        if (!commonAncestorContentType.equals(proposedContentType)) {
            if (currentContentType == null || currentContentType.equals(commonAncestorContentType)) {
                op = IOperationFactory.instance.getChangePropertiesOperation(changePropertiesDilemmaHandler);
                op.setContentType(shareable, proposedContentType);
            } else if (!currentContentType.equals(proposedContentType)) {
                success[0] = false;
            }
        }
        FileLineDelimiter currentLineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(10));
        FileLineDelimiter proposedLineDelimiter = proposedContent.getLineDelimiter();
        FileLineDelimiter commonAncestorLineDelimiter = null;
        if (commonAncestorContent != null) {
            commonAncestorLineDelimiter = commonAncestorContent.getLineDelimiter();
        }
        if (success[0] && commonAncestorLineDelimiter != proposedLineDelimiter) {
            if (currentLineDelimiter == null || currentLineDelimiter == commonAncestorLineDelimiter) {
                if (op == null) {
                    op = IOperationFactory.instance.getChangePropertiesOperation(changePropertiesDilemmaHandler);
                }
                op.setLineDelimiter(shareable, proposedLineDelimiter);
            } else if (currentLineDelimiter != proposedLineDelimiter) {
                success[0] = false;
            }
        }
        if (success[0] && op != null) {
            this.disableVerifyInSync(op);
            op.run((IProgressMonitor)progress.newChild(80));
        }
        return success[0];
    }

    @Override
    public void autoResolveConflict(IWorkspaceConnection connection, ILogicalConflictReport conflictReport, ILogicalChange logicalChange) {
        if (conflictReport == null) {
            throw new IllegalArgumentException();
        }
        if (logicalChange == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        this.workspaces.put(connection.getResolvedWorkspace().getItemId(), connection);
        IUpdateReport report = conflictReport.conflictReport();
        IItemConflictReport conflictFound = null;
        for (IItemConflictReport conflictedItem : report.conflicts()) {
            if (!conflictedItem.item().sameItemId((IItemHandle)logicalChange.item())) continue;
            conflictFound = conflictedItem;
            break;
        }
        if (conflictFound == null) {
            ++this.conflictsResolvedCount;
        } else {
            AutoResolveRequest request = new AutoResolveRequest(connection, conflictReport, logicalChange, conflictFound);
            if (this.isEvilTwinResolvable(request)) {
                this.addRequest(this.evilTwinConflicts, request);
            } else if (request.isContentConflict()) {
                this.addRequest(this.contentConflicts, request);
            } else if (request.isAutoMergeable()) {
                this.addRequest(this.autoMergeableConflicts, request);
            }
        }
    }

    private void addRequest(HashMap<UUID, List<AutoResolveRequest>> requests, AutoResolveRequest request) {
        IContextHandle context = request.getAffectedConfiguation().getConnectionHandle();
        List<AutoResolveRequest> requestsForContext = requests.get(context.getItemId());
        if (requestsForContext == null) {
            requestsForContext = new ArrayList<AutoResolveRequest>();
            requests.put(context.getItemId(), requestsForContext);
        }
        requestsForContext.add(request);
    }

    @Override
    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    @Override
    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }

    public final class AutoResolveRequest {
        private final IItemConflictReport conflict;
        private final ILogicalChange logicalChange;
        private final ILogicalConflictReport conflictReport;
        private IWorkspaceConnection connection;
        private final ConfigurationFacade configurationDescriptor;
        private List<ILogicalChange> dependencyTree = null;

        public AutoResolveRequest(IWorkspaceConnection workspaceConnection, ILogicalConflictReport conflictReport, ILogicalChange logicalChange, IItemConflictReport conflict) {
            this.conflict = conflict;
            this.logicalChange = logicalChange;
            this.conflictReport = conflictReport;
            this.connection = workspaceConnection;
            this.configurationDescriptor = new ConfigurationFacade((IConnection)workspaceConnection, logicalChange.component());
        }

        public ILogicalChange getLogicalChange() {
            return this.logicalChange;
        }

        public ConfigurationFacade getAffectedConfiguation() {
            return this.configurationDescriptor;
        }

        public IVersionableHandle getProposedContributorState() {
            return this.conflict.getProposedContributorState();
        }

        public IVersionableHandle getCommonAncestorState() {
            return this.conflict.getCommonAncestorState();
        }

        public IVersionableHandle getSelectedContributorState() {
            return this.conflict.getSelectedContributorState();
        }

        public boolean isContentConflict() {
            ILogicalConflict logicalConflict;
            int conflictType;
            return this.logicalChange != null && this.logicalChange.kind() == 1 && ((conflictType = (logicalConflict = (ILogicalConflict)this.logicalChange).conflictType()) == 1 || conflictType == 9);
        }

        public boolean isAutoMergeable() {
            return this.logicalChange != null && this.logicalChange.kind() == 2;
        }

        public List<ILogicalChange> computeFlattenedDependencies() {
            if (this.dependencyTree == null) {
                ArrayList<ILogicalChange> toReturn = new ArrayList<ILogicalChange>();
                LinkedList<ILogicalChange> depsToProcess = new LinkedList<ILogicalChange>();
                HashSet<UUID> seenUuids = new HashSet<UUID>();
                depsToProcess.addAll(this.conflictReport.getDependentChanges(this.logicalChange));
                while (depsToProcess.size() > 0) {
                    ILogicalChange current = (ILogicalChange)depsToProcess.removeFirst();
                    if (seenUuids.contains(current.item().getItemId())) continue;
                    if (!this.logicalChange.item().sameItemId((IItemHandle)current.item())) {
                        toReturn.add(current);
                    }
                    seenUuids.add(current.item().getItemId());
                    List deps = this.conflictReport.getDependentChanges(current);
                    toReturn.ensureCapacity(toReturn.size() + deps.size());
                    for (ILogicalChange change : deps) {
                        if (seenUuids.contains(change.item().getItemId())) continue;
                        depsToProcess.add(change);
                    }
                }
                this.dependencyTree = toReturn;
            }
            return this.dependencyTree;
        }

        public ILogicalConflictReport getLogicalConflictReport() {
            return this.conflictReport;
        }
    }

    public final class AutoResolveState {
        boolean executableMerged;
        boolean propertiesMerged;
        boolean userPropertiesMerged;
        boolean externalDataMerged;
        boolean contentMerged;
        boolean addMerged;
        ResourceType mergeType;

        public AutoResolveState(IVersionableHandle type) {
            this.mergeType = type instanceof IFileItemHandle ? ResourceType.FILE : (type instanceof IFolderHandle ? ResourceType.FOLDER : ResourceType.SYMBOLIC_LINK);
        }

        boolean isMerged() {
            if (this.mergeType == ResourceType.FILE) {
                return this.executableMerged && this.propertiesMerged && this.contentMerged && this.addMerged && this.userPropertiesMerged && this.externalDataMerged;
            }
            if (this.mergeType == ResourceType.SYMBOLIC_LINK) {
                return this.userPropertiesMerged && this.contentMerged && this.addMerged;
            }
            if (this.mergeType == ResourceType.FOLDER) {
                return this.userPropertiesMerged && this.addMerged;
            }
            return false;
        }
    }

    private static class DeferredReparentingOperands {
        ArrayList<IFolderHandle> oldParents = new ArrayList();
        ArrayList<IFolderHandle> newParents = new ArrayList();
        HashSet<UUID> doNotReparent = new HashSet();

        private DeferredReparentingOperands() {
        }

        public void add(IFolderHandle oldParent, IFolderHandle newParent) {
            this.oldParents.add(oldParent);
            this.newParents.add(newParent);
        }

        public void exclude(IVersionableHandle v) {
            this.doNotReparent.add(v.getItemId());
        }

        public void run(AutoResolveRequest req, ISandbox sandbox, ChangeSetChooser chooser, SubMonitor monitor) throws TeamRepositoryException {
            monitor.setWorkRemaining(3);
            monitor.beginTask("Adjusting parent hierarchy", 3);
            IWorkspaceConnection.IConfigurationOpFactory opFactory = req.connection.configurationOpFactory();
            IConfiguration config = req.connection.configuration(req.configurationDescriptor.getComponentHandle());
            List children = config.childEntries(this.oldParents, (IProgressMonitor)monitor.newChild(1));
            ArrayList toFetch = new ArrayList();
            for (Map family : children) {
                toFetch.addAll(family.values());
            }
            IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)req.connection.teamRepository());
            List fetched = manager.versionableManager().fetchCompleteStates(toFetch, (IProgressMonitor)monitor.newChild(1));
            HashMap<UUID, IVersionable> kids = new HashMap<UUID, IVersionable>(fetched.size());
            for (IVersionable v : fetched) {
                kids.put(v.getItemId(), v);
            }
            monitor.setWorkRemaining(this.oldParents.size());
            int i = 0;
            while (i < this.oldParents.size()) {
                IFolderHandle newParent = this.newParents.get(i);
                SubMonitor childMonitor = monitor.newChild(1);
                childMonitor.setWorkRemaining(kids.size());
                for (IVersionableHandle child : ((Map)children.get(i)).values()) {
                    if (this.doNotReparent.contains(child.getItemId())) continue;
                    IVersionable full = (IVersionable)kids.get(child.getItemId());
                    IVersionable workingCopy = (IVersionable)full.getWorkingCopy();
                    workingCopy.setParent(newParent);
                    IWorkspaceConnection.ISaveOp op = opFactory.save(workingCopy);
                    chooser.toCommit(req.configurationDescriptor.getComponentHandle(), child, (IWorkspaceConnection.IConfigurationOp)op, (IProgressMonitor)childMonitor.newChild(1));
                }
                childMonitor.done();
                ++i;
            }
        }
    }
}

