/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalConflict;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictRecord;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictTracker;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.VersionableStateCache;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveLocalConflictsOperation;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class AutoResolveLocalOperation
extends FileSystemOperation
implements IAutoResolveLocalConflictsOperation {
    private int conflictsResolvedCount;
    private Shed shed;
    private Map<LocalChangeContext, AutoResolveRequest> requests;
    private IStatus status = Status.OK_STATUS;
    private ITeamRepository repository;
    private ISandbox sandbox;

    public AutoResolveLocalOperation(BackupDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? BackupDilemmaHandler.getDefault() : dilemmaHandler);
        this.shed = new Shed(dilemmaHandler == null ? BackupDilemmaHandler.getDefault() : dilemmaHandler);
        this.conflictsResolvedCount = 0;
        this.requests = new HashMap<LocalChangeContext, AutoResolveRequest>();
    }

    @Override
    public void setTeamRepository(ITeamRepository repository) {
        this.repository = repository;
    }

    @Override
    public void setSandbox(ISandbox sandbox) {
        this.sandbox = sandbox;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations();
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
                        ICopyFileAreaLockRequest lockRequest = cfaManager.lockRequestFactory().getLockRequest(affectedConfigurations, true);
                        ICopyFileAreasLock lock = cfaManager.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            AutoResolveLocalOperation.this.performAutoMerge((IProgressMonitor)progress.newChild(90));
                        }
                        finally {
                            lock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(op, Messages.AutoResolveOperation_2, (IProgressMonitor)progress.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.done();
    }

    void performAutoMerge(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.requests.size() * 3));
        HashMap<UUID, Throwable> exceptions = new HashMap<UUID, Throwable>();
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository);
        VersionableStateCache stateCache = new VersionableStateCache(manager);
        ILocation root = this.sandbox.getRoot();
        MultiStatus currentStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.AutoResolveOperation_3, null);
        for (AutoResolveRequest request : this.requests.values()) {
            ArrayList<LocalConflictRecord> conflicts;
            LocalConflictTracker tracker;
            IComponentHandle componentHandle;
            IContextHandle contextHandle;
            block18: {
                contextHandle = request.getContextHandle();
                componentHandle = request.getComponentHandle();
                LocalConflictManager.getInstance().beginUpdateOperation(contextHandle, componentHandle, root, monitor);
                tracker = LocalConflictManager.getInstance().getTracker(contextHandle, componentHandle, root, (IProgressMonitor)progress.newChild(1));
                conflicts = new ArrayList<LocalConflictRecord>(request.getVersionables().size());
                for (UUID versionableID : request.getVersionables()) {
                    LocalConflictRecord conflict;
                    LocalConflictRecord localConflictRecord = conflict = tracker != null ? tracker.getConflict(versionableID) : null;
                    if (conflict == null) {
                        currentStatus.merge(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.AutoResolveLocalOperation_1, (Object)conflict.getVersionableHandle().getItemId())));
                        continue;
                    }
                    if (conflict.isModificationConflict() && conflict.getCommonAncestor() != null) {
                        stateCache.add(conflict.getVersionableHandle());
                        stateCache.add(conflict.getCommonAncestor());
                        conflicts.add(conflict);
                        continue;
                    }
                    currentStatus.merge(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.AutoResolveLocalOperation_2, (Object)conflict.getVersionableHandle().getItemId())));
                }
                stateCache.populate((IProgressMonitor)progress.newChild(1));
                if (!conflicts.isEmpty()) break block18;
                currentStatus.merge(FileSystemStatusUtil.getStatusFor(4, Messages.AutoResolveLocalOperation_0));
                LocalConflictManager.getInstance().endUpdateOperation(contextHandle, componentHandle, root);
                continue;
            }
            try {
                try {
                    for (LocalConflictRecord conflict : conflicts) {
                        try {
                            IFileItem proposedItem = (IFileItem)stateCache.getVersionable(conflict.getVersionableHandle());
                            IFileItem commonAncestorItem = (IFileItem)stateCache.getVersionable(conflict.getCommonAncestor());
                            if (commonAncestorItem == null || proposedItem == null) {
                                exceptions.put(conflict.getVersionableHandle().getItemId(), (Throwable)((Object)new FileSystemException("Could not retrieve item state from the repository")));
                                continue;
                            }
                            IShareable shareable = this.sandbox.findShareable(contextHandle, componentHandle, conflict.getVersionableHandle(), (IProgressMonitor)progress.newChild(1));
                            if (shareable == null) {
                                exceptions.put(conflict.getVersionableHandle().getItemId(), (Throwable)((Object)new FileSystemException("Could not retrieve shareable")));
                                continue;
                            }
                            IStatus autoMergeStatus = this.getFileContentMerger().performAutoMerge(this.repository, commonAncestorItem, proposedItem, shareable, "org.eclipse.core.runtime.text", this.shed, (IProgressMonitor)progress.newChild(1));
                            currentStatus.merge(autoMergeStatus);
                            if (!autoMergeStatus.isOK()) continue;
                            FileLineDelimiter lineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(1));
                            if (!(lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_PLATFORM) || lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE) || lineDelimiter.equals((Object)FileLineDelimiter.getPlatformDelimiter()))) {
                                try {
                                    this.getFileContentMerger().convertLineDelimiter(shareable, proposedItem, lineDelimiter, this.shed, (IProgressMonitor)progress.newChild(1));
                                }
                                catch (Exception e) {
                                    exceptions.put(conflict.getVersionableHandle().getItemId(), e);
                                    continue;
                                }
                            }
                            ++this.conflictsResolvedCount;
                            if (tracker == null) continue;
                            tracker.remove(conflict.getVersionableHandle());
                        }
                        catch (TeamRepositoryException e) {
                            exceptions.put(conflict.getVersionableHandle().getItemId(), e);
                        }
                        catch (IOException e) {
                            exceptions.put(conflict.getVersionableHandle().getItemId(), e);
                        }
                    }
                }
                catch (TeamRepositoryException e1) {
                    exceptions.put(request.getComponentHandle().getItemId(), e1);
                    LocalConflictManager.getInstance().endUpdateOperation(contextHandle, componentHandle, root);
                    continue;
                }
            }
            catch (Throwable throwable) {
                LocalConflictManager.getInstance().endUpdateOperation(contextHandle, componentHandle, root);
                throw throwable;
            }
            LocalConflictManager.getInstance().endUpdateOperation(contextHandle, componentHandle, root);
        }
        this.status = !exceptions.isEmpty() ? this.asStatus(exceptions) : (!currentStatus.isOK() ? currentStatus : Status.OK_STATUS);
    }

    private Set<ConfigurationFacade> getAffectedConfigurations() {
        HashSet<ConfigurationFacade> facades = new HashSet<ConfigurationFacade>();
        for (LocalChangeContext context : this.requests.keySet()) {
            facades.add(new ConfigurationFacade(this.repository, context.getConnection(), context.getComponent()));
        }
        return facades;
    }

    @Override
    public int numberOfConflictsResolved() {
        return this.conflictsResolvedCount;
    }

    @Override
    public void addConflictToResolve(ILocalConflict conflict) {
        LocalChangeContext localChangeContext = new LocalChangeContext(conflict.getComponent(), conflict.getContextHandle(), this.sandbox.getRoot());
        AutoResolveRequest autoResolveRequest = this.internalGetRequest(localChangeContext);
        autoResolveRequest.addVersionableToResolve(conflict.getItemID());
    }

    private AutoResolveRequest internalGetRequest(LocalChangeContext localChangeContext) {
        AutoResolveRequest autoResolveRequest = this.requests.get(localChangeContext);
        if (autoResolveRequest == null) {
            autoResolveRequest = new AutoResolveRequest(localChangeContext.getConnection(), localChangeContext.getComponent());
            this.requests.put(localChangeContext, autoResolveRequest);
        }
        return autoResolveRequest;
    }

    private IStatus asStatus(Map<UUID, Throwable> exceptions) {
        if (exceptions.size() == 1) {
            return FileSystemStatusUtil.getStatusFor(exceptions.values().iterator().next());
        }
        IStatus[] children = new IStatus[exceptions.size()];
        int i = 0;
        for (Throwable t : exceptions.values()) {
            children[i++] = FileSystemStatusUtil.getStatusFor(t);
        }
        return new MultiStatus("com.ibm.team.filesystem.client", 0, children, Messages.AutoResolveOperation_3, null);
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    private static final class AutoResolveRequest {
        private final IComponentHandle componentHandle;
        private final IContextHandle contextHandle;
        private final List<UUID> versionableIDs = new ArrayList<UUID>();

        public AutoResolveRequest(IContextHandle connection, IComponentHandle component) {
            this.contextHandle = connection;
            this.componentHandle = component;
        }

        public IContextHandle getContextHandle() {
            return this.contextHandle;
        }

        public IComponentHandle getComponentHandle() {
            return this.componentHandle;
        }

        public void addVersionableToResolve(UUID itemHandle) {
            this.versionableIDs.add(itemHandle);
        }

        public List<UUID> getVersionables() {
            return this.versionableIDs;
        }
    }
}

