/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalConflict;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractResolveLocalConflictsOperation
extends FileSystemOperation {
    HashMap<UUID, HashMap<UUID, Collection<ILocalConflict>>> conflictByContext = new HashMap();
    private LocalConflictDescriptorCollection conflicts = new LocalConflictDescriptorCollection();

    protected AbstractResolveLocalConflictsOperation(DilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        Collection<Collection<ILocalConflict>> contextBuckets = this.conflicts.getPartitionedConflicts();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)contextBuckets.size());
        for (Collection<ILocalConflict> collection : contextBuckets) {
            this.doExecute(collection, (IProgressMonitor)progress.newChild(1));
        }
    }

    protected abstract void doExecute(Collection<ILocalConflict> var1, IProgressMonitor var2) throws FileSystemException, TeamRepositoryException;

    public void addConflictsToResolve(Collection<ILocalConflict> conflictDescriptors) {
        if (conflictDescriptors == null) {
            throw new IllegalArgumentException();
        }
        this.conflicts.addAll(conflictDescriptors);
    }

    public void addConflictToResolve(ILocalConflict conflictDescriptor) {
        if (conflictDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.conflicts.add(conflictDescriptor);
    }

    private class LocalConflictDescriptorCollection {
        private LocalConflictDescriptorCollection() {
        }

        public void add(ILocalConflict conflict) {
            UUID componentID;
            Collection<ILocalConflict> conflicts;
            if (conflict == null) {
                throw new IllegalArgumentException();
            }
            UUID contextId = conflict.getContextHandle().getItemId();
            HashMap<Object, Collection<ILocalConflict>> conflictByComponent = AbstractResolveLocalConflictsOperation.this.conflictByContext.get(contextId);
            if (conflictByComponent == null) {
                conflictByComponent = new HashMap();
                AbstractResolveLocalConflictsOperation.this.conflictByContext.put(contextId, conflictByComponent);
            }
            if ((conflicts = conflictByComponent.get(componentID = conflict.getComponent().getItemId())) == null) {
                conflicts = new ArrayList<ILocalConflict>();
                conflictByComponent.put(componentID, conflicts);
            }
            conflicts.add(conflict);
        }

        public void addAll(Collection<ILocalConflict> conflictDescriptors) {
            if (conflictDescriptors == null) {
                throw new IllegalArgumentException();
            }
            for (ILocalConflict conflict : conflictDescriptors) {
                this.add(conflict);
            }
        }

        public Collection<Collection<ILocalConflict>> getPartitionedConflicts() {
            ArrayList<Collection<ILocalConflict>> result = new ArrayList<Collection<ILocalConflict>>();
            Collection<HashMap<UUID, Collection<ILocalConflict>>> conflictByComponentsBuckets = AbstractResolveLocalConflictsOperation.this.conflictByContext.values();
            for (HashMap<UUID, Collection<ILocalConflict>> conflictByComponentsBucket : conflictByComponentsBuckets) {
                result.addAll(conflictByComponentsBucket.values());
            }
            return result;
        }
    }
}

