/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.LockOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.ExclusiveFileLockPatternUtil;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.LockOperationFailureException;
import com.ibm.team.scm.common.dto.IAcceptCombinedUpdateReport;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchResult;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractLockOperation
extends FileSystemOperation {
    private Map<ITeamRepository, List<LockEntry>> repoBatch = new HashMap<ITeamRepository, List<LockEntry>>();

    public AbstractLockOperation(LockDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? new LockDilemmaHandler() : dilemmaHandler);
    }

    protected LockEntry add(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle, IContributorHandle contributorHandle) {
        LockEntry lockEntry = new LockEntry(workspaceConnection, componentHandle, versionableHandle, contributorHandle);
        this.addLockEntry(lockEntry);
        return lockEntry;
    }

    protected LockEntry add(IWorkspaceConnection sourceWorkspaceConnection, IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle, IContributorHandle contributorHandle) {
        LockEntry lockEntry = new LockEntry(sourceWorkspaceConnection, workspaceConnection, componentHandle, versionableHandle, contributorHandle);
        this.addLockEntry(lockEntry);
        return lockEntry;
    }

    protected void addLockEntry(LockEntry lockEntry) {
        ITeamRepository repo = lockEntry.getRepository();
        List<LockEntry> list = this.repoBatch.get(repo);
        if (list == null) {
            list = new ArrayList<LockEntry>();
            this.repoBatch.put(repo, list);
        }
        list.add(lockEntry);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.repoBatch.size());
        for (Map.Entry<ITeamRepository, List<LockEntry>> entry : this.repoBatch.entrySet()) {
            block5: {
                sub = progress.newChild(1).setWorkRemaining(100);
                lockEntries = entry.getValue();
                workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)entry.getKey());
                this.checkIncomingChanges(workspaceManager, lockEntries, (IProgressMonitor)sub.newChild(5));
                getLockProgress = sub.newChild(5);
                getLockProgress.setTaskName(Messages.AbstractLockOperation_0);
                lockOperations = this.getLockOperations(workspaceManager, lockEntries, (IProgressMonitor)getLockProgress);
                applyLockProgress = sub.newChild(85);
                applyLockProgress.setTaskName(Messages.AbstractLockOperation_1);
                try {
                    workspaceManager.applyLockOperations(lockOperations, (IProgressMonitor)applyLockProgress);
                    break block5;
                }
                catch (LockOperationFailureException e) {
                    strings = e.getMessage().split("\r\n|\r|\n");
                    if (strings.length == 1) {
                        throw e;
                    }
                    errors = new IStatus[strings.length];
                    i = 0;
                    ** while (i < strings.length)
                }
lbl-1000:
                // 1 sources

                {
                    errors[i] = FileSystemStatusUtil.getStatusFor(4, strings[i]);
                    ++i;
                    continue;
                }
lbl25:
                // 1 sources

                status = new MultiStatus("com.ibm.team.filesystem.client", 4, errors, Messages.AbstractLockOperation_2, null);
                throw new FileSystemStatusException((IStatus)status);
            }
            this.refreshFileAttributes(lockEntries, sub.newChild(5));
        }
    }

    private void checkIncomingChanges(IWorkspaceManager workspaceManager, List<LockEntry> lockEntries, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.isLockOperation()) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(lockEntries.size() * 4));
        IWorkspaceConnection sourceWorkspace = null;
        for (LockEntry lockEntry : lockEntries) {
            sourceWorkspace = lockEntry.getSourceWorkspaceConnection((IProgressMonitor)sub.newChild(1));
            if (sourceWorkspace != null) break;
        }
        if (sourceWorkspace == null) {
            return;
        }
        HashMap<UUID, IWorkspaceConnection> streams = new HashMap<UUID, IWorkspaceConnection>();
        HashMap<UUID, LockEntry> byVersionable = new HashMap<UUID, LockEntry>();
        HashMap<UUID, HashMap<UUID, IVersionableHandle>> byStream = new HashMap<UUID, HashMap<UUID, IVersionableHandle>>();
        HashMap componentsForTarget = new HashMap();
        for (LockEntry lockEntry : lockEntries) {
            byVersionable.put(lockEntry.getVersionable().getItemId(), lockEntry);
            IWorkspaceConnection stream = lockEntry.getWorkspaceConnection((IProgressMonitor)sub.newChild(1));
            UUID id = stream.getResolvedWorkspace().getItemId();
            streams.put(id, stream);
            HashMap<UUID, IVersionableHandle> toLock = (HashMap<UUID, IVersionableHandle>)byStream.get(id);
            if (toLock == null) {
                toLock = new HashMap<UUID, IVersionableHandle>();
                byStream.put(id, toLock);
            }
            toLock.put(lockEntry.getVersionable().getItemId(), lockEntry.getVersionable());
            HashMap<UUID, IComponentHandle> components = (HashMap<UUID, IComponentHandle>)componentsForTarget.get(id);
            if (components == null) {
                components = new HashMap<UUID, IComponentHandle>();
                componentsForTarget.put(id, components);
            }
            IComponentHandle c = lockEntry.getComponent();
            components.put(c.getItemId(), c);
        }
        sub.setWorkRemaining(streams.size());
        ArrayList<LockEntry> conflictedLocks = new ArrayList<LockEntry>();
        for (Map.Entry entry : streams.entrySet()) {
            IWorkspaceConnection stream = (IWorkspaceConnection)entry.getValue();
            ArrayList components = new ArrayList(((Map)componentsForTarget.get(entry.getKey())).values());
            IAcceptCombinedUpdateReport compareReport = sourceWorkspace.fetchAcceptCombinedUpdateReport(stream, 0, components, (IProgressMonitor)sub.newChild(1));
            Collection updates = compareReport.getUpdateReport().updates();
            Map toLock = (Map)byStream.get(entry.getKey());
            for (IItemUpdateReport report : updates) {
                LockEntry lockEntry;
                IVersionableHandle item = report.item();
                if (!toLock.containsKey(item.getItemId()) || (lockEntry = (LockEntry)byVersionable.get(item.getItemId())) == null) continue;
                conflictedLocks.add(lockEntry);
            }
            Collection conflicts = compareReport.getUpdateReport().conflicts();
            for (IItemConflictReport report : conflicts) {
                LockEntry lockEntry;
                IVersionableHandle item = report.item();
                if (!toLock.containsKey(item.getItemId()) || (lockEntry = (LockEntry)byVersionable.get(item.getItemId())) == null) continue;
                conflictedLocks.add(lockEntry);
            }
        }
        if (!conflictedLocks.isEmpty()) {
            Map map = Collections.singletonMap(workspaceManager.teamRepository(), conflictedLocks);
            int result = this.getDilemmaHandler().incomingChangesToLockedFiles(map);
            if (result != 0) {
                throw new OperationCanceledException();
            }
        }
    }

    @Override
    protected LockDilemmaHandler getDilemmaHandler() {
        return (LockDilemmaHandler)super.getDilemmaHandler();
    }

    private List<IWorkspaceManager.IVersionableLockOperation> getLockOperations(IWorkspaceManager workspaceManager, List<LockEntry> lockEntries, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)lockEntries.size());
        IWorkspaceManager.IVersionableLockOperationFactory lockOperationFactory = workspaceManager.lockOperationFactory();
        ArrayList<IWorkspaceManager.IVersionableLockOperation> lockOperations = new ArrayList<IWorkspaceManager.IVersionableLockOperation>();
        for (LockEntry lockEntry : lockEntries) {
            IWorkspaceConnection connection;
            IWorkspaceManager.IVersionableLockOperation op = this.getLockOperation(lockOperationFactory, lockEntry, connection = workspaceManager.getWorkspaceConnection(lockEntry.getStream(), (IProgressMonitor)sub.newChild(1)));
            if (op == null) continue;
            lockOperations.add(op);
        }
        return lockOperations;
    }

    protected Map<ITeamRepository, List<LockEntry>> getRepositoryBatch() {
        return this.repoBatch;
    }

    protected abstract IWorkspaceManager.IVersionableLockOperation getLockOperation(IWorkspaceManager.IVersionableLockOperationFactory var1, LockEntry var2, IWorkspaceConnection var3);

    protected abstract boolean isLockOperation();

    protected int checkLockOwners(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        HashMap<ITeamRepository, List<LockEntry>> notLockOwner = new HashMap<ITeamRepository, List<LockEntry>>();
        for (Map.Entry<ITeamRepository, List<LockEntry>> entry : this.getRepositoryBatch().entrySet()) {
            IWorkspaceManager workspaceManager;
            ITeamRepository repo = entry.getKey();
            IContributor caller = repo.loggedInContributor();
            HashMap workspaceComponentLockSearch = new HashMap();
            ArrayList<IWorkspaceHandle> streamLockSearch = new ArrayList<IWorkspaceHandle>();
            HashMap<ItemId, ArrayList<IComponentHandle>> componentsInStreamLockSearch = new HashMap<ItemId, ArrayList<IComponentHandle>>();
            for (LockEntry lockEntry : entry.getValue()) {
                IContributorHandle owner = lockEntry.getContributor();
                if (owner == null) {
                    ArrayList<IVersionableHandle> versionables;
                    if (lockEntry.isStreamLockEntry()) {
                        streamLockSearch.add(lockEntry.getStream());
                        continue;
                    }
                    if (lockEntry.isComponentLockEntry()) {
                        ItemId id = ItemId.create((IItemHandle)lockEntry.getStream());
                        ArrayList<IComponentHandle> components = (ArrayList<IComponentHandle>)componentsInStreamLockSearch.get(id);
                        if (components == null) {
                            components = new ArrayList<IComponentHandle>();
                            componentsInStreamLockSearch.put(id, components);
                        }
                        components.add(lockEntry.getComponent());
                        continue;
                    }
                    HashMap<UUID, ArrayList<IVersionableHandle>> componentLockSearch = (HashMap<UUID, ArrayList<IVersionableHandle>>)workspaceComponentLockSearch.get(lockEntry.getStream().getItemId());
                    if (componentLockSearch == null) {
                        componentLockSearch = new HashMap<UUID, ArrayList<IVersionableHandle>>();
                        workspaceComponentLockSearch.put(lockEntry.getStream().getItemId(), componentLockSearch);
                    }
                    if ((versionables = (ArrayList<IVersionableHandle>)componentLockSearch.get(lockEntry.getComponent().getItemId())) == null) {
                        versionables = new ArrayList<IVersionableHandle>();
                        componentLockSearch.put(lockEntry.getComponent().getItemId(), versionables);
                    }
                    versionables.add(lockEntry.getVersionable());
                    continue;
                }
                if (owner.sameItemId((IItemHandle)caller)) continue;
                ArrayList<LockEntry> list = (ArrayList<LockEntry>)notLockOwner.get(repo);
                if (list == null) {
                    list = new ArrayList<LockEntry>();
                    notLockOwner.put(repo, list);
                }
                list.add(lockEntry);
            }
            if (!workspaceComponentLockSearch.isEmpty()) {
                monitor.setWorkRemaining(workspaceComponentLockSearch.size() * 100);
                workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                for (Map.Entry entry2 : workspaceComponentLockSearch.entrySet()) {
                    IWorkspaceHandle streamHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((UUID)entry2.getKey(), null);
                    SubMonitor subMonitor = monitor.newChild(100);
                    subMonitor.setWorkRemaining(10 * ((Map)entry2.getValue()).size());
                    for (Map.Entry search : ((Map)entry2.getValue()).entrySet()) {
                        IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((UUID)search.getKey(), null);
                        List versionableHandles = (List)search.getValue();
                        SubMonitor iterMonitor2 = subMonitor.newChild(10);
                        iterMonitor2.setWorkRemaining(versionableHandles.size());
                        while (!versionableHandles.isEmpty()) {
                            int count = 0;
                            ILockSearchCriteria searchCriteria = ILockSearchCriteria.FACTORY.newInstance();
                            searchCriteria.getStreams().add(streamHandle);
                            searchCriteria.getComponents().add(componentHandle);
                            Iterator iter = versionableHandles.iterator();
                            while (count < 512 && iter.hasNext()) {
                                IVersionableHandle handle = (IVersionableHandle)iter.next();
                                iter.remove();
                                searchCriteria.getVersionables().add(handle);
                                ++count;
                            }
                            ILockSearchResult result = workspaceManager.findLocks(searchCriteria, 512, (IProgressMonitor)iterMonitor2.newChild(searchCriteria.getVersionables().size()));
                            for (IStreamLockReport report : result.getReports()) {
                                for (IComponentLockReport lockReport : report.getComponentLocks()) {
                                    for (IVersionableLock lock : lockReport.getLocks()) {
                                        if (lock.getContributor().sameItemId((IItemHandle)caller)) continue;
                                        ArrayList<LockEntry> list = (ArrayList<LockEntry>)notLockOwner.get(repo);
                                        if (list == null) {
                                            list = new ArrayList<LockEntry>();
                                            notLockOwner.put(repo, list);
                                        }
                                        LockEntry lockEntry = new LockEntry(repo, streamHandle, componentHandle, lock.getVersionable(), lock.getContributor());
                                        list.add(lockEntry);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!streamLockSearch.isEmpty()) {
                workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                SubMonitor subMonitor = monitor.newChild(streamLockSearch.size());
                List workspaceConnections = workspaceManager.getWorkspaceConnections(streamLockSearch, (IProgressMonitor)subMonitor);
                int i = 0;
                while (i < workspaceConnections.size()) {
                    IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)workspaceConnections.get(i);
                    if (workspaceConnection.isLocked() && !caller.getItemId().getUuidValue().equals(workspaceConnection.getLockOwnerItemID())) {
                        ArrayList<LockEntry> list = (ArrayList<LockEntry>)notLockOwner.get(repo);
                        if (list == null) {
                            list = new ArrayList<LockEntry>();
                            notLockOwner.put(repo, list);
                        }
                        IContributorHandle lockOwnerHandle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceConnection.getLockOwnerItemID()), null);
                        IContributor lockOwner = (IContributor)repo.itemManager().fetchCompleteItem((IItemHandle)lockOwnerHandle, 0, (IProgressMonitor)subMonitor);
                        LockEntry lockEntry = new LockEntry(repo, (IWorkspaceHandle)streamLockSearch.get(i), null, null, (IContributorHandle)lockOwner);
                        list.add(lockEntry);
                    }
                    ++i;
                }
            }
            if (componentsInStreamLockSearch.isEmpty()) continue;
            workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            SubMonitor subMonitor = monitor.newChild(componentsInStreamLockSearch.size());
            ArrayList<IWorkspaceHandle> workspaces = new ArrayList<IWorkspaceHandle>(componentsInStreamLockSearch.size());
            for (ItemId id : componentsInStreamLockSearch.keySet()) {
                workspaces.add((IWorkspaceHandle)id.toHandle());
            }
            List workspaceConnections = workspaceManager.getWorkspaceConnections(workspaces, (IProgressMonitor)subMonitor);
            int i = 0;
            while (i < workspaceConnections.size()) {
                IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)workspaceConnections.get(i);
                List components = (List)componentsInStreamLockSearch.get(ItemId.create((IItemHandle)workspaceConnection.getContextHandle()));
                for (IComponentHandle componentHandle : components) {
                    if (!workspaceConnection.isLocked(componentHandle) || caller.getItemId().getUuidValue().equals(workspaceConnection.getLockOwnerItemID(componentHandle))) continue;
                    ArrayList<LockEntry> list = (ArrayList<LockEntry>)notLockOwner.get(repo);
                    if (list == null) {
                        list = new ArrayList<LockEntry>();
                        notLockOwner.put(repo, list);
                    }
                    IContributorHandle lockOwnerHandle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceConnection.getLockOwnerItemID(componentHandle)), null);
                    IContributor lockOwner = (IContributor)repo.itemManager().fetchCompleteItem((IItemHandle)lockOwnerHandle, 0, (IProgressMonitor)subMonitor);
                    LockEntry lockEntry = new LockEntry(repo, (IWorkspaceHandle)workspaceConnection.getContextHandle(), componentHandle, null, (IContributorHandle)lockOwner);
                    list.add(lockEntry);
                }
                ++i;
            }
        }
        LockDilemmaHandler handler = this.getDilemmaHandler();
        int result = !notLockOwner.isEmpty() ? handler.currentUserDoesntOwnLock(notLockOwner) : 3;
        return result;
    }

    private void refreshFileAttributes(List<LockEntry> lockEntries, SubMonitor subMonitor) throws TeamRepositoryException {
        HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>();
        HashMap<IWorkspaceConnection, List<StringMatcher>> patterns = new HashMap<IWorkspaceConnection, List<StringMatcher>>();
        HashMap workspaceComponent = new HashMap();
        for (LockEntry lockEntry : lockEntries) {
            List<StringMatcher> matchers;
            IFlowEntry defaultFlowEntry;
            IWorkspaceConnection workspaceConnection = lockEntry.getSourceWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1));
            if (workspaceConnection == null || (defaultFlowEntry = workspaceConnection.getFlowTable().getDefaultDeliverFlow()) == null || !defaultFlowEntry.getFlowNode().getItemId().equals((Object)lockEntry.getStream().getItemId()) || (matchers = this.hasPattern(workspaceConnection, patterns, subMonitor.newChild(1))) == null || matchers.size() == 0) continue;
            ArrayList<IComponentHandle> components = (ArrayList<IComponentHandle>)workspaceComponent.get(workspaceConnection);
            if (components == null) {
                components = new ArrayList<IComponentHandle>();
                workspaceComponent.put(workspaceConnection, components);
            }
            if (components.contains(lockEntry.getComponent())) continue;
            components.add(lockEntry.getComponent());
            configurations.add(new ConfigurationFacade((IConnection)lockEntry.getSourceWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1)), lockEntry.getComponent()));
        }
        if (configurations.size() == 0) {
            return;
        }
        Map<ISandbox, Set<ConfigurationFacade>> affectedAreas = ExclusiveFileLockPatternUtil.getCopyFileAreasAffected(configurations, (IProgressMonitor)subMonitor.newChild(10));
        if (affectedAreas.size() == 0) {
            return;
        }
        HashMap<IWorkspaceConnection, ISandbox> sandboxes = new HashMap<IWorkspaceConnection, ISandbox>();
        for (LockEntry lockEntry : lockEntries) {
            IShareable shareable;
            IWorkspaceConnection workspaceConnection = lockEntry.getSourceWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1));
            ISandbox sandbox = null;
            if (sandboxes.containsKey(workspaceConnection)) {
                sandbox = (ISandbox)sandboxes.get(workspaceConnection);
            } else {
                sandbox = ExclusiveFileLockPatternUtil.getSandbox(affectedAreas, workspaceConnection, subMonitor.newChild(1));
                sandboxes.put(workspaceConnection, sandbox);
            }
            if (sandbox == null || (shareable = sandbox.findShareable(workspaceConnection.getContextHandle(), lockEntry.getComponent(), lockEntry.getVersionable(), (IProgressMonitor)subMonitor.newChild(1))) == null) continue;
            List matchers = (List)patterns.get(workspaceConnection);
            if (this instanceof LockOperation) {
                ExclusiveFileLockPatternUtil.makeFileWriteable(shareable, matchers);
                continue;
            }
            ILocalChange localChange = shareable.getChange((IProgressMonitor)subMonitor.newChild(1));
            if (localChange == null || localChange.getType() != 0) continue;
            ExclusiveFileLockPatternUtil.makeFileReadOnly(shareable, matchers);
        }
    }

    private List<StringMatcher> hasPattern(IWorkspaceConnection workspaceConnection, Map<IWorkspaceConnection, List<StringMatcher>> workspacePatterns, SubMonitor progress) {
        List<StringMatcher> patterns = workspacePatterns.get(workspaceConnection);
        if (patterns != null) {
            return patterns;
        }
        patterns = ExclusiveFileLockPatternUtil.getPatternsToMatch((IConnection)workspaceConnection, (IProgressMonitor)progress.newChild(1));
        workspacePatterns.put(workspaceConnection, patterns);
        return patterns;
    }
}

