/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.AbortCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAbortCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class AbortPortsOperation
extends ChangeHistoryChangeSetsOperation
implements IAbortCurrentPatchOperation {
    private final Map<IWorkspaceConnection, List<IComponentHandle>> abortRequests;
    private int flags = 0;
    private final AbortCurrentPatchDilemmaHandler problemHandler;

    public AbortPortsOperation(AbortCurrentPatchDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? AbortCurrentPatchDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? AbortCurrentPatchDilemmaHandler.getDefault() : dilemmaHandler;
        this.abortRequests = new HashMap<IWorkspaceConnection, List<IComponentHandle>>();
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.abortRequests.size());
        for (Map.Entry<IWorkspaceConnection, List<IComponentHandle>> entry : this.abortRequests.entrySet()) {
            IWorkspaceConnection workspaceConnection = entry.getKey();
            List<IComponentHandle> components = entry.getValue();
            List<IChangeSetHandle> changeSetsToReferesh = this.getChangeSetsForCurrentPorts(workspaceConnection, components);
            ChangeSetRefreshUtils.refreshLocalForRemoval(refresher, affectedAreas, workspaceConnection, changeSetsToReferesh, (IProgressMonitor)monitor.newChild(1));
        }
    }

    private List<IChangeSetHandle> getChangeSetsForCurrentPorts(IWorkspaceConnection workspaceConnection, List<IComponentHandle> components) {
        ArrayList<IChangeSetHandle> changeSetsToReferesh = new ArrayList<IChangeSetHandle>();
        for (IComponentHandle component : components) {
            ICurrentPatch currentPort = workspaceConnection.getCurrentPatch(component);
            if (currentPort == null || currentPort.getTargetChangeSet() == null) continue;
            changeSetsToReferesh.add(currentPort.getTargetChangeSet());
        }
        return changeSetsToReferesh;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbortPortsOperation_0, (int)100);
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        final Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations(determinants, (IProgressMonitor)progress.newChild(4));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        AbortPortsOperation.this.abortPorts(affectedConfigurations, monitor);
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.AbortPortsOperation_1, (IProgressMonitor)progress.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    protected void abortPorts(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbortPortsOperation_2, (int)(3 * this.abortRequests.size() + 23));
        if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            SubMonitor iterProgress = progress.newChild(1);
            iterProgress.setWorkRemaining(affectedConfigurations.size());
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
            for (ConfigurationFacade configurationFacade : affectedConfigurations) {
                verifyOp.addToVerify(configurationFacade.getConnection((IProgressMonitor)iterProgress.newChild(1)), configurationFacade.getComponentHandle());
            }
            verifyOp.run((IProgressMonitor)progress.newChild(10));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
        try {
            this.checkinPendingChanges(affectedConfigurations, this.problemHandler, true, (IProgressMonitor)progress.newChild(10));
            for (Map.Entry entry : this.abortRequests.entrySet()) {
                try {
                    IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)entry.getKey();
                    List componentHandles = (List)entry.getValue();
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IUpdateReport report = workspaceConnection.abortCurrentPatch(((List)entry.getValue()).toArray(new IComponentHandle[((List)entry.getValue()).size()]), this.flags, (IProgressMonitor)progress.newChild(componentHandles.size()));
                    UpdateOperation updateOperation = new UpdateOperation(workspaceConnection, Collections.singletonList(report), 3, this.problemHandler, null);
                    this.disableVerifyInSync(updateOperation);
                    updateOperation.run((IProgressMonitor)progress.newChild(componentHandles.size()));
                }
                catch (TeamRepositoryException e) {
                    this.collectStatus((IStatus)new Status(4, "com.ibm.team.filesystem.client", "Error while discarding change set", (Throwable)e));
                }
            }
        }
        finally {
            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
        }
    }

    private Set<ConfigurationFacade> getAffectedConfigurations(Collection<IAuditable> determinants, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.abortRequests.size());
        HashSet<ConfigurationFacade> affectedConfigurations = new HashSet<ConfigurationFacade>();
        for (Map.Entry<IWorkspaceConnection, List<IComponentHandle>> entry : this.abortRequests.entrySet()) {
            IWorkspaceConnection workspaceConnection = entry.getKey();
            List<IComponentHandle> componentHandles = entry.getValue();
            for (IComponentHandle componentHandle : componentHandles) {
                affectedConfigurations.add(new ConfigurationFacade((IConnection)workspaceConnection, componentHandle));
            }
            List<IChangeSetHandle> changeSetHandles = this.getChangeSetsForCurrentPorts(workspaceConnection, componentHandles);
            List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, (IProgressMonitor)monitor.newChild(1));
            determinants.addAll(changeSets);
        }
        return affectedConfigurations;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void abort(IWorkspaceConnection workspace, Collection<? extends IComponentHandle> components) {
        void var4_8;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (components == null) {
            throw new IllegalArgumentException();
        }
        HashSet<UUID> checkForDuplicateInput = new HashSet<UUID>();
        for (IComponentHandle iComponentHandle : components) {
            if (checkForDuplicateInput.add(iComponentHandle.getItemId())) continue;
            throw new IllegalArgumentException();
        }
        List<IComponentHandle> list = this.abortRequests.get(workspace);
        if (list == null) {
            ArrayList arrayList = new ArrayList();
            this.abortRequests.put(workspace, arrayList);
        } else {
            HashSet<UUID> alreadyExisting = new HashSet<UUID>();
            for (IComponentHandle iComponentHandle : components) {
                alreadyExisting.add(iComponentHandle.getItemId());
            }
            if (checkForDuplicateInput.removeAll(alreadyExisting)) {
                throw new IllegalArgumentException();
            }
        }
        var4_8.addAll(components);
    }
}

