/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ISimpleItem;
import com.ibm.team.repository.common.ISimpleItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ItemLocator<T extends IItem> {
    private ItemNamespace namespace;
    private UUID itemId;
    private IItemType itemType;
    private int cachedHashcode = 0;

    public ItemLocator(ItemNamespace namespace, IItemType itemType, UUID itemId) {
        if (namespace == null || itemId == null || itemType == null) {
            throw new NullPointerException();
        }
        this.namespace = namespace;
        this.itemType = itemType;
        this.itemId = itemId;
        if (itemType.isUnmanaged() && !namespace.handlesVersionables()) {
            throw new IllegalArgumentException("Versionables need more than just a repository to uniquely identify their state selection. You must specify the namespace for a baseline, workspace, or era.");
        }
        if (itemType.isAuditable() && !namespace.handlesAuditables()) {
            throw new IllegalArgumentException("Auditables exist in a repository namespace. They can't be included in a workspace, baseline, etc.");
        }
        if (itemType.isSimple() && !namespace.handlesSimpleItems()) {
            throw new IllegalArgumentException("Simple items exist in a repository namespace. They can't be included in a workspace, baseline, etc.");
        }
    }

    public ItemLocator(ITeamRepository repo, IAuditableHandle handle) {
        this(RepositoryNamespace.create(repo), handle.getItemType(), handle.getItemId());
    }

    public ItemLocator(ITeamRepository repo, ItemId<? extends IItem> handle) {
        this(RepositoryNamespace.create(repo), handle.getItemType(), handle.getItemUUID());
    }

    public ITeamRepository getRepository() {
        return this.namespace.getRepository();
    }

    public static <K extends IItem> ItemLocator<K> create(ITeamRepository repo, ItemId<? extends K> handle) {
        return new ItemLocator(RepositoryNamespace.create(repo), handle.getItemType(), handle.getItemUUID());
    }

    public ItemLocator(ItemNamespace namespace, ItemId<T> itemId) {
        this(namespace, itemId.getItemType(), itemId.getItemUUID());
    }

    public ItemLocator(T sharedItem) {
        this(RepositoryNamespace.create(ClientRepositoryUtil.getRepository(sharedItem)), sharedItem.getItemType(), sharedItem.getItemId());
    }

    public static <T extends IItem> ItemLocator<T> forItem(T sharedItem) {
        return new ItemLocator<T>(RepositoryNamespace.create(ClientRepositoryUtil.getRepository(sharedItem)), ItemId.forItem(sharedItem));
    }

    public ItemId<T> getItemId() {
        return new ItemId(this.itemType, this.itemId);
    }

    public <K extends IItemHandle> K toHandle() {
        return (K)this.itemType.createItemHandle((Object)this.namespace.getRepository(), this.itemId, null);
    }

    public ItemNamespace getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        if (this.cachedHashcode == 0) {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
            result = 31 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
            this.cachedHashcode = result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        }
        return this.cachedHashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemLocator other = (ItemLocator)obj;
        if (this.itemId == null ? other.itemId != null : !this.itemId.equals((Object)other.itemId)) {
            return false;
        }
        if (this.itemType == null ? other.itemType != null : !this.itemType.equals(other.itemType)) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
    }

    public static <T extends IItem> List<ItemLocator<T>> idsToLocators(ItemNamespace namespace, Collection<ItemId<T>> ids) {
        ArrayList result = NewCollection.arrayList();
        for (ItemId<T> next : ids) {
            result.add(ItemLocator.create(namespace, next));
        }
        return result;
    }

    public static <T extends IItem> List<IItemHandle> locatorsToHandles(Collection<ItemLocator<T>> toClose) {
        ArrayList result = NewCollection.arrayList();
        for (ItemLocator<T> next : toClose) {
            result.add(next.toHandle());
        }
        return result;
    }

    public static <T extends IItem> List<ItemId<T>> locatorsToIds(List<ItemLocator<T>> componentChangeSets) {
        ArrayList result = NewCollection.arrayList();
        for (ItemLocator<T> next : componentChangeSets) {
            result.add(next.getItemId());
        }
        return result;
    }

    public static <T extends IItem> Map<ItemNamespace, List<ItemId<T>>> groupByNamespace(Collection<ItemLocator<T>> toGroup) {
        HashMap result = NewCollection.hashMap();
        for (ItemLocator<T> next : toGroup) {
            CollectionUtil.addToMapOfLists((Map)result, (Object)next.getNamespace(), next.getItemId());
        }
        return result;
    }

    public static <T extends IAuditable> ItemLocator<T> create(ITeamRepository namespace, IAuditableHandle item) {
        return new ItemLocator<T>(RepositoryNamespace.create(namespace), new ItemId((IItemHandle)item));
    }

    public static <T extends ISimpleItem> ItemLocator<T> create(ITeamRepository namespace, ISimpleItemHandle item) {
        return new ItemLocator<T>(RepositoryNamespace.create(namespace), new ItemId((IItemHandle)item));
    }

    public static <T extends IItem> ItemLocator<T> create(ItemNamespace namespace, ItemId<T> item) {
        return new ItemLocator<T>(namespace, item);
    }

    public static <T extends IItem> ItemLocator<T> create(ItemNamespace namespace, IItemHandle item) {
        return new ItemLocator<T>(namespace, item.getItemType(), item.getItemId());
    }

    public boolean isNull() {
        return this.itemId.equals((Object)ItemId.getNullItemUUID());
    }

    public IItemType getItemType() {
        return this.itemType;
    }

    public static <K extends IItem, T extends K> ItemLocator<K> upcast(ItemLocator<T> toConvert) {
        return toConvert;
    }
}

