/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraCache;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class EraNamespace
extends ItemNamespace {
    private final EraDescriptor era;

    public EraNamespace(EraDescriptor era) {
        this.era = era;
    }

    public final EraDescriptor getEra() {
        return this.era;
    }

    @Override
    public ItemId<IComponent> fetchComponentId(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.era.getComponent();
    }

    @Override
    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    @Override
    public IContextHandle getContextHandle() {
        return null;
    }

    @Override
    public IItemContext createContext(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String configurationName = this.computeConfigurationName(this.era, (IProgressMonitor)progress.newChild(100));
        return new EraContext(this.era, configurationName);
    }

    protected final String computeConfigurationName(EraDescriptor era, IProgressMonitor monitor) throws TeamRepositoryException {
        String configurationName = era.isEmpty() ? Messages.EraNamespace_0 : EraCache.getDefault().fetchChangeSetDescription(era, 0, monitor);
        return configurationName;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.era.getRepository();
    }

    @Override
    public boolean hasConnection() {
        return false;
    }

    @Override
    public boolean hasVersionableTree() {
        return true;
    }

    @Override
    public boolean handlesAuditables() {
        return false;
    }

    @Override
    public boolean handlesSimpleItems() {
        return false;
    }

    @Override
    public boolean handlesVersionables() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.era == null ? 0 : this.era.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EraNamespace other = (EraNamespace)obj;
        return !(this.era == null ? other.era != null : !this.era.equals(other.era));
    }

    public static EraNamespace create(EraDescriptor era) {
        if (era == null) {
            throw new NullPointerException();
        }
        return (EraNamespace)ItemNamespace.commonNamespace(new EraNamespace(era));
    }

    public static EraNamespace createEmptyNamespace(ITeamRepository repo, ItemId<IComponent> component) {
        return EraNamespace.create(EraDescriptor.createEmptyEra(repo, component));
    }
}

