/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;

public class EmptyNamespace
extends ItemNamespace {
    private ItemId<IComponent> component;
    private ITeamRepository repo;

    public static EmptyNamespace create(ITeamRepository repo, ItemId<IComponent> component) {
        return new EmptyNamespace(repo, component);
    }

    public EmptyNamespace(ITeamRepository repo, ItemId<IComponent> component) {
        this.component = component;
        this.repo = repo;
    }

    public ItemId<IComponent> getComponent() {
        return this.component;
    }

    @Override
    protected IItemContext createContext(IProgressMonitor monitor) throws TeamRepositoryException {
        return new EraContext(EraDescriptor.createEmptyEra(this.repo, this.component), Messages.EmptyNamespace_0);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmptyNamespace other = (EmptyNamespace)obj;
        return !(this.component == null ? other.component != null : !this.component.equals(other.component));
    }

    @Override
    public ItemId<IComponent> fetchComponentId(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.component;
    }

    @Override
    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    @Override
    public IContextHandle getContextHandle() {
        return null;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repo;
    }

    @Override
    public boolean handlesAuditables() {
        return true;
    }

    @Override
    public boolean handlesSimpleItems() {
        return true;
    }

    @Override
    public boolean handlesVersionables() {
        return true;
    }

    @Override
    public boolean hasConnection() {
        return false;
    }

    @Override
    public boolean hasVersionableTree() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }
}

