/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.magic;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;

public class MagicPattern {
    public final String pattern;
    public final StringMatcher matcher;
    public final String mimeType;
    public final FileLineDelimiter delim;
    public final String encoding;
    public final boolean isBuiltIn;

    public MagicPattern(String pattern, boolean ignoreCase, String mimeType, FileLineDelimiter delim, String encoding) {
        this(pattern, ignoreCase, mimeType, delim, encoding, false);
    }

    public MagicPattern(String pattern, boolean ignoreCase, String mimeType, FileLineDelimiter delim, String encoding, boolean isBuiltIn) {
        this.pattern = pattern;
        this.matcher = new StringMatcher(pattern, ignoreCase, false);
        this.mimeType = mimeType;
        this.delim = delim;
        this.encoding = encoding;
        this.isBuiltIn = isBuiltIn;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public FileLineDelimiter getDelim() {
        return this.delim;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public String toString() {
        return "(MagicPattern: " + this.pattern + "; " + this.mimeType + "; " + this.delim.toString() + "; " + this.encoding + (this.isBuiltIn ? "; isBuiltIn" : "") + ")";
    }
}

