/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictRecord;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedBufferedInputStream;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.LocaleUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class LocalConflictTracker {
    private static final Log log = LoggingHelper.getLog(LocalConflictTracker.class);
    public static final String REMEMBERED_CHANGE_SAFE_MODIFIER = ".backup";
    private HashMap<UUID, LocalConflictRecord> localConflicts = new HashMap();
    private LocalChangeContext context;
    private boolean needInitialization = true;

    public LocalConflictTracker(LocalChangeContext context) {
        this.context = context;
    }

    public LocalConflictRecord remove(IVersionableHandle versionable) {
        return this.remove(versionable.getItemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalConflictRecord remove(UUID versionableID) {
        if (LocalConflictTracker.isTracingEnabled()) {
            LocalConflictTracker.trace("Removing conflict for versionable " + versionableID.getUuidValue());
        }
        HashMap<UUID, LocalConflictRecord> hashMap = this.localConflicts;
        synchronized (hashMap) {
            return this.localConflicts.remove(versionableID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalConflictRecord findExisting(IVersionableHandle versionable) {
        HashMap<UUID, LocalConflictRecord> hashMap = this.localConflicts;
        synchronized (hashMap) {
            return this.localConflicts.get(versionable.getItemId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalConflictRecord internalCreateConflict(IVersionableHandle versionable, IRelativeLocation localPath) {
        HashMap<UUID, LocalConflictRecord> hashMap = this.localConflicts;
        synchronized (hashMap) {
            LocalConflictRecord record = this.findExisting(versionable);
            if (record == null) {
                record = new LocalConflictRecord(localPath);
                record.setVersionableHandle(versionable);
                record.setSandbox(this.getSandbox());
                this.localConflicts.put(versionable.getItemId(), record);
            }
            return record;
        }
    }

    private ISandbox getSandbox() {
        return SharingManager.getInstance().getSandbox(this.context.getRoot(), false);
    }

    public static void backupFile(ISandbox sandbox, IRelativeLocation path, IRelativeLocation backupPath, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        Shareable shareable = (Shareable)sandbox.findShareable(path, ResourceType.FILE);
        if (!(shareable = LocalConflictTracker.getShareableForExistingStorage(shareable, (IProgressMonitor)progress.newChild(1))).exists((IProgressMonitor)progress.newChild(1))) {
            IllegalStateException exception = new IllegalStateException(NLS.bind((String)"File {0} does not exist", (Object)shareable.getFullPath().toString()));
            exception.fillInStackTrace();
            throw new FileSystemException(exception);
        }
        Shareable backupShareable = (Shareable)sandbox.findShareable(backupPath, ResourceType.FILE);
        if (backupShareable.exists((IProgressMonitor)progress.newChild(1))) {
            IllegalStateException exception = new IllegalStateException(NLS.bind((String)"File {0} exist already", (Object)backupShareable.getFullPath().toString()));
            exception.fillInStackTrace();
            throw new FileSystemException(exception);
        }
        Shareable backupShareableParent = (Shareable)sandbox.findShareable(backupPath.removeLastSegments(1), ResourceType.FOLDER);
        if (!backupShareableParent.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1))) {
            IFileStorage storage = SharingManager.getInstance().getLocalFileStorage(shareable.getSandbox(), backupPath, ResourceType.FILE);
            backupShareable = storage.getShareable();
        }
        File source = (File)sandbox.getRoot().append(path).getAdapter(File.class);
        try {
            backupShareable.getFileStorage().create(new FileOptions(true, shareable, null), (InputStream)new UnsynchronizedBufferedInputStream((InputStream)new FileInputStream(source)), (IProgressMonitor)progress.newChild(1));
        }
        catch (FileNotFoundException e) {
            throw new FileSystemException(e);
        }
    }

    private static Shareable getShareableForExistingStorage(Shareable shareable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!shareable.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1))) {
            Shareable realShareable = null;
            ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(4));
            if (!shareable.getSandbox().isCaseSensitive()) {
                IFileStorage parentStorage = shareable.getFileStorage().getParent();
                if (parentStorage != null) {
                    IFileStorage child = parentStorage.getChild(shareable.getLocalPath().getName(), (IProgressMonitor)progress.newChild(95));
                    if (child != null) {
                        realShareable = child.getShareable();
                    }
                } else {
                    realShareable = LocalConflictTracker.getRealShareable(shareable, (IProgressMonitor)progress.newChild(95), type);
                }
            }
            if (realShareable == null) {
                IFileStorage storage = SharingManager.getInstance().getLocalFileStorage(shareable.getSandbox(), shareable.getLocalPath(), type == null ? ResourceType.FILE : type);
                realShareable = storage.getShareable();
            }
            shareable = realShareable;
        }
        return shareable;
    }

    private static Shareable getRealShareable(Shareable shareable, IProgressMonitor monitor, ResourceType type) throws FileSystemException {
        File asFile = (File)shareable.getFullPath().getAdapter(File.class);
        if (asFile == null) {
            return null;
        }
        Shareable realShareable = null;
        File parent = asFile.getParentFile();
        if (parent != null) {
            String name = LocaleUtil.fileSystemNormalization((String)shareable.getLocalPath().getName());
            File[] children = parent.listFiles();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)children.length);
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.getName().length() == name.length() && LocaleUtil.fileSystemNormalization((String)child.getName()).equals(name)) {
                    PathLocation path = new PathLocation((IPath)new Path(child.getAbsolutePath()));
                    realShareable = (Shareable)SharingManager.getInstance().findShareable(path, type == null ? ResourceType.FILE : type);
                    if (realShareable == null || realShareable.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1))) break;
                    realShareable = null;
                    break;
                }
                ++n2;
            }
        }
        return realShareable;
    }

    public static IRelativeLocation getSafeLocation(IShareable shareable) {
        IRelativeLocation backupPath = shareable.getLocalPath().removeLastSegments(1).append(String.valueOf(shareable.getLocalPath().getName()) + REMEMBERED_CHANGE_SAFE_MODIFIER);
        ILocation root = shareable.getSandbox().getRoot();
        File backupFile = (File)root.append(backupPath).getAdapter(File.class);
        while (backupFile.exists()) {
            backupPath = backupPath.removeLastSegments(1).append(String.valueOf(backupPath.getName()) + REMEMBERED_CHANGE_SAFE_MODIFIER);
            backupFile = (File)root.append(backupPath).getAdapter(File.class);
        }
        return backupPath;
    }

    public static boolean isSafeLocation(IRelativeLocation path) {
        return path.getName().endsWith(REMEMBERED_CHANGE_SAFE_MODIFIER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LocalConflictRecord> getConflicts() {
        HashMap<UUID, LocalConflictRecord> hashMap = this.localConflicts;
        synchronized (hashMap) {
            ArrayList<LocalConflictRecord> result = new ArrayList<LocalConflictRecord>();
            for (LocalConflictRecord localConflictRecord : this.localConflicts.values()) {
                result.add(localConflictRecord);
            }
            return result;
        }
    }

    public LocalChangeContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAfterShareRemoval(IRelativeLocation path, IProgressMonitor monitor) {
        HashMap<UUID, LocalConflictRecord> hashMap = this.localConflicts;
        synchronized (hashMap) {
            boolean changed = false;
            Iterator<Map.Entry<UUID, LocalConflictRecord>> iterator = this.localConflicts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, LocalConflictRecord> entry = iterator.next();
                if (!path.isPrefixOf(entry.getValue().getLocalPath())) continue;
                if (LocalConflictTracker.isTracingEnabled()) {
                    LocalConflictTracker.trace("Removing conflict for versionable " + entry.getValue().getVersionableHandle().getItemId() + " due to share removal");
                }
                iterator.remove();
                changed = true;
            }
            return changed;
        }
    }

    public void setLocalConflicts(Collection<LocalConflictRecord> localConflicts) {
        for (LocalConflictRecord localConflictRecord : localConflicts) {
            if (LocalConflictTracker.isTracingEnabled()) {
                LocalConflictTracker.trace("Loaded conflict for versionable " + localConflictRecord.getVersionableHandle().getItemId());
            }
            this.localConflicts.put(localConflictRecord.getVersionableHandle().getItemId(), localConflictRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<UUID, LocalConflictRecord> hashMap = this.localConflicts;
        synchronized (hashMap) {
            if (LocalConflictTracker.isTracingEnabled() && !this.localConflicts.isEmpty()) {
                LocalConflictTracker.trace("Clearing all conflicts.");
            }
            this.localConflicts.clear();
        }
    }

    public boolean needInitialization() {
        return this.needInitialization;
    }

    public void isInitialized() {
        this.needInitialization = false;
    }

    public LocalConflictRecord getConflict(IVersionableHandle item) {
        return this.getConflict(item.getItemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalConflictRecord getConflict(UUID itemID) {
        HashMap<UUID, LocalConflictRecord> hashMap = this.localConflicts;
        synchronized (hashMap) {
            return this.localConflicts.get(itemID);
        }
    }

    public LocalConflictRecord createConflict(IVersionableHandle versionableHandle, IRelativeLocation localPath) {
        if (LocalConflictTracker.isTracingEnabled()) {
            LocalConflictTracker.trace("Creating conflict for versionable " + versionableHandle.getItemId() + " at path " + localPath.toString());
        }
        return this.internalCreateConflict(versionableHandle, localPath);
    }

    public synchronized void confirmChanges(ILocalChange[] confirmed) {
        ILocalChange[] iLocalChangeArray = confirmed;
        int n = confirmed.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            this.remove(change.getTarget());
            ++n2;
        }
    }

    private static boolean isTracingEnabled() {
        return log != null && log.isTraceEnabled();
    }

    private static void trace(String message, Throwable e) {
        if (log != null) {
            log.trace((Object)message, e);
        }
    }

    private static void trace(String message) {
        if (log != null) {
            log.trace((Object)message);
        }
    }
}

