/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.Assert;

public class LocalConflictRecord {
    private ISandbox sandbox;
    private IRelativeLocation localPath;
    private IVersionableHandle versionableHandle;
    private IVersionableHandle deletedDuringReplay;
    private int flags = 0;
    static final int DELETION_TYPE = 1;
    static final int CONTENT_CHANGE_TYPE = 2;
    static final int IS_MOD_CONFLICT = 4;
    static final int IS_PROPERTY_CONFLICT = 8;
    static final int IS_MOVE_CONFLICT = 16;
    private UUID beforeStateId;

    public LocalConflictRecord(IRelativeLocation path) {
        this.setLocalPath(path);
    }

    public void setLocalPath(IRelativeLocation path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        this.localPath = path;
    }

    public IRelativeLocation getLocalPath() {
        return this.localPath;
    }

    public void setBeforeStateId(UUID stateId) {
        this.beforeStateId = stateId;
    }

    public UUID getBeforeStateId() {
        return this.beforeStateId;
    }

    public boolean isContentChange() {
        return (this.flags & 2) != 0;
    }

    public void setContentChange(boolean contentChange) {
        this.flags = contentChange ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isDeletion() {
        return (this.flags & 1) != 0;
    }

    public boolean isModificationConflict() {
        return (this.flags & 4) != 0;
    }

    public void setModificationConflict(boolean conflict) {
        this.flags = conflict ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isPropertyConflict() {
        return (this.flags & 8) != 0;
    }

    public void setPropertyConflict(boolean conflict) {
        this.flags = conflict ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public boolean isMoveOrRenameConflict() {
        return (this.flags & 0x10) != 0;
    }

    public void setMoveOrRenameConflict(boolean conflict) {
        this.flags = conflict ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public void setDeletion(boolean deletion) {
        this.flags = deletion ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public IVersionableHandle getVersionableHandle() {
        return this.versionableHandle;
    }

    public IVersionableHandle getCommonAncestor() {
        if (this.getVersionableHandle() != null && this.getBeforeStateId() != null) {
            return (IVersionableHandle)this.getVersionableHandle().getItemType().createItemHandle(this.getVersionableHandle().getItemId(), this.getBeforeStateId());
        }
        return null;
    }

    public IVersionableHandle getDeletedDuringReplay() {
        return this.deletedDuringReplay;
    }

    public void setDeletedDuringReplay(IVersionableHandle deletedVersionable) {
        this.deletedDuringReplay = deletedVersionable;
    }

    public void setVersionableHandle(IVersionableHandle versionableHandle) {
        this.versionableHandle = versionableHandle;
        Assert.isNotNull((Object)this.versionableHandle.getStateId(), (String)"LocalConflictRecord: VersionableHandle must have a state ID");
    }

    public void setSandbox(ISandbox sandbox) {
        this.sandbox = sandbox;
    }

    public ISandbox getSandbox() {
        return this.sandbox;
    }

    public boolean isComplete() {
        return !this.isPropertyConflict() && !this.isModificationConflict() && !this.isMoveOrRenameConflict();
    }
}

