/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.localchanges.ILocalConflictChangeEvent;
import com.ibm.team.filesystem.client.internal.localchanges.ILocalConflictListener;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class LocalConflictNotifier {
    List<ILocalConflictListener> listeners = new ArrayList<ILocalConflictListener>();
    List<LocalChangeContext> disabled = new ArrayList<LocalChangeContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ILocalConflictListener listener) {
        List<ILocalConflictListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ILocalConflictListener listener) {
        List<ILocalConflictListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfChanges(Set<LocalChangeContext> changed) {
        if (changed.isEmpty()) {
            return;
        }
        ArrayList<ILocalConflictListener> toNotify = new ArrayList<ILocalConflictListener>();
        List<ILocalConflictListener> list = this.listeners;
        synchronized (list) {
            toNotify.addAll(this.listeners);
        }
        if (toNotify.isEmpty()) {
            return;
        }
        ArrayList<ILocalConflictChangeEvent> events = new ArrayList(changed.size());
        for (LocalChangeContext lcc : changed) {
            List<LocalChangeContext> list2 = this.disabled;
            synchronized (list2) {
                if (!this.disabled.contains(lcc)) {
                    events.add(new Event(lcc));
                }
            }
        }
        if (events.isEmpty()) {
            return;
        }
        events = Collections.unmodifiableList(events);
        for (ILocalConflictListener listener : toNotify) {
            try {
                listener.handleLocalConflictChanges(events);
            }
            catch (Exception e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableNotification(LocalChangeContext context) {
        List<LocalChangeContext> list = this.disabled;
        synchronized (list) {
            this.disabled.add(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableNotification(LocalChangeContext context) {
        List<LocalChangeContext> list = this.disabled;
        synchronized (list) {
            this.disabled.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabledFor(LocalChangeContext context) {
        List<LocalChangeContext> list = this.disabled;
        synchronized (list) {
            return !this.disabled.contains(context);
        }
    }

    private static class Event
    implements ILocalConflictChangeEvent {
        private LocalChangeContext context;

        public Event(LocalChangeContext lcc) {
            this.context = lcc;
        }

        @Override
        public IContextHandle getContextHandle() {
            return this.context.getConnection();
        }

        @Override
        public IComponentHandle getComponentHandle() {
            return this.context.getComponent();
        }
    }
}

