/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeBatch;
import com.ibm.team.filesystem.client.ILocalChangeEvent;
import com.ibm.team.filesystem.client.ILocalChangeListener;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.ILocalConflictMetadata;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Trace;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.ILocalConflictListener;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictNotifier;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictRecord;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictTracker;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class LocalConflictManager
implements ILocalChangeListener,
ICopyFileAreaListener {
    private static final String LOCAL_CONFLICT_TRACING = "jazz.scm.localconflict.trace";
    private static LocalConflictManager instance;
    private Map<LocalChangeContext, LocalConflictTracker> trackers = new HashMap<LocalChangeContext, LocalConflictTracker>();
    private LocalConflictNotifier notifier = new LocalConflictNotifier();
    private UpdateLocalConflictsJob updateJob = new UpdateLocalConflictsJob();
    public static final String UPDATE_LOCAL_CONFLICTS_FAMILY;
    private static int CFA_REGISTERED;
    private static int CFA_DEREGISTERED;
    private static int COMPONENT_UNLOADED;
    private static int SHARE_REMOVED;
    private static int LOCAL_CHANGE_EVENT;
    private static int NOTIFY_CHANGED;
    private static int INITIALIZE_TRACKER;
    private static boolean tracingStateInitialized;
    private static PrintStream traceStream;

    static {
        UPDATE_LOCAL_CONFLICTS_FAMILY = UpdateLocalConflictsJob.class.getName();
        CFA_REGISTERED = 1;
        CFA_DEREGISTERED = 2;
        COMPONENT_UNLOADED = 3;
        SHARE_REMOVED = 4;
        LOCAL_CHANGE_EVENT = 5;
        NOTIFY_CHANGED = 6;
        INITIALIZE_TRACKER = 7;
        tracingStateInitialized = false;
        traceStream = null;
    }

    public static synchronized LocalConflictManager getInstance() {
        if (instance == null) {
            instance = new LocalConflictManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalConflictTracker> getTrackers(ILocation copyFileAreaRoot) {
        Map<LocalChangeContext, LocalConflictTracker> map = this.trackers;
        synchronized (map) {
            ArrayList<LocalConflictTracker> result = new ArrayList<LocalConflictTracker>();
            for (Map.Entry<LocalChangeContext, LocalConflictTracker> entry : this.trackers.entrySet()) {
                LocalChangeContext key = entry.getKey();
                if (!key.getRoot().equals(copyFileAreaRoot)) continue;
                result.add(entry.getValue());
            }
            return result;
        }
    }

    private LocalConflictManager() {
        FileSystemCore.getSharingManager().getLocalChangeManager().addLocalChangeListener(this);
        FileSystemCore.getSharingManager().addListener(this);
    }

    public void dispose() {
        this.waitForLocalConflictJobs(null);
        FileSystemCore.getSharingManager().getLocalChangeManager().removeLocalChangeListener(this);
        FileSystemCore.getSharingManager().removeListener(this);
    }

    @Override
    public void change(ICopyFileAreaEvent[] events) {
        ICopyFileAreaEvent[] iCopyFileAreaEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ICopyFileAreaEvent event = iCopyFileAreaEventArray[n2];
            if (event.getReason() == 8) {
                this.updateJob.queueUpdate(event.getCopyFileAreaRoot(), COMPONENT_UNLOADED);
            } else if (event.getReason() == 10) {
                this.updateJob.queueUpdate(event.getCopyFileAreaRoot(), CFA_DEREGISTERED);
            } else if (event.getReason() == 9) {
                this.updateJob.queueUpdate(event.getCopyFileAreaRoot(), CFA_REGISTERED);
            } else if (event.getReason() == 2) {
                this.updateJob.queueShareRemoval(event.getCopyFileAreaRoot(), event.getPath(), event.getVersionable());
            }
            ++n2;
        }
    }

    @Override
    public void changeOccurred(ILocalChangeEvent event) {
        LocalConflictManager.traceLocalChangeInfo("Change occurred" + event);
        this.updateJob.queueLocalChangeEvent(event);
    }

    public LocalConflictTracker getTracker(IContextHandle connection, IComponentHandle component, ILocation sandboxPath, IProgressMonitor monitor) {
        LocalChangeContext context = new LocalChangeContext(component, connection, sandboxPath);
        return this.getTracker(context, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalConflictTracker getTracker(LocalChangeContext context, IProgressMonitor monitor) {
        LocalConflictTracker tracker;
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(context.getRoot());
        Map<LocalChangeContext, LocalConflictTracker> map = this.trackers;
        synchronized (map) {
            tracker = this.trackers.get(context);
            if (tracker != null) {
                return tracker;
            }
        }
        if (cfa == null || !context.isLoaded(monitor)) {
            return null;
        }
        map = this.trackers;
        synchronized (map) {
            tracker = this.trackers.get(context);
            if (tracker == null) {
                LocalConflictManager.traceLocalChangeInfo("Adding tracker for " + context.toString());
                tracker = new LocalConflictTracker(context);
                this.trackers.put(context, tracker);
                this.updateJob.initializeTracker(context);
            }
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalConflictTracker getExistingTracker(IContextHandle connection, IComponentHandle component, ILocation cfaRoot) {
        Map<LocalChangeContext, LocalConflictTracker> map = this.trackers;
        synchronized (map) {
            LocalChangeContext context = new LocalChangeContext(component, connection, cfaRoot);
            LocalConflictTracker tracker = this.trackers.get(context);
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(LocalChangeContext context) {
        Map<LocalChangeContext, LocalConflictTracker> map = this.trackers;
        synchronized (map) {
            this.trackers.remove(context);
        }
        LocalConflictManager.traceLocalChangeInfo("Removing local conflict tracker for " + context.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalConflictTracker findTracker(LocalChangeContext ctx, IProgressMonitor monitor) {
        Map<LocalChangeContext, LocalConflictTracker> map = this.trackers;
        synchronized (map) {
            block5: {
                LocalConflictTracker tracker = this.trackers.get(ctx);
                if (tracker != null) {
                    return tracker;
                }
                if (ICopyFileAreaManager.instance.copyFileAreaExists(ctx.getRoot(), 0)) break block5;
                return null;
            }
            return this.getTracker(ctx.getConnection(), ctx.getComponent(), ctx.getRoot(), monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalConflictTracker internalGetTracker(LocalChangeContext ctx) {
        Map<LocalChangeContext, LocalConflictTracker> map = this.trackers;
        synchronized (map) {
            return this.trackers.get(ctx);
        }
    }

    public LocalConflictTracker findTracker(IContextHandle connection, IComponentHandle component, ILocation cfaRoot, IProgressMonitor monitor) {
        return this.findTracker(new LocalChangeContext(component, connection, cfaRoot), monitor);
    }

    public boolean hasConflict(ILocalChange localChange) {
        LocalConflictTracker tracker;
        if (localChange.getTarget() != null && (tracker = this.getExistingTracker(localChange.getConnection(), localChange.getComponent(), localChange.getSandboxRoot())) != null) {
            return tracker.findExisting(localChange.getTarget()) != null;
        }
        return false;
    }

    public void addLocalConflictListener(ILocalConflictListener listener) {
        this.notifier.addListener(listener);
    }

    public void removeLocalConflictListener(ILocalConflictListener localConflictListener) {
        this.notifier.removeListener(localConflictListener);
    }

    public void beginUpdateOperation(IContextHandle connection, IComponentHandle component, ILocation root, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        long start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
        LocalChangeContext context = new LocalChangeContext(component, connection, root);
        this.notifier.disableNotification(context);
        LocalConflictTracker tracker = this.getTracker(connection, component, root, (IProgressMonitor)progress.newChild(1));
        if (tracker == null) {
            return;
        }
        if (CFALockUtil.isLockedForUpdate(root, component, connection)) {
            if (tracker.needInitialization()) {
                this.internalInitializeTracker(tracker, context, (IProgressMonitor)progress.newChild(99));
            }
        } else {
            this.waitForLocalConflictJobs((IProgressMonitor)progress.newChild(99));
        }
        if (Trace.LOG_ELAPSED_TIME) {
            Trace.endTrace(start, String.valueOf(this.getClass().getSimpleName()) + ":beginUpdateOperation()");
        }
        progress.done();
    }

    public void endUpdateOperation(IContextHandle connection, IComponentHandle component, ILocation root) {
        LocalChangeContext context = new LocalChangeContext(component, connection, root);
        this.notifier.enableNotification(context);
        this.updateJob.queueChangeNotification(context);
    }

    public void requestNotify(IContextHandle connection, IComponentHandle component, ILocation root) {
        LocalChangeContext context = new LocalChangeContext(component, connection, root);
        this.updateJob.queueChangeNotification(context);
    }

    public void synchronizeConflicts(Collection<IShareable> shareables, ILocation sandboxFolder, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(shareables.size() * 2 + 1));
        for (IShareable shareable : shareables) {
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
            if (share == null) continue;
            IContextHandle connectionHandle = share.getSharingDescriptor().getConnectionHandle();
            IComponentHandle component = share.getSharingDescriptor().getComponent();
            this.getTracker(connectionHandle, component, sandboxFolder, (IProgressMonitor)progress.newChild(1));
        }
        this.waitForLocalConflictJobs((IProgressMonitor)progress.newChild(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceLocalChangeInfo(String info) {
        String string = LOCAL_CONFLICT_TRACING;
        synchronized (LOCAL_CONFLICT_TRACING) {
            if (!tracingStateInitialized) {
                String toTrace = System.getProperty(LOCAL_CONFLICT_TRACING);
                if ("true".equalsIgnoreCase(toTrace)) {
                    traceStream = System.out;
                } else if (toTrace != null) {
                    try {
                        traceStream = new PrintStream(new File(toTrace));
                    }
                    catch (FileNotFoundException e) {
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                    }
                }
                tracingStateInitialized = true;
            }
            if (traceStream != null) {
                traceStream.println(String.valueOf(new Date().toString()) + " " + info);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void synchronizeConflicts(ISandbox[] sandboxes, ILocalChangeManager.RefreshType traversalType, IProgressMonitor monitor) throws FileSystemException {
        int length = sandboxes.length;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + length));
        int i = 0;
        while (i < length) {
            ISandbox sandbox = sandboxes[i];
            IShare[] shares = sandbox.allShares((IProgressMonitor)progress.newChild(1));
            this.synchronizeConflicts(shares, traversalType, sandbox.getRoot(), (IProgressMonitor)progress.newChild(100));
            ++i;
        }
    }

    private void synchronizeConflicts(IShare[] shares, ILocalChangeManager.RefreshType traversalType, ILocation root, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(shares.length + 10));
        IShare[] iShareArray = shares;
        int n = shares.length;
        int n2 = 0;
        while (n2 < n) {
            IShare share = iShareArray[n2];
            if (share != null) {
                IContextHandle connectionHandle = share.getSharingDescriptor().getConnectionHandle();
                IComponentHandle component = share.getSharingDescriptor().getComponent();
                this.getTracker(connectionHandle, component, root, (IProgressMonitor)progress.newChild(1));
            }
            ++n2;
        }
        this.waitForLocalConflictJobs((IProgressMonitor)progress.newChild(10));
        progress.done();
    }

    public void synchronizeConflicts(ILocalChange[] changes, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(changes.length + 10));
        ILocalChange[] iLocalChangeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocation sandboxRoot;
            IComponentHandle component;
            ILocalChange change = iLocalChangeArray[n2];
            IContextHandle connection = change.getConnection();
            LocalConflictTracker conflictTracker = this.getTracker(connection, component = change.getComponent(), sandboxRoot = change.getSandboxRoot(), (IProgressMonitor)progress.newChild(1));
            if (conflictTracker != null) {
                LocalConflictManager.getInstance().requestNotify(connection, component, sandboxRoot);
            }
            ++n2;
        }
        this.waitForLocalConflictJobs((IProgressMonitor)progress.newChild(10));
        progress.done();
    }

    public void synchronizeConflicts(IWorkspaceConnection workspace, IComponentHandle component, ISandbox sandbox, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        LocalConflictTracker tracker = this.getTracker(workspace.getContextHandle(), component, sandbox.getRoot(), (IProgressMonitor)progress.newChild(1));
        if (tracker == null) {
            return;
        }
        if (CFALockUtil.isLockedForUpdate(sandbox.getRoot(), component, workspace.getContextHandle())) {
            LocalChangeContext context;
            if (tracker.needInitialization() && this.internalInitializeTracker(tracker, context = new LocalChangeContext(component, workspace.getContextHandle(), sandbox.getRoot()), (IProgressMonitor)progress.newChild(99))) {
                this.updateJob.queueChangeNotification(context);
            }
        } else {
            ILocation sandboxRoot = sandbox.getRoot();
            LocalConflictManager.getInstance().requestNotify(workspace.getContextHandle(), component, sandboxRoot);
            this.waitForLocalConflictJobs((IProgressMonitor)progress.newChild(99));
        }
        progress.done();
    }

    private void waitForJobs(Object jobFamily, long waitTimeInMillis, IProgressMonitor monitor) {
        try {
            Job.getJobManager().join((Object)LocalChangeManager.RECOMPUTE_PENDING_CHANGES_FAMILY, monitor);
        }
        catch (OperationCanceledException e) {
            LocalConflictManager.traceLocalChangeInfo("OCE");
        }
        catch (InterruptedException e) {
            LocalConflictManager.traceLocalChangeInfo("IE");
        }
        LocalConflictManager.traceLocalChangeInfo("waitForJobs");
        try {
            boolean needWait = true;
            long start = System.currentTimeMillis();
            while (needWait) {
                needWait = false;
                Job[] jobs = Job.getJobManager().find(jobFamily);
                LocalConflictManager.traceLocalChangeInfo("waitFor: " + jobs.length + " jobs");
                Job[] jobArray = jobs;
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job job = jobArray[n2];
                    if (job.belongsTo(jobFamily) && job.getState() != 0) {
                        if (System.currentTimeMillis() - start > waitTimeInMillis) {
                            String message = NLS.bind((String)"Job {0} has been in state {1} for too long", (Object)job.getName(), (Object)job.getState());
                            LocalConflictManager.traceLocalChangeInfo(message);
                            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, message, null));
                            return;
                        }
                        needWait = true;
                        break;
                    }
                    ++n2;
                }
                if (!needWait) continue;
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean internalInitializeTracker(LocalConflictTracker tracker, LocalChangeContext context, IProgressMonitor monitor) {
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(context.getRoot());
        if (cfa == null) {
            tracker.isInitialized();
        } else if (tracker.needInitialization()) {
            try {
                ILocalConflictMetadata metadata = cfa.internalGetMetadata().getLocalConflictMetadata();
                Collection<LocalConflictRecord> localConflicts = metadata.getLocalConflicts(context.getConnection(), context.getComponent(), monitor);
                int size = localConflicts.size();
                localConflicts = this.getLocalConflictsWithLocalChanges(context, tracker, localConflicts, monitor);
                int afterSize = localConflicts.size();
                if (size > afterSize) {
                    metadata.setLocalConflicts(context.getConnection(), context.getComponent(), localConflicts, monitor);
                }
                tracker.setLocalConflicts(localConflicts);
                return true;
            }
            catch (FileSystemException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
            }
            finally {
                tracker.isInitialized();
            }
        }
        return false;
    }

    private Collection<LocalConflictRecord> getLocalConflictsWithLocalChanges(LocalChangeContext context, LocalConflictTracker tracker, Collection<LocalConflictRecord> localConflicts, IProgressMonitor monitor) {
        if (localConflicts.isEmpty()) {
            return localConflicts;
        }
        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(context.getRoot(), true);
        HashSet<UUID> conflictingVersionables = new HashSet<UUID>();
        if (sandbox != null) {
            ILocalChange[] pendingChanges;
            for (LocalConflictRecord localConflictRecord : localConflicts) {
                conflictingVersionables.add(localConflictRecord.getVersionableHandle().getItemId());
            }
            ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
            lcm.syncPendingChanges(tracker.getContext().getConnection(), tracker.getContext().getComponent(), sandbox, monitor);
            ILocalChange[] iLocalChangeArray = pendingChanges = lcm.getPendingChanges(tracker.getContext().getConnection(), tracker.getContext().getComponent(), sandbox);
            int n = pendingChanges.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange localChange = iLocalChangeArray[n2];
                if (localChange.getTarget() != null && conflictingVersionables.contains(localChange.getTarget().getItemId())) {
                    conflictingVersionables.remove(localChange.getTarget().getItemId());
                }
                if (conflictingVersionables.isEmpty()) {
                    return localConflicts;
                }
                ++n2;
            }
        }
        ArrayList<LocalConflictRecord> withChanges = new ArrayList<LocalConflictRecord>();
        for (LocalConflictRecord localConflictRecord : localConflicts) {
            if (conflictingVersionables.contains(localConflictRecord.getVersionableHandle().getItemId())) continue;
            withChanges.add(localConflictRecord);
        }
        return withChanges;
    }

    public void waitForLocalConflictJobs(IProgressMonitor monitor) {
        this.waitForJobs(UPDATE_LOCAL_CONFLICTS_FAMILY, 10000L, monitor);
    }

    public void commitChanges(ILocalChange[] committed, IProgressMonitor monitor) {
        Map<LocalChangeContext, List<ILocalChange>> changes = this.getChangesMap(committed);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changes.size());
        for (Map.Entry<LocalChangeContext, List<ILocalChange>> entry : changes.entrySet()) {
            LocalConflictTracker tracker = this.findTracker(entry.getKey(), (IProgressMonitor)progress.newChild(1));
            if (tracker == null) continue;
            tracker.confirmChanges(entry.getValue().toArray(new ILocalChange[entry.getValue().size()]));
            this.updateJob.queueChangeNotification(entry.getKey());
        }
        progress.done();
    }

    private Map<LocalChangeContext, List<ILocalChange>> getChangesMap(ILocalChange[] changes) {
        HashMap<LocalChangeContext, List<ILocalChange>> changesMap = new HashMap<LocalChangeContext, List<ILocalChange>>();
        ILocalChange[] iLocalChangeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange c = iLocalChangeArray[n2];
            LocalChangeContext ctx = ((LocalChange)c).context;
            if (ctx != null) {
                ArrayList<ILocalChange> changesList = (ArrayList<ILocalChange>)changesMap.get(ctx);
                if (changesList == null) {
                    changesList = new ArrayList<ILocalChange>();
                    changesMap.put(ctx, changesList);
                }
                changesList.add(c);
            }
            ++n2;
        }
        return changesMap;
    }

    class UpdateLocalConflictsJob
    extends Job {
        private List<UpdateRequest> updates;
        private Set<LocalChangeContext> changed;
        private Set<LocalChangeContext> checkLoaded;

        public UpdateLocalConflictsJob() {
            super(Messages.LocalConflictManager_0);
            this.updates = new LinkedList<UpdateRequest>();
            this.changed = new HashSet<LocalChangeContext>();
            this.checkLoaded = new HashSet<LocalChangeContext>();
        }

        public boolean belongsTo(Object family) {
            return UPDATE_LOCAL_CONFLICTS_FAMILY.equals(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            long start;
            long l = start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                try {
                    this.doUpdate(monitor);
                    this.updateMetadata(monitor);
                }
                catch (FileSystemException e) {
                    IStatus iStatus = FileSystemStatusUtil.getStatusFor((Throwable)((Object)e));
                    this.fireChangedEvent(monitor);
                    if (Trace.LOG_ELAPSED_TIME) {
                        Trace.endTrace(start, String.valueOf(((Object)((Object)this)).getClass().getName()) + ":" + this.getName());
                    }
                    return iStatus;
                }
            }
            finally {
                this.fireChangedEvent(monitor);
                if (Trace.LOG_ELAPSED_TIME) {
                    Trace.endTrace(start, String.valueOf(((Object)((Object)this)).getClass().getName()) + ":" + this.getName());
                }
            }
            this.schedule();
            return Status.OK_STATUS;
        }

        private void fireChangedEvent(IProgressMonitor monitor) {
            try {
                LocalConflictManager.this.notifier.notifyOfChanges(this.changed);
            }
            finally {
                this.changed.clear();
            }
        }

        private void updateMetadata(IProgressMonitor monitor) throws FileSystemException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.changed.size() * 2));
            for (LocalChangeContext context : this.changed) {
                AbstractLock lock;
                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(context.getRoot());
                if (cfa == null || (lock = CFALockUtil.lockExistingForUpdate(context.getRoot(), context.getConnection(), context.getComponent(), (IProgressMonitor)progress.newChild(1))) == null) continue;
                try {
                    ILocalConflictMetadata metadata = cfa.internalGetMetadata().getLocalConflictMetadata();
                    LocalConflictTracker tracker = LocalConflictManager.this.internalGetTracker(context);
                    Collection<Object> conflicts = tracker == null ? Collections.EMPTY_SET : tracker.getConflicts();
                    metadata.setLocalConflicts(context.getConnection(), context.getComponent(), (Collection<LocalConflictRecord>)conflicts, monitor);
                    if (tracker == null || !conflicts.isEmpty() || !this.checkLoaded.contains(context)) continue;
                    this.checkLoaded.remove(context);
                    if (context.isLoaded((IProgressMonitor)progress.newChild(10))) continue;
                    LocalConflictManager.this.remove(context);
                }
                finally {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldSchedule() {
            List<UpdateRequest> list = this.updates;
            synchronized (list) {
                return !this.updates.isEmpty();
            }
        }

        public boolean shouldRun() {
            return this.shouldSchedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUpdate(IProgressMonitor monitor) throws FileSystemException {
            while (true) {
                UpdateRequest update;
                List<UpdateRequest> list = this.updates;
                synchronized (list) {
                    if (this.updates.isEmpty()) {
                        return;
                    }
                    update = this.updates.remove(0);
                }
                this.doUpdate(update, monitor);
            }
        }

        private void doUpdate(UpdateRequest update, IProgressMonitor monitor) throws FileSystemException {
            long start;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            long l = start = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
            if (update.type == INITIALIZE_TRACKER) {
                this.initializeTrackers((IProgressMonitor)progress);
            } else if (update.type == CFA_DEREGISTERED) {
                this.removeTracker(update.copyFileAreaRoot);
            } else if (update.type != CFA_REGISTERED) {
                if (update.type == COMPONENT_UNLOADED) {
                    this.updateAfterComponentUnload(update.copyFileAreaRoot, (IProgressMonitor)progress);
                } else if (update.type == SHARE_REMOVED) {
                    this.updateAfterRemoval(update.copyFileAreaRoot, update.path, (IProgressMonitor)progress);
                } else if (update.type == LOCAL_CHANGE_EVENT) {
                    HashMap<LocalChangeContext, LocalConflictTracker> toUpdate = new HashMap<LocalChangeContext, LocalConflictTracker>();
                    ILocalChangeEvent event = update.event;
                    Collection<LocalChangeContext> contextsWithChanges = this.getChangedContexts(event);
                    boolean initialize = false;
                    SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(20), (int)contextsWithChanges.size());
                    for (LocalChangeContext localChangeContext : contextsWithChanges) {
                        LocalConflictTracker tracker = LocalConflictManager.this.getTracker(localChangeContext, (IProgressMonitor)subProgress.newChild(1));
                        if (tracker == null) continue;
                        initialize |= tracker.needInitialization();
                        if (!LocalConflictManager.this.notifier.isNotificationEnabledFor(localChangeContext)) continue;
                        toUpdate.put(localChangeContext, tracker);
                    }
                    if (initialize) {
                        this.initializeTrackers((IProgressMonitor)progress.newChild(30));
                    }
                    subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(50), (int)toUpdate.size());
                    for (Map.Entry entry : toUpdate.entrySet()) {
                        if (!this.updateForLocalChangeRemoval((LocalChangeContext)entry.getKey(), (LocalConflictTracker)entry.getValue(), event, (IProgressMonitor)subProgress.newChild(1))) continue;
                        this.changed.add((LocalChangeContext)entry.getKey());
                    }
                } else if (update.type == NOTIFY_CHANGED) {
                    this.changed.add(update.context);
                }
            }
            if (Trace.LOG_ELAPSED_TIME) {
                Trace.endTrace(start, String.valueOf(((Object)((Object)this)).getClass().getName()) + ":" + this.getName());
            }
            progress.done();
        }

        private Collection<LocalChangeContext> getChangedContexts(ILocalChangeEvent event) {
            ILocalChange change;
            int n;
            int n2;
            ILocalChange[] iLocalChangeArray;
            ILocalChangeBatch batch;
            ILocalChangeBatch[] batches;
            HashSet<LocalChangeContext> result = new HashSet<LocalChangeContext>();
            ILocalChangeBatch[] iLocalChangeBatchArray = batches = event.getBatches(2);
            int n3 = batches.length;
            int n4 = 0;
            while (n4 < n3) {
                batch = iLocalChangeBatchArray[n4];
                iLocalChangeArray = batch.getBatchedChanges();
                n2 = iLocalChangeArray.length;
                n = 0;
                while (n < n2) {
                    change = iLocalChangeArray[n];
                    result.add(new LocalChangeContext(batch.getComponent(), batch.getConnection(), change.getSandboxRoot()));
                    ++n;
                }
                ++n4;
            }
            iLocalChangeBatchArray = batches = event.getBatches(1);
            n3 = batches.length;
            n4 = 0;
            while (n4 < n3) {
                batch = iLocalChangeBatchArray[n4];
                iLocalChangeArray = batch.getBatchedChanges();
                n2 = iLocalChangeArray.length;
                n = 0;
                while (n < n2) {
                    change = iLocalChangeArray[n];
                    result.add(new LocalChangeContext(batch.getComponent(), batch.getConnection(), change.getSandboxRoot()));
                    ++n;
                }
                ++n4;
            }
            iLocalChangeBatchArray = batches = event.getBatches(3);
            n3 = batches.length;
            n4 = 0;
            while (n4 < n3) {
                batch = iLocalChangeBatchArray[n4];
                iLocalChangeArray = batch.getBatchedChanges();
                n2 = iLocalChangeArray.length;
                n = 0;
                while (n < n2) {
                    change = iLocalChangeArray[n];
                    result.add(new LocalChangeContext(batch.getComponent(), batch.getConnection(), change.getSandboxRoot()));
                    ++n;
                }
                ++n4;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeTracker(ILocation copyFileAreaRoot) {
            Map map = LocalConflictManager.this.trackers;
            synchronized (map) {
                Iterator iterator = LocalConflictManager.this.trackers.keySet().iterator();
                while (iterator.hasNext()) {
                    LocalChangeContext key = (LocalChangeContext)iterator.next();
                    if (!key.getRoot().equals(copyFileAreaRoot)) continue;
                    iterator.remove();
                    this.changed.add(key);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeTrackers(IProgressMonitor monitor) throws FileSystemException {
            ArrayList<LocalConflictTracker> toInit = new ArrayList<LocalConflictTracker>();
            Map map = LocalConflictManager.this.trackers;
            synchronized (map) {
                for (Map.Entry entry : LocalConflictManager.this.trackers.entrySet()) {
                    LocalConflictTracker tracker = (LocalConflictTracker)entry.getValue();
                    if (!tracker.needInitialization()) continue;
                    toInit.add(tracker);
                }
            }
            if (toInit.isEmpty()) {
                return;
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(toInit.size() * 3));
            for (LocalConflictTracker tracker : toInit) {
                if (!tracker.needInitialization()) continue;
                LocalChangeContext context = tracker.getContext();
                AbstractLock lock = CFALockUtil.lockExistingForUpdate(context.getRoot(), context.getConnection(), context.getComponent(), (IProgressMonitor)progress.newChild(1));
                if (lock == null) {
                    tracker.isInitialized();
                    continue;
                }
                try {
                    if (!tracker.needInitialization() || !LocalConflictManager.this.internalInitializeTracker(tracker, context, (IProgressMonitor)progress.newChild(1))) continue;
                    this.changed.add(context);
                }
                finally {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
        }

        private boolean updateForLocalChangeRemoval(LocalChangeContext localChangeContext, LocalConflictTracker localConflictTracker, ILocalChangeEvent event, IProgressMonitor monitor) {
            Object change3;
            int n;
            ILocalChange[] iLocalChangeArray;
            ILocalChangeBatch[] confirmed = event.getBatches(3);
            HashMap<UUID, Object> changesWeCareAbout = new HashMap<UUID, Object>();
            ILocalChangeBatch[] iLocalChangeBatchArray = confirmed;
            int n2 = confirmed.length;
            int n3 = 0;
            while (n3 < n2) {
                ILocalChangeBatch lcb = iLocalChangeBatchArray[n3];
                if (lcb.getConnection().sameItemId((IItemHandle)localChangeContext.getConnection()) && lcb.getComponent().sameItemId((IItemHandle)localChangeContext.getComponent())) {
                    iLocalChangeArray = lcb.getBatchedChanges();
                    n = iLocalChangeArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        change3 = iLocalChangeArray[n4];
                        if (change3.getSandboxRoot().equals(localChangeContext.getRoot()) && change3.getTarget() != null && localConflictTracker.findExisting(change3.getTarget()) != null) {
                            changesWeCareAbout.put(change3.getTarget().getItemId(), change3);
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
            ILocalChangeBatch[] cancelled = event.getBatches(2);
            change3 = cancelled;
            int n5 = cancelled.length;
            n2 = 0;
            while (n2 < n5) {
                ILocalChangeBatch lcb = change3[n2];
                if (lcb.getConnection().sameItemId((IItemHandle)localChangeContext.getConnection()) && lcb.getComponent().sameItemId((IItemHandle)localChangeContext.getComponent())) {
                    ILocalChange[] iLocalChangeArray2 = lcb.getBatchedChanges();
                    int n6 = iLocalChangeArray2.length;
                    n = 0;
                    while (n < n6) {
                        ILocalChange change2 = iLocalChangeArray2[n];
                        if (change2.getSandboxRoot().equals(localChangeContext.getRoot()) && change2.getTarget() != null && localConflictTracker.findExisting(change2.getTarget()) != null) {
                            changesWeCareAbout.put(change2.getTarget().getItemId(), change2);
                        }
                        ++n;
                    }
                }
                ++n2;
            }
            if (changesWeCareAbout.isEmpty()) {
                return false;
            }
            ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(localChangeContext.getRoot(), false);
            ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
            lcm.syncPendingChanges(localChangeContext.getConnection(), localChangeContext.getComponent(), sandbox, monitor);
            ILocalChange[] pendingChanges = lcm.getPendingChanges(localChangeContext.getConnection(), localChangeContext.getComponent(), sandbox);
            iLocalChangeArray = pendingChanges;
            n = pendingChanges.length;
            int n7 = 0;
            while (n7 < n) {
                ILocalChange localChange = iLocalChangeArray[n7];
                if (localChange.getTarget() != null && changesWeCareAbout.containsKey(localChange.getTarget().getItemId()) && !localChange.isType(4)) {
                    changesWeCareAbout.remove(localChange.getTarget().getItemId());
                }
                ++n7;
            }
            if (changesWeCareAbout.isEmpty()) {
                return false;
            }
            for (Object change3 : changesWeCareAbout.values()) {
                localConflictTracker.remove(change3.getTarget());
            }
            return true;
        }

        private void updateAfterComponentUnload(ILocation copyFileAreaRoot, IProgressMonitor monitor) throws FileSystemException {
            List<LocalConflictTracker> trackers = LocalConflictManager.this.getTrackers(copyFileAreaRoot);
            if (trackers.isEmpty()) {
                return;
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)trackers.size());
            for (LocalConflictTracker localConflictTracker : trackers) {
                LocalChangeContext localChangeContext = localConflictTracker.getContext();
                if (localChangeContext.isLoaded((IProgressMonitor)progress.newChild(1))) continue;
                localConflictTracker.clear();
                this.changed.add(localConflictTracker.getContext());
                this.checkLoaded.add(localConflictTracker.getContext());
            }
        }

        private void updateAfterRemoval(ILocation copyFileAreaRoot, IRelativeLocation path, IProgressMonitor monitor) throws FileSystemException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            List<LocalConflictTracker> trackers = LocalConflictManager.this.getTrackers(copyFileAreaRoot);
            if (trackers.isEmpty()) {
                return;
            }
            ISandbox sandbox = this.getSandbox(copyFileAreaRoot);
            if (!this.shareExist(sandbox, path, progress.newChild(10))) {
                progress.setWorkRemaining(trackers.size() * 2);
                for (LocalConflictTracker localConflictTracker : trackers) {
                    LocalChangeContext localChangeContext = localConflictTracker.getContext();
                    if (localChangeContext.isLoaded((IProgressMonitor)progress.newChild(1))) {
                        if (!localConflictTracker.updateAfterShareRemoval(path, (IProgressMonitor)progress.newChild(1))) continue;
                        this.changed.add(localConflictTracker.getContext());
                        continue;
                    }
                    localConflictTracker.clear();
                    this.changed.add(localConflictTracker.getContext());
                    this.checkLoaded.add(localConflictTracker.getContext());
                }
            }
        }

        private boolean shareExist(ISandbox sandbox, IRelativeLocation path, SubMonitor monitor) throws FileSystemException {
            IShare share = SharingManager.getInstance().getShare(sandbox.getRoot(), path, (IProgressMonitor)monitor);
            return share != null && share.getPath().equals(path);
        }

        private ISandbox getSandbox(ILocation copyFileAreaRoot) {
            return SharingManager.getInstance().getSandbox(copyFileAreaRoot, false);
        }

        public void queueUpdate(ILocation copyFileAreaRoot, int type) {
            this.queue(new UpdateRequest(copyFileAreaRoot, type));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queue(UpdateRequest updateRequest) {
            List<UpdateRequest> list = this.updates;
            synchronized (list) {
                this.updates.add(updateRequest);
            }
            this.schedule();
        }

        public void queueShareRemoval(ILocation copyFileAreaRoot, IRelativeLocation path, IVersionableHandle versionable) {
            this.queue(new UpdateRequest(copyFileAreaRoot, SHARE_REMOVED, path));
        }

        public void queueLocalChangeEvent(ILocalChangeEvent event) {
            this.queue(new UpdateRequest(event, LOCAL_CHANGE_EVENT));
        }

        public void queueChangeNotification(LocalChangeContext context) {
            this.queue(new UpdateRequest(context, NOTIFY_CHANGED));
        }

        public void initializeTracker(LocalChangeContext context) {
            this.queue(new UpdateRequest(context, INITIALIZE_TRACKER));
        }
    }

    class UpdateRequest {
        private ILocation copyFileAreaRoot;
        private int type;
        private IRelativeLocation path;
        private ILocalChangeEvent event;
        private LocalChangeContext context;

        public UpdateRequest(ILocation copyFileAreaRoot, int type) {
            this(copyFileAreaRoot, type, null);
        }

        public UpdateRequest(ILocation copyFileAreaRoot, int type, IRelativeLocation path) {
            this.copyFileAreaRoot = copyFileAreaRoot;
            this.type = type;
            this.path = path;
        }

        public UpdateRequest(ILocalChangeEvent event, int type) {
            this.event = event;
            this.type = type;
        }

        public UpdateRequest(LocalChangeContext context, int type) {
            this.context = context;
            this.type = type;
        }
    }
}

