/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeBatch;
import com.ibm.team.filesystem.client.ILocalChangeEvent;
import com.ibm.team.filesystem.client.ILocalChangeListener;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class LocalChangeNotifier
extends Job {
    private static final int SCHEDULING_DELAY = 200;
    private volatile long latestRequest;
    private static final ThreadLocal changeNotification = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(0);
        }
    };
    private static final boolean DEBUG_EVENTS = System.getProperty("filesystem.debug.localChangeEvents", "false").equals("true");
    private ListenerList listeners = new ListenerList();
    private ChangeGeneration collectedChanges = new ChangeGeneration();

    public static void disableChangeNotification() {
        changeNotification.set(new Integer((Integer)changeNotification.get() + 1));
    }

    public static void enableChangeNotification() {
        int level = (Integer)changeNotification.get();
        if (level == 0) {
            throw new IllegalStateException();
        }
        changeNotification.set(new Integer(level - 1));
    }

    public static boolean isChangeNotificationEnabled() {
        return (Integer)changeNotification.get() == 0;
    }

    public LocalChangeNotifier() {
        super(Messages.LocalChangeNotifier_9);
        this.setSystem(true);
        this.setUser(false);
    }

    public void addListener(ILocalChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public synchronized void changesCanceled(LocalChangeContext context, ILocalChange[] canceled) {
        if (canceled.length == 0) {
            return;
        }
        int i = 0;
        while (i < canceled.length) {
            if ((!this.collectedChanges.removeChange(context, canceled[i], 1) || ((LocalChange)canceled[i]).isWild()) && LocalChangeNotifier.isChangeNotificationEnabled()) {
                this.collectedChanges.addChange(context, canceled[i], 2);
            }
            ++i;
        }
        if (LocalChangeNotifier.isChangeNotificationEnabled()) {
            this.scheduleNotification();
        }
    }

    public synchronized void changeCanceled(LocalChangeContext context, ILocalChange canceled) {
        if (this.collectedChanges.removeChange(context, canceled, 1) && !((LocalChange)canceled).isWild()) {
            return;
        }
        if (!LocalChangeNotifier.isChangeNotificationEnabled()) {
            return;
        }
        this.collectedChanges.addChange(context, canceled, 2);
        this.scheduleNotification();
    }

    public synchronized void changesConfirmed(LocalChangeContext context, ILocalChange[] confirmed) {
        if (confirmed.length == 0) {
            return;
        }
        int i = 0;
        while (i < confirmed.length) {
            this.collectedChanges.removeChange(context, confirmed[i], 1);
            if (LocalChangeNotifier.isChangeNotificationEnabled()) {
                this.collectedChanges.addChange(context, confirmed[i], 3);
            }
            ++i;
        }
        if (LocalChangeNotifier.isChangeNotificationEnabled()) {
            this.scheduleNotification();
        }
    }

    public synchronized void changeOccurred(LocalChangeContext context, ILocalChange newChange) {
        if (!LocalChangeNotifier.isChangeNotificationEnabled()) {
            return;
        }
        this.collectedChanges.removeChange(context, newChange, 2);
        this.collectedChanges.addChange(context, newChange, 1);
        this.scheduleNotification();
    }

    public synchronized void changesOccurred(LocalChangeContext context, ILocalChange[] pendingChanges) {
        if (!LocalChangeNotifier.isChangeNotificationEnabled()) {
            return;
        }
        if (pendingChanges.length == 0) {
            return;
        }
        int i = 0;
        while (i < pendingChanges.length) {
            this.collectedChanges.removeChange(context, pendingChanges[i], 2);
            this.collectedChanges.addChange(context, pendingChanges[i], 1);
            ++i;
        }
        this.scheduleNotification();
    }

    private synchronized ChangeGeneration collectChanges() {
        if (!this.collectedChanges.hasChanges()) {
            return null;
        }
        ChangeGeneration result = this.collectedChanges;
        this.collectedChanges = new ChangeGeneration();
        return result;
    }

    private void notify(IProgressMonitor monitor, ChangeGeneration currentChanges, Object[] currentListeners) {
        try {
            monitor.beginTask(Messages.LocalChangeNotifier_10, currentListeners.length);
            final Event event = new Event(currentChanges);
            if (DEBUG_EVENTS) {
                System.out.println(new Date() + "\n" + event);
            }
            int i = 0;
            while (i < currentListeners.length) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                final ILocalChangeListener next = (ILocalChangeListener)currentListeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        LoggingHelper.error("com.ibm.team.filesystem.client", Messages.LocalChangeNotifier_12, exception);
                    }

                    public void run() throws Exception {
                        next.changeOccurred(event);
                    }
                });
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void removeListener(ILocalChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected IStatus run(IProgressMonitor monitor) {
        ChangeGeneration currentChanges;
        if (System.currentTimeMillis() - this.latestRequest < 200L) {
            this.schedule(200L);
            return Status.CANCEL_STATUS;
        }
        Job[] found = Job.getJobManager().find(LocalChangeTracker.CHANGES_COMPUTER_JOB_FAMILY);
        int i = 0;
        while (i < found.length) {
            int state = found[i].getState();
            if (state == 4 || state == 2 || state == 1) {
                this.schedule(200L);
                return Status.CANCEL_STATUS;
            }
            ++i;
        }
        if (!LocalChangeManager.getInstance().isNotificationEnabled()) {
            this.schedule(200L);
            return Status.CANCEL_STATUS;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        while ((currentChanges = this.collectChanges()) != null) {
            progress.setWorkRemaining(2);
            this.notify((IProgressMonitor)progress.newChild(1), currentChanges, this.listeners.getListeners());
        }
        progress.done();
        return Status.OK_STATUS;
    }

    void scheduleNotification() {
        this.latestRequest = System.currentTimeMillis();
        this.schedule(200L);
    }

    public boolean belongsTo(Object family) {
        if (family == ICopyFileAreaManager.instance) {
            return true;
        }
        if (family == LocalChangeManager.getInstance()) {
            return true;
        }
        return super.belongsTo(family);
    }

    public static class ChangeGeneration {
        private Map[] collectedChanges = new Map[]{new HashMap(), new HashMap(), new HashMap()};

        boolean addChange(LocalChangeContext context, ILocalChange toAdd, int kind) {
            Set<ILocalChange> existing = this.collectedChanges(kind).get(context);
            if (existing == null) {
                existing = new HashSet<ILocalChange>();
                this.collectedChanges(kind).put(context, existing);
            }
            return existing.add(toAdd);
        }

        private Map<LocalChangeContext, Set<ILocalChange>> collectedChanges(int kind) {
            return this.collectedChanges[kind - 1];
        }

        public ILocalChangeBatch[] getBatches(int kind) {
            Map<LocalChangeContext, Set<ILocalChange>> selected = this.collectedChanges(kind);
            if (selected.isEmpty()) {
                return new ILocalChangeBatch[0];
            }
            ILocalChangeBatch[] result = new ILocalChangeBatch[selected.size()];
            int position = 0;
            for (Map.Entry<LocalChangeContext, Set<ILocalChange>> current : selected.entrySet()) {
                LocalChangeContext context = current.getKey();
                result[position++] = new Snapshot(context, current.getValue());
            }
            return result;
        }

        public ILocalChange[] getChanges(IContextHandle connection, IComponentHandle component, ILocation shareRoot, int kind) {
            LocalChangeContext context = new LocalChangeContext(component, connection, shareRoot);
            Set<ILocalChange> existing = this.collectedChanges(kind).get(context);
            return existing == null ? new ILocalChange[]{} : existing.toArray(new ILocalChange[existing.size()]);
        }

        public boolean hasChanges(IContextHandle connection, IComponentHandle component, int kind) {
            Map<LocalChangeContext, Set<ILocalChange>> changes = this.collectedChanges(kind);
            if (changes.isEmpty()) {
                return false;
            }
            for (Map.Entry<LocalChangeContext, Set<ILocalChange>> entry : changes.entrySet()) {
                LocalChangeContext context = entry.getKey();
                if (!context.getConnection().sameItemId((IItemHandle)connection) || !context.getComponent().sameItemId((IItemHandle)component)) continue;
                return !entry.getValue().isEmpty();
            }
            return false;
        }

        public boolean hasChanges() {
            int i = 0;
            while (i < this.collectedChanges.length) {
                if (!this.collectedChanges[i].isEmpty()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        boolean removeChange(LocalChangeContext context, ILocalChange toRemove, int kind) {
            Set<ILocalChange> existing = this.collectedChanges(kind).get(context);
            if (existing == null) {
                return false;
            }
            return existing.remove(toRemove);
        }

        public boolean hasChanges(IContextHandle connection, IComponentHandle component, ILocation cfaRoot, int kind) {
            LocalChangeContext context = new LocalChangeContext(component, connection, cfaRoot);
            Set<ILocalChange> existing = this.collectedChanges(kind).get(context);
            return existing != null && !existing.isEmpty();
        }
    }

    public static class Event
    implements ILocalChangeEvent {
        private ChangeGeneration currentChanges;

        private static void checkKind(int kind) {
            Assert.isLegal((kind == 1 || kind == 2 || kind == 3 ? 1 : 0) != 0);
        }

        public Event(ChangeGeneration currentChanges) {
            this.currentChanges = currentChanges;
        }

        @Override
        public ILocalChangeBatch[] getBatches(int kind) {
            Event.checkKind(kind);
            return this.currentChanges.getBatches(kind);
        }

        @Override
        public ILocalChange[] getChanges(IContextHandle connection, IComponentHandle component, ILocation sharePath, int kind) {
            Event.checkKind(kind);
            return this.currentChanges.getChanges(connection, component, sharePath, kind);
        }

        @Override
        public boolean hasChanges(IContextHandle connection, IComponentHandle component, int kind) {
            Event.checkKind(kind);
            return this.currentChanges.hasChanges(connection, component, kind);
        }

        @Override
        public boolean hasChanges(IContextHandle connection, IComponentHandle component, ILocation cfaRoot, int kind) {
            Event.checkKind(kind);
            return this.currentChanges.hasChanges(connection, component, cfaRoot, kind);
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("OCCURRED: " + Arrays.asList(this.getBatches(1)) + "\n");
            result.append("CONFIRMED: " + Arrays.asList(this.getBatches(3)) + "\n");
            result.append("CANCELED: " + Arrays.asList(this.getBatches(2)) + "\n");
            return result.toString();
        }
    }

    private static class Snapshot
    implements ILocalChangeBatch {
        private Set<ILocalChange> changes;
        private LocalChangeContext context;

        public Snapshot(LocalChangeContext context, Set<ILocalChange> changes) {
            this.context = context;
            this.changes = changes;
        }

        @Override
        public ILocalChange[] getBatchedChanges() {
            return this.changes.toArray(new ILocalChange[this.changes.size()]);
        }

        @Override
        public IComponentHandle getComponent() {
            return this.context.getComponent();
        }

        @Override
        public IContextHandle getConnection() {
            return this.context.getConnection();
        }

        public String toString() {
            return this.changes.toString();
        }
    }
}

