/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class LocalChangeContext {
    private IComponentHandle component;
    private IContextHandle connection;
    private ILocation cfaRoot;

    public LocalChangeContext(IComponentHandle component, IContextHandle connection, ILocation cfaRoot) {
        this.component = component;
        this.connection = connection;
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        this.cfaRoot = cfa != null ? cfa.getRoot() : cfaRoot.getCanonicalForm();
    }

    public IComponentHandle getComponent() {
        return this.component;
    }

    public IContextHandle getConnection() {
        return this.connection;
    }

    public ILocation getRoot() {
        return this.cfaRoot;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalChangeContext)) {
            return false;
        }
        LocalChangeContext another = (LocalChangeContext)obj;
        return another.component.sameItemId((IItemHandle)this.component) && another.connection.sameItemId((IItemHandle)this.connection) && another.cfaRoot.equals(this.cfaRoot);
    }

    public int hashCode() {
        return this.component.getItemId().hashCode() ^ this.connection.getItemId().hashCode() ^ this.cfaRoot.hashCode();
    }

    public String toString() {
        return "LocalChangeContext(" + this.cfaRoot.toOSString() + ", " + this.connection.getItemId().getUuidValue() + ", " + this.component.getItemId().getUuidValue() + ')';
    }

    public boolean isLoaded(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = null;
        try {
            CopyFileArea cfa;
            lock = CFALockUtil.lockExistingForRead(this.cfaRoot, (IProgressMonitor)progress.newChild(40));
            if (lock != null && (cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaRoot)) != null && cfa.isConfigurationShared(this.connection, this.component, (IProgressMonitor)progress.newChild(50))) {
                return true;
            }
        }
        catch (FileSystemException e) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "com.ibm.team.filesystem.client", "Error aquiring read lock for cfa" + this.cfaRoot.getName(), (Throwable)((Object)e)));
        }
        finally {
            if (lock != null) {
                try {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(10));
                }
                catch (FileSystemException e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "com.ibm.team.filesystem.client", "Error releasing read lock for cfa" + this.cfaRoot.getName(), (Throwable)((Object)e)));
                }
            }
            progress.done();
        }
        return false;
    }
}

