/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules.builders;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ILoadRuleBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.RuleBuilder;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;

public class VersionableBuilder
implements ILoadRuleBuilder {
    private RuleBuilder ruleBuilder;
    private String[] repositoryPath;
    private UUID itemId;
    private IItemType itemType;

    public VersionableBuilder(RuleBuilder ruleBuilder) {
        this.ruleBuilder = ruleBuilder;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws TeamRepositoryException {
    }

    @Override
    public void endElement(String eName) throws TeamRepositoryException {
        if (eName.equals("parentFolder") || eName.equals("item")) {
            if (this.repositoryPath != null) {
                this.ruleBuilder.setRepositoryPath(this.repositoryPath);
            } else {
                if (this.itemType == null || this.itemId == null) {
                    throw new FileSystemException(Messages.VersionableBuilder_3);
                }
                IVersionableHandle versionable = (IVersionableHandle)this.itemType.createItemHandle(this.itemId, null);
                this.ruleBuilder.setVersionableHandle(versionable);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ILoadRuleBuilder startElement(String eName, Attributes attrs) throws TeamRepositoryException {
        VersionableBuilder builder = this;
        if (!eName.equals("parentFolder") && !eName.equals("item")) return builder;
        int i = 0;
        while (i < attrs.getLength()) {
            String attrName = attrs.getQName(i);
            String value = attrs.getValue(i);
            if ("itemType".equals(attrName)) {
                if (value.equals("file")) {
                    this.itemType = IFileItem.ITEM_TYPE;
                } else if (value.equals("folder")) {
                    this.itemType = IFolder.ITEM_TYPE;
                } else {
                    if (!value.equals("link")) throw new FileSystemException(NLS.bind((String)Messages.VersionableBuilder_1, (Object)eName, (Object[])new Object[]{value, attrName}));
                    this.itemType = ISymbolicLink.ITEM_TYPE;
                }
            } else if ("itemId".equals(attrName)) {
                try {
                    this.itemId = UUID.valueOf((String)value);
                }
                catch (IllegalArgumentException e) {
                    throw new FileSystemException(NLS.bind((String)Messages.VersionableBuilder_5, (Object)eName, (Object[])new Object[]{value, "itemId"}), e);
                }
            } else {
                if (!"repositoryPath".equals(attrName)) throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_6, (Object)attrName, (Object[])new Object[]{value}));
                this.repositoryPath = new Path(value).segments();
            }
            ++i;
        }
        if (this.repositoryPath == null && this.itemType == null && this.itemId == null) {
            throw new FileSystemException(NLS.bind((String)Messages.VersionableBuilder_2, (Object)"repositoryPath", (Object[])new Object[]{"itemType", "itemId"}));
        }
        if (this.repositoryPath != null && (this.itemType != null || this.itemId != null)) {
            throw new FileSystemException(NLS.bind((String)Messages.VersionableBuilder_4, (Object)"repositoryPath", (Object[])new Object[]{"itemType", "itemId"}));
        }
        if (this.itemType == null && this.itemId != null) {
            throw new FileSystemException(NLS.bind((String)Messages.VersionableBuilder_0, (Object)"itemType", (Object[])new Object[0]));
        }
        if (this.itemType == null || this.itemId != null) return builder;
        throw new FileSystemException(NLS.bind((String)Messages.VersionableBuilder_0, (Object)"itemType", (Object[])new Object[0]));
    }
}

