/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules.builders;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.loadRules.ChildLoadFilter;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ILoadRuleBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ParentLoadBuilder;
import com.ibm.team.repository.common.util.NLS;
import org.xml.sax.Attributes;

public class ChildFilterBuilder
implements ILoadRuleBuilder {
    private ParentLoadBuilder parentLoadBuilder;
    private ChildLoadFilter filter;

    public ChildFilterBuilder(ParentLoadBuilder parentLoadBuilder) {
        this.parentLoadBuilder = parentLoadBuilder;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws FileSystemException {
    }

    @Override
    public void endElement(String eName) throws FileSystemException {
        if (eName.equals("include")) {
            this.parentLoadBuilder.setFilter(this.filter);
        } else if (eName.equals("exclude")) {
            this.parentLoadBuilder.setFilter(this.filter);
        } else if (!eName.equals("filter")) {
            throw new FileSystemException(NLS.bind((String)Messages.ChildFilterBuilder_0, (Object)eName, (Object[])new Object[0]));
        }
    }

    @Override
    public ILoadRuleBuilder startElement(String eName, Attributes attrs) throws FileSystemException {
        if (eName.equals("include")) {
            this.filter = new ChildLoadFilter(eName, true);
        } else if (eName.equals("exclude")) {
            this.filter = new ChildLoadFilter(eName, false);
        } else if (eName.equals("filter")) {
            int i = 0;
            while (i < attrs.getLength()) {
                String attrName = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("name".equals(attrName)) {
                    this.filter.addName(value);
                } else if ("pattern".equals(attrName)) {
                    this.filter.addPattern(value);
                } else {
                    throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_6, (Object)attrName, (Object[])new Object[]{value}));
                }
                ++i;
            }
        } else {
            throw new FileSystemException(NLS.bind((String)Messages.ChildFilterBuilder_1, (Object)eName, (Object[])new Object[0]));
        }
        return this;
    }
}

