/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules;

import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.operations.LoadRuleSerializationDilemmaHandler;
import com.ibm.team.scm.common.IComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RelativeLoadLocation {
    private final IRelativeLocation relativePath;
    private final boolean includeRepositoryPath;
    private final boolean includeComponentName;
    protected static final String EOL = System.getProperty("line.separator");

    public RelativeLoadLocation(IRelativeLocation relativePath, boolean includeComponentName, boolean includeRepositoryPath) {
        this.relativePath = relativePath;
        this.includeComponentName = includeComponentName;
        this.includeRepositoryPath = includeRepositoryPath;
    }

    public boolean includeRepositoryPath() {
        return this.includeRepositoryPath;
    }

    public IRelativeLocation getResolvedRelativeLoadLocation(IComponent component, String[] repoPath) {
        return this.getResolvedRelativeLoadLocation(null, component, repoPath);
    }

    public IRelativeLocation getResolvedRelativeLoadLocation(String subFolderName, IComponent component, String[] repoPath) {
        IRelativeLocation result = null;
        if (subFolderName != null && !subFolderName.isEmpty()) {
            result = new RelativeLocation(subFolderName);
        }
        if (this.relativePath != null) {
            result = result != null ? result.append(this.relativePath) : this.relativePath;
        }
        if (result == null) {
            result = RelativeLocation.EMPTY_LOCATION;
        }
        if (this.includeComponentName) {
            result = result.append(component.getName());
        }
        if (this.includeRepositoryPath() && repoPath != null && repoPath.length > 0) {
            result = result.append(new RelativeLocation(repoPath));
        }
        return result;
    }

    public void toRule(Document document, Element parent, LoadRuleSerializationDilemmaHandler preferences, IProgressMonitor progress) {
        if (!this.relativePath.isEmpty() || this.includeComponentName || this.includeRepositoryPath()) {
            Element element = document.createElement("sandboxRelativePath");
            parent.appendChild(element);
            if (!this.relativePath.isEmpty()) {
                element.setAttribute("pathPrefix", this.relativePath.toString());
            }
            if (this.includeComponentName) {
                element.setAttribute("includeComponentName", "true");
            }
            if (this.includeRepositoryPath()) {
                element.setAttribute("includeRepositoryPath", "true");
            }
        }
    }
}

