/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.load.loadRules.ChildLoadFilter;
import com.ibm.team.filesystem.client.internal.load.loadRules.LoadRequest;
import com.ibm.team.filesystem.client.internal.load.loadRules.RelativeLoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.LoadRuleSerializationDilemmaHandler;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParentLoadRequest
extends LoadRequest {
    private String[] parentRepoPath;
    private IFolderHandle parentFolder;
    private ChildLoadFilter include;
    private ChildLoadFilter exclude;

    public ParentLoadRequest(IConnection connection, IComponent component, RelativeLoadLocation relativeLoadLocation, ChildLoadFilter include, ChildLoadFilter exclude, IFolderHandle parentFolder) {
        super(connection, component, relativeLoadLocation);
        this.include = include;
        this.exclude = exclude;
        if (parentFolder == null) {
            throw new IllegalArgumentException("Parent folder should not be null");
        }
        this.parentFolder = parentFolder;
        this.parentRepoPath = null;
    }

    public ParentLoadRequest(IConnection connection, IComponent component, RelativeLoadLocation relativeLoadLocation, ChildLoadFilter include, ChildLoadFilter exclude, IFolderHandle parentFolder, String[] repositoryPath) {
        super(connection, component, relativeLoadLocation);
        this.include = include;
        this.exclude = exclude;
        if (parentFolder == null) {
            throw new IllegalArgumentException("Parent folder should not be null");
        }
        this.parentFolder = parentFolder;
        this.parentRepoPath = repositoryPath;
    }

    public ParentLoadRequest(IConnection connection, IComponent component, RelativeLoadLocation relativeLoadLocation, ChildLoadFilter include, ChildLoadFilter exclude, String[] repositoryPath) {
        super(connection, component, relativeLoadLocation);
        this.include = include;
        this.exclude = exclude;
        this.parentFolder = null;
        this.parentRepoPath = repositoryPath;
    }

    private IRelativeLocation getResolvedRelativeLoadLocation(String subFolder, IProgressMonitor progress) throws TeamRepositoryException {
        RelativeLoadLocation relativeLoadLocation = this.getRelativeLoadLocation();
        if (relativeLoadLocation != null) {
            return relativeLoadLocation.getResolvedRelativeLoadLocation(subFolder, this.getComponent(), this.getFolderRepositoryPath(progress));
        }
        if (subFolder != null) {
            return new RelativeLocation(subFolder);
        }
        return RelativeLocation.EMPTY_LOCATION;
    }

    private String[] getFolderRepositoryPath(IProgressMonitor progress) throws TeamRepositoryException {
        if (this.parentRepoPath == null) {
            IAncestorReport ancestors = (IAncestorReport)this.getConfiguration().locateAncestors(Collections.singletonList(this.parentFolder), progress).get(0);
            this.setRepoPath(ancestors);
        }
        return this.parentRepoPath;
    }

    @Override
    public void toRule(Document document, Element parent, LoadRuleSerializationDilemmaHandler preferences, IProgressMonitor progress) throws TeamRepositoryException {
        RelativeLoadLocation relativeLoadLocation;
        Element element = document.createElement("parentLoadRule");
        parent.appendChild(element);
        this.addComponentToRule(document, element, preferences, progress);
        this.addVersionableToRule(this.getFolderRepositoryPath(progress), (IVersionableHandle)this.parentFolder, document, element, "parentFolder", preferences, progress);
        if (this.include != null) {
            this.include.toRule(document, element, preferences, progress);
        }
        if (this.exclude != null) {
            this.exclude.toRule(document, element, preferences, progress);
        }
        if ((relativeLoadLocation = this.getRelativeLoadLocation()) != null) {
            relativeLoadLocation.toRule(document, element, preferences, progress);
        }
    }

    @Override
    public IStatus configureLoad(ILoadOperation loadOp, ISandbox sandbox, IProgressMonitor monitor) {
        return this.configureLoad(loadOp, sandbox, false, monitor);
    }

    @Override
    public IStatus configureLoad(ILoadOperation loadOp, ISandbox sandbox, boolean allowsNestedShares, IProgressMonitor monitor) {
        return this.configureLoad(loadOp, sandbox, allowsNestedShares, null, monitor);
    }

    @Override
    public IStatus configureLoad(ILoadOperation loadOp, ISandbox sandbox, boolean allowsNestedShares, String subFolder, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IConnection connection = this.getConnection();
        try {
            Map<String, IVersionableHandle> allChildren;
            IConfiguration config = this.getConfiguration();
            IFolderHandle parent = this.getParentFolder((IProgressMonitor)progress.newChild(10));
            try {
                allChildren = config.childEntries(parent, (IProgressMonitor)progress.newChild(70));
            }
            catch (ItemNotFoundException e) {
                return FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.ParentLoadRequest_6, (Object)this.getRepoPathForErrorMsg(), (Object[])new Object[]{this.getComponentName(), sandbox.getRoot().toOSString()}));
            }
            catch (VersionablePermissionDeniedException e) {
                return FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.ParentLoadRequest_7, (Object)this.getRepoPathForErrorMsg(), (Object[])new Object[]{this.getComponentName(), sandbox.getRoot().toOSString()}));
            }
            allChildren = this.excludeIncludeChildren(allChildren);
            this.loadChildren(loadOp, sandbox, allowsNestedShares, subFolder, connection, allChildren, progress.newChild(20));
        }
        catch (ItemNotFoundException e) {
            return FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.ParentLoadRequest_8, (Object)this.getRepoPathForErrorMsg(), (Object[])new Object[]{this.getComponentName(), sandbox.getRoot().toOSString()}));
        }
        catch (TeamRepositoryException e) {
            String niceRepositoryPath = this.getRepoPathForErrorMsg();
            return FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ParentLoadRequest_3, (Object)niceRepositoryPath, (Object[])new Object[]{this.getComponentName(), sandbox.getRoot().toOSString()}), e);
        }
        return Status.OK_STATUS;
    }

    private void loadChildren(ILoadOperation loadOp, ISandbox sandbox, boolean allowsNestedShares, String subFolder, IConnection connection, Map<String, IVersionableHandle> allChildren, SubMonitor progress) throws TeamRepositoryException {
        if (!allChildren.isEmpty()) {
            IRelativeLocation relativeLoadPath = this.getResolvedRelativeLoadLocation(subFolder, (IProgressMonitor)progress.newChild(1));
            if (connection instanceof IWorkspaceConnection) {
                loadOp.requestLoad(sandbox, relativeLoadPath, (IWorkspaceConnection)connection, (IComponentHandle)this.getComponent(), allChildren.values(), allowsNestedShares);
            } else {
                loadOp.requestLoad(sandbox, relativeLoadPath, (IBaselineConnection)connection, allChildren.values(), allowsNestedShares);
            }
        }
    }

    private Map<String, IVersionableHandle> excludeIncludeChildren(Map<String, IVersionableHandle> allChildren) {
        if (this.include != null) {
            allChildren = this.include.applyFilter(allChildren);
        }
        if (this.exclude != null) {
            allChildren = this.exclude.applyFilter(allChildren);
        }
        return allChildren;
    }

    private String getRepoPathForErrorMsg() {
        if (this.parentRepoPath != null) {
            return this.getNiceRepoPath(this.parentRepoPath);
        }
        if (this.parentFolder != null) {
            return NLS.bind((String)Messages.ParentLoadRequest_5, (Object)this.parentFolder.getItemId(), (Object[])new Object[0]);
        }
        return this.getNiceRepoPath(this.parentRepoPath);
    }

    private IFolderHandle getParentFolder(IProgressMonitor progress) throws TeamRepositoryException, ItemNotFoundException, FileSystemException {
        if (this.parentFolder == null) {
            IConfiguration config = this.getConfiguration();
            IVersionableHandle versionable = config.resolvePath(this.getComponent().getRootFolder(), this.parentRepoPath, progress);
            if (versionable == null) {
                throw new ItemNotFoundException(NLS.bind((String)Messages.ParentLoadRequest_0, (Object)this.getNiceRepoPath(this.parentRepoPath), (Object[])new Object[]{this.getComponentName()}));
            }
            if (!(versionable instanceof IFolderHandle)) {
                throw new FileSystemException(NLS.bind((String)Messages.ParentLoadRequest_1, (Object)this.getNiceRepoPath(this.parentRepoPath), (Object[])new Object[]{this.getComponentName()}));
            }
            this.parentFolder = (IFolderHandle)versionable;
        }
        return this.parentFolder;
    }

    @Override
    public IVersionableHandle requireRepoPath() {
        if (this.parentRepoPath == null && this.getRelativeLoadLocation() != null && this.getRelativeLoadLocation().includeRepositoryPath()) {
            return this.parentFolder;
        }
        return null;
    }

    @Override
    public void setRepoPath(IAncestorReport ancestors) throws FileSystemException {
        if (ancestors.getNameItemPairs().isEmpty()) {
            throw new FileSystemException(NLS.bind((String)Messages.ParentLoadRequest_4, (Object)this.getComponentName(), (Object[])new Object[]{this.getConnection().getName(), this.parentFolder.getItemId().getUuidValue()}));
        }
        this.parentRepoPath = new String[ancestors.getNameItemPairs().size() - 1];
        Iterator i = ancestors.getNameItemPairs().iterator();
        i.next();
        int j = 0;
        while (i.hasNext()) {
            INameItemPair pair = (INameItemPair)i.next();
            this.parentRepoPath[j] = pair.getName();
            ++j;
        }
    }
}

