/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ILoadRuleBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.LoadRuleBuilder;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LoadRuleHandler
extends DefaultHandler {
    private StringBuffer textBuffer;
    private List<IStatus> warnings = new ArrayList<IStatus>();
    private LoadRuleBuilder loadRuleBuilder;
    private Stack<ILoadRuleBuilder> elementBuilders = new Stack();
    private boolean allowsNestedShares = true;

    public LoadRuleHandler(boolean allowsNestedShares) {
        this.allowsNestedShares = allowsNestedShares;
    }

    public LoadRuleHandler() {
        this(true);
    }

    public List<IStatus> getWarnings() {
        return this.warnings;
    }

    public ILoadRule2 getLoadRule(IConnection connection, IProgressMonitor progress) throws TeamRepositoryException {
        return this.loadRuleBuilder.getLoadRule(connection, progress);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        ILoadRuleBuilder builder;
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equals("sourceControlLoadRule")) {
            if (this.loadRuleBuilder != null) {
                throw new IllegalStateException(NLS.bind((String)Messages.LoadRuleHandler_1, (Object)"sourceControlLoadRule", (Object[])new Object[0]));
            }
            this.loadRuleBuilder = new LoadRuleBuilder(this.allowsNestedShares);
            builder = this.loadRuleBuilder;
        } else {
            builder = (ILoadRuleBuilder)this.elementBuilders.lastElement();
        }
        try {
            builder = builder.startElement(eName, attrs);
        }
        catch (TeamRepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
        this.elementBuilders.push(builder);
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        ILoadRuleBuilder builder = this.elementBuilders.pop();
        try {
            builder.endElement(eName);
        }
        catch (TeamRepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(s);
        } else {
            this.textBuffer.append(s);
        }
        try {
            ((ILoadRuleBuilder)this.elementBuilders.lastElement()).characters(buf, offset, len);
        }
        catch (TeamRepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    @Override
    public void warning(SAXParseException spe) throws SAXParseException {
        Exception cause = spe.getException();
        if (cause == null) {
            cause = spe;
        }
        this.warnings.add(FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.LoadRuleHandler_0, (Object)spe.getSystemId(), (Object[])new Object[]{spe.getLineNumber()}), cause));
    }
}

