/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.EclipseReadException;
import com.ibm.team.filesystem.client.FileDownloadHandler;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IKeywordExpansionContext;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.api.storage.FileOptionsFactory;
import com.ibm.team.filesystem.client.internal.content.DeletedContent;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.load.DeferredInformation;
import com.ibm.team.filesystem.client.internal.load.EncodingDownloadFailure;
import com.ibm.team.filesystem.client.internal.load.IUpdateInfo;
import com.ibm.team.filesystem.client.internal.load.KeywordExpansionContext;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.internal.load.LocalChangeRecorder;
import com.ibm.team.filesystem.client.internal.load.UpdateOrder;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.IUpdateMutator;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.ExclusiveFileLockPatternUtil;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.SilentProgressMonitor;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport2;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.LocaleUtil;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IVersionablePermissionsReport;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class UpdateMutator
extends FileSystemOperation
implements IUpdateMutator {
    private static final String COLLISION_RENAME = "#jazz";
    private final FileAreaUpdateReport2 updates;
    protected final ITeamRepository repository;
    protected final IConnection connection;
    protected final IContextHandle connectionHandle;
    private final Set<ICopyFileArea> copyFileAreasToUpdate;
    protected final IDownloadListener downloadMonitor;
    protected IFileContentManagerSession contentSession;
    private boolean lastComponentSharedResult;
    private IComponentHandle lastComponentShareTested;
    private boolean expandKeywords;
    private Map<ILocation, Map<ConfigurationFacade, Set<UUID>>> toSkip = NewCollection.hashMap();
    private final Set<ShareReference> inconsistentShares = NewCollection.hashSet();
    private final Set<ShareReference> newShares = NewCollection.hashSet();
    private final Map<UUID, IComponentStateSummary> componentStatesBefore;
    private final Map<UUID, IComponentStateSummary> componentStatesAfter;
    private Map<ICopyFileArea, Map<UUID, Map<UUID, Set<IRelativeLocation>>>> shareParents;
    private final Map<ICopyFileArea, Map<UUID, List<FileAreaUpdate>>> failedUpdates;
    private final Map<ICopyFileArea, List<FileAreaUpdate>> missingSource;
    private final Map<UUID, List<ICopyFileArea>> copyFileAreasByComponent;
    private final Shed shed;
    private UpdateOrder updateInfo;
    private final Collection<IItemUpdateReport> rawUpdates;
    private final UpdateDilemmaHandler problemHandler;
    private final Map<UUID, IComponent> componentCache = NewCollection.hashMap();
    private Map<ICopyFileArea, Map<UUID, LocalChangeRecorder>> localChangeRecorders;
    private IKeywordExpansionContext keywordExpansionContext;
    private Map<ICopyFileArea, Map<IRelativeLocation, IShare>> sharesWithExpandedKeywords;
    private final Log traceLog;

    protected void deleteIncompleteFile(ILocation fullPath) throws IOException {
        File victim = (File)fullPath.getAdapter(File.class);
        if (victim != null && victim.exists()) {
            victim.delete();
        }
    }

    protected OutputStream getFileOutputStream(ILocation fullPath) throws IOException {
        File file = (File)fullPath.getAdapter(File.class);
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            file.setWritable(true, true);
            file.getParentFile().setWritable(true, true);
            return new FileOutputStream(file);
        }
    }

    public UpdateMutator(IConnection session, Collection<? extends IComponentStateSummary> componentStatesBefore, Collection<? extends IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport2 updates, Collection<? extends IItemUpdateReport> rawUpdates, Collection<? extends ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler problemHandler, IDownloadListener downloadMonitor) {
        super(problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler);
        this.problemHandler = problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler;
        this.repository = session.teamRepository();
        if (session instanceof IWorkspaceConnection) {
            this.connectionHandle = ((IWorkspaceConnection)session).getResolvedWorkspace();
        } else if (session instanceof IBaselineConnection) {
            this.connectionHandle = ((IBaselineConnection)session).getBaseline();
        } else {
            throw new IllegalArgumentException();
        }
        this.connection = session;
        if (componentStatesBefore == null) {
            throw new IllegalArgumentException();
        }
        if (componentStatesAfter == null) {
            throw new IllegalArgumentException();
        }
        if (copyFileAreasToUpdate == null) {
            throw new IllegalArgumentException();
        }
        if (rawUpdates == null) {
            throw new IllegalArgumentException();
        }
        this.componentStatesBefore = NewCollection.hashMap();
        for (IComponentStateSummary iComponentStateSummary : componentStatesBefore) {
            this.componentStatesBefore.put(iComponentStateSummary.getComponent().getItemId(), iComponentStateSummary);
        }
        this.componentStatesAfter = NewCollection.hashMap();
        for (IComponentStateSummary iComponentStateSummary : componentStatesAfter) {
            this.componentStatesAfter.put(iComponentStateSummary.getComponent().getItemId(), iComponentStateSummary);
        }
        this.shareParents = NewCollection.hashMap();
        this.updates = updates;
        this.rawUpdates = rawUpdates;
        this.failedUpdates = NewCollection.hashMap();
        this.missingSource = NewCollection.hashMap();
        this.downloadMonitor = downloadMonitor;
        this.copyFileAreasToUpdate = NewCollection.hashSet(copyFileAreasToUpdate);
        this.copyFileAreasByComponent = NewCollection.hashMap();
        this.shed = new Shed(problemHandler.getBackupDilemmaHandler());
        Log log = LoggingHelper.getLog(UpdateMutator.class);
        this.traceLog = log != null && log.isTraceEnabled() ? log : null;
    }

    private final void createFile(IComponent component, FileAreaUpdate update, List<DeferredDownloadInformation> deferredDownloadInfo, boolean shouldAddNewSiblings, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (!this.isComponentShared((IComponentHandle)component)) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * copyFileAreas.size()));
        for (ICopyFileArea cfa : copyFileAreas) {
            this.createFile(cfa, component, update, deferredDownloadInfo, shouldAddNewSiblings, (IProgressMonitor)progress.newChild(100));
        }
    }

    private final void createFile(ICopyFileArea cfa, IComponent component, FileAreaUpdate update, List<DeferredDownloadInformation> deferredDownloadInfo, boolean shouldAddNewSiblings, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileItemHandle fileItemState = (IFileItemHandle)update.afterState();
        CreateUpdateInfo createUpdateInfo = new CreateUpdateInfo(cfa, update, component, (IProgressMonitor)progress.newChild(1));
        boolean foundParent = this.findParentOfAddition(cfa, component, update, shouldAddNewSiblings, createUpdateInfo, (IProgressMonitor)progress.newChild(1));
        if (!foundParent) {
            return;
        }
        Shareable existingNewFileShareable = (Shareable)SharingManager.getInstance().findShareable(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
        String name = this.getActualName((IVersionableHandle)fileItemState, update, existingNewFileShareable);
        IRelativeLocation path = createUpdateInfo.parentPath.append(name);
        createUpdateInfo.errorMsgFileName = path.toString();
        Shareable potentialCollision = new Shareable(cfa.getRoot(), path, ResourceType.FILE);
        if (potentialCollision.exists((IProgressMonitor)progress.newChild(1))) {
            if (createUpdateInfo.descriptor != null) {
                this.failedUpdate(cfa, update);
                if (existingNewFileShareable != null) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_1, (Object)createUpdateInfo.errorMsgFileName, (Object[])new Object[]{component.getName()})))));
                    this.recordInconsistentShare((IComponentHandle)component, existingNewFileShareable.getShare((IProgressMonitor)progress.newChild(1)));
                }
                return;
            }
            if (existingNewFileShareable != null) {
                ILocalChange change;
                LocalChangeRecorder localChangeRecorder;
                if (this.isPreserveLocalChanges() && (localChangeRecorder = this.getLocalChangeRecorder(cfa, (IComponentHandle)component)) != null && (change = localChangeRecorder.getLocalChange(update.item())).isType(2) && existingNewFileShareable.equals(potentialCollision) && this.handleCollision(cfa, component, update, potentialCollision, (IProgressMonitor)progress.newChild(1))) {
                    existingNewFileShareable = null;
                }
                if (existingNewFileShareable != null) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_0, (Object)createUpdateInfo.errorMsgFileName, (Object[])new Object[]{component.getName()})))));
                    this.recordInconsistentShare((IComponentHandle)component, existingNewFileShareable.getShare((IProgressMonitor)progress.newChild(1)));
                    return;
                }
            } else if (!this.handleCollision(cfa, component, update, potentialCollision, (IProgressMonitor)progress.newChild(1))) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_0, (Object)createUpdateInfo.errorMsgFileName, (Object[])new Object[]{component.getName()})))));
                this.recordInconsistentShare((IComponentHandle)component, potentialCollision.getShare((IProgressMonitor)progress.newChild(1)));
                return;
            }
        }
        if (existingNewFileShareable != null && existingNewFileShareable.exists((IProgressMonitor)progress.newChild(1))) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_29, (Object)createUpdateInfo.errorMsgFileName, (Object[])new Object[]{component.getName()})))));
            this.recordInconsistentShare((IComponentHandle)component, existingNewFileShareable.getShare((IProgressMonitor)progress.newChild(1)));
            return;
        }
        progress.setWorkRemaining(90);
        Shareable fileToCreate = new Shareable(cfa.getRoot(), path, ResourceType.FILE);
        DeferredDownloadInformation deferredDownload = new DeferredDownloadInformation(cfa, update, createUpdateInfo.descriptor, null, false);
        deferredDownloadInfo.add(deferredDownload);
        boolean skipWrite = this.skipUpdate(cfa.getRoot(), (IComponentHandle)component, (IVersionableHandle)fileItemState);
        this.storeFileContent(deferredDownload, fileToCreate, skipWrite, (IProgressMonitor)progress.newChild(90));
    }

    private LocalChangeRecorder getLocalChangeRecorder(ICopyFileArea cfa, IComponentHandle component) {
        if (this.localChangeRecorders == null) {
            return null;
        }
        Map<UUID, LocalChangeRecorder> recordersByComponent = this.localChangeRecorders.get(cfa);
        if (recordersByComponent != null) {
            return recordersByComponent.get(component.getItemId());
        }
        return null;
    }

    private void createLink(IComponent component, FileAreaUpdate update, Set<Shareable> linksToRefresh, Set<Shareable> linksToRecompute, boolean shouldAddNewSiblings, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (!this.isComponentShared((IComponentHandle)component)) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            this.createLink(cfa, component, update, linksToRefresh, linksToRecompute, shouldAddNewSiblings, (IProgressMonitor)totalProgress.newChild(1));
        }
    }

    private void createLink(ICopyFileArea cfa, IComponent component, FileAreaUpdate update, final Set<Shareable> linksToRefresh, final Set<Shareable> linksToRecompute, boolean shouldAddNewSiblings, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        FileItemInfoProxy proxy;
        ISymbolicLinkHandle linkItemState = (ISymbolicLinkHandle)update.afterState();
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CreateUpdateInfo createUpdateInfo = new CreateUpdateInfo(cfa, update, component, (IProgressMonitor)progress.newChild(1));
        boolean foundParent = this.findParentOfAddition(cfa, component, update, shouldAddNewSiblings, createUpdateInfo, (IProgressMonitor)progress.newChild(1));
        if (!foundParent) {
            return;
        }
        Shareable existingNewLinkShareable = (Shareable)SharingManager.getInstance().findShareable(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)linkItemState, (IProgressMonitor)progress.newChild(1));
        String name = this.getActualName((IVersionableHandle)linkItemState, update, existingNewLinkShareable);
        IRelativeLocation path = createUpdateInfo.parentPath.append(name);
        createUpdateInfo.errorMsgFileName = path.toString();
        Shareable potentialCollision = new Shareable(cfa.getRoot(), path, ResourceType.SYMBOLIC_LINK);
        if (potentialCollision.exists((IProgressMonitor)progress.newChild(1))) {
            if (createUpdateInfo.descriptor != null) {
                this.failedUpdate(cfa, update);
                if (existingNewLinkShareable != null) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_1, (Object)createUpdateInfo.errorMsgFileName, (Object[])new Object[]{component.getName()})))));
                    this.recordInconsistentShare((IComponentHandle)component, existingNewLinkShareable.getShare((IProgressMonitor)progress.newChild(1)));
                }
                return;
            }
            if (existingNewLinkShareable != null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_0, (Object)createUpdateInfo.errorMsgFileName, (Object[])new Object[]{component.getName()})))));
                this.recordInconsistentShare((IComponentHandle)component, existingNewLinkShareable.getShare((IProgressMonitor)progress.newChild(1)));
                return;
            }
            if (!this.handleCollision(cfa, component, update, potentialCollision, (IProgressMonitor)progress.newChild(1))) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_0, (Object)createUpdateInfo.errorMsgFileName, (Object[])new Object[]{component.getName()})))));
                this.recordInconsistentShare((IComponentHandle)component, potentialCollision.getShare((IProgressMonitor)progress.newChild(1)));
                return;
            }
        }
        if (existingNewLinkShareable != null && existingNewLinkShareable.exists((IProgressMonitor)progress.newChild(1))) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_52, (Object)createUpdateInfo.errorMsgFileName, (Object[])new Object[]{component.getName()})))));
            this.recordInconsistentShare((IComponentHandle)component, existingNewLinkShareable.getShare((IProgressMonitor)progress.newChild(1)));
            return;
        }
        progress.setWorkRemaining(70);
        final Shareable linkToCreate = new Shareable(cfa.getRoot(), path, ResourceType.SYMBOLIC_LINK);
        final IFileStorage linkStorage = linkToCreate.getFileStorage();
        final String target = linkStorage.convertTargetIntoLocalForm(update.getLinkTarget());
        final boolean isDirectory = update.isDirectoryLink();
        if (!this.skipUpdate(cfa.getRoot(), (IComponentHandle)component, (IVersionableHandle)linkItemState)) {
            if (linkStorage.supportSymbolicLinks()) {
                try {
                    final String pathTransfer = path.toString();
                    SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                        @Override
                        public void run() throws FileSystemException {
                            IStatus warning = null;
                            try {
                                linkStorage.create(target, isDirectory, (IProgressMonitor)progress.newChild(50));
                            }
                            catch (FileSystemException e) {
                                if (!(e.getCause() instanceof CoreException)) {
                                    throw e;
                                }
                                CoreException ce = (CoreException)e.getCause();
                                IStatus status = ce.getStatus();
                                if (status.getSeverity() != 2 && status.getSeverity() != 1) {
                                    throw e;
                                }
                                warning = ce.getStatus();
                            }
                            if (warning == null) {
                                linksToRefresh.add(linkToCreate);
                            } else {
                                Status highLevelStatus = new Status(warning.getSeverity(), warning.getPlugin(), NLS.bind((String)Messages.UpdateMutator_59, (Object)pathTransfer, (Object[])new Object[]{warning.getMessage()}));
                                UpdateMutator.this.collectStatus((IStatus)highLevelStatus);
                                linksToRecompute.add(linkToCreate);
                            }
                        }
                    });
                }
                catch (FileSystemException e) {
                    this.recordInconsistentShare((IComponentHandle)component, linkToCreate.getShare((IProgressMonitor)progress.newChild(1)));
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_31, (Object)path.toString(), (Object[])new Object[]{component.getName()}), (Throwable)((Object)e)));
                }
            } else {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.UpdateMutator_50, (Object)path.toString(), (Object[])new Object[]{update.getLinkTarget()}), null));
                linksToRecompute.add(linkToCreate);
            }
        }
        if (createUpdateInfo.isShare) {
            proxy = new FileItemInfoProxy((IVersionableHandle)linkItemState, createUpdateInfo.parent, name, PathUtils.isLoadedWithAnotherName(linkToCreate.getSandbox(), path, update.getName()));
            proxy.setTarget(linkToCreate.getFileStorage().getModificationStamp(), update.getLinkTarget(), target, isDirectory);
            IShare share = SharingManager.getInstance().share(linkToCreate, createUpdateInfo.descriptor, proxy.getFileItemInfo(), new MetadataProperties(update.getMetadataProperties()), 2, (IProgressMonitor)progress.newChild(1));
            this.newShares.add(new ShareReference((IComponentHandle)component, share));
        } else {
            proxy = new FileItemInfoProxy((IVersionableHandle)linkItemState, createUpdateInfo.parent, update.getName());
            proxy.setTarget(linkToCreate.getFileStorage().getModificationStamp(), update.getLinkTarget(), target, isDirectory);
            cfa.setItemMetaData(linkToCreate.getLocalPath(), proxy.getFileItemInfo(), ICopyFileArea.PropertyUpdate.REPLACE, new MetadataProperties(update.getMetadataProperties()), (IProgressMonitor)progress.newChild(1));
        }
    }

    private String getActualName(IVersionableHandle state, FileAreaUpdate update, Shareable existingShareable) throws FileSystemException {
        String remoteVersionableName = update.getName();
        if (existingShareable == null) {
            return remoteVersionableName;
        }
        String loadedAsName = existingShareable.getFileStorage().getActualName();
        if (update.getItem().sameItemId((IItemHandle)state)) {
            return loadedAsName;
        }
        return remoteVersionableName;
    }

    private boolean findParentOfAddition(ICopyFileArea cfa, IComponent component, FileAreaUpdate update, boolean shouldAddNewSiblings, CreateUpdateInfo createUpdateInfo, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        boolean found = true;
        if (createUpdateInfo.parentPath == null) {
            IRelativeLocation sharePoint = this.getSharePoint(cfa, (IComponentHandle)component, createUpdateInfo.parent);
            if (sharePoint != null) {
                if (shouldAddNewSiblings) {
                    Shareable parentShareable;
                    createUpdateInfo.descriptor = SharingDescriptor.create(this.connection, component, update.afterState(), this.getClientDataForSharingDescriptor());
                    createUpdateInfo.parentPath = sharePoint;
                    createUpdateInfo.isShare = true;
                    if (!createUpdateInfo.parentPath.isEmpty() && !(parentShareable = new Shareable(cfa.getRoot(), createUpdateInfo.parentPath, ResourceType.FOLDER)).exists((IProgressMonitor)progress.newChild(1))) {
                        parentShareable.getFileStorage().create(true, null, (IProgressMonitor)progress.newChild(1));
                    }
                } else {
                    found = false;
                }
            } else {
                InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)createUpdateInfo.parent, (IComponentHandle)component, this.connectionHandle, false);
                if (info != null) {
                    IShare share = cfa.getShare(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)createUpdateInfo.parent, (IProgressMonitor)progress.newChild(1));
                    if (share != null) {
                        this.recordInconsistentShare((IComponentHandle)component, share);
                    } else {
                        this.recordInconsistentComponent(cfa, (IComponentHandle)component, (IProgressMonitor)progress.newChild(1));
                    }
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_2, (Object)createUpdateInfo.errorMsgFileName, (Object[])new Object[]{component.getName()})))));
                } else {
                    this.failedUpdate(cfa, update);
                }
                found = false;
            }
        }
        return found;
    }

    private final void createFolder(IComponent component, FileAreaUpdate update, boolean shouldAddNewSiblings, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        IFolderHandle parent = update.getDestinationParent();
        if (parent == null) {
            return;
        }
        if (!this.isComponentShared((IComponentHandle)component)) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            this.createFolder(cfa, component, update, shouldAddNewSiblings, (IProgressMonitor)progress.newChild(1));
        }
    }

    private final void createFolder(ICopyFileArea cfa, IComponent component, FileAreaUpdate update, boolean shouldAddNewSiblings, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        IShare share;
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CreateUpdateInfo createUpdateInfo = new CreateUpdateInfo(cfa, update, component, (IProgressMonitor)progress.newChild(1));
        boolean foundParent = this.findParentOfAddition(cfa, component, update, shouldAddNewSiblings, createUpdateInfo, (IProgressMonitor)progress.newChild(1));
        if (!foundParent) {
            return;
        }
        IFolderHandle folderItemState = (IFolderHandle)update.afterState();
        IFolderHandle parent = update.getDestinationParent();
        Shareable existingNewFolderShareable = (Shareable)SharingManager.getInstance().findShareable(cfa.getRoot(), this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)folderItemState, null);
        String name = this.getActualName((IVersionableHandle)folderItemState, update, existingNewFolderShareable);
        IRelativeLocation path = createUpdateInfo.parentPath.append(name);
        createUpdateInfo.errorMsgFileName = path.toString();
        Shareable newFolderShareable = new Shareable(cfa.getRoot(), path, ResourceType.FOLDER);
        Shareable potentialCollision = new Shareable(cfa.getRoot(), path, ResourceType.FOLDER);
        if (potentialCollision.exists((IProgressMonitor)progress.newChild(1)) || !potentialCollision.getSandbox().isCaseSensitive() && (potentialCollision.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1)) || !name.equals(potentialCollision.getFileStorage().getActualName()))) {
            IVersionableHandle collisionRemote = null;
            IComponentHandle collisionComponent = null;
            IContextHandle collisionConnection = null;
            share = potentialCollision.getShare((IProgressMonitor)progress.newChild(1));
            if (share != null) {
                collisionRemote = potentialCollision.getRemote((IProgressMonitor)progress.newChild(1));
                collisionComponent = share.getSharingDescriptor().getComponent();
                collisionConnection = share.getSharingDescriptor().getConnectionHandle();
            }
            if (potentialCollision.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FOLDER && collisionRemote == null && existingNewFolderShareable == null) {
                if (!name.equals((potentialCollision = this.getShareableForExistingStorage(potentialCollision, update, (IProgressMonitor)progress.newChild(1))).getFileStorage().getActualName())) {
                    this.move(cfa, component, (IComponentHandle)component, potentialCollision, newFolderShareable, parent, name, null, false, null, false, (IProgressMonitor)progress.newChild(25));
                }
                if (createUpdateInfo.isShare) {
                    FileItemInfo proxy = new FileItemInfoProxy((IVersionableHandle)folderItemState, parent, name, PathUtils.isLoadedWithAnotherName(newFolderShareable.getSandbox(), path, name)).getFileItemInfo();
                    IShare newShare = SharingManager.getInstance().share(newFolderShareable, createUpdateInfo.descriptor, proxy, new MetadataProperties(update.getMetadataProperties()), 2, (IProgressMonitor)progress.newChild(1));
                    this.newShares.add(new ShareReference((IComponentHandle)component, newShare));
                } else {
                    FileItemInfo proxy = new FileItemInfoProxy((IVersionableHandle)folderItemState, parent, name).getFileItemInfo();
                    cfa.setItemMetaData(path, proxy, ICopyFileArea.PropertyUpdate.REPLACE, new MetadataProperties(update.getMetadataProperties()), (IProgressMonitor)progress.newChild(50));
                }
                return;
            }
            if (folderItemState.sameItemId((IItemHandle)collisionRemote) && component.sameItemId((IItemHandle)collisionComponent) && this.connectionHandle.sameItemId((IItemHandle)collisionConnection)) {
                if (name.equals(potentialCollision.getFileStorage().getActualName())) {
                    FileItemInfo proxy = new FileItemInfoProxy((IVersionableHandle)folderItemState, parent, name, false).getFileItemInfo();
                    cfa.setItemMetaData(potentialCollision.getLocalPath(), proxy, ICopyFileArea.PropertyUpdate.REPLACE, new MetadataProperties(update.getMetadataProperties()), (IProgressMonitor)progress.newChild(50));
                } else {
                    this.move(cfa, component, (IComponentHandle)component, potentialCollision, newFolderShareable, parent, name, (IVersionableHandle)folderItemState, true, new MetadataProperties(update.getMetadataProperties()), false, (IProgressMonitor)progress.newChild(25));
                }
                return;
            }
            if (createUpdateInfo.isShare) {
                if (!this.connectionHandle.sameItemId((IItemHandle)collisionConnection)) {
                    if (collisionConnection != null) {
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_55, (Object)path.toString(), (Object[])new Object[0])));
                    } else {
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_46, (Object)path.toString(), (Object[])new Object[0])));
                    }
                    this.failedUpdate(cfa, update);
                    return;
                }
                if (!folderItemState.sameItemId((IItemHandle)collisionRemote) && !this.updateInfo.isMovedOrDeleted(collisionComponent, collisionRemote)) {
                    if (collisionComponent != null) {
                        String componentName = Messages.UpdateMutator_56;
                        try {
                            IComponent fullCollisionComponent = this.getFullComponent(collisionComponent, (IProgressMonitor)progress.newChild(1));
                            componentName = fullCollisionComponent.getName();
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            // empty catch block
                        }
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_57, (Object)path.toString(), (Object[])new Object[]{componentName})));
                    } else {
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_46, (Object)path.toString(), (Object[])new Object[0])));
                    }
                    this.failedUpdate(cfa, update);
                    return;
                }
            }
            if (!this.handleCollision(cfa, component, update, potentialCollision, (IProgressMonitor)progress.newChild(25))) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_12, (Object)createUpdateInfo.errorMsgFileName, (Object[])new Object[]{potentialCollision.getFileStorage().getActualName()})))));
                this.recordInconsistentShare((IComponentHandle)component, potentialCollision.getShare((IProgressMonitor)progress.newChild(1)));
                return;
            }
        }
        if (existingNewFolderShareable != null && existingNewFolderShareable.exists((IProgressMonitor)progress.newChild(1))) {
            this.move(cfa, component, (IComponentHandle)component, existingNewFolderShareable, newFolderShareable, parent, name, (IVersionableHandle)folderItemState, true, new MetadataProperties(update.getMetadataProperties()), false, (IProgressMonitor)progress.newChild(25));
        } else {
            try {
                FileItemInfo proxy;
                final IFileStorage fileStorage = newFolderShareable.getFileStorage();
                if (!this.skipUpdate(newFolderShareable.getCopyFileAreaRoot(), (IComponentHandle)component, (IVersionableHandle)folderItemState)) {
                    SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                        @Override
                        public void run() throws FileSystemException {
                            fileStorage.create(false, null, (IProgressMonitor)progress.newChild(50));
                        }
                    });
                }
                if (createUpdateInfo.isShare) {
                    proxy = new FileItemInfoProxy((IVersionableHandle)folderItemState, parent, name, false).getFileItemInfo();
                    SharingDescriptor descriptor = SharingDescriptor.create(this.connection, component, (IVersionableHandle)folderItemState, this.getClientDataForSharingDescriptor());
                    share = SharingManager.getInstance().share(newFolderShareable, descriptor, proxy, new MetadataProperties(update.getMetadataProperties()), 2, (IProgressMonitor)progress.newChild(1));
                    this.newShares.add(new ShareReference((IComponentHandle)component, share));
                } else {
                    proxy = new FileItemInfoProxy((IVersionableHandle)folderItemState, parent, name).getFileItemInfo();
                    cfa.setItemMetaData(newFolderShareable.getLocalPath(), proxy, ICopyFileArea.PropertyUpdate.REPLACE, new MetadataProperties(update.getMetadataProperties()), (IProgressMonitor)progress.newChild(1));
                }
            }
            catch (FileSystemException e) {
                this.recordInconsistentShare((IComponentHandle)component, newFolderShareable.getShare((IProgressMonitor)progress.newChild(1)));
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_31, (Object)path.toString(), (Object[])new Object[]{component.getName()}), (Throwable)((Object)e)));
            }
            this.folderCreated(newFolderShareable, createUpdateInfo.isShare, (IProgressMonitor)progress.newChild(1));
        }
    }

    private IRelativeLocation getSharePoint(ICopyFileArea cfa, IComponentHandle component, IFolderHandle parent) {
        IRelativeLocation location;
        Set<IRelativeLocation> relativePathsOfParent;
        Map<UUID, Set<IRelativeLocation>> parentsByComponent;
        Map<UUID, Map<UUID, Set<IRelativeLocation>>> parentsForCFAByComponent = this.shareParents.get(cfa);
        if (parentsForCFAByComponent != null && (parentsByComponent = parentsForCFAByComponent.get(component.getItemId())) != null && (relativePathsOfParent = parent != null ? parentsByComponent.get(parent.getItemId()) : parentsByComponent.get(null)) != null && relativePathsOfParent.size() == 1 && cfa.getShare(location = relativePathsOfParent.iterator().next()) == null) {
            return location;
        }
        return null;
    }

    private final void deleteSubtree(IComponent component, IFolderHandle parent, String name, IVersionableHandle itemState, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (!this.isComponentShared((IComponentHandle)component)) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            Shareable toDeleteShareable;
            SubMonitor progress = totalProgress.newChild(1).setWorkRemaining(100);
            if (parent == null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, Messages.UpdateMutator_32, null));
                this.recordInconsistentComponent(cfa, (IComponentHandle)component, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            progress.subTask(NLS.bind((String)Messages.UpdateMutator_4, (Object)name, (Object[])new Object[0]));
            IRelativeLocation toDeletePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, itemState, (IProgressMonitor)progress.newChild(1));
            if (toDeletePath == null) {
                IComponentHandle alternateComponent = this.updateInfo.getCurrentComponent(component, parent);
                if (alternateComponent != null) {
                    toDeletePath = cfa.getLocalPathFor(this.connectionHandle, alternateComponent, itemState, (IProgressMonitor)progress.newChild(1));
                    component = (IComponent)this.connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)alternateComponent, 0, (IProgressMonitor)progress.newChild(1));
                }
                if (toDeletePath == null) {
                    cfa.forget(this.connectionHandle, (IComponentHandle)component, itemState, null);
                    continue;
                }
            }
            if (!(toDeleteShareable = new Shareable(cfa.getRoot(), toDeletePath, ResourceType.getResourceType(itemState))).exists((IProgressMonitor)progress.newChild(1))) {
                if (toDeleteShareable.isShare((IProgressMonitor)progress.newChild(1))) {
                    toDeleteShareable.unshare((IProgressMonitor)progress.newChild(95));
                    continue;
                }
                toDeleteShareable.forget((IProgressMonitor)progress.newChild(95));
                continue;
            }
            if (this.isPreserveLocalChanges()) {
                LocalChangeRecorder localChangeRecorder = this.getLocalChangeRecorder(cfa, (IComponentHandle)component);
                if (localChangeRecorder == null) {
                    this.deleteSubtree((IComponentHandle)component, toDeleteShareable, (IProgressMonitor)progress.newChild(95));
                    continue;
                }
                this.handleSubtreeDeletion(cfa, localChangeRecorder, toDeleteShareable, true, (IProgressMonitor)progress.newChild(95));
                continue;
            }
            this.deleteSubtree((IComponentHandle)component, toDeleteShareable, (IProgressMonitor)progress.newChild(95));
        }
    }

    private boolean handleSubtreeDeletion(ICopyFileArea cfa, LocalChangeRecorder recorder, Shareable shareable, boolean isRootOfDeletion, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        IVersionableHandle remote = shareable.getRemote((IProgressMonitor)progress.newChild(1));
        if (remote == null) {
            this.computeChanges(shareable, (IProgressMonitor)progress.newChild(1));
            return true;
        }
        ILocalChange localChange = recorder.getLocalChange(remote);
        if (localChange != null) {
            if (localChange.isType(1)) {
                if (!(!localChange.isType(8) || localChange.getComponent().sameItemId((IItemHandle)recorder.getComponent()) && this.isSourceLocationDeleted(localChange))) {
                    return true;
                }
                cfa.forget(shareable.getLocalPath(), (IProgressMonitor)progress.newChild(48));
                this.computeChanges(shareable, (IProgressMonitor)progress.newChild(1));
                return true;
            }
            if (!(!localChange.isType(8) || localChange.getComponent().sameItemId((IItemHandle)recorder.getComponent()) && this.isSourceLocationDeleted(localChange))) {
                return true;
            }
        }
        if (!isRootOfDeletion && shareable.isShare((IProgressMonitor)progress.newChild(1))) {
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
            if (share == null) {
                return true;
            }
            ILocalChange[] pendingChanges = LocalChangeManager.getInstance().getPendingChanges(new IShare[]{share});
            if (pendingChanges.length == 0) {
                this.deleteSubtree(recorder.getComponent(), shareable, (IProgressMonitor)progress.newChild(47));
                return false;
            }
            return true;
        }
        if (shareable.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FOLDER) {
            IFileStorage fileStorage = shareable.getFileStorage();
            Collection<IFileStorage> children = fileStorage.getChildren(false, (IProgressMonitor)progress.newChild(1));
            boolean childKept = false;
            for (IFileStorage child : children) {
                childKept |= this.handleSubtreeDeletion(cfa, recorder, child.getShareable(), false, (IProgressMonitor)progress.newChild(1));
            }
            if (childKept) {
                this.forgetShallow(cfa, recorder.getComponent(), shareable, remote, (IProgressMonitor)progress.newChild(44));
                this.computeChanges(shareable, (IProgressMonitor)progress.newChild(1));
                return true;
            }
            this.deleteSubtree(recorder.getComponent(), shareable, (IProgressMonitor)progress.newChild(45));
            return false;
        }
        this.deleteSubtree(recorder.getComponent(), shareable, (IProgressMonitor)progress.newChild(47));
        return false;
    }

    private void computeChanges(Shareable shareable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (shareable.getShare((IProgressMonitor)progress.newChild(1)) != null) {
            LocalChangeManager.getInstance().computeChanges(shareable, (IProgressMonitor)progress.newChild(1));
        }
    }

    private boolean isSourceLocationDeleted(ILocalChange localChange) {
        return this.updateInfo.isMovedOrDeleted(localChange.getComponent(), localChange.getTarget());
    }

    private void forgetShallow(ICopyFileArea cfa, IComponentHandle component, Shareable shareable, IVersionableHandle remote, IProgressMonitor monitor) throws FileSystemException {
        if (shareable.isShare(monitor)) {
            shareable.unshare(monitor);
        } else {
            cfa.forget(this.connectionHandle, component, remote, monitor);
        }
    }

    private void deleteSubtree(IComponentHandle component, Shareable toDeleteShareable, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVersionableHandle remote = toDeleteShareable.getRemote((IProgressMonitor)progress.newChild(1));
        if (remote == null || !this.skipUpdate(toDeleteShareable.getCopyFileAreaRoot(), component, remote)) {
            final IFileStorage storage = toDeleteShareable.getFileStorage();
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                    @Override
                    public void run() throws FileSystemException {
                        storage.delete(UpdateMutator.this.shed, (IProgressMonitor)progress.newChild(50));
                    }
                });
            }
            catch (FileSystemException e) {
                this.recordInconsistentShare(component, toDeleteShareable.getShare((IProgressMonitor)progress.newChild(1)));
                if (component instanceof IComponent) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_34, (Object)toDeleteShareable.getLocalPath(), (Object[])new Object[]{((IComponent)component).getName(), e.getMessage()}), (Throwable)((Object)e)));
                }
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_59a, (Object)toDeleteShareable.getLocalPath(), (Object[])new Object[]{e.getMessage()}), (Throwable)((Object)e)));
            }
        }
        if (toDeleteShareable.isShare((IProgressMonitor)progress.newChild(1))) {
            toDeleteShareable.unshare((IProgressMonitor)progress.newChild(49));
        } else {
            toDeleteShareable.forget((IProgressMonitor)progress.newChild(49));
        }
        progress.done();
    }

    protected final void modifyFile(IComponent component, FileAreaUpdate update, List<? super DeferredDownloadInformation> deferredDownloadInfo, Date timestamp, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (!this.isComponentShared((IComponentHandle)component)) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(copyFileAreas.size());
        IFileItemHandle fileItemState = (IFileItemHandle)update.afterState();
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor progress = totalProgress.newChild(1);
            progress.setWorkRemaining(20);
            String errorMsgFileName = update.getName();
            try {
                IRelativeLocation toModifyPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
                if (toModifyPath == null) {
                    IShare share;
                    InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)fileItemState, (IComponentHandle)component, this.connectionHandle, false);
                    if (info != null) {
                        IRelativeLocation remotePath = cfa.getRemotePathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(1));
                        if (remotePath != null) {
                            errorMsgFileName = remotePath.toString();
                        }
                        if (this.isTraceLoggingEnabled()) {
                            this.logTraceInfo(NLS.bind((String)"File {0} in component {1} could not be modified because it was deleted", (Object)errorMsgFileName, (Object[])new Object[]{component.getName()}));
                        }
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_8, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                        continue;
                    }
                    if (this.isTraceLoggingEnabled()) {
                        this.logTraceInfo(NLS.bind((String)"File {0} in component {1} could not be modified because it does not exist.", (Object)errorMsgFileName, (Object[])new Object[]{component.getName()}));
                    }
                    if ((share = cfa.getShare(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)update.getDestinationParent(), (IProgressMonitor)progress.newChild(1))) != null) {
                        if (this.isTraceLoggingEnabled()) {
                            this.logTraceInfo(NLS.bind((String)"The destination parent for file {0} in component {1} was found.", (Object)errorMsgFileName, (Object[])new Object[]{component.getName()}));
                        }
                        this.handleMissingSource(cfa, update);
                        continue;
                    }
                    this.failedUpdate(cfa, update);
                    continue;
                }
                errorMsgFileName = toModifyPath.toString();
                Shareable toModifyShareable = new Shareable(cfa.getRoot(), toModifyPath, ResourceType.FILE);
                if (toModifyShareable.getResourceType((IProgressMonitor)progress.newChild(1)) != ResourceType.FILE) {
                    if (this.isTraceLoggingEnabled()) {
                        this.logTraceInfo(NLS.bind((String)"Unable to modify {0} in component {1} because it is not a file.", (Object)errorMsgFileName, (Object[])new Object[]{component.getName()}));
                    }
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_35, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})))));
                    this.recordInconsistentShare((IComponentHandle)component, toModifyShareable.getShare((IProgressMonitor)progress.newChild(1)));
                    continue;
                }
                if (toModifyShareable.exists((IProgressMonitor)progress.newChild(1)) && (toModifyShareable.getSandbox().isCaseSensitive() || toModifyShareable.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1)) && toModifyShareable.getFileStorage().getActualName().equals(toModifyPath.getName()))) {
                    LocalChangeRecorder localChangeRecorder;
                    if (this.isPreserveLocalChanges() && (localChangeRecorder = this.getLocalChangeRecorder(cfa, (IComponentHandle)component)) != null) {
                        ILocalChange change = localChangeRecorder.getLocalChange(update.item());
                        boolean hasLocalChange = change != null && change.getType() != 0;
                        IVersionableHandle oldVersionable = toModifyShareable.getRemote((IProgressMonitor)progress.newChild(1));
                        boolean hasContentChange = LocalChangeManager.getInstance().isContentDirty(toModifyShareable, (IProgressMonitor)progress.newChild(1));
                        boolean hasLocalAddition = oldVersionable == null;
                        InverseFileItemInfo inverseInfo = cfa.getItemInfo(update.item(), (IComponentHandle)component, this.connectionHandle, false);
                        if (hasLocalChange) {
                            boolean propertiesNeedUpdate = false;
                            if (inverseInfo != null) {
                                propertiesNeedUpdate |= !inverseInfo.getChangedProperties().isEmpty();
                                propertiesNeedUpdate |= !inverseInfo.getRemovedProperties().isEmpty();
                            }
                            if (propertiesNeedUpdate && oldVersionable != null) {
                                localChangeRecorder.rememberPropertyChanges(toModifyShareable, update.afterState(), oldVersionable.getStateId(), inverseInfo.getOriginalProperties(), inverseInfo.getChangedProperties(), inverseInfo.getRemovedProperties());
                            }
                        }
                        ContentHash hash = inverseInfo == null ? null : inverseInfo.getHash();
                        if (hasContentChange || hasLocalAddition) {
                            try {
                                localChangeRecorder.rememberContent(update.afterState(), oldVersionable == null ? null : oldVersionable.getStateId(), hash, toModifyShareable, inverseInfo == null ? null : inverseInfo.getLineDelimiter(), inverseInfo == null ? null : inverseInfo.getContentType(), inverseInfo == null ? null : Boolean.valueOf(inverseInfo.isExecutable()), this.problemHandler.getBackupDilemmaHandler(), (IProgressMonitor)progress.newChild(1));
                            }
                            catch (Throwable e) {
                                this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                            }
                        } else {
                            localChangeRecorder.rememberContentProperties(update.afterState(), oldVersionable == null ? null : oldVersionable.getStateId(), hash, toModifyShareable, inverseInfo == null ? null : inverseInfo.getLineDelimiter(), inverseInfo == null ? null : inverseInfo.getContentType(), inverseInfo == null ? null : Boolean.valueOf(inverseInfo.isExecutable()));
                        }
                    }
                    Date existingModificationTime = new Date(toModifyShareable.getFileStorage().getLocalTimeStamp());
                    DeferredDownloadInformation deferredDownload = new DeferredDownloadInformation(cfa, update, null, existingModificationTime, false);
                    deferredDownloadInfo.add(deferredDownload);
                    boolean skipWrite = this.skipUpdate(toModifyShareable.getCopyFileAreaRoot(), deferredDownload.getComponent(), toModifyShareable.getRemote((IProgressMonitor)progress.newChild(2)));
                    if (this.isTraceLoggingEnabled()) {
                        String extraInfo = "stateId: " + update.getAfter().getUuidValue() + " skipWrite: " + skipWrite;
                        this.logTraceInfo(NLS.bind((String)"File {0} in component {1} queued for download: {2}.", (Object)errorMsgFileName, (Object[])new Object[]{component.getName(), extraInfo}));
                    }
                    this.storeFileContent(deferredDownload, toModifyShareable, skipWrite, (IProgressMonitor)progress.newChild(10));
                    continue;
                }
                this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_8, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
            }
            finally {
                progress.done();
            }
        }
    }

    private void modifyFolder(IComponent component, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (!this.isComponentShared((IComponentHandle)component)) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(copyFileAreas.size());
        IFolderHandle folderState = (IFolderHandle)update.afterState();
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor progress = totalProgress.newChild(1);
            progress.setWorkRemaining(10);
            String errorMsgFileName = update.getName();
            try {
                IRelativeLocation toModifyPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)folderState, (IProgressMonitor)progress.newChild(1));
                MetadataProperties properties = new MetadataProperties(update.getMetadataProperties());
                if (toModifyPath == null) {
                    InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)folderState, (IComponentHandle)component, this.connectionHandle, false);
                    if (info != null) {
                        IRelativeLocation remotePath = cfa.getRemotePathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)folderState, (IProgressMonitor)progress.newChild(1));
                        if (remotePath != null) {
                            errorMsgFileName = remotePath.toString();
                        }
                        cfa.setProperties(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)folderState, properties, (IProgressMonitor)progress.newChild(8));
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_53, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                        continue;
                    }
                    IShare share = cfa.getShare(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)update.getDestinationParent(), (IProgressMonitor)progress.newChild(4));
                    if (share != null) {
                        IRelativeLocation localParentPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)update.getDestinationParent(), (IProgressMonitor)progress.newChild(4));
                        if (localParentPath != null) {
                            errorMsgFileName = localParentPath.append(update.getName()).toString();
                        }
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_65, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                        this.recordInconsistentShare((IComponentHandle)component, share);
                        continue;
                    }
                    this.failedUpdate(cfa, update);
                    continue;
                }
                errorMsgFileName = toModifyPath.toString();
                InverseFileItemInfo oldInfo = cfa.getItemInfo((IVersionableHandle)folderState, (IComponentHandle)component, this.connectionHandle, false);
                if (oldInfo == null) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_48, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()}), null));
                    Shareable toModifyShareable = new Shareable(cfa.getRoot(), toModifyPath, ResourceType.FOLDER);
                    this.recordInconsistentShare((IComponentHandle)component, toModifyShareable.getShare(null));
                    continue;
                }
                FileItemInfoProxy newInfoProxy = new FileItemInfoProxy(oldInfo);
                newInfoProxy.setItemState((IVersionableHandle)folderState);
                FileItemInfo newInfo = newInfoProxy.getFileItemInfo();
                cfa.setItemMetaData(toModifyPath, newInfo, ICopyFileArea.PropertyUpdate.REPLACE, properties, (IProgressMonitor)progress.newChild(9));
            }
            finally {
                progress.done();
            }
        }
    }

    private void modifyLink(IComponent component, FileAreaUpdate update, Set<Shareable> linksToRefresh, Set<Shareable> linksToRecompute, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (!this.isComponentShared((IComponentHandle)component)) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
        totalProgress.setWorkRemaining(copyFileAreas.size());
        ISymbolicLinkHandle linkItemState = (ISymbolicLinkHandle)update.afterState();
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor progress = totalProgress.newChild(1);
            progress.setWorkRemaining(10);
            String errorMsgFileName = update.getName();
            try {
                IRelativeLocation toModifyPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)linkItemState, (IProgressMonitor)progress.newChild(1));
                if (toModifyPath == null) {
                    InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)linkItemState, (IComponentHandle)component, this.connectionHandle, false);
                    if (info != null) {
                        IRelativeLocation remotePath = cfa.getRemotePathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)linkItemState, (IProgressMonitor)progress.newChild(9));
                        if (remotePath != null) {
                            errorMsgFileName = remotePath.toString();
                        }
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_30, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                        continue;
                    }
                    IShare share = cfa.getShare(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)update.getDestinationParent(), (IProgressMonitor)progress.newChild(4));
                    if (share != null) {
                        IRelativeLocation localParentPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)update.getDestinationParent(), (IProgressMonitor)progress.newChild(4));
                        if (localParentPath != null) {
                            errorMsgFileName = localParentPath.append(update.getName()).toString();
                        }
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_66, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
                        this.recordInconsistentShare((IComponentHandle)component, share);
                        continue;
                    }
                    this.failedUpdate(cfa, update);
                    continue;
                }
                errorMsgFileName = toModifyPath.toString();
                Shareable toModifyShareable = new Shareable(cfa.getRoot(), toModifyPath, ResourceType.SYMBOLIC_LINK);
                if (toModifyShareable.getResourceType((IProgressMonitor)progress.newChild(1)) != ResourceType.SYMBOLIC_LINK) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_33, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})))));
                    this.recordInconsistentShare((IComponentHandle)component, toModifyShareable.getShare((IProgressMonitor)progress.newChild(8)));
                    continue;
                }
                if (toModifyShareable.exists((IProgressMonitor)progress.newChild(1)) && (toModifyShareable.getSandbox().isCaseSensitive() || toModifyShareable.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1)) && toModifyShareable.getFileStorage().getActualName().equals(toModifyPath.getName()))) {
                    this.modifyLink(cfa, toModifyShareable, component, update, linksToRefresh, linksToRecompute, progress.newChild(7));
                    continue;
                }
                this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_42, (Object)errorMsgFileName, (Object[])new Object[]{component.getName()})));
            }
            finally {
                progress.done();
            }
        }
    }

    private void modifyLink(ICopyFileArea copyFileArea, Shareable shareable, IComponent component, FileAreaUpdate updateInfo, Set<Shareable> linksToRefresh, Set<Shareable> linksToRecompute, SubMonitor progress) throws TeamRepositoryException, FileSystemException {
        InverseFileItemInfo oldInfo;
        String linkTarget;
        IVersionableHandle symbolicLinkHandle;
        boolean isDirectory;
        SubMonitor monitor;
        block20: {
            monitor = SubMonitor.convert((IProgressMonitor)progress, (int)6);
            isDirectory = updateInfo.isDirectoryLink();
            symbolicLinkHandle = updateInfo.afterState();
            IFileStorage linkStorage = shareable.getFileStorage();
            linkTarget = linkStorage.convertTargetIntoLocalForm(updateInfo.getLinkTarget());
            if (linkStorage.supportSymbolicLinks()) {
                if (!this.skipUpdate(copyFileArea.getRoot(), (IComponentHandle)component, shareable.getRemote((IProgressMonitor)monitor.newChild(1)))) {
                    LocalChangeRecorder localChangeRecorder = this.getLocalChangeRecorder(copyFileArea, (IComponentHandle)component);
                    if (localChangeRecorder != null) {
                        boolean hasLocalChange;
                        ILocalChange change = localChangeRecorder == null ? null : localChangeRecorder.getLocalChange(updateInfo.item());
                        boolean bl = hasLocalChange = change != null && change.getType() != 0;
                        if (hasLocalChange) {
                            boolean hasContentChange;
                            IVersionableHandle oldVersionable = shareable.getRemote((IProgressMonitor)monitor.newChild(1));
                            LinkInfo oldTargetInfo = shareable.getFileStorage().getLinkInfo((IProgressMonitor)monitor.newChild(1));
                            String localTarget = oldTargetInfo.getTarget();
                            boolean localIsDirectoryLink = false;
                            if (oldTargetInfo.getType() == LinkType.NONE) {
                                FileItemInfo existingInfo = shareable.getFileItemInfo((IProgressMonitor)monitor.newChild(1));
                                if (existingInfo != null) {
                                    localIsDirectoryLink = existingInfo.isDirectoryLink();
                                }
                            } else {
                                localIsDirectoryLink = oldTargetInfo.getType() == LinkType.DIRECTORY;
                            }
                            boolean bl2 = hasContentChange = !linkTarget.equals(localTarget) || isDirectory != localIsDirectoryLink;
                            if (hasContentChange) {
                                InverseFileItemInfo inverseInfo = copyFileArea.getItemInfo(symbolicLinkHandle, (IComponentHandle)component, this.connectionHandle, false);
                                ContentHash hash = inverseInfo == null ? null : inverseInfo.getHash();
                                localChangeRecorder.rememberLinkChanges(shareable, symbolicLinkHandle, oldVersionable == null ? null : oldVersionable.getStateId(), localTarget, localIsDirectoryLink, hash);
                            }
                        }
                    }
                    SharingManager.getInstance().disableChangeMonitoring();
                    try {
                        try {
                            linkStorage.setTarget(this.shed, linkTarget == null ? "" : linkTarget, isDirectory, (IProgressMonitor)monitor.newChild(1));
                            linksToRefresh.add(shareable);
                        }
                        catch (FileSystemException e) {
                            if (e.getCause() instanceof CoreException) {
                                CoreException ce = (CoreException)e.getCause();
                                IStatus status = ce.getStatus();
                                if (status.getSeverity() == 2 || status.getSeverity() == 1) {
                                    Status highLevelStatus = new Status(status.getSeverity(), status.getPlugin(), NLS.bind((String)Messages.UpdateMutator_59, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{status.getMessage()}));
                                    this.collectStatus((IStatus)highLevelStatus);
                                    linksToRecompute.add(shareable);
                                } else {
                                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                                    this.recordInconsistentShare((IComponentHandle)component, shareable.getShare(null));
                                }
                            } else {
                                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                                this.recordInconsistentShare((IComponentHandle)component, shareable.getShare(null));
                            }
                            SharingManager.getInstance().enableChangeMonitoring();
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        SharingManager.getInstance().enableChangeMonitoring();
                        throw throwable;
                    }
                    SharingManager.getInstance().enableChangeMonitoring();
                }
            } else {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.UpdateMutator_47, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{linkTarget}), null));
                linksToRecompute.add(shareable);
            }
        }
        if ((oldInfo = copyFileArea.getItemInfo(symbolicLinkHandle, (IComponentHandle)component, this.connectionHandle, false)) == null) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_48, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{component.getName()}), null));
            this.recordInconsistentShare((IComponentHandle)component, shareable.getShare(null));
        } else {
            FileItemInfoProxy newInfoProxy = new FileItemInfoProxy(oldInfo);
            newInfoProxy.setItemState(symbolicLinkHandle);
            newInfoProxy.setTarget(shareable.getFileStorage().getModificationStamp(), updateInfo.getLinkTarget(), linkTarget, isDirectory);
            FileItemInfo newInfo = newInfoProxy.getFileItemInfo();
            copyFileArea.setItemMetaData(shareable.getLocalPath(), newInfo, ICopyFileArea.PropertyUpdate.REPLACE, new MetadataProperties(updateInfo.getMetadataProperties()), (IProgressMonitor)monitor.newChild(1));
        }
    }

    private void storeFileContent(DeferredDownloadInformation downloadInfo, Shareable shareable, boolean skipWrite, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (skipWrite && shareable.getRemote((IProgressMonitor)monitor.newChild(1)) != null && !FileSystemCore.getContentManager(this.repository).convertDelimitersDuringRetrieval(downloadInfo.getContent())) {
            IFileContent content = downloadInfo.getContent();
            downloadInfo.setContentUpdated(shareable, content.getHash(), content.getRawLength());
            return;
        }
        if (shareable.exists((IProgressMonitor)monitor.newChild(1))) {
            try {
                this.shed.forceBackup(shareable, (IProgressMonitor)monitor.newChild(97));
            }
            catch (FileSystemException e) {
                if (this.isPreserveLocalChanges()) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_36, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)((Object)e)));
                }
                this.recordInconsistentShare(downloadInfo.getComponent(), shareable.getShare((IProgressMonitor)monitor.newChild(1)));
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_36, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)((Object)e)));
            }
        }
        downloadInfo.setExpandKeywords(this.keywordExpansionContext != null && KeywordExpansionContext.isShareLoadedWithKeywordExpansionEnabled(shareable, (IProgressMonitor)monitor.newChild(1)));
        DownloadHandler downloader = new DownloadHandler(shareable, downloadInfo, skipWrite);
        this.contentSession.retrieveContent((IFileItemHandle)downloadInfo.getFileItemState(), downloadInfo.getContent(), downloader);
    }

    private static void read(InputStream in) throws IOException {
        byte[] b = new byte[16000];
        try {
            while (in.read(b) != -1) {
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected final void moveSubtree(IComponent component, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        boolean crossComponentMove;
        IComponent previousComponent;
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (update.getComponent().sameItemId((IItemHandle)update.getPreviousComponent())) {
            previousComponent = component;
            crossComponentMove = false;
        } else {
            previousComponent = (IComponent)this.connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)update.getPreviousComponent(), 0, (IProgressMonitor)totalProgress.newChild(20));
            crossComponentMove = true;
        }
        IFolderHandle destinationParent = update.getDestinationParent();
        String newName = update.getName();
        IVersionableHandle itemMovedState = update.afterState();
        boolean alsoModified = update.isChangeType(4);
        if (!this.isComponentShared((IComponentHandle)previousComponent)) {
            return;
        }
        List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(previousComponent.getItemId());
        totalProgress.setWorkRemaining(copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            LocalChangeRecorder localChangeRecorder;
            ILocalChange localChange;
            Shareable toMoveShareable;
            SubMonitor progress = totalProgress.newChild(80);
            progress.setWorkRemaining(100);
            boolean itemToMoveExists = false;
            boolean itemToMoveIsShare = false;
            boolean itemToMoveIsLoadedWithAnotherName = false;
            boolean targetFolderExistsLocally = false;
            boolean targetFolderIsShareParent = false;
            IShare targetShare = null;
            IShare sourceShare = null;
            IRelativeLocation targetPath = null;
            String sourceErrorMsgName = update.getOldName();
            String targetErrorMsgName = update.getName();
            IRelativeLocation toMovePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)previousComponent, itemMovedState, (IProgressMonitor)progress.newChild(1));
            if (toMovePath == null && crossComponentMove && (toMovePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, itemMovedState, (IProgressMonitor)progress.newChild(1))) != null) {
                previousComponent = component;
                crossComponentMove = false;
            }
            if (toMovePath != null) {
                Shareable sourceShareable = new Shareable(cfa.getRoot(), toMovePath, ResourceType.getResourceType(itemMovedState));
                sourceShare = sourceShareable.getShare((IProgressMonitor)progress.newChild(1));
                itemToMoveExists = sourceShareable.exists((IProgressMonitor)progress.newChild(1));
                itemToMoveIsShare = sourceShareable.isShare((IProgressMonitor)progress.newChild(1));
                if (itemToMoveIsShare) {
                    itemToMoveIsLoadedWithAnotherName = sourceShare.isLoadedWithAnotherName((IProgressMonitor)progress.newChild(1));
                }
                sourceErrorMsgName = toMovePath.toString();
            } else {
                itemToMoveExists = false;
                sourceShare = cfa.getShare(this.connectionHandle, (IComponentHandle)previousComponent, itemMovedState, (IProgressMonitor)progress.newChild(1));
                IRelativeLocation bestGuess = cfa.getRemotePathFor(this.connectionHandle, (IComponentHandle)previousComponent, itemMovedState, (IProgressMonitor)progress.newChild(1));
                if (bestGuess != null) {
                    sourceErrorMsgName = bestGuess.toString();
                }
            }
            Shareable destinationParentShareable = null;
            IRelativeLocation sharePoint = this.getSharePoint(cfa, (IComponentHandle)component, destinationParent);
            if (sharePoint != null) {
                targetPath = crossComponentMove && itemToMoveExists && itemToMoveIsShare && newName.equals(sourceShare.getPath().getName()) ? sourceShare.getPath() : sharePoint.append(newName);
                targetFolderIsShareParent = true;
                targetErrorMsgName = targetPath.toString();
            } else {
                IRelativeLocation destinationParentPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)destinationParent, (IProgressMonitor)progress.newChild(1));
                destinationParentShareable = null;
                if (destinationParentPath != null) {
                    destinationParentShareable = new Shareable(cfa.getRoot(), destinationParentPath, ResourceType.FOLDER);
                    targetPath = destinationParentShareable.getLocalPath().append(newName);
                    targetErrorMsgName = targetPath.toString();
                    targetShare = destinationParentShareable.getShare((IProgressMonitor)progress.newChild(1));
                    targetFolderExistsLocally = true;
                } else {
                    IRelativeLocation bestGuess;
                    targetFolderExistsLocally = false;
                    targetShare = cfa.getShare(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)destinationParent, (IProgressMonitor)progress.newChild(1));
                    if (targetShare == null && itemToMoveIsShare) {
                        targetFolderIsShareParent = true;
                        targetPath = sourceShare.getPath().getParent().append(newName);
                    } else if (targetShare != null && (bestGuess = cfa.getRemotePathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)destinationParent, (IProgressMonitor)progress.newChild(1))) != null) {
                        targetErrorMsgName = bestGuess.toString();
                    }
                }
            }
            if (!itemToMoveExists) {
                boolean reportFailedUpdateForSource = sourceShare == null;
                boolean reportFailedUpdateForTarget = false;
                if (sourceShare != null) {
                    this.recordInconsistentShare((IComponentHandle)previousComponent, sourceShare);
                    this.recordInconsistentShare((IComponentHandle)component, targetShare);
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_9, (Object)sourceErrorMsgName, (Object[])new Object[]{targetErrorMsgName, component.getName()})))));
                } else if (targetShare != null) {
                    this.handleMissingSource(cfa, update);
                } else if (!targetFolderIsShareParent) {
                    reportFailedUpdateForTarget = true;
                }
                if (reportFailedUpdateForSource && !previousComponent.sameItemId((IItemHandle)component)) {
                    this.failedUpdate(cfa, update, (IComponentHandle)previousComponent);
                }
                if (!reportFailedUpdateForTarget && (!reportFailedUpdateForSource || !previousComponent.sameItemId((IItemHandle)component))) continue;
                this.failedUpdate(cfa, update);
                continue;
            }
            if (!(targetFolderExistsLocally || targetFolderIsShareParent && itemToMoveIsShare || itemToMoveIsShare && targetShare == null)) {
                toMoveShareable = new Shareable(cfa.getRoot(), toMovePath, ResourceType.getResourceType(itemMovedState));
                this.deleteSubtree((IComponentHandle)previousComponent, toMoveShareable, (IProgressMonitor)progress.newChild(1));
                cfa.forget(toMovePath, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            toMoveShareable = new Shareable(cfa.getRoot(), toMovePath, ResourceType.getResourceType(itemMovedState));
            if (this.isPreserveLocalChanges() && !crossComponentMove && (localChange = (localChangeRecorder = this.getLocalChangeRecorder(cfa, (IComponentHandle)component)).getLocalChange(update.getItem())) != null && localChange.isType(8)) {
                localChangeRecorder.rememberMove(update, localChange, toMoveShareable, (IProgressMonitor)progress.newChild(1));
            }
            Shareable potentialCollision = new Shareable(cfa.getRoot(), targetPath, ResourceType.getResourceType(itemMovedState));
            if (itemToMoveIsShare && targetFolderIsShareParent) {
                FileItemInfo info = cfa.getItemInfo(toMoveShareable.getLocalPath());
                if (info.isLoadedWithAnotherName()) {
                    if (!targetFolderIsShareParent) {
                        this.recordInconsistentShare((IComponentHandle)previousComponent, sourceShare);
                        this.recordInconsistentShare((IComponentHandle)component, targetShare);
                        this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_43, (Object)sourceErrorMsgName, (Object[])new Object[]{targetErrorMsgName, component.getName()})))));
                    }
                    this.updateMetaDataAfterMove(cfa, component, (IComponentHandle)previousComponent, toMoveShareable, potentialCollision, itemToMoveIsShare, itemToMoveIsLoadedWithAnotherName, true, new MetadataProperties(update.getMetadataProperties()), alsoModified, destinationParent, itemMovedState, newName, (IProgressMonitor)progress.newChild(75));
                    continue;
                }
                if (update.getOldName().equals(update.getName())) {
                    this.updateMetaDataAfterMove(cfa, component, (IComponentHandle)previousComponent, toMoveShareable, potentialCollision, itemToMoveIsShare, itemToMoveIsLoadedWithAnotherName, true, new MetadataProperties(update.getMetadataProperties()), alsoModified, destinationParent, itemMovedState, newName, (IProgressMonitor)progress.newChild(75));
                    continue;
                }
            }
            if (itemMovedState.sameItemId((IItemHandle)potentialCollision.getRemote((IProgressMonitor)progress.newChild(1))) && component.sameItemId((IItemHandle)previousComponent)) {
                if (update.getOldName().equals(update.getName())) {
                    if (alsoModified || !(itemMovedState instanceof IFileItemHandle) && !(itemMovedState instanceof ISymbolicLinkHandle)) continue;
                    InverseFileItemInfo oldInfo = cfa.getItemInfo(itemMovedState, (IComponentHandle)component, this.connectionHandle, true);
                    FileItemInfoProxy info = new FileItemInfoProxy(oldInfo);
                    info.setItemState(itemMovedState);
                    cfa.setItemMetaData(toMoveShareable.getLocalPath(), info.getFileItemInfo(), ICopyFileArea.PropertyUpdate.REPLACE, new MetadataProperties(update.getMetadataProperties()), (IProgressMonitor)progress.newChild(75));
                    continue;
                }
            } else if (potentialCollision.exists((IProgressMonitor)progress.newChild(1)) || !potentialCollision.getSandbox().isCaseSensitive() && (potentialCollision.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1)) || !potentialCollision.getFileStorage().getActualName().equals(update.getName()))) {
                if (PathUtils.sameRelativePath(potentialCollision.getLocalPath(), true, toMoveShareable.getLocalPath(), true)) {
                    this.updateMetaDataAfterMove(cfa, component, (IComponentHandle)previousComponent, toMoveShareable, potentialCollision, itemToMoveIsShare, itemToMoveIsLoadedWithAnotherName, true, new MetadataProperties(update.getMetadataProperties()), alsoModified, destinationParent, itemMovedState, newName, (IProgressMonitor)progress.newChild(75));
                    continue;
                }
                if (!this.handleCollision(cfa, component, update, potentialCollision, (IProgressMonitor)progress.newChild(75))) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)new FileSystemException(NLS.bind((String)Messages.UpdateMutator_13, (Object)toMovePath.toString(), (Object[])new Object[]{targetPath.toString()})))));
                    this.recordInconsistentShare((IComponentHandle)previousComponent, sourceShare);
                    this.recordInconsistentShare((IComponentHandle)component, targetShare);
                    continue;
                }
            }
            boolean recordInconsistentForTarget = false;
            if (crossComponentMove) {
                if (itemMovedState.getItemType().equals(IFolder.ITEM_TYPE)) {
                    IComponent oldComponent = previousComponent;
                    IComponent newComponent = component;
                    final ICopyFileArea theCfa = cfa;
                    ArrayList prexisting = new ArrayList();
                    toMoveShareable.accept(new IShareableVisitor((IComponentHandle)newComponent, prexisting, (IComponentHandle)oldComponent){
                        private final /* synthetic */ IComponentHandle val$newComponent;
                        private final /* synthetic */ List val$prexisting;
                        private final /* synthetic */ IComponentHandle val$oldComponent;
                        {
                            this.val$newComponent = iComponentHandle;
                            this.val$prexisting = list;
                            this.val$oldComponent = iComponentHandle2;
                        }

                        @Override
                        public boolean visit(IShareable shareable, IProgressMonitor monitor) {
                            IVersionableHandle remote;
                            block3: {
                                try {
                                    remote = shareable.getRemote(monitor);
                                    IRelativeLocation previousComponentPath = theCfa.getLocalPathFor(UpdateMutator.this.connectionHandle, this.val$newComponent, remote, monitor);
                                    if (previousComponentPath == null) break block3;
                                    this.val$prexisting.add(remote);
                                    return true;
                                }
                                catch (FileSystemException e) {
                                    UpdateMutator.this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                                    return false;
                                }
                            }
                            return remote.getItemType().equals(IFolder.ITEM_TYPE);
                        }

                        @Override
                        public IComponentHandle getComponent() {
                            return this.val$oldComponent;
                        }
                    }, Integer.MAX_VALUE, true, false, (IProgressMonitor)progress.newChild(1));
                    if (!prexisting.isEmpty()) {
                        recordInconsistentForTarget = true;
                        throw new FileSystemException(NLS.bind((String)Messages.UpdateMutator_68, (Object)toMovePath.toString(), (Object[])new Object[]{targetPath.toString()}));
                    }
                } else {
                    IRelativeLocation previousComponentPath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, itemMovedState, (IProgressMonitor)progress.newChild(1));
                    if (previousComponentPath != null) {
                        Shareable previousComponentShareable = new Shareable(cfa.getRoot(), previousComponentPath, ResourceType.getResourceType(itemMovedState));
                        this.deleteSubtree((IComponentHandle)component, previousComponentShareable, (IProgressMonitor)progress.newChild(1));
                        cfa.forget(previousComponentPath, (IProgressMonitor)progress.newChild(1));
                    }
                }
            }
            Shareable targetShareable = new Shareable(cfa.getRoot(), targetPath, ResourceType.getResourceType(itemMovedState));
            try {
                this.move(cfa, component, (IComponentHandle)previousComponent, toMoveShareable, targetShareable, destinationParent, newName, itemMovedState, true, new MetadataProperties(update.getMetadataProperties()), alsoModified, (IProgressMonitor)progress.newChild(75));
            }
            catch (FileSystemStatusException e) {
                this.collectStatus(e.getStatus());
                this.recordInconsistentShare((IComponentHandle)previousComponent, sourceShare);
                this.recordInconsistentShare((IComponentHandle)component, targetShare);
                continue;
            }
            catch (TeamRepositoryException e) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_54, (Object)toMovePath.toString(), (Object[])new Object[]{targetPath.toString(), e.getMessage()}), e));
                this.recordInconsistentShare((IComponentHandle)previousComponent, sourceShare);
                this.recordInconsistentShare((IComponentHandle)component, targetShare);
                continue;
            }
            if (!recordInconsistentForTarget) continue;
            this.recordInconsistentShare((IComponentHandle)component, targetShare);
        }
    }

    private void move(ICopyFileArea cfa, IComponent component, IComponentHandle previousComponent, Shareable toMoveShareable, final Shareable destinationShareable, IFolderHandle destinationParent, String newName, IVersionableHandle itemMovedState, boolean moveUpdate, MetadataProperties properties, boolean alsoModified, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean isShare = toMoveShareable.isShare((IProgressMonitor)progress.newChild(1));
        boolean isShareLoadedWithAlternativeName = false;
        if (isShare) {
            isShareLoadedWithAlternativeName = toMoveShareable.getShare((IProgressMonitor)progress.newChild(1)).isLoadedWithAnotherName((IProgressMonitor)progress.newChild(1));
        }
        final IFileStorage storage = toMoveShareable.getFileStorage();
        final IRelativeLocation targetPath = destinationShareable.getLocalPath();
        if (!this.skipUpdate(cfa.getRoot(), previousComponent, toMoveShareable.getRemote((IProgressMonitor)progress.newChild(1)))) {
            SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                @Override
                public void run() throws FileSystemException {
                    storage.move(destinationShareable.getSandbox(), targetPath, (IProgressMonitor)progress.newChild(75));
                }
            });
        }
        this.updateMetaDataAfterMove(cfa, component, previousComponent, toMoveShareable, destinationShareable, isShare, isShareLoadedWithAlternativeName, moveUpdate, properties, alsoModified, destinationParent, itemMovedState, newName, (IProgressMonitor)progress.newChild(20));
        this.itemMoved(toMoveShareable, destinationShareable, (IProgressMonitor)progress.newChild(1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleCollision(ICopyFileArea cfa, IComponent component, FileAreaUpdate update, Shareable originalShareable, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVersionableHandle remoteItem = originalShareable.getRemote((IProgressMonitor)progress.newChild(1));
        boolean shouldPreserve = false;
        Shareable shareable = this.getShareableForExistingStorage(originalShareable, update, (IProgressMonitor)progress.newChild(1));
        if (remoteItem != null) {
            boolean movedOrDeleted = this.updateInfo.isMovedOrDeleted((IComponentHandle)component, remoteItem);
            if (movedOrDeleted) {
                shouldPreserve = true;
            } else if (shareable.isShare((IProgressMonitor)progress.newChild(1))) {
                if (this.isPreserveLocalChanges()) {
                    shouldPreserve = true;
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_3, (Object)shareable.getLocalPath(), (Object[])new Object[0])));
                } else {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_17, (Object)shareable.getLocalPath(), (Object[])new Object[0])));
                }
            } else {
                if (!this.isPreserveLocalChanges()) return false;
                LocalChangeRecorder localChangeRecorder = this.getLocalChangeRecorder(cfa, (IComponentHandle)component);
                if (localChangeRecorder == null) {
                    return false;
                }
                ILocalChange localChange = localChangeRecorder.getLocalChange(remoteItem);
                if (localChange == null || !localChange.isType(8)) return false;
                IRelativeLocation preMovePath = localChange.getOriginalPath();
                Shareable preMoveShareable = new Shareable(cfa.getRoot(), preMovePath, originalShareable.getResourceType((IProgressMonitor)progress.newChild(1)));
                if (preMoveShareable.exists((IProgressMonitor)progress.newChild(1))) {
                    localChangeRecorder.preserveSubtree(remoteItem, originalShareable, (IProgressMonitor)progress.newChild(95));
                } else {
                    localChangeRecorder.rememberMove(update, localChange, originalShareable, (IProgressMonitor)progress.newChild(1));
                    IFileStorage fs = originalShareable.getFileStorage();
                    fs.move(new Sandbox(cfa), preMovePath, (IProgressMonitor)progress.newChild(94));
                }
            }
        } else if (this.isPreserveLocalChanges()) {
            ResourceType versionableType;
            ResourceType shareableType = originalShareable.getResourceType((IProgressMonitor)progress.newChild(1));
            boolean sameType = shareableType == (versionableType = ResourceType.getResourceType(update.item()));
            LocalChangeRecorder localChangeRecorder = this.getLocalChangeRecorder(cfa, (IComponentHandle)component);
            if (localChangeRecorder == null) {
                return false;
            }
            if (!sameType || shareableType != ResourceType.FOLDER) {
                if (sameType && shareableType == ResourceType.FILE) {
                    localChangeRecorder.rememberContent(update.afterState(), null, null, originalShareable, null, null, null, this.problemHandler.getBackupDilemmaHandler(), (IProgressMonitor)progress.newChild(1));
                    this.deleteSubtree((IComponentHandle)component, shareable, (IProgressMonitor)progress.newChild(97));
                } else if (sameType && shareableType == ResourceType.SYMBOLIC_LINK) {
                    LinkInfo oldTargetInfo = originalShareable.getFileStorage().getLinkInfo((IProgressMonitor)progress.newChild(1));
                    String localTarget = oldTargetInfo.getTarget();
                    boolean localIsDirectoryLink = false;
                    if (oldTargetInfo.getType() == LinkType.NONE) {
                        FileItemInfo existingInfo = shareable.getFileItemInfo((IProgressMonitor)progress.newChild(1));
                        if (existingInfo != null) {
                            localIsDirectoryLink = existingInfo.isDirectoryLink();
                        }
                    } else {
                        localIsDirectoryLink = oldTargetInfo.getType() == LinkType.DIRECTORY;
                    }
                    localChangeRecorder.rememberLinkChanges(originalShareable, update.afterState(), null, localTarget, localIsDirectoryLink, null);
                    this.deleteSubtree((IComponentHandle)component, shareable, (IProgressMonitor)progress.newChild(96));
                } else {
                    localChangeRecorder.preserveSubtree(null, originalShareable, (IProgressMonitor)progress.newChild(97));
                }
            }
        }
        if (shouldPreserve) {
            this.preserve(cfa, component, shareable, (IProgressMonitor)progress.newChild(98));
            return true;
        } else {
            if (this.isPreserveLocalChanges()) return true;
            this.deleteSubtree((IComponentHandle)component, shareable, (IProgressMonitor)progress.newChild(98));
        }
        return true;
    }

    private Shareable getShareableForExistingStorage(Shareable shareable, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (!shareable.getSandbox().isCaseSensitive() && !shareable.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1))) {
                IFileStorage child;
                ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(4));
                IFileStorage parentStorage = shareable.getFileStorage().getParent();
                Object realShareable = parentStorage != null ? ((child = parentStorage.getChild(shareable.getLocalPath().getName(), (IProgressMonitor)progress.newChild(95))) == null ? null : child.getShareable()) : this.getRealShareable(shareable, (IProgressMonitor)progress.newChild(95), type);
                if (realShareable == null) {
                    IFileStorage storage = SharingManager.getInstance().getLocalFileStorage(shareable.getSandbox(), shareable.getLocalPath(), type == null ? ResourceType.FILE : type);
                    realShareable = storage.getShareable();
                }
                shareable = realShareable;
            }
            return shareable;
        }
        catch (RuntimeException e) {
            throw new FileSystemException(NLS.bind((String)Messages.MergeLoadMutator_30, (Object)update.getName(), (Object[])new Object[0]), e);
        }
    }

    protected Shareable getRealShareable(Shareable shareable, IProgressMonitor monitor, ResourceType type) throws FileSystemException {
        File asFile = (File)shareable.getFullPath().getAdapter(File.class);
        if (asFile == null) {
            return null;
        }
        Shareable realShareable = null;
        File parent = asFile.getParentFile();
        if (parent != null) {
            String name = LocaleUtil.fileSystemNormalization((String)shareable.getLocalPath().getName());
            File[] children = parent.listFiles();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)children.length);
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.getName().length() == name.length() && LocaleUtil.fileSystemNormalization((String)child.getName()).equals(name)) {
                    PathLocation path = new PathLocation((IPath)new Path(child.getAbsolutePath()));
                    realShareable = (Shareable)SharingManager.getInstance().findShareable(path, type == null ? ResourceType.FILE : type);
                    if (realShareable == null || realShareable.getFileStorage().storageExists((IProgressMonitor)progress.newChild(1))) break;
                    realShareable = null;
                    break;
                }
                ++n2;
            }
        }
        return realShareable;
    }

    private void preserve(ICopyFileArea cfa, IComponent component, final Shareable shareable, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        String destination;
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean isShareRoot = shareable.isShare((IProgressMonitor)progress.newChild(1));
        boolean isLoadedWithAlternateName = false;
        if (isShareRoot) {
            isLoadedWithAlternateName = shareable.getShare((IProgressMonitor)progress.newChild(1)).isLoadedWithAnotherName((IProgressMonitor)progress.newChild(1));
        }
        ILocation path = shareable.getFullPath();
        ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
        ILocation parent = path.getParent();
        String name = path.getName();
        String extension = shareable.getLocalPath().getName();
        int posn = extension.lastIndexOf(".");
        if (posn < 0) {
            extension = "";
        } else {
            extension = extension.substring(posn);
            name = name.substring(0, name.length() - extension.length());
        }
        name = String.valueOf(name) + COLLISION_RENAME;
        int count = 0;
        ILocation destinationPath = null;
        do {
            destination = String.valueOf(name) + count + extension;
            ++count;
        } while (this.exists(destinationPath = parent.append(new RelativeLocation(destination)), (IProgressMonitor)progress.setWorkRemaining(96).newChild(1)));
        final IFileStorage storage = shareable.getFileStorage();
        final IRelativeLocation targetPath = shareable.getLocalPath().getParent().append(destination);
        SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

            @Override
            public void run() throws FileSystemException {
                storage.move(shareable.getSandbox(), targetPath, (IProgressMonitor)progress.newChild(70));
            }
        });
        Shareable targetShareable = new Shareable(shareable.getSandbox(), targetPath, type);
        this.updateMetaDataAfterMove(cfa, component, (IComponentHandle)component, shareable, targetShareable, isShareRoot, isLoadedWithAlternateName, false, null, false, null, null, null, (IProgressMonitor)progress.newChild(25));
        progress.done();
    }

    protected boolean exists(ILocation location, IProgressMonitor progress) throws FileSystemException {
        IFileInfo fileInfo;
        block3: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)1);
            IPath path = (IPath)location.getAdapter(IPath.class);
            IFileStore fileStorage = EFS.getLocalFileSystem().getStore(path);
            try {
                fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                if (!fileInfo.getAttribute(32)) break block3;
                return true;
            }
            catch (CoreException e) {
                throw new FileSystemException(NLS.bind((String)Messages.PathUtils_0, (Object)path.toString(), (Object[])new Object[0]), e);
            }
        }
        return fileInfo.exists();
    }

    protected final boolean isComponentShared(IComponentHandle component) throws FileSystemException {
        if (component.sameItemId((IItemHandle)this.lastComponentShareTested)) {
            return this.lastComponentSharedResult;
        }
        this.lastComponentShareTested = component;
        List<ICopyFileArea> cfas = this.copyFileAreasByComponent.get(component.getItemId());
        this.lastComponentSharedResult = cfas != null;
        return this.lastComponentSharedResult;
    }

    private void recordInconsistentShare(IComponentHandle component, IShare share) {
        if (share != null) {
            this.inconsistentShares.add(new ShareReference(component, share));
        }
    }

    private void recordInconsistentComponent(ICopyFileArea cfa, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        Collection<IShare> sharesNowInconsistent = cfa.allShares(this.connectionHandle, component, monitor);
        for (IShare share : sharesNowInconsistent) {
            this.recordInconsistentShare(component, share);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    protected final void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        block60: {
            ThreadCheck.checkLongOpsAllowed();
            this.updateInfo = new UpdateOrder(this.updates.getAdds(), this.updates.getDeletes(), this.updates.getMoves(), this.updates.getModifies(), this.rawUpdates);
            this.calculateShareParents(this.updateInfo);
            if (this.atLeastOneShareEnabledForKeywordExpansion()) {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
                monitor = progress;
                this.keywordExpansionContext = KeywordExpansionContext.createForUpdate(SCMPlatform.getWorkspaceManager((ITeamRepository)this.connection.teamRepository()), this.updates, (IProgressMonitor)progress.newChild(1));
            }
            if (this.isPreserveLocalChanges()) {
                block57: {
                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    components = this.getAffectedComponents();
                    localChangeManager = LocalChangeManager.getInstance();
                    this.localChangeRecorders = NewCollection.hashMap();
                    try {
                        subProgress = progress.newChild(5);
                        subProgress.setWorkRemaining(components.size());
                        for (IComponentHandle component : components) {
                            cfas = this.copyFileAreasByComponent.get(component.getItemId());
                            if (cfas != null) {
                                subSubProgress = subProgress.newChild(1);
                                subSubProgress.setWorkRemaining(cfas.size() * 2);
                                for (ICopyFileArea cfa : cfas) {
                                    sandbox = new Sandbox(cfa);
                                    conflictTracker = LocalConflictManager.getInstance().getTracker(this.connectionHandle, component, cfa.getRoot(), (IProgressMonitor)subSubProgress.newChild(1));
                                    if (conflictTracker != null) {
                                        LocalConflictManager.getInstance().beginUpdateOperation(this.connectionHandle, component, cfa.getRoot(), (IProgressMonitor)subSubProgress.newChild(1));
                                        localChangeRecorder = new LocalChangeRecorder(sandbox, conflictTracker, localChangeManager.getPendingChanges(this.connection.getContextHandle(), component, sandbox));
                                        localChangeRecorder.setFileContentMerger(this.getFileContentMerger());
                                        recorderPerComponent = this.localChangeRecorders.get(cfa);
                                        if (recorderPerComponent == null) {
                                            recorderPerComponent = NewCollection.hashMap();
                                            this.localChangeRecorders.put(cfa, recorderPerComponent);
                                        }
                                        recorderPerComponent.put(component.getItemId(), localChangeRecorder);
                                        continue;
                                    }
                                    subSubProgress.worked(1);
                                }
                                continue;
                            }
                            subProgress.worked(1);
                        }
                        this.internalExecuteWithFallBack((IProgressMonitor)progress.newChild(90));
                        break block57;
                    }
                    catch (Throwable var16_16) {
                        try {
                            totalNumberOfChangeRecorders = 0;
                            for (Map<UUID, LocalChangeRecorder> localChangeRecorderList : this.localChangeRecorders.values()) {
                                totalNumberOfChangeRecorders += localChangeRecorderList.size();
                            }
                            subProgress = progress.newChild(5);
                            subProgress.setWorkRemaining(totalNumberOfChangeRecorders * 2);
                            for (Map.Entry<ICopyFileArea, Map<UUID, LocalChangeRecorder>> entry : this.localChangeRecorders.entrySet()) {
                                for (LocalChangeRecorder localChangeRecorder : entry.getValue().values()) {
                                    try {
                                        if (localChangeRecorder != null && !localChangeRecorder.isLocalChangesReplayed()) {
                                            unsetWorkspaceComponentState = false;
                                            errorsBeforeSandboxChanges = this.getErrors().length;
                                            try {
                                                try {
                                                    status = localChangeRecorder.replayLocalChanges(this.shed, (IProgressMonitor)subProgress.newChild(1));
                                                    if (!status.isOK()) {
                                                        this.collectStatus(status);
                                                    }
                                                }
                                                catch (Throwable e) {
                                                    unsetWorkspaceComponentState = true;
                                                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Unable to replay local changes on reload", e));
                                                    if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                                                        if (this.isTraceLoggingEnabled()) {
                                                            this.logTraceInfo(NLS.bind((String)"UpdateMutator#execute: There were errors while replaying local changes during update operation. Set the workspace component state of the component with item id: \"{0}\" at sandbox location: \"{1}\", to UNKNOWN, in the metadata.", (Object)localChangeRecorder.getComponent().getItemId(), (Object[])new Object[]{entry.getKey().getRoot()}));
                                                        }
                                                        this.updateWorkspaceComponentStateToUnknown(Collections.singletonList(entry.getKey()), Collections.singletonList(localChangeRecorder.getComponent().getItemId()), (IProgressMonitor)subProgress.newChild(1));
                                                        continue;
                                                    }
                                                    subProgress.worked(1);
                                                    continue;
                                                }
                                            }
                                            catch (Throwable var26_37) {
                                                if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                                                    if (this.isTraceLoggingEnabled()) {
                                                        this.logTraceInfo(NLS.bind((String)"UpdateMutator#execute: There were errors while replaying local changes during update operation. Set the workspace component state of the component with item id: \"{0}\" at sandbox location: \"{1}\", to UNKNOWN, in the metadata.", (Object)localChangeRecorder.getComponent().getItemId(), (Object[])new Object[]{entry.getKey().getRoot()}));
                                                    }
                                                    this.updateWorkspaceComponentStateToUnknown(Collections.singletonList(entry.getKey()), Collections.singletonList(localChangeRecorder.getComponent().getItemId()), (IProgressMonitor)subProgress.newChild(1));
                                                } else {
                                                    subProgress.worked(1);
                                                }
                                                throw var26_37;
                                            }
                                            if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                                                if (this.isTraceLoggingEnabled()) {
                                                    this.logTraceInfo(NLS.bind((String)"UpdateMutator#execute: There were errors while replaying local changes during update operation. Set the workspace component state of the component with item id: \"{0}\" at sandbox location: \"{1}\", to UNKNOWN, in the metadata.", (Object)localChangeRecorder.getComponent().getItemId(), (Object[])new Object[]{entry.getKey().getRoot()}));
                                                }
                                                this.updateWorkspaceComponentStateToUnknown(Collections.singletonList(entry.getKey()), Collections.singletonList(localChangeRecorder.getComponent().getItemId()), (IProgressMonitor)subProgress.newChild(1));
                                                continue;
                                            }
                                            subProgress.worked(1);
                                            continue;
                                        }
                                        subProgress.worked(2);
                                    }
                                    finally {
                                        LocalConflictManager.getInstance().endUpdateOperation(this.connectionHandle, localChangeRecorder.getComponent(), entry.getKey().getRoot());
                                    }
                                }
                            }
                        }
                        finally {
                            ** for (component : components)
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        cfas = this.copyFileAreasByComponent.get(component.getItemId());
                        if (cfas == null) continue;
                        for (ICopyFileArea cfa : cfas) {
                            LocalConflictManager.getInstance().endUpdateOperation(this.connectionHandle, component, cfa.getRoot());
                        }
                        continue;
                    }
lbl107:
                    // 1 sources

                    throw var16_16;
                }
                try {
                    totalNumberOfChangeRecorders = 0;
                    for (Map<UUID, LocalChangeRecorder> localChangeRecorderList : this.localChangeRecorders.values()) {
                        totalNumberOfChangeRecorders += localChangeRecorderList.size();
                    }
                    subProgress = progress.newChild(5);
                    subProgress.setWorkRemaining(totalNumberOfChangeRecorders * 2);
                    for (Object entry : this.localChangeRecorders.entrySet()) {
                        for (LocalChangeRecorder localChangeRecorder : ((Map)entry.getValue()).values()) {
                            try {
                                if (localChangeRecorder != null && !localChangeRecorder.isLocalChangesReplayed()) {
                                    unsetWorkspaceComponentState = false;
                                    errorsBeforeSandboxChanges = this.getErrors().length;
                                    try {
                                        try {
                                            status = localChangeRecorder.replayLocalChanges(this.shed, (IProgressMonitor)subProgress.newChild(1));
                                            if (!status.isOK()) {
                                                this.collectStatus(status);
                                            }
                                        }
                                        catch (Throwable e) {
                                            unsetWorkspaceComponentState = true;
                                            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Unable to replay local changes on reload", e));
                                            if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                                                if (this.isTraceLoggingEnabled()) {
                                                    this.logTraceInfo(NLS.bind((String)"UpdateMutator#execute: There were errors while replaying local changes during update operation. Set the workspace component state of the component with item id: \"{0}\" at sandbox location: \"{1}\", to UNKNOWN, in the metadata.", (Object)localChangeRecorder.getComponent().getItemId(), (Object[])new Object[]{((ICopyFileArea)entry.getKey()).getRoot()}));
                                                }
                                                this.updateWorkspaceComponentStateToUnknown(Collections.singletonList((ICopyFileArea)entry.getKey()), Collections.singletonList(localChangeRecorder.getComponent().getItemId()), (IProgressMonitor)subProgress.newChild(1));
                                                continue;
                                            }
                                            subProgress.worked(1);
                                            continue;
                                        }
                                    }
                                    catch (Throwable var26_38) {
                                        if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                                            if (this.isTraceLoggingEnabled()) {
                                                this.logTraceInfo(NLS.bind((String)"UpdateMutator#execute: There were errors while replaying local changes during update operation. Set the workspace component state of the component with item id: \"{0}\" at sandbox location: \"{1}\", to UNKNOWN, in the metadata.", (Object)localChangeRecorder.getComponent().getItemId(), (Object[])new Object[]{((ICopyFileArea)entry.getKey()).getRoot()}));
                                            }
                                            this.updateWorkspaceComponentStateToUnknown(Collections.singletonList((ICopyFileArea)entry.getKey()), Collections.singletonList(localChangeRecorder.getComponent().getItemId()), (IProgressMonitor)subProgress.newChild(1));
                                        } else {
                                            subProgress.worked(1);
                                        }
                                        throw var26_38;
                                    }
                                    if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                                        if (this.isTraceLoggingEnabled()) {
                                            this.logTraceInfo(NLS.bind((String)"UpdateMutator#execute: There were errors while replaying local changes during update operation. Set the workspace component state of the component with item id: \"{0}\" at sandbox location: \"{1}\", to UNKNOWN, in the metadata.", (Object)localChangeRecorder.getComponent().getItemId(), (Object[])new Object[]{((ICopyFileArea)entry.getKey()).getRoot()}));
                                        }
                                        this.updateWorkspaceComponentStateToUnknown(Collections.singletonList((ICopyFileArea)entry.getKey()), Collections.singletonList(localChangeRecorder.getComponent().getItemId()), (IProgressMonitor)subProgress.newChild(1));
                                        continue;
                                    }
                                    subProgress.worked(1);
                                    continue;
                                }
                                subProgress.worked(2);
                            }
                            finally {
                                LocalConflictManager.getInstance().endUpdateOperation(this.connectionHandle, localChangeRecorder.getComponent(), ((ICopyFileArea)entry.getKey()).getRoot());
                            }
                        }
                    }
                }
                finally {
                    ** for (component : components)
                }
lbl-1000:
                // 1 sources

                {
                    cfas = this.copyFileAreasByComponent.get(component.getItemId());
                    if (cfas == null) continue;
                    for (ICopyFileArea cfa : cfas) {
                        LocalConflictManager.getInstance().endUpdateOperation(this.connectionHandle, component, cfa.getRoot());
                    }
                    continue;
lbl170:
                    // 1 sources

                    break block60;
                }
            }
            this.internalExecuteWithFallBack(monitor);
        }
    }

    private boolean atLeastOneShareEnabledForKeywordExpansion() {
        return this.sharesWithExpandedKeywords != null && !this.sharesWithExpandedKeywords.isEmpty();
    }

    private List<IComponentHandle> getAffectedComponents() {
        ArrayList components = NewCollection.arrayList();
        for (IComponentStateSummary css : this.componentStatesAfter.values()) {
            components.add(css.getComponent());
        }
        return components;
    }

    public boolean isPreserveLocalChanges() {
        return this.problemHandler.isPreserveLocalChanges();
    }

    private void internalExecuteWithFallBack(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean unsetWorkspaceComponentState = false;
        int errorsBeforeSandboxChanges = this.getErrors().length;
        try {
            try {
                this.internalExecute((IProgressMonitor)progress.newChild(95));
            }
            catch (Exception e) {
                unsetWorkspaceComponentState = true;
                throw e;
            }
        }
        finally {
            if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                if (this.isTraceLoggingEnabled()) {
                    this.logTraceInfo("UpdateMutator#internalExecuteWithFallBack: There were errors while performing update operation. Set the workspace component state of all the components being updated to UNKNOWN, in the metadata.");
                }
                this.updateWorkspaceComponentStateToUnknown(this.copyFileAreasToUpdate, this.componentStatesAfter.keySet(), (IProgressMonitor)progress.newChild(5));
            } else {
                progress.worked(5);
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void internalExecute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        block52: {
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)105);
            shouldAddNewSiblings = this.addNewSiblingsDirection(this.updateInfo);
            maxContentToDownLoad = this.updateInfo.getFileMoves().size() + this.updateInfo.getFileAdds().size() + this.updateInfo.getGroupedModifies().size();
            deferredDownloadInfo = NewCollection.arrayList((int)maxContentToDownLoad);
            linksToRefresh = NewCollection.hashSet();
            linksToRecompute = NewCollection.hashSet();
            this.contentSession = FileSystemCore.getContentManager(this.repository).createSession(NLS.bind((String)Messages.UpdateMutator_19, (Object)this.connection.getName(), (Object[])new Object[0]), true, maxContentToDownLoad, (IProgressMonitor)subMonitor.newChild(80));
            progress = new CancellationMonitor((IProgressMonitor)subMonitor);
            isCancelled = false;
            try {
                this.startingUpdates(this.updateInfo, (IProgressMonitor)progress);
                for (FileAreaUpdate update : this.updateInfo.getFolderAdds()) {
                    component = this.getFullComponent(update, (IProgressMonitor)progress);
                    this.createFolder((IComponent)component, update, shouldAddNewSiblings, (IProgressMonitor)progress);
                    this.checkCancelled((IProgressMonitor)progress);
                }
                for (FileAreaUpdate update : this.updateInfo.getFolderMoves()) {
                    component = this.getFullComponent(update, (IProgressMonitor)progress);
                    this.moveSubtree((IComponent)component, update, (IProgressMonitor)progress);
                    this.updateInfo.processed(update);
                    this.checkCancelled((IProgressMonitor)progress);
                }
                this.folderAddsAndMovesCompleted((IProgressMonitor)progress);
                for (FileAreaUpdate update : this.updateInfo.getLinkMoves()) {
                    component = this.getFullComponent(update, (IProgressMonitor)progress);
                    this.moveSubtree((IComponent)component, update, (IProgressMonitor)progress);
                    this.updateInfo.processed(update);
                    if (update.isChangeType(4)) {
                        this.modifyLink((IComponent)component, update, linksToRefresh, linksToRecompute, (IProgressMonitor)progress);
                    }
                    this.checkCancelled((IProgressMonitor)progress);
                }
                for (FileAreaUpdate update : this.updateInfo.getFileMoves()) {
                    component = this.getFullComponent(update, (IProgressMonitor)progress);
                    this.moveSubtree((IComponent)component, update, (IProgressMonitor)progress);
                    this.updateInfo.processed(update);
                    if (update.isChangeType(4)) {
                        this.modifyFile((IComponent)component, update, deferredDownloadInfo, update.getFileTimestamp(), (IProgressMonitor)progress);
                    } else {
                        this.contentSession.decrementTransferCount(1L);
                    }
                    this.checkCancelled((IProgressMonitor)progress);
                }
                for (FileAreaUpdate update : this.updateInfo.getOrderedDeletes()) {
                    component = this.getFullComponent(update, (IProgressMonitor)progress);
                    this.deleteSubtree((IComponent)component, update.getSourceParent(), update.getName(), update.beforeState(), (IProgressMonitor)progress);
                    this.updateInfo.processed(update);
                    this.checkCancelled((IProgressMonitor)progress);
                }
                inaccessibleUpdates = (List)this.updateInfo.getInaccessibleUpdates();
                if (!inaccessibleUpdates.isEmpty()) {
                    this.cleanupInaccessible(inaccessibleUpdates, (IProgressMonitor)progress);
                }
                for (FileAreaUpdate update : this.updateInfo.getGroupedModifies()) {
                    if (update.getItem() instanceof IFileItemHandle) {
                        component = this.getFullComponent(update, (IProgressMonitor)progress);
                        this.modifyFile(component, update, deferredDownloadInfo, update.getFileTimestamp(), (IProgressMonitor)progress);
                    } else if (update.getItem() instanceof ISymbolicLinkHandle) {
                        component = this.getFullComponent(update, (IProgressMonitor)progress);
                        this.modifyLink(component, update, linksToRefresh, linksToRecompute, (IProgressMonitor)progress);
                        this.contentSession.decrementTransferCount(1L);
                    } else if (update.getItem() instanceof IFolderHandle) {
                        component = this.getFullComponent(update, (IProgressMonitor)progress);
                        this.modifyFolder(component, update, (IProgressMonitor)progress);
                        this.contentSession.decrementTransferCount(1L);
                    }
                    this.checkCancelled((IProgressMonitor)progress);
                }
                for (FileAreaUpdate update : this.updateInfo.getLinkAdds()) {
                    component = this.getFullComponent(update, (IProgressMonitor)progress);
                    this.createLink(component, update, linksToRefresh, linksToRecompute, shouldAddNewSiblings, (IProgressMonitor)progress);
                    this.checkCancelled((IProgressMonitor)progress);
                }
                for (FileAreaUpdate update : this.updateInfo.getFileAdds()) {
                    component = this.getFullComponent(update, (IProgressMonitor)progress);
                    this.createFile(component, update, deferredDownloadInfo, shouldAddNewSiblings, (IProgressMonitor)progress);
                    this.checkCancelled((IProgressMonitor)progress);
                }
                if (!this.missingSource.isEmpty()) {
                    for (Map.Entry entry : this.missingSource.entrySet()) {
                        cfa = (ICopyFileArea)entry.getKey();
                        for (FileAreaUpdate update : (List)entry.getValue()) {
                            component = this.getFullComponent(update, (IProgressMonitor)progress);
                            this.checkCancelled((IProgressMonitor)progress);
                            this.loadMissingSubtree(cfa, component, update, deferredDownloadInfo, linksToRefresh, linksToRecompute, (IProgressMonitor)progress);
                        }
                    }
                }
                this.verifyUpdatesOutsideShares((IProgressMonitor)progress);
                break block52;
            }
            catch (Throwable var17_17) {
                this.contentSession.join();
                isCancelled = isCancelled != false || progress.isCanceled() != false || this.contentSession.isCanceled() != false || this.isUpdateCancelled(deferredDownloadInfo) != false;
                try {
                    if (!isCancelled) {
                        this.doDilemmaHandling(deferredDownloadInfo, (IProgressMonitor)subMonitor.newChild(10));
                        isCancelled = isCancelled != false || this.isUpdateCancelled(deferredDownloadInfo) != false;
                    }
                }
                finally {
                    nonCancellableMonitor = new NonCancellingProgressMonitor((IProgressMonitor)subMonitor.newChild(5));
                    metaDataMonitor = SubMonitor.convert((IProgressMonitor)nonCancellableMonitor, (int)(deferredDownloadInfo.size() * 5 + linksToRefresh.size()));
                    downloadInfo = deferredDownloadInfo.iterator();
                    if (true) ** GOTO lbl107
                }
                {
                }
            }
            do {
                if (!(downloadInfo = (DeferredDownloadInformation)downloadInfo.next()).contentUpdated()) continue;
                this.refresh(downloadInfo, (IProgressMonitor)metaDataMonitor.newChild(1));
lbl107:
                // 3 sources

            } while (downloadInfo.hasNext());
            if (!linksToRefresh.isEmpty() || !linksToRecompute.isEmpty()) {
                this.refreshLinks(linksToRefresh, linksToRecompute, (IProgressMonitor)metaDataMonitor.newChild(linksToRefresh.size()));
            }
            for (DeferredDownloadInformation downloadInfo : deferredDownloadInfo) {
                if (!downloadInfo.contentUpdated()) continue;
                skipUpdate = this.skipUpdate(downloadInfo.getCopyFileArea().getRoot(), downloadInfo.getComponent(), downloadInfo.getShareable().getRemote((IProgressMonitor)metaDataMonitor.newChild(1)));
                try {
                    if (this.isTraceLoggingEnabled()) {
                        extraInfo = "stateid: " + downloadInfo.getFileItemState().getStateId().getUuidValue() + " skipUpdate: " + skipUpdate;
                        this.logTraceInfo(NLS.bind((String)"Updating metadata for file {0}: {1}", (Object)downloadInfo.getShareable().getFullPath(), (Object[])new Object[]{extraInfo}));
                    }
                    this.updateMetaData(downloadInfo, skipUpdate, (IProgressMonitor)metaDataMonitor.newChild(1));
                    if (skipUpdate) continue;
                    downloadInfo.getShareable().getFileStorage().setExecutable(downloadInfo.isExecutable(), (IProgressMonitor)metaDataMonitor.newChild(1));
                }
                catch (FileSystemException e) {
                    this.recordInconsistentShare(downloadInfo.getComponent(), downloadInfo.getShareable().getShare((IProgressMonitor)metaDataMonitor.newChild(1)));
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)e));
                }
            }
            metaDataMonitor.done();
            iterProgress = subMonitor.newChild(5);
            iterProgress.setWorkRemaining(deferredDownloadInfo.size());
            for (Object downloadInfo : deferredDownloadInfo) {
                if (!downloadInfo.contentUpdated()) continue;
                this.fileLoaded(downloadInfo.getShareable(), (IProgressMonitor)iterProgress.newChild(1));
            }
            iterProgress.done();
            this.refreshFileAttributes(this.updates, (IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)subMonitor.newChild(25)));
            this.updatesComplete((IProgressMonitor)subMonitor.newChild(5));
            throw var17_17;
        }
        this.contentSession.join();
        isCancelled = isCancelled != false || progress.isCanceled() != false || this.contentSession.isCanceled() != false || this.isUpdateCancelled(deferredDownloadInfo) != false;
        try {
            if (!isCancelled) {
                this.doDilemmaHandling(deferredDownloadInfo, (IProgressMonitor)subMonitor.newChild(10));
                isCancelled = isCancelled != false || this.isUpdateCancelled(deferredDownloadInfo) != false;
            }
        }
        finally {
            nonCancellableMonitor = new NonCancellingProgressMonitor((IProgressMonitor)subMonitor.newChild(5));
            metaDataMonitor = SubMonitor.convert((IProgressMonitor)nonCancellableMonitor, (int)(deferredDownloadInfo.size() * 5 + linksToRefresh.size()));
            downloadInfo = deferredDownloadInfo.iterator();
            if (true) ** GOTO lbl157
        }
        {
        }
        do {
            if (!(downloadInfo = (DeferredDownloadInformation)downloadInfo.next()).contentUpdated()) continue;
            this.refresh(downloadInfo, (IProgressMonitor)metaDataMonitor.newChild(1));
lbl157:
            // 3 sources

        } while (downloadInfo.hasNext());
        if (!linksToRefresh.isEmpty() || !linksToRecompute.isEmpty()) {
            this.refreshLinks(linksToRefresh, linksToRecompute, (IProgressMonitor)metaDataMonitor.newChild(linksToRefresh.size()));
        }
        for (DeferredDownloadInformation downloadInfo : deferredDownloadInfo) {
            if (!downloadInfo.contentUpdated()) continue;
            skipUpdate = this.skipUpdate(downloadInfo.getCopyFileArea().getRoot(), downloadInfo.getComponent(), downloadInfo.getShareable().getRemote((IProgressMonitor)metaDataMonitor.newChild(1)));
            try {
                if (this.isTraceLoggingEnabled()) {
                    extraInfo = "stateid: " + downloadInfo.getFileItemState().getStateId().getUuidValue() + " skipUpdate: " + skipUpdate;
                    this.logTraceInfo(NLS.bind((String)"Updating metadata for file {0}: {1}", (Object)downloadInfo.getShareable().getFullPath(), (Object[])new Object[]{extraInfo}));
                }
                this.updateMetaData(downloadInfo, skipUpdate, (IProgressMonitor)metaDataMonitor.newChild(1));
                if (skipUpdate) continue;
                downloadInfo.getShareable().getFileStorage().setExecutable(downloadInfo.isExecutable(), (IProgressMonitor)metaDataMonitor.newChild(1));
            }
            catch (FileSystemException e) {
                this.recordInconsistentShare(downloadInfo.getComponent(), downloadInfo.getShareable().getShare((IProgressMonitor)metaDataMonitor.newChild(1)));
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)e));
            }
        }
        metaDataMonitor.done();
        iterProgress = subMonitor.newChild(5);
        iterProgress.setWorkRemaining(deferredDownloadInfo.size());
        for (Object downloadInfo : deferredDownloadInfo) {
            if (!downloadInfo.contentUpdated()) continue;
            this.fileLoaded(downloadInfo.getShareable(), (IProgressMonitor)iterProgress.newChild(1));
        }
        iterProgress.done();
        this.refreshFileAttributes(this.updates, (IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)subMonitor.newChild(25)));
        this.updatesComplete((IProgressMonitor)subMonitor.newChild(5));
        this.reportDownloadFailures(deferredDownloadInfo, (IProgressMonitor)subMonitor.newChild(5));
        if (isCancelled || subMonitor.isCanceled()) {
            failures = this.getErrors();
            if (failures.length > 0 && (multi = new MultiStatus("com.ibm.team.filesystem.client", 0, failures, Messages.UpdateMutator_20, null)).matches(4)) {
                throw new FileSystemStatusException((IStatus)multi);
            }
            throw new OperationCanceledException();
        }
        this.updateConfigStatesAndWCState((IProgressMonitor)subMonitor.newChild(5));
        failures = this.getErrors();
        if (failures.length > 0 && (multi = new MultiStatus("com.ibm.team.filesystem.client", 0, failures, Messages.UpdateMutator_20, null)).matches(4)) {
            e = failures[0].getException();
            if (e instanceof EclipseReadException) {
                throw (EclipseReadException)e;
            }
            throw new FileSystemStatusException((IStatus)multi);
        }
        this.handleDeletedContent(deferredDownloadInfo, (IProgressMonitor)subMonitor.newChild(5));
        this.updateCompleted((IProgressMonitor)subMonitor.newChild(5));
    }

    private void loadMissingSubtree(ICopyFileArea cfa, IComponent component, FileAreaUpdate rootUpdate, List<DeferredDownloadInformation> deferredDownloadInfo, Set<Shareable> linksToRefresh, Set<Shareable> linksToRecompute, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        LoadTree fetchSubtree = this.fetchSubtree(component, rootUpdate.item(), (IProgressMonitor)progress.newChild(1));
        for (FileAreaUpdate update : fetchSubtree.getFileAreaUpdates()) {
            if (update.item().getItemType().equals(IFolder.ITEM_TYPE)) {
                this.createFolder(cfa, component, update, false, monitor);
                continue;
            }
            if (update.item().getItemType().equals(IFileItem.ITEM_TYPE)) {
                this.createFile(cfa, component, update, deferredDownloadInfo, false, (IProgressMonitor)progress);
                continue;
            }
            if (update.item().getItemType().equals(ISymbolicLink.ITEM_TYPE)) {
                this.createLink(cfa, component, update, linksToRefresh, linksToRecompute, false, (IProgressMonitor)progress);
                continue;
            }
            throw new IllegalArgumentException(update.item().getItemType().toString());
        }
    }

    private LoadTree fetchSubtree(IComponent component, IVersionableHandle versionable, IProgressMonitor monitor) throws TeamRepositoryException {
        IFileSystemManager fsm = (IFileSystemManager)this.connection.teamRepository().getClientLibrary(IFileSystemManager.class);
        FileSystemServiceProxy fss = ((FileSystemManager)fsm).getFileSystemService();
        IVersionableHandle[] versionableHandles = new IVersionableHandle[]{versionable};
        return fss.getFileTreeByVersionable(this.connection, (IComponentHandle)component, versionableHandles, -1, true, null, monitor);
    }

    private boolean addNewSiblingsDirection(UpdateOrder orderer) throws FileSystemException {
        ArrayList newSiblings = NewCollection.arrayList();
        this.findNewSiblings(orderer.getFileAdds(), newSiblings);
        this.findNewSiblings(orderer.getFolderAdds(), newSiblings);
        this.findNewSiblings(orderer.getLinkAdds(), newSiblings);
        if (this.containsOnlySubcomponentInfoFiles(newSiblings)) {
            return false;
        }
        if (!newSiblings.isEmpty()) {
            int direction = this.problemHandler.siblingSharesToAdd(newSiblings);
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            if (direction == 3) {
                return false;
            }
            if (direction == 0) {
                return true;
            }
            throw new FileSystemException(NLS.bind((String)Messages.UpdateMutator_63, (Object)newSiblings.size(), (Object[])new Object[0]));
        }
        return true;
    }

    private boolean containsOnlySubcomponentInfoFiles(Collection<IShareable> shareables) {
        if (shareables == null || shareables.isEmpty()) {
            return false;
        }
        for (IShareable shareable : shareables) {
            if (shareable == null || ".subcomponent_info".equals(shareable.getLocalPath().getName())) continue;
            return false;
        }
        return true;
    }

    private void findNewSiblings(List<FileAreaUpdate> adds, List<IShareable> newSiblings) {
        for (FileAreaUpdate update : adds) {
            List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(update.getComponent().getItemId());
            if (copyFileAreas == null) continue;
            for (ICopyFileArea cfa : copyFileAreas) {
                IFolderHandle parent = update.getDestinationParent();
                IRelativeLocation sharePoint = this.getSharePoint(cfa, update.component(), parent);
                if (sharePoint == null) continue;
                newSiblings.add(new Shareable(cfa.getRoot(), sharePoint.append(update.getName()), ResourceType.FILE));
            }
        }
    }

    private void calculateShareParents(UpdateOrder orderer) throws TeamRepositoryException {
        this.shareParents = NewCollection.hashMap();
        for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
            HashMap shareParentsByCFA = NewCollection.hashMap();
            this.shareParents.put(cfa, shareParentsByCFA);
            Collection<IShare> allShares = cfa.allShares();
            for (IShare share : allShares) {
                Map<IRelativeLocation, IShare> sharesInCFAWithExpandedKeywords;
                InverseFileItemInfo info;
                IFolderHandle parent;
                UUID parentUUID;
                Set shareParentsRelativePaths;
                Map shareParentsByComponent;
                if (!share.getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)this.connectionHandle)) continue;
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                IComponentHandle component = orderer.isMovedCrossComponent(descriptor.getComponent(), descriptor.getRootVersionable());
                if (component == null) {
                    component = descriptor.getComponent();
                }
                if ((shareParentsByComponent = (Map)shareParentsByCFA.get(component.getItemId())) == null) {
                    shareParentsByComponent = NewCollection.hashMap();
                    shareParentsByCFA.put(component.getItemId(), shareParentsByComponent);
                }
                if ((shareParentsRelativePaths = (Set)shareParentsByComponent.get(parentUUID = (parent = (info = cfa.getItemInfo(descriptor.getRootVersionable(), descriptor.getComponent(), descriptor.getConnectionHandle(), true)).getParent()) == null ? null : parent.getItemId())) == null) {
                    shareParentsRelativePaths = NewCollection.hashSet((int)3);
                    shareParentsByComponent.put(parentUUID, shareParentsRelativePaths);
                }
                shareParentsRelativePaths.add(share.getPath().getParent());
                ArrayList cfas = this.copyFileAreasByComponent.get(descriptor.getComponent().getItemId());
                if (cfas == null) {
                    cfas = NewCollection.arrayList((int)2);
                    this.copyFileAreasByComponent.put(descriptor.getComponent().getItemId(), cfas);
                }
                if (!cfas.contains(cfa)) {
                    cfas.add(cfa);
                }
                if (!KeywordExpansionContext.isShareLoadedWithKeywordExpansionEnabled(share)) continue;
                if (this.sharesWithExpandedKeywords == null) {
                    this.sharesWithExpandedKeywords = new HashMap<ICopyFileArea, Map<IRelativeLocation, IShare>>();
                }
                if ((sharesInCFAWithExpandedKeywords = this.sharesWithExpandedKeywords.get(cfa)) == null) {
                    sharesInCFAWithExpandedKeywords = new HashMap<IRelativeLocation, IShare>();
                    this.sharesWithExpandedKeywords.put(cfa, sharesInCFAWithExpandedKeywords);
                }
                sharesInCFAWithExpandedKeywords.put(share.getPath(), share);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void cleanupInaccessible(List<FileAreaUpdate> inaccessible, IProgressMonitor monitor) throws TeamRepositoryException {
        block15: {
            SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * inaccessible.size()));
            HashMap shareablesToDelete = NewCollection.hashMap();
            for (FileAreaUpdate inaccessibleUpdates : inaccessible) {
                void var7_11;
                if (!inaccessibleUpdates.isChangeType(8)) {
                    IComponentHandle iComponentHandle = inaccessibleUpdates.getComponent();
                } else {
                    IComponentHandle iComponentHandle = inaccessibleUpdates.getPreviousComponent();
                }
                if (!this.isComponentShared((IComponentHandle)var7_11)) continue;
                IVersionableHandle item = inaccessibleUpdates.getItem();
                List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(var7_11.getItemId());
                SubMonitor subMonitor = totalProgress.newChild(1);
                subMonitor.setWorkRemaining(copyFileAreas.size());
                for (ICopyFileArea cfa : copyFileAreas) {
                    Shareable toDeleteShareable;
                    void var7_8;
                    SubMonitor progress = subMonitor.newChild(1);
                    progress.setWorkRemaining(100);
                    progress.subTask(Messages.UpdateMutator_60);
                    IRelativeLocation toDeletePath = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)var7_8, item, (IProgressMonitor)progress.newChild(1));
                    if (toDeletePath == null) {
                        if (inaccessibleUpdates.isChangeType(8) && !var7_8.sameItemId((IItemHandle)inaccessibleUpdates.getComponent())) {
                            IComponentHandle iComponentHandle = inaccessibleUpdates.getComponent();
                            toDeletePath = cfa.getLocalPathFor(this.connectionHandle, iComponentHandle, item, (IProgressMonitor)progress.newChild(1));
                        }
                        if (toDeletePath == null) {
                            cfa.forget(this.connectionHandle, (IComponentHandle)var7_8, item, null);
                            continue;
                        }
                    }
                    if (!(toDeleteShareable = new Shareable(cfa.getRoot(), toDeletePath, ResourceType.getResourceType(item))).exists((IProgressMonitor)progress.newChild(1))) {
                        if (toDeleteShareable.isShare((IProgressMonitor)progress.newChild(1))) {
                            toDeleteShareable.unshare((IProgressMonitor)progress.newChild(96));
                            continue;
                        }
                        toDeleteShareable.forget((IProgressMonitor)progress.newChild(96));
                        continue;
                    }
                    if (inaccessibleUpdates.isChangeType(2)) {
                        this.deleteSubtree((IComponentHandle)var7_8, toDeleteShareable, (IProgressMonitor)progress.newChild(96));
                        continue;
                    }
                    shareablesToDelete.put(toDeleteShareable, var7_8);
                }
            }
            if (shareablesToDelete.isEmpty()) break block15;
            totalProgress.setWorkRemaining(shareablesToDelete.size());
            List inaccessibleShareables = NewCollection.arrayList(shareablesToDelete.keySet());
            int direction = this.problemHandler.inaccessibleForUpdate(inaccessibleShareables);
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            if (direction == 0) {
                for (Map.Entry entry : shareablesToDelete.entrySet()) {
                    this.deleteSubtree((IComponentHandle)entry.getValue(), (Shareable)entry.getKey(), (IProgressMonitor)totalProgress.newChild(1));
                }
            } else {
                MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.UpdateMutator_61, null);
                for (Map.Entry entry : shareablesToDelete.entrySet()) {
                    this.recordInconsistentShare((IComponentHandle)entry.getValue(), ((Shareable)entry.getKey()).getShare((IProgressMonitor)totalProgress.newChild(1)));
                    multiStatus.add(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_62, (Object)((Shareable)entry.getKey()).getLocalPath().toString(), (Object[])new Object[0])));
                }
            }
        }
    }

    private void handleDeletedContent(List<DeferredDownloadInformation> deferredDownloadInfo, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)deferredDownloadInfo.size());
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        ArrayList contentDeleted = NewCollection.arrayList();
        for (DeferredDownloadInformation deferredUpdateInformation : deferredDownloadInfo) {
            if (deferredUpdateInformation == null || !deferredUpdateInformation.contentDeleted()) continue;
            Shareable shareable = deferredUpdateInformation.getShareable();
            contentDeleted.add(shareable);
            try {
                lcm.computeChanges(shareable, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        if (!contentDeleted.isEmpty()) {
            int response = this.problemHandler.deletedContent(contentDeleted);
            if (response == 1) {
                throw new OperationCanceledException();
            }
            if (response != 0) {
                for (IShareable sharable : contentDeleted) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_58, (Object)sharable.getLocalPath().toString(), (Object[])new Object[0])));
                }
            }
        }
    }

    private boolean isUpdateCancelled(List<DeferredDownloadInformation> deferredDownloadInfo) {
        for (DeferredDownloadInformation info : deferredDownloadInfo) {
            if (info.getFailure() == null || !(this.getCauseOfFailure(info) instanceof OperationCanceledException)) continue;
            return true;
        }
        return false;
    }

    private void refreshLinks(Set<Shareable> linksToRefresh, Set<Shareable> linksToRecompute, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(linksToRefresh.size() + linksToRecompute.size()));
        for (Shareable shareable : linksToRefresh) {
            try {
                new Shareable(shareable.getSandbox(), shareable.getLocalPath(), ResourceType.SYMBOLIC_LINK).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        for (Shareable shareable : linksToRecompute) {
            try {
                lcm.computeChanges(shareable, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
    }

    protected void startingUpdates(IUpdateInfo orderer, IProgressMonitor progress) {
    }

    protected void folderAddsAndMovesCompleted(IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
    }

    protected void updateCompleted(IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
    }

    private void verifyUpdatesOutsideShares(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.failedUpdates.size());
        if (this.failedUpdates.isEmpty()) {
            return;
        }
        HashMap shares = NewCollection.hashMap();
        for (ICopyFileArea iCopyFileArea : this.copyFileAreasToUpdate) {
            Map<UUID, List<FileAreaUpdate>> failedUpdatesForCFA = this.failedUpdates.get(iCopyFileArea);
            if (failedUpdatesForCFA == null) continue;
            Collection<IShare> allShares = iCopyFileArea.allShares();
            for (IShare iShare : allShares) {
                Map sharesForComponent;
                ISharingDescriptor descriptor = iShare.getSharingDescriptor();
                if (!failedUpdatesForCFA.containsKey(descriptor.getComponent().getItemId()) || !descriptor.getConnectionHandle().sameItemId((IItemHandle)this.connectionHandle)) continue;
                Map sharesForCFA = (Map)shares.get(iCopyFileArea);
                if (sharesForCFA == null) {
                    sharesForCFA = NewCollection.hashMap();
                    shares.put(iCopyFileArea, sharesForCFA);
                }
                if ((sharesForComponent = (Map)sharesForCFA.get(descriptor.getComponent().getItemId())) == null) {
                    sharesForComponent = NewCollection.hashMap();
                    sharesForCFA.put(descriptor.getComponent().getItemId(), sharesForComponent);
                }
                sharesForComponent.put(descriptor.getRootVersionable().getItemId(), iShare);
            }
        }
        for (Map.Entry entry : this.failedUpdates.entrySet()) {
            ICopyFileArea cfa = (ICopyFileArea)entry.getKey();
            Map failedUpdatesForCFA = (Map)entry.getValue();
            for (Map.Entry entry2 : failedUpdatesForCFA.entrySet()) {
                Map sharesForComponent;
                List interestingUpdatesForComponent = (List)entry2.getValue();
                UUID componentItemId = (UUID)entry2.getKey();
                Map sharesForCFA = (Map)shares.get(cfa);
                if (sharesForCFA == null || (sharesForComponent = (Map)sharesForCFA.get(componentItemId)) == null || sharesForComponent.isEmpty()) continue;
                HashMap itemsToLocate = NewCollection.hashMap();
                HashMap locateUpdates = NewCollection.hashMap();
                IConfiguration configuration = this.determineItemsToLocate(componentItemId, interestingUpdatesForComponent, itemsToLocate, locateUpdates);
                if (itemsToLocate.isEmpty()) continue;
                SubMonitor subProgress = progress.newChild(1).setWorkRemaining(100);
                IComponent component = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)configuration.component(), 0, (IProgressMonitor)subProgress.newChild(10));
                List toLocate = NewCollection.arrayList(itemsToLocate.values());
                List report = configuration.locateAncestors(toLocate, (IProgressMonitor)subProgress.newChild(50));
                subProgress.setWorkRemaining(report.size());
                HashMap visibilitesToCheck = NewCollection.hashMap();
                int i = 0;
                block6: for (IAncestorReport parentage : report) {
                    List nameItemPairs = parentage.getNameItemPairs();
                    int j = 0;
                    while (j < nameItemPairs.size()) {
                        INameItemPair pair = (INameItemPair)nameItemPairs.get(j);
                        IShare share = (IShare)sharesForComponent.get(pair.getItem().getItemId());
                        if (share != null) {
                            boolean filtered;
                            block24: {
                                filtered = false;
                                try {
                                    LoadFilter filter = LoadFilter.getFilter(share.getSharingDescriptor());
                                    if (filter == null) break block24;
                                    int k = j + 1;
                                    while (k < nameItemPairs.size()) {
                                        if (!filter.include(((INameItemPair)nameItemPairs.get(k)).getName())) {
                                            filtered = true;
                                            break;
                                        }
                                        ++k;
                                    }
                                }
                                catch (IOException e) {
                                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                                }
                            }
                            if (filtered) {
                                locateUpdates.remove(((IVersionableHandle)toLocate.get(i)).getItemId());
                                continue block6;
                            }
                            int k = j + 1;
                            while (k < nameItemPairs.size()) {
                                IVersionableHandle item = ((INameItemPair)nameItemPairs.get(k)).getItem();
                                visibilitesToCheck.put(item.getItemId(), item);
                                ++k;
                            }
                            continue block6;
                        }
                        ++j;
                    }
                }
                if (visibilitesToCheck.isEmpty()) continue;
                IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository);
                IVersionablePermissionsReport[] permissions = wm.getPermissions(visibilitesToCheck.values().toArray(new IVersionableHandle[visibilitesToCheck.size()]), (IComponentHandle)component, (IProgressMonitor)subProgress.newChild(1));
                HashSet permissionsDenied = NewCollection.hashSet();
                IVersionablePermissionsReport[] filtered = permissions;
                int share = permissions.length;
                int n = 0;
                while (n < share) {
                    IVersionablePermissionsReport permissionReport = filtered[n];
                    if (permissionReport.isReportOfInaccessible()) {
                        permissionsDenied.addAll(permissionReport.getItemsIds());
                    }
                    ++n;
                }
                i = 0;
                for (IAncestorReport parentage : report) {
                    List nameItemPairs = parentage.getNameItemPairs();
                    int j = 0;
                    while (j < nameItemPairs.size()) {
                        INameItemPair pair = (INameItemPair)nameItemPairs.get(j);
                        IShare share2 = (IShare)sharesForComponent.get(pair.getItem().getItemId());
                        if (share2 != null) {
                            boolean filtered2 = false;
                            int k = j + 1;
                            while (k < nameItemPairs.size()) {
                                if (permissionsDenied.contains(((INameItemPair)nameItemPairs.get(k)).getItem().getItemId())) {
                                    filtered2 = true;
                                    break;
                                }
                                ++k;
                            }
                            if (filtered2) {
                                locateUpdates.remove(((IVersionableHandle)toLocate.get(i)).getItemId());
                                break;
                            }
                            this.recordInconsistentShare(configuration.component(), share2);
                            this.reportFailedUpdates(component, (IVersionableHandle)toLocate.get(i), locateUpdates, nameItemPairs);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    private IConfiguration determineItemsToLocate(UUID componentItemId, List<FileAreaUpdate> interestingUpdatesForComponent, Map<UUID, IVersionableHandle> itemsToLocate, Map<UUID, Set<FileAreaUpdate>> locateUpdates) throws ItemNotFoundException, ComponentNotInWorkspaceException {
        HashMap itemsSeen = NewCollection.hashMap();
        IConfiguration configuration = null;
        for (FileAreaUpdate update : interestingUpdatesForComponent) {
            if (configuration == null) {
                configuration = this.connection instanceof IWorkspaceConnection ? (componentItemId.equals((Object)update.getComponent().getItemId()) ? ((IWorkspaceConnection)this.connection).configuration(update.component()) : ((IWorkspaceConnection)this.connection).configuration(update.getPreviousComponent())) : ((IBaselineConnection)this.connection).configuration();
            }
            if (update.isChangeType(8)) {
                if (!componentItemId.equals((Object)update.getComponent().getItemId())) continue;
                this.determineWhatToLocate(itemsSeen, itemsToLocate, locateUpdates, update);
                continue;
            }
            if (!update.isChangeType(1) && !update.isChangeType(4)) continue;
            this.determineWhatToLocate(itemsSeen, itemsToLocate, locateUpdates, update);
        }
        return configuration;
    }

    private void determineWhatToLocate(Map<UUID, UUID> itemsSeen, Map<UUID, IVersionableHandle> itemsToLocate, Map<UUID, Set<FileAreaUpdate>> locateUpdates, FileAreaUpdate update) {
        Set<Object> toRecord;
        UUID itemId = update.item().getItemId();
        UUID parentId = update.getDestinationParent().getItemId();
        itemsSeen.put(itemId, parentId);
        if (itemsToLocate.containsKey(itemId)) {
            itemsToLocate.remove(itemId);
            toRecord = locateUpdates.remove(itemId);
        } else {
            toRecord = NewCollection.hashSet();
        }
        toRecord.add(update);
        if (!itemsSeen.containsKey(parentId)) {
            itemsToLocate.put(parentId, (IVersionableHandle)update.getDestinationParent());
            locateUpdates.put(parentId, toRecord);
            itemsSeen.put(parentId, null);
        } else {
            this.recordUpdateAgainstLocate(parentId, toRecord, itemsSeen, locateUpdates);
        }
    }

    private void recordUpdateAgainstLocate(UUID itemId, Set<FileAreaUpdate> toRecord, Map<UUID, UUID> itemsSeen, Map<UUID, Set<FileAreaUpdate>> locateUpdates) {
        int paranoiaCount = 0;
        while (paranoiaCount < 2000) {
            UUID parent = itemsSeen.get(itemId);
            if (parent == null) {
                Set<FileAreaUpdate> updatesRecorded = locateUpdates.get(itemId);
                if (updatesRecorded == null) {
                    locateUpdates.put(itemId, toRecord);
                    break;
                }
                updatesRecorded.addAll(toRecord);
                break;
            }
            itemId = parent;
            ++paranoiaCount;
        }
    }

    private void reportFailedUpdates(IComponent component, IVersionableHandle versionableHandle, Map<UUID, Set<FileAreaUpdate>> locateUpdates, List<INameItemPair> nameItemPairs) {
        Iterator<INameItemPair> iPairs = nameItemPairs.iterator();
        iPairs.next();
        StringBuffer path = new StringBuffer(47);
        while (iPairs.hasNext()) {
            INameItemPair pair = iPairs.next();
            path.append(pair.getName()).append('/');
        }
        Set<FileAreaUpdate> updatesToReport = locateUpdates.get(versionableHandle.getItemId());
        if (updatesToReport != null) {
            for (FileAreaUpdate update : updatesToReport) {
                if (update.isChangeType(4)) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_25, (Object)update.getName(), (Object[])new Object[]{path.toString(), component.getName()})));
                    continue;
                }
                if (update.isChangeType(1) && update.item() instanceof IFileItemHandle) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_26, (Object)update.getName(), (Object[])new Object[]{path.toString(), component.getName()})));
                    continue;
                }
                if (update.isChangeType(1) && update.item() instanceof IFolderHandle) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_27, (Object)update.getName(), (Object[])new Object[]{path.toString(), component.getName()})));
                    continue;
                }
                if (update.isChangeType(1) && update.item() instanceof ISymbolicLinkHandle) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_49, (Object)update.getName(), (Object[])new Object[]{path.toString(), component.getName()})));
                    continue;
                }
                if (!update.isChangeType(8)) continue;
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_28, (Object)update.getOldName(), (Object[])new Object[]{path.toString(), component.getName()})));
            }
        }
    }

    private void doDilemmaHandling(List<DeferredDownloadInformation> deferredDownloadInfo, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList encodingFailures = NewCollection.arrayList();
        for (DeferredInformation deferredInformation : deferredDownloadInfo) {
            if (deferredInformation == null || deferredInformation.getFailure() == null) continue;
            Object rootCause = deferredInformation.getFailure();
            int digParanoiaCount = 0;
            while (rootCause instanceof TeamRepositoryException && digParanoiaCount < 50) {
                Throwable cause = ((TeamRepositoryException)((Object)rootCause)).getCause();
                if (cause == null) break;
                rootCause = cause;
                ++digParanoiaCount;
            }
            if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                encodingFailures.add(new EncodingDownloadFailure(deferredInformation));
                continue;
            }
            if (rootCause instanceof CharacterCodingException) {
                encodingFailures.add(new EncodingDownloadFailure(deferredInformation));
                continue;
            }
            if (!(rootCause instanceof OperationCanceledException)) continue;
            throw new OperationCanceledException();
        }
        if (encodingFailures.size() > 0) {
            boolean bl;
            for (EncodingDownloadFailure encodingDownloadFailure : encodingFailures) {
                encodingDownloadFailure.setIgnoreEncoding(true);
            }
            boolean bl2 = false;
            this.contentSession = FileSystemCore.getContentManager(this.repository).createSession(NLS.bind((String)Messages.UpdateMutator_19, (Object)this.connection.getName(), (Object[])new Object[0]), true, encodingFailures.size(), (IProgressMonitor)progress.newChild(75));
            try {
                for (EncodingDownloadFailure failure : encodingFailures) {
                    if (!failure.hasDirection()) continue;
                    DeferredDownloadInformation info = (DeferredDownloadInformation)failure.getDeferredUpdateInformation();
                    IVersionableHandle fileItemState = info.getFileItemState();
                    info.setExpandKeywords(this.keywordExpansionContext != null && KeywordExpansionContext.isShareLoadedWithKeywordExpansionEnabled(info.getShareable(), (IProgressMonitor)progress.newChild(1)));
                    this.contentSession.retrieveContent((IFileItemHandle)fileItemState, info.getContent(), info.getEncoding(), info.getLineDelimiter(), new DownloadHandler(info.getShareable(), info, false));
                    bl = true;
                }
            }
            finally {
                if (bl) {
                    this.contentSession.join();
                }
            }
            SubMonitor iterProgress = progress.newChild(25);
            iterProgress.setWorkRemaining(encodingFailures.size());
            for (EncodingDownloadFailure failure : encodingFailures) {
                if (!failure.getDeferredUpdateInformation().isLineDelimiterIgnored() || failure.getDeferredUpdateInformation().getFailure() != null) continue;
                failure.getDeferredUpdateInformation().convert((IProgressMonitor)iterProgress.newChild(1));
            }
        }
    }

    private void reportDownloadFailures(List<DeferredDownloadInformation> deferredDownloadInfo, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(deferredDownloadInfo.size() * 2));
        boolean reportedSupportedCharSets = false;
        for (DeferredDownloadInformation deferredUpdateInformation : deferredDownloadInfo) {
            IShare share;
            IStatus status;
            if (deferredUpdateInformation == null) continue;
            if (deferredUpdateInformation.getFailure() != null) {
                Throwable rootCause = this.getCauseOfFailure(deferredUpdateInformation);
                if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                    if (!reportedSupportedCharSets) {
                        StringBuffer charSetsAvailable = new StringBuffer();
                        for (String charsetName : Charset.availableCharsets().keySet()) {
                            charSetsAvailable.append(charsetName).append(' ');
                        }
                        IStatus infoStatus = FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.UpdateMutator_11, (Object)charSetsAvailable.toString(), (Object[])new Object[0]));
                        this.collectStatus(infoStatus);
                        reportedSupportedCharSets = true;
                    }
                    status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_21, (Object)deferredUpdateInformation.getShareable().getLocalPath(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), deferredUpdateInformation.getFailure());
                } else if (rootCause instanceof CharacterCodingException) {
                    status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_23, (Object)deferredUpdateInformation.getShareable().getLocalPath(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), deferredUpdateInformation.getFailure());
                } else {
                    if (rootCause instanceof OperationCanceledException) continue;
                    status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.UpdateMutator_22, (Object)deferredUpdateInformation.getShareable().getLocalPath(), (Object[])new Object[0]), deferredUpdateInformation.getFailure());
                }
                this.collectStatus(status);
                share = null;
                try {
                    share = deferredUpdateInformation.getShareable().getShare((IProgressMonitor)progress.newChild(1));
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
                if (share == null) {
                    this.recordInconsistentComponent(deferredUpdateInformation.getCopyFileArea(), deferredUpdateInformation.getComponent(), (IProgressMonitor)progress.newChild(1));
                    continue;
                }
                if (deferredUpdateInformation.isContentUpdateBlocked()) continue;
                this.recordInconsistentShare(deferredUpdateInformation.getComponent(), deferredUpdateInformation.getShareable().getShare((IProgressMonitor)progress.newChild(1)));
                continue;
            }
            if (!deferredUpdateInformation.isLineDelimiterIgnored()) continue;
            IFileContent contentInfo = deferredUpdateInformation.getFileAreaUpdate().getOptionalContent();
            status = FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.UpdateMutator_51, (Object)deferredUpdateInformation.getShareable().getLocalPath(), (Object[])new Object[]{contentInfo.getCharacterEncoding(), contentInfo.getLineDelimiter().toString()}));
            this.collectStatus(status);
            share = null;
            try {
                share = deferredUpdateInformation.getShareable().getShare((IProgressMonitor)progress.newChild(1));
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
            if (share == null) {
                this.recordInconsistentComponent(deferredUpdateInformation.getCopyFileArea(), deferredUpdateInformation.getComponent(), (IProgressMonitor)progress.newChild(1));
                continue;
            }
            this.recordInconsistentShare(deferredUpdateInformation.getComponent(), deferredUpdateInformation.getShareable().getShare((IProgressMonitor)progress.newChild(1)));
        }
    }

    private Throwable getCauseOfFailure(DeferredDownloadInformation deferredUpdateInformation) {
        Throwable rootCause = deferredUpdateInformation.getFailure();
        if (rootCause == null) {
            rootCause = deferredUpdateInformation.getFailure();
        }
        int paranoiaCount = 0;
        while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
            Throwable cause = ((TeamRepositoryException)rootCause).getCause();
            if (cause == null) break;
            rootCause = cause;
            ++paranoiaCount;
        }
        return rootCause;
    }

    protected void refresh(DeferredDownloadInformation downloadInfo, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)1);
        Shareable shareable = downloadInfo.getShareable();
        final IFileStorage file = shareable.getFileStorage();
        if (file != null) {
            SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                @Override
                public void run() throws FileSystemException {
                    file.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)new SilentProgressMonitor((IProgressMonitor)progress.newChild(1)));
                }
            });
        }
    }

    protected void updateMetaData(DeferredDownloadInformation downloadInfo, boolean skipUpdate, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)100);
        Shareable shareable = downloadInfo.getShareable();
        IFileStorage file = shareable.getFileStorage();
        if (file != null) {
            ISharingDescriptor sharingDescriptor;
            boolean isLoadedWithAnotherName;
            String name;
            IFolderHandle parent;
            long modificationStamp = file.getModificationStamp();
            FileContent content = (FileContent)downloadInfo.getContent();
            FileItemInfo oldInfo = downloadInfo.getCopyFileArea().getItemInfo(shareable.getLocalPath());
            if (oldInfo == null) {
                parent = downloadInfo.getRemoteParent();
                name = downloadInfo.getRemoteName();
                isLoadedWithAnotherName = PathUtils.isLoadedWithAnotherName(shareable.getSandbox(), shareable.getLocalPath(), name);
            } else {
                parent = oldInfo.getParent();
                name = oldInfo.getName();
                isLoadedWithAnotherName = oldInfo.isLoadedWithAnotherName();
            }
            FileItemInfoProxy infoProxy = new FileItemInfoProxy(downloadInfo.getFileItemState(), parent, name, isLoadedWithAnotherName);
            infoProxy.setContentInfo(modificationStamp, downloadInfo.getHash(), downloadInfo.getContentSize(), content);
            infoProxy.setExecutable(downloadInfo.isExecutable(), downloadInfo.isExecutable());
            infoProxy.setContentType(downloadInfo.getContentType());
            infoProxy.setLinks(downloadInfo.getLinkInfo());
            if (skipUpdate || downloadInfo.isContentUpdateBlocked()) {
                infoProxy.setContentChanged(true, modificationStamp);
            }
            if ((sharingDescriptor = downloadInfo.getSharingDescriptor()) != null) {
                IShare share = SharingManager.getInstance().share(shareable, sharingDescriptor, infoProxy.getFileItemInfo(), downloadInfo.getMetadataProperties(), 2, (IProgressMonitor)progress.newChild(100));
                this.newShares.add(new ShareReference(sharingDescriptor.getComponent(), share));
            } else {
                downloadInfo.getCopyFileArea().setItemMetaData(shareable.getLocalPath(), infoProxy.getFileItemInfo(), ICopyFileArea.PropertyUpdate.REPLACE, downloadInfo.getMetadataProperties(), (IProgressMonitor)progress.newChild(100));
            }
            if (skipUpdate && !shareable.exists((IProgressMonitor)progress.newChild(1))) {
                downloadInfo.getCopyFileArea().makePendingDeletion(downloadInfo.getShareable().getLocalPath(), (IProgressMonitor)progress.newChild(99));
            }
        }
        progress.done();
    }

    private IComponent getFullComponent(FileAreaUpdate update, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentHandle component = update.component();
        return this.getFullComponent(component, monitor);
    }

    private IComponent getFullComponent(IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component instanceof IComponent) {
            return (IComponent)component;
        }
        IComponent fullComponent = this.componentCache.get(component.getItemId());
        if (fullComponent != null) {
            return fullComponent;
        }
        fullComponent = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)component, 0, monitor);
        this.componentCache.put(fullComponent.getItemId(), fullComponent);
        return fullComponent;
    }

    private void updateConfigStatesAndWCState(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        ICopyFileArea cfa;
        if (this.isTraceLoggingEnabled()) {
            this.logTraceInfo("UpdateMutator#updateConfigStatesAndWCState: Start.");
        }
        this.newShares.removeAll(this.inconsistentShares);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.newShares.size() + this.inconsistentShares.size() + this.componentStatesAfter.size() * 2));
        for (ShareReference newShare : this.newShares) {
            IComponentStateSummary summary = this.componentStatesAfter.get(newShare.component.getItemId());
            cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(newShare.share.getSandbox().getRoot());
            cfa.setConfigurationState(this.connectionHandle, newShare.component, newShare.share.getSharingDescriptor().getRootVersionable(), summary.getConfigurationTime(), (IProgressMonitor)subMonitor.newChild(1));
        }
        HashMap<ILocation, Collection<LoadedConfigurationDescriptor>> cfaRootToLoadedComponentConfigurations = new HashMap<ILocation, Collection<LoadedConfigurationDescriptor>>();
        for (IComponentStateSummary stateAfter : this.componentStatesAfter.values()) {
            IComponentStateSummary stateBefore = this.componentStatesBefore.get(stateAfter.getComponent().getItemId());
            if (stateBefore != null) {
                SubMonitor configStateProgress = subMonitor.newChild(1);
                configStateProgress.setWorkRemaining(this.copyFileAreasToUpdate.size());
                for (ICopyFileArea cfa2 : this.copyFileAreasToUpdate) {
                    ISyncTime beforeConfigurationTime = stateBefore.getConfigurationTime();
                    if (beforeConfigurationTime.equals(ISyncTime.TIME_NONE)) {
                        if (this.isTraceLoggingEnabled()) {
                            this.logTraceInfo(NLS.bind((String)"UpdateMutator#updateConfigStatesAndWCState: The before IComponentStateSummary had configuration time set to UNKNOWN, for component with item id: \"{0}\". This is only expected to happen in case of IncrementalLoadOperation.", (Object)stateAfter.getComponent().getItemId(), (Object[])new Object[0]));
                        }
                        beforeConfigurationTime = null;
                    }
                    cfa2.setConfigurationState(this.connectionHandle, stateAfter.getComponent(), beforeConfigurationTime, stateAfter.getConfigurationTime(), (IProgressMonitor)configStateProgress.newChild(1));
                }
            } else {
                subMonitor.worked(1);
            }
            SubMonitor wcStateProgress = subMonitor.newChild(1);
            wcStateProgress.setWorkRemaining(this.copyFileAreasToUpdate.size());
            for (ICopyFileArea cfa2 : this.copyFileAreasToUpdate) {
                this.updateWorkspaceComponentState(cfaRootToLoadedComponentConfigurations, cfa2.getRoot(), stateAfter, (IProgressMonitor)wcStateProgress.newChild(1));
            }
        }
        for (ShareReference inconsistentShare : this.inconsistentShares) {
            cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(inconsistentShare.share.getSandbox().getRoot());
            cfa.setUnknownConfigurationState(this.connectionHandle, inconsistentShare.component, inconsistentShare.share.getPath(), (IProgressMonitor)subMonitor.newChild(1));
        }
        if (this.isTraceLoggingEnabled()) {
            this.logTraceInfo("UpdateMutator#updateConfigStatesAndWCState: End.");
        }
    }

    private void updateWorkspaceComponentState(Map<ILocation, Collection<LoadedConfigurationDescriptor>> cfaRootToLoadedComponentConfigurations, ILocation cfaRoot, IComponentStateSummary summary, IProgressMonitor monitor) throws FileSystemException {
        LoadedConfigurationDescriptor loadedComponentConfiguration;
        if (this.isTraceLoggingEnabled()) {
            this.logTraceInfo("UpdateMutator#updateWorkspaceComponentState: Start.");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.isTraceLoggingEnabled()) {
            this.logTraceInfo(NLS.bind((String)"UpdateMutator#updateWorkspaceComponentState: Processing the sandbox at location: \"{0}\".", (Object)cfaRoot, (Object[])new Object[0]));
        }
        if (this.isTraceLoggingEnabled()) {
            this.logTraceInfo("UpdateMutator#updateWorkspaceComponentState: Fetching all the loaded configuration descriptors for the sandbox.");
        }
        Collection<LoadedConfigurationDescriptor> loadedComponentConfigurations = SharingManager.getInstance().allLoadedConfigurations(cfaRoot, cfaRootToLoadedComponentConfigurations, (IProgressMonitor)progress.newChild(50));
        UUID componentItemId = summary.getComponent().getItemId();
        if (this.isTraceLoggingEnabled()) {
            this.logTraceInfo(NLS.bind((String)"UpdateMutator#updateWorkspaceComponentState: Retrieving the loaded configuration descriptor for the component with itemId \"{0}\".", (Object)componentItemId.getUuidValue(), (Object[])new Object[0]));
        }
        if ((loadedComponentConfiguration = CopyFileAreaUtil.getFilteredLoadedConfigurationForComponent(this.connectionHandle.getItemId(), componentItemId, loadedComponentConfigurations)) != null) {
            if (this.isTraceLoggingEnabled()) {
                this.logTraceInfo("UpdateMutator#updateWorkspaceComponentState: Invoking CopyFileAreaUtil#updateWorkspaceComponentState().");
            }
            CopyFileAreaUtil.updateWorkspaceComponentState(cfaRoot, summary.getWorkspaceComponentState(), false, loadedComponentConfiguration, this.traceLog, (IProgressMonitor)progress.newChild(50));
        } else {
            if (this.isTraceLoggingEnabled()) {
                this.logTraceInfo(NLS.bind((String)"UpdateMutator#updateWorkspaceComponentState: The component with itemId \"{0}\" is not loaded, hence we do not update it's workspace component state in the metadata.", (Object)componentItemId.getUuidValue(), (Object[])new Object[0]));
            }
            progress.worked(50);
        }
        if (this.isTraceLoggingEnabled()) {
            this.logTraceInfo("UpdateMutator#updateWorkspaceComponentState: End.");
        }
    }

    protected ISyncTime getBeforeConfigState(IComponentHandle component) {
        return this.componentStatesBefore.get(component.getItemId()).getConfigurationTime();
    }

    protected void updateMetaDataAfterMove(ICopyFileArea cfa, IComponent component, IComponentHandle previousComponent, Shareable sourceShareable, Shareable targetShareable, boolean isShareRoot, boolean isLoadedWithAlternateName, boolean moveUpdate, MetadataProperties properties, boolean alsoModified, IFolderHandle parent, IVersionableHandle itemState, String remoteName, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        MetadataProperties updateProperties;
        ICopyFileArea.PropertyUpdate propertyUpdateDirection;
        boolean deferModify;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean bl = deferModify = alsoModified && (itemState instanceof ISymbolicLinkHandle || itemState instanceof IFileItemHandle);
        if (moveUpdate) {
            if (deferModify) {
                propertyUpdateDirection = ICopyFileArea.PropertyUpdate.CANCEL_CHANGES;
                updateProperties = null;
            } else if (alsoModified) {
                propertyUpdateDirection = ICopyFileArea.PropertyUpdate.REPLACE;
                updateProperties = properties;
            } else {
                propertyUpdateDirection = ICopyFileArea.PropertyUpdate.PRESERVE;
                updateProperties = null;
            }
        } else {
            propertyUpdateDirection = ICopyFileArea.PropertyUpdate.PRESERVE;
            updateProperties = null;
        }
        FileItemInfo itemInfo = cfa.getItemInfo(sourceShareable.getLocalPath());
        if (isShareRoot) {
            if (!sourceShareable.getLocalPath().equals(targetShareable.getLocalPath()) && !isLoadedWithAlternateName) {
                cfa.moveInfo(sourceShareable.getLocalPath(), targetShareable.getLocalPath(), false, (IProgressMonitor)progress.newChild(74));
            }
            IShare share = isLoadedWithAlternateName ? sourceShareable.getShare((IProgressMonitor)progress.newChild(1)) : targetShareable.getShare((IProgressMonitor)progress.newChild(1));
            if (!component.sameItemId((IItemHandle)previousComponent)) {
                SharingDescriptor sharingDescriptor;
                SharingDescriptor descriptor = (SharingDescriptor)share.getSharingDescriptor();
                ISyncTime previousSyncState = this.getBeforeConfigState(previousComponent);
                ISyncTime componentSyncState = this.getBeforeConfigState((IComponentHandle)component);
                FileItemInfo info = null;
                if (moveUpdate) {
                    InverseFileItemInfo oldInfo = cfa.getItemInfo(itemState, previousComponent, this.connectionHandle, true);
                    FileItemInfoProxy infoProxy = new FileItemInfoProxy(oldInfo);
                    if (!deferModify) {
                        infoProxy.setItemState(itemState);
                    }
                    infoProxy.changeIdentity(parent, remoteName);
                    info = infoProxy.getFileItemInfo();
                }
                if (!descriptor.getConfigurationState().equals(previousSyncState)) {
                    this.recordInconsistentShare((IComponentHandle)component, share);
                    sharingDescriptor = SharingDescriptor.create(this.connection, component, descriptor.getRootVersionable(), this.getClientDataForSharingDescriptor());
                    cfa.share(share.getPath(), sharingDescriptor, info, propertyUpdateDirection, updateProperties, 2, (IProgressMonitor)progress.newChild(24));
                } else if (componentSyncState == null) {
                    this.newShares.add(new ShareReference((IComponentHandle)component, share));
                    sharingDescriptor = SharingDescriptor.create(this.connection, component, descriptor.getRootVersionable(), this.getClientDataForSharingDescriptor());
                    cfa.share(share.getPath(), sharingDescriptor, info, propertyUpdateDirection, updateProperties, 2, (IProgressMonitor)progress.newChild(24));
                } else {
                    sharingDescriptor = SharingDescriptor.create(this.connection, component, descriptor.getRootVersionable(), componentSyncState, this.getClientDataForSharingDescriptor());
                    cfa.share(share.getPath(), sharingDescriptor, info, propertyUpdateDirection, updateProperties, 2, (IProgressMonitor)progress.newChild(25));
                }
            } else if (moveUpdate) {
                InverseFileItemInfo oldInfo = cfa.getItemInfo(itemState, (IComponentHandle)component, this.connectionHandle, true);
                FileItemInfoProxy info = new FileItemInfoProxy(oldInfo);
                if (!deferModify) {
                    info.setItemState(itemState);
                }
                info.changeIdentity(parent, remoteName);
                cfa.setItemMetaData(share.getPath(), info.getFileItemInfo(), propertyUpdateDirection, updateProperties, (IProgressMonitor)progress.newChild(25));
            }
        } else if (itemInfo != null) {
            SharingDescriptor sourceDescriptor;
            cfa.moveInfo(sourceShareable.getLocalPath(), targetShareable.getLocalPath(), moveUpdate, (IProgressMonitor)progress.newChild(90));
            if (moveUpdate && !deferModify) {
                InverseFileItemInfo oldInfo = cfa.getItemInfo(itemState, (IComponentHandle)component, this.connectionHandle, true);
                FileItemInfoProxy info = new FileItemInfoProxy(oldInfo);
                info.setItemState(itemState);
                cfa.setItemMetaData(targetShareable.getLocalPath(), info.getFileItemInfo(), propertyUpdateDirection, updateProperties, (IProgressMonitor)progress.newChild(1));
            }
            if (!(sourceDescriptor = (SharingDescriptor)sourceShareable.getShare((IProgressMonitor)progress.newChild(1)).getSharingDescriptor()).getConfigurationState().equals(this.getBeforeConfigState(sourceDescriptor.getComponent()))) {
                this.recordInconsistentShare((IComponentHandle)component, targetShareable.getShare((IProgressMonitor)progress.newChild(1)));
            }
        }
        cfa.unloadComponentIfNoShares(previousComponent, this.connectionHandle, (IProgressMonitor)progress.newChild(7));
    }

    @Override
    public void setExpandKeywords(boolean expandKeywords) {
        this.expandKeywords = expandKeywords;
    }

    private Map<String, byte[]> getClientDataForSharingDescriptor() {
        HashMap<String, byte[]> additionalInfo = null;
        if (this.expandKeywords) {
            additionalInfo = new HashMap<String, byte[]>(1);
            additionalInfo.put("com.ibm.team.filesystem.client.KeywordExpansion", Boolean.TRUE.toString().getBytes());
        }
        return additionalInfo;
    }

    @Override
    public final void setSkipStoreContent(Map<ILocation, Map<ConfigurationFacade, Set<UUID>>> skipList) {
        this.toSkip = skipList;
    }

    protected final void addUpdateToSkip(ILocation cfa, IComponentHandle component, IVersionableHandle remote) {
        ConfigurationFacade desc;
        Set uuids;
        HashMap configMap = this.toSkip.get(cfa);
        if (configMap == null) {
            configMap = NewCollection.hashMap();
            this.toSkip.put(cfa, configMap);
        }
        if ((uuids = (Set)configMap.get((Object)(desc = new ConfigurationFacade(this.connection, component)))) == null) {
            uuids = NewCollection.hashSet();
            configMap.put(desc, uuids);
        }
        uuids.add(remote.getItemId());
    }

    protected final boolean isSkipping() {
        return !this.toSkip.isEmpty();
    }

    protected final boolean skipUpdate(ILocation cfa, IComponentHandle comp, IVersionableHandle remote) {
        if (remote == null) {
            return false;
        }
        Map<ConfigurationFacade, Set<UUID>> configMap = this.toSkip.get(cfa);
        if (configMap == null) {
            return false;
        }
        ConfigurationFacade desc = new ConfigurationFacade(this.connection, comp);
        Set<UUID> uuids = configMap.get((Object)desc);
        if (uuids == null) {
            return false;
        }
        return uuids.contains(remote.getItemId());
    }

    private void failedUpdate(ICopyFileArea cfa, FileAreaUpdate update) {
        this.failedUpdate(cfa, update, update.component());
    }

    protected final void failedUpdate(ICopyFileArea cfa, FileAreaUpdate update, IComponentHandle component) {
        List failedUpdatesForComponent;
        HashMap failedUpdatesForCFA = this.failedUpdates.get(cfa);
        if (failedUpdatesForCFA == null) {
            failedUpdatesForCFA = NewCollection.hashMap();
            this.failedUpdates.put(cfa, failedUpdatesForCFA);
        }
        if ((failedUpdatesForComponent = (List)failedUpdatesForCFA.get(component.getItemId())) == null) {
            failedUpdatesForComponent = NewCollection.arrayList();
            failedUpdatesForCFA.put(component.getItemId(), failedUpdatesForComponent);
        }
        failedUpdatesForComponent.add(update);
    }

    private void handleMissingSource(ICopyFileArea cfa, FileAreaUpdate update) {
        ArrayList missingSourceForCFA = this.missingSource.get(cfa);
        if (missingSourceForCFA == null) {
            missingSourceForCFA = NewCollection.arrayList();
            this.missingSource.put(cfa, missingSourceForCFA);
        }
        if (!missingSourceForCFA.contains(update)) {
            missingSourceForCFA.add(update);
        }
    }

    @Override
    protected void reportErrorsAsException(IStatus[] errors) throws FileSystemException {
        if (errors.length == 0) {
            return;
        }
        if (!this.inconsistentShares.isEmpty()) {
            MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, errors, NLS.bind((String)Messages.UpdateMutator_24, (Object)errors.length, (Object[])new Object[0]), null);
            throw new FileSystemStatusException((IStatus)result);
        }
        super.reportErrorsAsException(errors);
    }

    protected void folderCreated(Shareable newFolder, boolean isShare, IProgressMonitor monitor) throws TeamRepositoryException {
    }

    protected void fileLoaded(Shareable fileLoaded, IProgressMonitor monitor) throws FileSystemException {
    }

    protected void itemMoved(Shareable toMoveShareable, Shareable destinationShareable, IProgressMonitor newChild) {
    }

    protected void updatesComplete(IProgressMonitor monitor) throws FileSystemException {
    }

    private void refreshFileAttributes(FileAreaUpdateReport2 updateReport, IProgressMonitor progress) throws TeamRepositoryException {
        int totalUpdates = this.updates.getAdds().size() + this.updates.getModifies().size() + this.updates.getMoves().size();
        if (totalUpdates == 0) {
            return;
        }
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)(this.updates.getAdds().size() + 2));
        List<StringMatcher> matchers = ExclusiveFileLockPatternUtil.getPatternsToMatch(this.connection, (IProgressMonitor)subProgress.newChild(1));
        if (matchers.isEmpty()) {
            return;
        }
        ArrayList updateRefreshes = NewCollection.arrayList((int)totalUpdates);
        updateRefreshes.addAll(this.updates.getAdds());
        updateRefreshes.addAll(this.updates.getModifies());
        updateRefreshes.addAll(this.updates.getMoves());
        Map<UUID, Set<UUID>> componentToVersionablesLockedByUser = ExclusiveFileLockPatternUtil.getLocksHeldByUser(this.connection, (IProgressMonitor)subProgress.newChild(1));
        HashSet versionablesLockedByUser = NewCollection.hashSet();
        for (Set<UUID> versionables : componentToVersionablesLockedByUser.values()) {
            versionablesLockedByUser.addAll(versionables);
        }
        subProgress.setWorkRemaining(updateRefreshes.size());
        IComponent component = null;
        for (FileAreaUpdate update : updateRefreshes) {
            if (update.getItem() instanceof IFileItemHandle) {
                if (versionablesLockedByUser.contains(update.getItem().getItemId())) {
                    subProgress.worked(1);
                    continue;
                }
                component = this.getFullComponent(update, progress);
                List<ICopyFileArea> copyFileAreas = this.copyFileAreasByComponent.get(component.getItemId());
                IFileItemHandle fileItemState = (IFileItemHandle)update.afterState();
                SubMonitor cfaProgress = SubMonitor.convert((IProgressMonitor)subProgress.newChild(1), (int)4);
                for (ICopyFileArea cfa : copyFileAreas) {
                    Shareable shareable;
                    IRelativeLocation path = cfa.getLocalPathFor(this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)fileItemState, (IProgressMonitor)cfaProgress.newChild(1));
                    if (path == null || (shareable = new Shareable(cfa.getRoot(), path, ResourceType.FILE)).getResourceType((IProgressMonitor)cfaProgress.newChild(1)) != ResourceType.FILE || !shareable.exists((IProgressMonitor)cfaProgress.newChild(1)) || !shareable.getSandbox().isCaseSensitive() && (!shareable.getFileStorage().storageExists((IProgressMonitor)cfaProgress.newChild(1)) || !shareable.getFileStorage().getActualName().equals(path.getName()))) continue;
                    ExclusiveFileLockPatternUtil.makeFileReadOnly(shareable, matchers);
                }
                continue;
            }
            subProgress.worked(1);
        }
    }

    private void updateWorkspaceComponentStateToUnknown(Collection<ICopyFileArea> copyFileAreasToUpdate, Collection<UUID> components, IProgressMonitor monitor) throws FileSystemException {
        if (this.isTraceLoggingEnabled()) {
            this.logTraceInfo("UpdateMutator#updateWorkspaceComponentStateToUnknown: Start.");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor subProgress = progress.newChild(100);
        subProgress.setWorkRemaining(copyFileAreasToUpdate.size());
        for (ICopyFileArea cfa : copyFileAreasToUpdate) {
            if (this.isTraceLoggingEnabled()) {
                this.logTraceInfo(NLS.bind((String)"UpdateMutator#updateWorkspaceComponentStateToUnknown: Processing the sandbox at location: \"{0}\".", (Object)cfa.getRoot(), (Object[])new Object[0]));
            }
            if (this.isTraceLoggingEnabled()) {
                this.logTraceInfo("UpdateMutator#updateWorkspaceComponentStateToUnknown: Fetching all the loaded configuration descriptors for the sandbox.");
            }
            Collection<LoadedConfigurationDescriptor> allLoadedComponentConfigurations = SharingManager.getInstance().allLoadedConfigurations(cfa.getRoot(), (IProgressMonitor)subProgress.newChild(1));
            if (this.isTraceLoggingEnabled()) {
                this.logTraceInfo("UpdateMutator#updateWorkspaceComponentStateToUnknown: Retrieving the loaded configuration descriptors for the components.");
            }
            Collection<LoadedConfigurationDescriptor> loadedComponentConfigurations = CopyFileAreaUtil.getFilteredLoadedConfigurationForComponents(this.connectionHandle.getItemId(), components, allLoadedComponentConfigurations);
            if (this.isTraceLoggingEnabled()) {
                this.logTraceInfo("UpdateMutator#updateWorkspaceComponentStateToUnknown: Invoking CopyFileAreaUtil#updateWorkspaceComponentStateToUnknown().");
            }
            CopyFileAreaUtil.updateWorkspaceComponentStateToUnknown(cfa.getRoot(), loadedComponentConfigurations, this.traceLog, (IProgressMonitor)subProgress.newChild(1));
        }
        if (this.isTraceLoggingEnabled()) {
            this.logTraceInfo("UpdateMutator#updateWorkspaceComponentStateToUnknown: End.");
        }
    }

    private void logTraceInfo(String message) {
        if (this.traceLog != null) {
            this.traceLog.trace((Object)message);
        }
    }

    private void logTraceInfo(String message, Throwable t) {
        if (this.traceLog != null) {
            this.traceLog.trace((Object)message, t);
        }
    }

    private boolean isTraceLoggingEnabled() {
        return this.traceLog != null && this.traceLog.isTraceEnabled();
    }

    private class CreateUpdateInfo {
        public boolean isShare = false;
        public ISharingDescriptor descriptor = null;
        public IRelativeLocation parentPath;
        public IFolderHandle parent;
        public String errorMsgFileName;

        public CreateUpdateInfo(ICopyFileArea cfa, FileAreaUpdate update, IComponent component, IProgressMonitor progress) throws FileSystemException {
            this.parent = update.getDestinationParent();
            this.parentPath = cfa.getLocalPathFor(UpdateMutator.this.connectionHandle, (IComponentHandle)component, (IVersionableHandle)this.parent, progress);
            this.errorMsgFileName = update.getName();
        }
    }

    private class DownloadHandler
    extends FileDownloadHandler {
        private final Shareable shareable;
        private final DeferredDownloadInformation downloadInfo;
        private boolean skipWrite;

        public DownloadHandler(Shareable shareable, DeferredDownloadInformation downloadInfo, boolean skipWrite) {
            this.shareable = shareable;
            this.downloadInfo = downloadInfo;
            this.skipWrite = skipWrite;
        }

        @Override
        public void downloadStreamAcquired(IFileItemHandle item, IFileContent content, InputStream in) throws TeamRepositoryException {
            final InputStream contentStream = in;
            SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                @Override
                public void run() throws FileSystemException {
                    try {
                        DownloadHandler.this.downloadInfo.reset();
                        if (((DownloadHandler)DownloadHandler.this).UpdateMutator.this.downloadMonitor != null) {
                            ((DownloadHandler)DownloadHandler.this).UpdateMutator.this.downloadMonitor.downloadStarted(DownloadHandler.this.shareable.getSandbox().getRoot(), DownloadHandler.this.shareable.getLocalPath(), DownloadHandler.this.downloadInfo.getContent().getEstimatedConvertedLength());
                        }
                        OutputStream out = null;
                        if (!DownloadHandler.this.skipWrite) {
                            try {
                                out = UpdateMutator.this.getFileOutputStream(DownloadHandler.this.shareable.getFullPath());
                            }
                            catch (IOException e) {
                                if (UpdateMutator.this.isTraceLoggingEnabled()) {
                                    UpdateMutator.this.logTraceInfo(NLS.bind((String)"Unable to open output stream for file {0}.", (Object)DownloadHandler.this.shareable.getFullPath(), (Object[])new Object[0]), e);
                                }
                                if (UpdateMutator.this.isPreserveLocalChanges()) {
                                    String message = NLS.bind((String)Messages.UpdateMutator_67, (Object)DownloadHandler.this.shareable.getFullPath(), (Object[])new Object[0]);
                                    IOException ex = new IOException(message, e);
                                    ex.fillInStackTrace();
                                    DownloadHandler.this.downloadInfo.setFailure(DownloadHandler.this.shareable, ex);
                                    DownloadHandler.this.recordBlockedFileContentUpdate();
                                    DownloadHandler.this.downloadInfo.setContentUpdateBlocked(true);
                                    DownloadHandler.this.skipWrite = true;
                                    if (UpdateMutator.this.isTraceLoggingEnabled()) {
                                        UpdateMutator.this.logTraceInfo(NLS.bind((String)"Attempting to create local conflict for file {0} after failure to open output stream.", (Object)DownloadHandler.this.shareable.getFullPath(), (Object[])new Object[0]));
                                    }
                                }
                                throw e;
                            }
                        }
                        boolean completed = false;
                        try {
                            IFileOptions fileInfo = FileOptionsFactory.getFileOptions(true, DownloadHandler.this.downloadInfo.getLineDelimiter(), DownloadHandler.this.downloadInfo.getEncoding(), DownloadHandler.this.downloadInfo.getFileAreaUpdate().getMetadataProperties());
                            InputStream contents = LocalFileStorage.getFileAccessExtension().prepareContentsToSet(fileInfo, contentStream);
                            DigestComputingInputStream inStream = ContentHash.getDigestComputingStream((InputStream)contents);
                            if (out == null) {
                                if (!$assertionsDisabled && !DownloadHandler.this.skipWrite) {
                                    throw new AssertionError();
                                }
                                if (UpdateMutator.this.isTraceLoggingEnabled()) {
                                    UpdateMutator.this.logTraceInfo(NLS.bind((String)"Skipping write for file {0}.", (Object)DownloadHandler.this.shareable.getFullPath(), (Object[])new Object[0]));
                                }
                                UpdateMutator.read((InputStream)inStream);
                            } else {
                                if (UpdateMutator.this.isTraceLoggingEnabled()) {
                                    UpdateMutator.this.logTraceInfo(NLS.bind((String)"Writing content for file {0}.", (Object)DownloadHandler.this.shareable.getFullPath(), (Object[])new Object[0]));
                                }
                                ContentManager.read((InputStream)inStream, (OutputStream)out);
                            }
                            Shareable shareableUpdated = new Shareable(DownloadHandler.this.shareable.getSandbox().getRoot(), DownloadHandler.this.shareable.getLocalPath(), ResourceType.FILE);
                            DownloadHandler.this.downloadInfo.setContentUpdated(shareableUpdated, ContentHash.valueOf((byte[])inStream.getFinalDigest()), inStream.getContentSize());
                            completed = true;
                            if (out != null) {
                                out.close();
                            }
                        }
                        finally {
                            try {
                                if (out != null) {
                                    out.close();
                                }
                            }
                            catch (IOException iOException) {}
                            if (!completed && !DownloadHandler.this.skipWrite) {
                                UpdateMutator.this.deleteIncompleteFile(DownloadHandler.this.shareable.getFullPath());
                            }
                        }
                    }
                    catch (ContentHashAlgorithmException e) {
                        LoggingHelper.error("com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_39, (Object)DownloadHandler.this.shareable.getFullPath().toString(), (Object[])new Object[0]), e);
                        throw new FileSystemException(NLS.bind((String)Messages.UpdateMutator_37, (Object)DownloadHandler.this.shareable.getFullPath().toString(), (Object[])new Object[0]), e);
                    }
                    catch (SocketException e) {
                        LoggingHelper.error("com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_39, (Object)DownloadHandler.this.shareable.getFullPath().toString(), (Object[])new Object[0]), e);
                        throw new FileSystemException(NLS.bind((String)Messages.UpdateMutator_37, (Object)DownloadHandler.this.shareable.getFullPath().toString(), (Object[])new Object[0]), e);
                    }
                    catch (IOException e) {
                        LoggingHelper.error("com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_39, (Object)DownloadHandler.this.shareable.getFullPath().toString(), (Object[])new Object[0]), e);
                        throw new FileSystemException(NLS.bind((String)Messages.UpdateMutator_38, (Object)DownloadHandler.this.shareable.getFullPath().toString(), (Object[])new Object[0]), e);
                    }
                }
            });
            File localFile = (File)this.shareable.getAdapter(File.class);
            this.downloadInfo.processModificationStamp(localFile);
        }

        @Override
        public void downloadFailed(IFileItemHandle item, IFileContent content, Exception e) {
            this.downloadInfo.setFailure(this.shareable, e);
            if (DeletedContent.isRootCauseDeletedContent(e)) {
                InputStream in = DeletedContent.getDeletedContentInputStream(this.downloadInfo.getEncoding());
                try {
                    this.downloadStreamAcquired(item, content, in);
                    this.downloadInfo.setContentUpdated(content.getHash(), content.getRawLength());
                    this.downloadInfo.setContentDeleted();
                }
                catch (TeamRepositoryException e2) {
                    this.downloadInfo.setFailure(e);
                }
            }
        }

        private void recordBlockedFileContentUpdate() {
            LocalChangeRecorder localChangeRecorder = UpdateMutator.this.getLocalChangeRecorder(this.downloadInfo.getCopyFileArea(), this.downloadInfo.getComponent());
            localChangeRecorder.rememberBlockedFileUpdate(this.shareable, this.downloadInfo.getFileItemState());
        }

        @Override
        protected IKeywordExpansionContext getKeywordExpansionContext(IFileItemHandle handle) {
            if (this.downloadInfo.isExpandKeywords()) {
                return UpdateMutator.this.keywordExpansionContext;
            }
            return null;
        }
    }

    private static class ShareReference {
        protected IComponentHandle component;
        protected IShare share;

        public ShareReference(IComponentHandle component, IShare share) {
            this.component = component;
            this.share = share;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.component == null ? 0 : this.component.getItemId().hashCode());
            result = 31 * result + (this.share.getFullPath() == null ? 0 : this.share.getFullPath().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ShareReference other = (ShareReference)obj;
            if (this.component == null ? other.component != null : !this.component.sameItemId((IItemHandle)other.component)) {
                return false;
            }
            return !(this.share.getFullPath() == null ? other.share.getFullPath() != null : !this.share.getFullPath().equals(other.share.getFullPath()));
        }
    }
}

