/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictRecord;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictTracker;
import com.ibm.team.filesystem.client.internal.utils.VersionableStateCache;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedBufferedInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class LocalChangeRecorder {
    private ISandbox sandbox;
    private LocalConflictTracker conflictTracker;
    private Map<UUID, LocalChangeRecord> changesToReplay = new HashMap<UUID, LocalChangeRecord>();
    private ILocalChange[] localChanges;
    private boolean localChangesReplayed = false;
    private IFileContentMerger merger;
    private final Log log;

    public LocalChangeRecorder(ISandbox sandbox, LocalConflictTracker localConflictTracker, ILocalChange[] pendingChanges) {
        if (sandbox == null) {
            throw new IllegalArgumentException();
        }
        if (localConflictTracker == null) {
            throw new IllegalArgumentException();
        }
        this.sandbox = sandbox;
        this.conflictTracker = localConflictTracker;
        this.localChanges = pendingChanges;
        Log log = LoggingHelper.getLog(LocalChangeRecorder.class);
        this.log = log != null && log.isTraceEnabled() ? log : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalChangeRecord getRecord(IVersionableHandle versionable) {
        Map<UUID, LocalChangeRecord> map = this.changesToReplay;
        synchronized (map) {
            LocalChangeRecord record = this.findExisting(versionable);
            if (record == null) {
                record = new LocalChangeRecord();
                record.setVersionableHandle(versionable);
                this.changesToReplay.put(versionable.getItemId(), record);
            }
            return record;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeRecord findExisting(IVersionableHandle versionable) {
        Map<UUID, LocalChangeRecord> map = this.changesToReplay;
        synchronized (map) {
            return this.changesToReplay.get(versionable.getItemId());
        }
    }

    private ISandbox getSandbox() {
        return this.sandbox;
    }

    private ICopyFileArea getCopyFileArea(ISandbox sandbox) throws FileSystemException {
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(sandbox.getRoot());
        if (cfa == null) {
            throw new FileSystemException(NLS.bind((String)Messages.MergeLoadMutator_25, (Object)sandbox.getRoot().toString()));
        }
        return cfa;
    }

    public void rememberContent(IVersionableHandle versionable, UUID stateId, ContentHash hash, IShareable shareable, FileLineDelimiter fileLineDelimiter, String contentType, Boolean isExecutable, BackupDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        LocalChangeRecord record = this.getRecordForBackupPath(shareable.getLocalPath());
        if (record != null) {
            IRelativeLocation path = shareable.getLocalPath();
            IRelativeLocation backupPath = LocalConflictTracker.getSafeLocation(shareable);
            LocalConflictTracker.backupFile(this.getSandbox(), path, backupPath, (IProgressMonitor)progress.newChild(1));
            record.setBackupPath(backupPath);
            if (this.isTracingEnabled()) {
                this.trace("Adjusting backup path of " + path + " to " + backupPath);
            }
            return;
        }
        record = this.getRecord(versionable);
        record.setVersionableHandle(versionable);
        record.recordContentChange(shareable, stateId, hash, fileLineDelimiter, contentType, isExecutable, (IProgressMonitor)progress.newChild(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalChangeRecord getRecordForBackupPath(IRelativeLocation location) {
        if (LocalConflictTracker.isSafeLocation(location)) {
            Map<UUID, LocalChangeRecord> map = this.changesToReplay;
            synchronized (map) {
                for (LocalChangeRecord record : this.changesToReplay.values()) {
                    if (record.getBackupPath() == null || !record.getBackupPath().equals(location)) continue;
                    return record;
                }
            }
        }
        return null;
    }

    public void rememberBlockedFileUpdate(Shareable shareable, IVersionableHandle versionable) {
        LocalChangeRecord record = this.getRecord(versionable);
        record.setVersionableHandle(versionable);
        record.recordBlockedFileUpdate(shareable);
    }

    public void rememberContentProperties(IVersionableHandle versionable, UUID stateId, ContentHash hash, Shareable shareable, FileLineDelimiter fileLineDelimiter, String contentType, Boolean isExecutable) {
        LocalChangeRecord record = this.getRecord(versionable);
        record.setVersionableHandle(versionable);
        record.recordContentProperties(shareable, stateId, hash, fileLineDelimiter, contentType, isExecutable);
    }

    public void rememberMove(FileAreaUpdate update, ILocalChange localChange, Shareable shareable, IProgressMonitor monitor) {
        LocalChangeRecord record = this.getRecord(localChange.getTarget());
        String name = shareable.getLocalPath().getName();
        if (record.isPreservedAfterCollision()) {
            name = record.getLocalPath().getName();
            record.clearSubtreeBackupInformation();
        } else {
            name = shareable.getLocalPath().getName();
        }
        record.setLocalPath(localChange.getOriginalPath());
        record.setAfterPath(localChange.getPath().getParent());
        if (!name.equals(localChange.getOriginalPath().getName())) {
            record.recordRename(localChange.getOriginalPath().getName(), name);
        }
        if (localChange.getTargetParent() != null) {
            FileItemInfo existingInfo;
            try {
                existingInfo = shareable.getFileItemInfo(monitor);
            }
            catch (FileSystemException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                existingInfo = null;
            }
            record.recordMove(existingInfo == null ? update.parent() : existingInfo.getParent(), localChange.getTargetParent());
        }
    }

    public void rememberDeletion(IRelativeLocation path, IVersionableHandle item) {
        LocalChangeRecord change = this.getRecord(item);
        change.setLocalPath(path);
        change.setDeletion(true);
    }

    public void rememberPropertyChanges(Shareable shareable, IVersionableHandle item, UUID stateId, Map<String, String> originalProperties, Map<String, String> changedProperties, Set<String> removedProperties) {
        LocalChangeRecord change = this.getRecord(item);
        change.recordPropertyChange(shareable.getLocalPath(), stateId, originalProperties, changedProperties, removedProperties);
    }

    public void rememberLinkChanges(Shareable shareable, IVersionableHandle item, UUID stateId, String localTarget, boolean localIsDirectoryLink, ContentHash hash) {
        LocalChangeRecord change = this.getRecord(item);
        change.setLocalPath(shareable.getLocalPath());
        change.recordLinkChanges(stateId, localTarget, localIsDirectoryLink, hash);
    }

    public void preserveSubtree(IVersionableHandle versionable, IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        IFileStorage fs = ((IShareableInternal)shareable).getFileStorage();
        IRelativeLocation originalLocation = shareable.getLocalPath();
        IRelativeLocation newLocation = LocalConflictTracker.getSafeLocation(shareable);
        fs.move(shareable.getSandbox(), newLocation, monitor);
        if (versionable == null) {
            LocalChangeRecord recordForBackupPath = this.getRecordForBackupPath(originalLocation);
            if (recordForBackupPath != null) {
                recordForBackupPath.setBackupPath(newLocation);
                this.trace("Previously moved folder moved from " + originalLocation + " to " + newLocation + " to avoid overwrite.");
            } else if (this.isTracingEnabled()) {
                this.trace("Unshared folder moved from " + originalLocation + " to " + newLocation + " to avoid overwrite.");
            }
        } else {
            LocalChangeRecord change = this.getRecord(versionable);
            change.recordSubtreeBackup(originalLocation, newLocation);
            if (this.isTracingEnabled()) {
                this.trace("Subtree " + originalLocation + " backed up to " + newLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LocalChangeRecord> getChangesToReplay() {
        Map<UUID, LocalChangeRecord> map = this.changesToReplay;
        synchronized (map) {
            ArrayList<LocalChangeRecord> result = new ArrayList<LocalChangeRecord>();
            for (LocalChangeRecord record : this.changesToReplay.values()) {
                result.add(record);
            }
            return result;
        }
    }

    private IShareable findShareable(IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        return this.getSandbox().findShareable(this.conflictTracker.getContext().getConnection(), this.conflictTracker.getContext().getComponent(), versionable, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public IStatus performAutoResolve(Shed shed, IProgressMonitor monitor) {
        block35: {
            changes = this.getChangesToReplay();
            if (changes.isEmpty()) {
                return Status.OK_STATUS;
            }
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(changes.size() * 2));
            sandbox = this.getSandbox();
            shareablesMap = new HashMap<UUID, IShareable>();
            exceptions = new HashMap<UUID, Throwable>();
            for (LocalChangeRecord record : changes) {
                try {
                    shareable = this.findShareable(record.getVersionableHandle(), (IProgressMonitor)progress.newChild(1));
                    shareablesMap.put(record.getVersionableHandle().getItemId(), shareable);
                }
                catch (Throwable e) {
                    exceptions.put(record.getVersionableHandle().getItemId(), e);
                }
            }
            if (shareablesMap.isEmpty()) {
                return this.asStatus(exceptions);
            }
            stateCache = null;
            performMerge = new ArrayList<LocalChangeRecord>();
            for (LocalChangeRecord record : changes) {
                itemId = record.getVersionableHandle().getItemId();
                shareable = (IShareable)shareablesMap.get(itemId);
                if (shareable == null || !record.isModify()) continue;
                try {
                    success = record.replayModification(shareable, this.conflictTracker.getContext().getConnection(), this.conflictTracker.getContext().getComponent(), shed, progress.newChild(1));
                    if (success || !record.isContentChange()) continue;
                    if (stateCache == null) {
                        sharingDescriptor = shareable.getShare((IProgressMonitor)progress.newChild(1)).getSharingDescriptor();
                        repository = IRepositoryResolver.EXISTING_SHARED.getRepoFor(null, sharingDescriptor.getRepositoryId());
                        manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                        stateCache = new VersionableStateCache(manager);
                    }
                    performMerge.add(record);
                    stateCache.add(record.getVersionableHandle());
                    if (record.getBeforeStateId() == null) continue;
                    stateCache.add(record.getCommonAncestor());
                }
                catch (Throwable e) {
                    if (exceptions.get(itemId) != null) continue;
                    exceptions.put(itemId, e);
                }
            }
            movesAndRenames = new HashMap<UUID, LocalChangeRecord>();
            for (LocalChangeRecord record : changes) {
                itemId = record.getVersionableHandle().getItemId();
                shareable = (IShareable)shareablesMap.get(itemId);
                if (shareable == null || !record.isMoveOrRename()) continue;
                movesAndRenames.put(itemId, record);
            }
            needAnotherPass = movesAndRenames.isEmpty() == false;
            moveExceptions = new HashMap<UUID, Throwable>();
            while (needAnotherPass) {
                needAnotherPass = false;
                changeWasResolved = false;
                changeFailed = false;
                toTry = new HashSet<K>(movesAndRenames.keySet());
                for (UUID uuid : toTry) {
                    record = (LocalChangeRecord)movesAndRenames.get(uuid);
                    shareable = (IShareable)shareablesMap.get(uuid);
                    try {
                        success = record.replayStructuralChange(shareable, this.conflictTracker.getContext().getConnection(), this.conflictTracker.getContext().getComponent(), shed, progress.newChild(1));
                        moveExceptions.remove(uuid);
                        if (success) {
                            changeWasResolved = true;
                            movesAndRenames.remove(uuid);
                            shareable = sandbox.findShareable(this.conflictTracker.getContext().getConnection(), this.conflictTracker.getContext().getComponent(), record.getVersionableHandle(), (IProgressMonitor)progress.newChild(1));
                            shareablesMap.put(record.getVersionableHandle().getItemId(), shareable);
                            continue;
                        }
                        changeFailed = true;
                    }
                    catch (Throwable e) {
                        changeFailed = true;
                        moveExceptions.put(uuid, e);
                    }
                }
                needAnotherPass = changeWasResolved & changeFailed;
            }
            if (!moveExceptions.isEmpty()) {
                for (Map.Entry<K, V> entry : moveExceptions.entrySet()) {
                    if (exceptions.get(entry.getKey()) != null) continue;
                    exceptions.put((UUID)entry.getKey(), (Throwable)entry.getValue());
                }
            }
            for (LocalChangeRecord record : changes) {
                if (!record.isDeletion()) continue;
                itemId = record.getVersionableHandle().getItemId();
                shareable = (IShareable)shareablesMap.get(itemId);
                try {
                    if (shareable == null) continue;
                    record.replayStructuralChange(shareable, this.conflictTracker.getContext().getConnection(), this.conflictTracker.getContext().getComponent(), shed, progress.newChild(1));
                }
                catch (Throwable e) {
                    if (exceptions.get(itemId) != null) continue;
                    exceptions.put(itemId, e);
                }
            }
            if (!performMerge.isEmpty()) {
                try {
                    stateCache.populate((IProgressMonitor)progress.newChild(1));
                    for (LocalChangeRecord record : performMerge) {
                        itemId = record.getVersionableHandle().getItemId();
                        try {
                            shareable = (IShareable)shareablesMap.get(itemId);
                            sharingDescriptor = shareable.getShare((IProgressMonitor)progress.newChild(1)).getSharingDescriptor();
                            repository = IRepositoryResolver.EXISTING_SHARED.getRepoFor(null, sharingDescriptor.getRepositoryId());
                            proposedItem = (IFileItem)stateCache.getVersionable(record.getVersionableHandle());
                            if (proposedItem == null) {
                                throw new FileSystemException(NLS.bind((String)Messages.LocalConflictTracker_0, (Object)shareable.getLocalPath()));
                            }
                            if (sharingDescriptor == null) continue;
                            if (record.getBeforeStateId() == null) {
                                if (LocalChangeManager.getInstance().isContentDirty(shareable, (IProgressMonitor)progress.newChild(1)) || (conflict = this.conflictTracker.getConflict(record.getVersionableHandle())) == null) continue;
                                conflict.setModificationConflict(false);
                                if (!conflict.isComplete()) continue;
                                this.conflictTracker.remove(record.getVersionableHandle());
                                continue;
                            }
                            commonAncestorItem = (IFileItem)stateCache.getVersionable(record.getCommonAncestor());
                            if (commonAncestorItem == null) {
                                throw new FileSystemException(NLS.bind((String)Messages.LocalConflictTracker_1, (Object)shareable.getLocalPath()));
                            }
                            status = this.getFileContentMerger().performAutoMerge(repository, commonAncestorItem, proposedItem, shareable, null, shed, (IProgressMonitor)progress.newChild(1));
                            if (!status.isOK()) continue;
                            conflict = this.conflictTracker.getConflict(record.getVersionableHandle());
                            if (conflict != null) {
                                conflict.setModificationConflict(false);
                                if (conflict.isComplete()) {
                                    this.conflictTracker.remove(record.getVersionableHandle());
                                }
                            }
                            if ((lineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(1))).equals((Object)FileLineDelimiter.LINE_DELIMITER_PLATFORM) || lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE) || lineDelimiter.equals((Object)FileLineDelimiter.getPlatformDelimiter())) continue;
                            try {
                                this.getFileContentMerger().convertLineDelimiter(shareable, proposedItem, lineDelimiter, shed, (IProgressMonitor)progress.newChild(1));
                            }
                            catch (Exception e) {
                                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                            }
                        }
                        catch (Throwable e) {
                            if (exceptions.get(itemId) != null) continue;
                            exceptions.put(itemId, e);
                        }
                    }
                    break block35;
                }
                catch (Throwable e) {
                    ** for (localConflictRecord : performMerge)
                }
lbl-1000:
                // 1 sources

                {
                    itemId = localConflictRecord.getVersionableHandle().getItemId();
                    if (exceptions.get(itemId) != null) continue;
                    exceptions.put(itemId, e);
                    continue;
                }
            }
        }
        if (!exceptions.isEmpty()) {
            return this.asStatus(exceptions);
        }
        return Status.OK_STATUS;
    }

    private IStatus asStatus(Map<UUID, Throwable> exceptions) {
        if (exceptions.size() == 1) {
            return FileSystemStatusUtil.getStatusFor(exceptions.values().iterator().next());
        }
        IStatus[] children = new IStatus[exceptions.size()];
        int i = 0;
        for (Throwable t : exceptions.values()) {
            children[i++] = FileSystemStatusUtil.getStatusFor(t);
        }
        return new MultiStatus("com.ibm.team.filesystem.client", 0, children, Messages.LocalConflictTracker_2, null);
    }

    public boolean isLocalChangesReplayed() {
        return this.localChangesReplayed;
    }

    public IStatus replayLocalChanges(Shed shed, IProgressMonitor progress) {
        if (!this.isLocalChangesReplayed()) {
            try {
                IStatus iStatus = this.performAutoResolve(shed, progress);
                return iStatus;
            }
            finally {
                this.localChangesReplayed = true;
            }
        }
        return Status.OK_STATUS;
    }

    public ILocalChange getLocalChange(IVersionableHandle item) {
        if (this.localChanges != null) {
            ILocalChange[] iLocalChangeArray = this.localChanges;
            int n = this.localChanges.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange localChange = iLocalChangeArray[n2];
                if (localChange.getTarget().sameItemId((IItemHandle)item)) {
                    return localChange;
                }
                ++n2;
            }
        }
        return null;
    }

    public ILocalChange getLocalContentChange(IVersionableHandle item) {
        ILocalChange localChange = this.getLocalChange(item);
        if (localChange != null && !localChange.isType(1)) {
            localChange = null;
        }
        return localChange;
    }

    public boolean hasLocalContentChange(IShareable shareable, SubMonitor subMonitor) throws FileSystemException {
        if (this.localChanges == null) {
            return false;
        }
        IVersionableHandle remote = shareable.getRemote((IProgressMonitor)subMonitor);
        if (remote == null) {
            return true;
        }
        return this.getLocalContentChange(remote) != null;
    }

    public boolean containsLocalChange(IShareable shareable, SubMonitor progress) throws FileSystemException {
        progress.setWorkRemaining(2);
        return this.hasLocalContentChange(shareable, progress.newChild(1)) || this.isBackupFile(shareable) || this.hasDescendantLocalChanges(shareable, true, (IProgressMonitor)progress.newChild(1));
    }

    private boolean isBackupFile(IShareable shareable) {
        return LocalConflictTracker.isSafeLocation(shareable.getLocalPath());
    }

    public boolean hasDescendantLocalChanges(IShareable shareable, final boolean contentOnly, IProgressMonitor progress) {
        final boolean[] haveLocalChange = new boolean[1];
        try {
            ((Shareable)shareable).accept(new IShareableVisitor(){

                @Override
                public boolean visit(IShareable shareable, IProgressMonitor monitor) {
                    block5: {
                        try {
                            IVersionableHandle remote = shareable.getRemote(monitor);
                            if (remote == null) break block5;
                            ILocalChange localChange = contentOnly ? LocalChangeRecorder.this.getLocalContentChange(remote) : LocalChangeRecorder.this.getLocalChange(remote);
                            if (localChange != null) {
                                haveLocalChange[0] = true;
                                return false;
                            }
                            return true;
                        }
                        catch (FileSystemException e) {
                            LoggingHelper.log("com.ibm.team.filesystem.client", e);
                            haveLocalChange[0] = true;
                            return false;
                        }
                    }
                    if (!shareable.shouldBeIgnored(monitor)) {
                        haveLocalChange[0] = true;
                        return false;
                    }
                    return true;
                }

                @Override
                public IComponentHandle getComponent() {
                    return LocalChangeRecorder.this.conflictTracker.getContext().getComponent();
                }
            }, Integer.MAX_VALUE, true, true, progress);
        }
        catch (FileSystemException e) {
            LoggingHelper.log("com.ibm.team.filesystem.client", e);
            return true;
        }
        return haveLocalChange[0];
    }

    public IComponentHandle getComponent() {
        return this.conflictTracker.getContext().getComponent();
    }

    public void setFileContentMerger(IFileContentMerger merger) {
        this.merger = merger;
    }

    private IFileContentMerger getFileContentMerger() {
        return this.merger;
    }

    private void trace(String string) {
        if (this.log != null) {
            this.log.trace((Object)string);
        }
    }

    private boolean isTracingEnabled() {
        return this.log != null && this.log.isTraceEnabled();
    }

    public void updatePendingChanges(ILocalChange[] pendingChanges) {
        ILocalChange lc;
        ArrayList<ILocalChange> newLocalChanges = new ArrayList<ILocalChange>();
        HashSet<UUID> affectedItemIds = new HashSet<UUID>();
        ILocalChange[] iLocalChangeArray = pendingChanges;
        int n = pendingChanges.length;
        int n2 = 0;
        while (n2 < n) {
            lc = iLocalChangeArray[n2];
            newLocalChanges.add(lc);
            if (lc.getTarget() != null) {
                affectedItemIds.add(lc.getTarget().getItemId());
            }
            ++n2;
        }
        iLocalChangeArray = this.localChanges;
        n = this.localChanges.length;
        n2 = 0;
        while (n2 < n) {
            lc = iLocalChangeArray[n2];
            if (lc.getTarget() == null || !affectedItemIds.contains(lc.getTarget().getItemId())) {
                newLocalChanges.add(lc);
                if (lc.getTarget() != null) {
                    affectedItemIds.add(lc.getTarget().getItemId());
                }
            }
            ++n2;
        }
        this.localChanges = newLocalChanges.toArray(new ILocalChange[newLocalChanges.size()]);
    }

    protected class LocalChangeRecord {
        private IVersionableHandle versionableHandle;
        private IRelativeLocation localPath;
        private IRelativeLocation afterPath;
        private IRelativeLocation backupPath;
        private boolean preservedAfterCollision;
        private UUID beforeStateId;
        private ContentHash hash;
        private boolean isContentChange;
        private boolean isBlockedContentUpdate;
        private String linkTarget;
        private boolean isDirectoryLink;
        private Map<String, String> originalProperties;
        private Set<String> removedProperties;
        private Map<String, String> changedProperties;
        private String beforeName;
        private String afterName;
        private IFolderHandle beforeParent;
        private IFolderHandle afterParent;
        private FileLineDelimiter fileLineDelimiter;
        private String contentType;
        private Boolean isExecutable;
        private boolean isDeletion;

        protected LocalChangeRecord() {
        }

        public void setLocalPath(IRelativeLocation path) {
            this.localPath = path;
        }

        public IRelativeLocation getLocalPath() {
            return this.localPath;
        }

        public void setBeforeStateId(UUID stateId) {
            this.beforeStateId = stateId;
        }

        public UUID getBeforeStateId() {
            return this.beforeStateId;
        }

        public void setAfterPath(IRelativeLocation path) {
            this.afterPath = path;
        }

        protected void setBackupPath(IRelativeLocation backupPath) {
            this.backupPath = backupPath;
        }

        protected IRelativeLocation getBackupPath() {
            return this.backupPath;
        }

        public boolean hasPreservedFile() {
            return this.backupPath != null && !this.backupPath.isEmpty();
        }

        protected void recordContentChange(IShareable shareable, UUID stateId, ContentHash hash, FileLineDelimiter fileLineDelimiter, String contentType, Boolean isExecutable, IProgressMonitor monitor) throws FileSystemException {
            IRelativeLocation path = shareable.getLocalPath();
            IRelativeLocation backupPath = LocalConflictTracker.getSafeLocation(shareable);
            LocalConflictTracker.backupFile(LocalChangeRecorder.this.getSandbox(), path, backupPath, monitor);
            this.setLocalPath(path);
            this.setBackupPath(backupPath);
            if (this.hasExistingConflict()) {
                this.setBeforeStateId(this.getBeforeStateIdFromConflict());
            } else {
                this.setBeforeStateId(stateId);
                this.setContentHash(hash);
            }
            this.setContentChange(true);
            this.setFileProperties(fileLineDelimiter, contentType, isExecutable);
            if (LocalChangeRecorder.this.isTracingEnabled()) {
                LocalChangeRecorder.this.trace("File " + path + " backed up to " + backupPath);
            }
        }

        public void recordContentProperties(Shareable shareable, UUID stateId, ContentHash hash, FileLineDelimiter fileLineDelimiter, String contentType, Boolean isExecutable) {
            IRelativeLocation path = shareable.getLocalPath();
            this.setLocalPath(path);
            if (this.hasExistingConflict()) {
                this.setBeforeStateId(this.getBeforeStateIdFromConflict());
            } else {
                this.setBeforeStateId(stateId);
                this.setContentHash(hash);
            }
            this.setFileProperties(fileLineDelimiter, contentType, isExecutable);
        }

        public void recordBlockedFileUpdate(Shareable shareable) {
            this.isBlockedContentUpdate = true;
        }

        protected void recordRename(String beforeName, String afterName) {
            this.beforeName = beforeName;
            this.afterName = afterName;
        }

        protected void recordMove(IFolderHandle beforeParent, IFolderHandle afterParent) {
            this.beforeParent = beforeParent;
            this.afterParent = afterParent;
        }

        protected void recordPropertyChange(IRelativeLocation path, UUID stateId, Map<String, String> originalProperties, Map<String, String> changedProperties, Set<String> removedProperties) {
            this.setLocalPath(path);
            if (this.hasExistingConflict()) {
                this.setBeforeStateId(this.getBeforeStateIdFromConflict());
            } else {
                this.setBeforeStateId(stateId);
            }
            this.originalProperties = originalProperties;
            this.changedProperties = changedProperties;
            this.removedProperties = removedProperties;
        }

        private boolean hasExistingConflict() {
            LocalConflictRecord conflict = LocalChangeRecorder.this.conflictTracker.getConflict(this.versionableHandle);
            return conflict != null;
        }

        private UUID getBeforeStateIdFromConflict() {
            LocalConflictRecord conflict = LocalChangeRecorder.this.conflictTracker.getConflict(this.versionableHandle);
            if (conflict != null) {
                return conflict.getBeforeStateId();
            }
            return null;
        }

        protected void recordLinkChanges(UUID stateId, String target, boolean isDirectory, ContentHash hash) {
            if (this.hasExistingConflict()) {
                this.setBeforeStateId(this.getBeforeStateIdFromConflict());
            } else {
                this.setBeforeStateId(stateId);
                this.setContentHash(hash);
            }
            this.linkTarget = target;
            this.isDirectoryLink = isDirectory;
        }

        protected void recordSubtreeBackup(IRelativeLocation originalLocation, IRelativeLocation newLocation) {
            this.preservedAfterCollision = true;
            this.setLocalPath(originalLocation);
            this.setBackupPath(newLocation);
        }

        public void clearSubtreeBackupInformation() {
            this.setBackupPath(null);
            this.preservedAfterCollision = false;
        }

        public void setFileProperties(FileLineDelimiter fileLineDelimiter, String contentType, Boolean isExecutable) {
            this.fileLineDelimiter = fileLineDelimiter;
            this.contentType = contentType;
            this.isExecutable = isExecutable;
        }

        public boolean isTargetChange() {
            return this.linkTarget != null;
        }

        public boolean replayModification(IShareable shareable, IContextHandle connectionHandle, IComponentHandle component, Shed shed, SubMonitor progress) throws FileSystemException {
            boolean complete = true;
            FileSystemException exception = null;
            try {
                if (this.isContentChange()) {
                    if (!this.restoreFileContent(shareable, (IProgressMonitor)progress.newChild(1))) {
                        complete = false;
                    }
                } else if (this.isTargetChange()) {
                    if (!this.replayTargetChange(shed, LocalChangeRecorder.this.sandbox, shareable, connectionHandle, component, progress.newChild(1))) {
                        complete = false;
                    }
                } else if (this.isBlockedContentUpdate) {
                    this.restoreFileProperties(shareable, progress);
                    complete = false;
                }
            }
            catch (FileSystemException e) {
                exception = e;
                complete = false;
            }
            if (this.isPropertyChange()) {
                try {
                    if (!this.replayPropertyChange(shareable, connectionHandle, component, (IProgressMonitor)progress.newChild(1))) {
                        complete = false;
                    }
                }
                catch (FileSystemException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    complete = false;
                }
            }
            if (exception != null) {
                throw exception;
            }
            if (!complete) {
                this.getLocalConflict().setModificationConflict(!complete);
            }
            return complete;
        }

        public boolean replayStructuralChange(IShareable shareable, IContextHandle connectionHandle, IComponentHandle component, Shed shed, SubMonitor progress) throws FileSystemException {
            if (this.isDeletion()) {
                return this.replayDelete(shareable, shed, progress);
            }
            if (this.isMoveOrRename()) {
                return this.replayMove(shareable, connectionHandle, component, shed, progress);
            }
            return true;
        }

        private boolean restoreFileContent(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
            IRelativeLocation backupPath = this.getBackupPath();
            if (backupPath == null) {
                LocalConflictRecord existing = LocalChangeRecorder.this.conflictTracker.findExisting(this.versionableHandle);
                return existing != null && !existing.isModificationConflict();
            }
            IRelativeLocation path = this.getLocalPath();
            Shareable backupShareable = (Shareable)LocalChangeRecorder.this.sandbox.findShareable(backupPath, ResourceType.FILE);
            if (shareable.exists((IProgressMonitor)progress.newChild(1))) {
                if (!backupShareable.getFileStorage().exists((IProgressMonitor)progress.newChild(1))) {
                    IFileStorage storage = SharingManager.getInstance().getLocalFileStorage(shareable.getSandbox(), backupPath, ResourceType.FILE);
                    backupShareable = storage.getShareable();
                    if (LocalChangeRecorder.this.isTracingEnabled()) {
                        LocalChangeRecorder.this.trace("Backup at " + backupPath + " accessed through local storage");
                    }
                }
                if (backupShareable.exists((IProgressMonitor)progress.newChild(1))) {
                    FileItemInfo itemInfo = this.restoreFileProperties(shareable, progress);
                    BackupDilemmaHandler handler = new BackupDilemmaHandler(){

                        @Override
                        public boolean backupEnabled() {
                            return false;
                        }
                    };
                    Shed backupShed = new Shed(handler);
                    try {
                        UnsynchronizedBufferedInputStream stream = new UnsynchronizedBufferedInputStream((InputStream)new FileInputStream((File)LocalChangeRecorder.this.sandbox.getRoot().append(backupPath).getAdapter(File.class)));
                        FileOptions options = new FileOptions(true, (Shareable)shareable, (IProgressMonitor)progress.newChild(1));
                        ((Shareable)shareable).getFileStorage().setContents(options, (InputStream)stream, backupShed, (IProgressMonitor)progress.newChild(1));
                        backupShareable.getFileStorage().delete(backupShed, (IProgressMonitor)progress.newChild(1));
                        this.setBackupPath(null);
                        boolean complete = false;
                        if (this.hash != null) {
                            boolean bl = complete = itemInfo != null && itemInfo.getHash() != null && itemInfo.getHash().equals((Object)this.hash);
                        }
                        if (LocalChangeRecorder.this.isTracingEnabled()) {
                            if (complete) {
                                LocalChangeRecorder.this.trace("File at " + path + " restored from backup with no conflict");
                            } else {
                                LocalChangeRecorder.this.trace("File at " + path + " restored from backup and local conflict requested");
                            }
                        }
                        return complete;
                    }
                    catch (FileSystemException e) {
                        if (this.isBlockedContentUpdate) {
                            backupShareable.getFileStorage().delete(backupShed, (IProgressMonitor)progress.newChild(1));
                            this.setBackupPath(null);
                            if (LocalChangeRecorder.this.isTracingEnabled()) {
                                LocalChangeRecorder.this.trace("Restoring file at " + path + " from backup blocked.");
                            }
                            return false;
                        }
                        throw e;
                    }
                    catch (FileNotFoundException e) {
                        throw new FileSystemException(e);
                    }
                }
                throw new FileSystemException(NLS.bind((String)Messages.LocalConflictRecord_0, (Object)backupShareable.getFullPath().toString()));
            }
            if (backupShareable.exists((IProgressMonitor)progress.newChild(1))) {
                backupShareable.getFileStorage().move(LocalChangeRecorder.this.sandbox, path, (IProgressMonitor)progress.newChild(1));
                this.setBackupPath(null);
                if (LocalChangeRecorder.this.isTracingEnabled()) {
                    LocalChangeRecorder.this.trace("Missing file at " + path + " restored from backup");
                }
                return true;
            }
            throw new FileSystemException(NLS.bind((String)Messages.LocalConflictRecord_0, (Object)backupShareable.getFullPath().toString()));
        }

        private FileItemInfo restoreFileProperties(IShareable shareable, SubMonitor progress) throws FileSystemException {
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(LocalChangeRecorder.this.sandbox.getRoot());
            FileItemInfo itemInfo = cfa.getItemInfo(shareable.getLocalPath());
            if (this.fileLineDelimiter != null) {
                FileItemInfoProxy newInfo = new FileItemInfoProxy(itemInfo);
                newInfo.changeProperties(itemInfo.isContentChanged(), itemInfo.getLastContentChangeCheckStamp(), this.fileLineDelimiter, this.contentType, this.isExecutable);
                cfa.setItemMetaData(shareable.getLocalPath(), newInfo.getFileItemInfo(), ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(1));
            }
            return itemInfo;
        }

        private boolean replayTargetChange(Shed shed, ISandbox sandbox, IShareable shareable, IContextHandle connectionHandle, IComponentHandle component, SubMonitor progress) throws FileSystemException {
            ICopyFileArea cfa;
            FileItemInfo itemInfo;
            IFileStorage fileStorage = ((IShareableInternal)shareable).getFileStorage();
            LinkInfo linkInfo = fileStorage.getLinkInfo((IProgressMonitor)progress);
            fileStorage.setTarget(shed, this.linkTarget, this.isDirectoryLink, (IProgressMonitor)progress);
            if (this.hash != null && (itemInfo = (cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(sandbox.getRoot())).getItemInfo(shareable.getLocalPath())) != null && itemInfo.getHash() != null && itemInfo.getHash().equals((Object)this.hash)) {
                return true;
            }
            return linkInfo != null && linkInfo.getTarget().equals(this.linkTarget) && linkInfo.getType() == LinkType.DIRECTORY == this.isDirectoryLink;
        }

        private boolean replayPropertyChange(IShareable shareable, IContextHandle connectionHandle, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            IMetadataProperties metadataProperties = shareable.getMetadataProperties((IProgressMonitor)progress.newChild(1));
            Map<String, String> currentProperties = metadataProperties.getOriginalProperties();
            HashMap<String, String> newProperties = new HashMap<String, String>(currentProperties);
            boolean allGood = true;
            HashMap<String, String> changesToRemember = new HashMap<String, String>();
            HashSet<String> removalsToRemember = new HashSet<String>();
            for (Map.Entry<String, String> entry : this.changedProperties.entrySet()) {
                String property = entry.getKey();
                String local = entry.getValue();
                if (local == null) continue;
                String original = this.originalProperties.get(property);
                String current = currentProperties.get(property);
                newProperties.put(property, local);
                if (original == current || original != null && current != null && current.equals(original) || current != null && current.equals(local)) continue;
                changesToRemember.put(property, local);
                allGood = false;
            }
            for (String property : this.removedProperties) {
                String current;
                String original = this.originalProperties.get(property);
                if (original == null || (current = currentProperties.get(property)) == null) continue;
                newProperties.remove(property);
                if (current.equals(original)) continue;
                removalsToRemember.add(property);
                allGood = false;
            }
            MetadataProperties propertyUpdate = new MetadataProperties(currentProperties, newProperties);
            LocalChangeRecorder.this.getCopyFileArea(LocalChangeRecorder.this.sandbox).setProperties(connectionHandle, component, this.versionableHandle, propertyUpdate, (IProgressMonitor)progress.newChild(1));
            this.changedProperties = changesToRemember;
            this.removedProperties = removalsToRemember;
            if (!allGood) {
                this.getLocalConflict().setPropertyConflict(!allGood);
            }
            return allGood;
        }

        public void setContentHash(ContentHash hash) {
            this.hash = hash;
        }

        public boolean isPreservedAfterCollision() {
            return this.preservedAfterCollision;
        }

        private boolean replayDelete(IShareable shareable, Shed shed, SubMonitor progress) throws FileSystemException {
            progress.setWorkRemaining(2);
            if (this.isDeletion() && shareable.exists((IProgressMonitor)progress.newChild(1))) {
                IFileStorage fileStorage = ((IShareableInternal)shareable).getFileStorage();
                fileStorage.delete(shed, (IProgressMonitor)progress.newChild(1));
            }
            return true;
        }

        private boolean replayMove(IShareable shareable, IContextHandle connectionHandle, IComponentHandle component, Shed shed, SubMonitor monitor) throws FileSystemException {
            boolean isConflict;
            String name;
            IShareable parentShareable;
            monitor.setWorkRemaining(10);
            if (!shareable.exists((IProgressMonitor)monitor.newChild(1))) {
                return false;
            }
            boolean reparentConflict = false;
            if (this.afterParent == null) {
                parentShareable = ((Shareable)shareable).getParent();
            } else {
                IVersionableHandle currentParent;
                parentShareable = LocalChangeRecorder.this.sandbox.findShareable(connectionHandle, component, (IVersionableHandle)this.afterParent, (IProgressMonitor)monitor.newChild(1));
                if (((Shareable)shareable).getParent() != null && (currentParent = ((Shareable)shareable).getParent().getRemote((IProgressMonitor)monitor.newChild(1))) != null) {
                    boolean bl = reparentConflict = !currentParent.sameItemId((IItemHandle)this.beforeParent);
                }
            }
            if (parentShareable == null || !parentShareable.exists((IProgressMonitor)monitor.newChild(1))) {
                if (this.afterPath == null) {
                    return false;
                }
                parentShareable = LocalChangeRecorder.this.sandbox.findShareable(this.afterPath, ResourceType.FOLDER);
                ((IShareableInternal)parentShareable).getFileStorage().create(true, null, (IProgressMonitor)monitor.newChild(1));
            }
            boolean renameConflict = false;
            if (this.afterName == null) {
                name = shareable.getLocalPath().getName();
            } else {
                name = this.afterName;
                renameConflict = !shareable.getLocalPath().getName().equals(this.beforeName);
            }
            IFileStorage fileStorage = ((IShareableInternal)shareable).getFileStorage();
            IRelativeLocation newPath = parentShareable.getLocalPath().append(name);
            IShareable targetShareable = LocalChangeRecorder.this.sandbox.findShareable(newPath, shareable.getResourceType((IProgressMonitor)monitor.newChild(1)));
            IVersionableHandle deletedDuringReplay = null;
            if (targetShareable.exists((IProgressMonitor)monitor.newChild(1))) {
                IFileStorage targetFileStorage = ((IShareableInternal)targetShareable).getFileStorage();
                deletedDuringReplay = targetShareable.getVersionable((IProgressMonitor)monitor.newChild(1));
                targetFileStorage.delete(shed, (IProgressMonitor)monitor.newChild(1));
            }
            fileStorage.move(LocalChangeRecorder.this.sandbox, newPath, (IProgressMonitor)monitor.newChild(1));
            this.setLocalPath(newPath);
            LocalConflictRecord existing = this.getLocalConflict(false);
            if (existing != null) {
                existing.setLocalPath(newPath);
            }
            if (!renameConflict) {
                this.beforeName = null;
                this.afterName = null;
            }
            if (!reparentConflict) {
                this.beforeParent = null;
                this.afterParent = null;
            }
            boolean bl = isConflict = renameConflict || reparentConflict || deletedDuringReplay != null;
            if (isConflict) {
                this.getLocalConflict().setDeletedDuringReplay(deletedDuringReplay);
                this.getLocalConflict().setMoveOrRenameConflict(isConflict);
            }
            return !isConflict;
        }

        public boolean isContentChange() {
            return this.isContentChange;
        }

        public void setContentChange(boolean isContentChange) {
            this.isContentChange = isContentChange;
        }

        public boolean isDeletion() {
            return this.isDeletion;
        }

        public void setDeletion(boolean isDeletion) {
            this.isDeletion = isDeletion;
        }

        public boolean isPropertyChange() {
            return this.changedProperties != null && !this.changedProperties.isEmpty() || this.removedProperties != null && !this.removedProperties.isEmpty();
        }

        public boolean isModify() {
            return this.isTargetChange() || this.isContentChange() || this.isPropertyChange() || this.isBlockedContentUpdate;
        }

        public boolean isMoveOrRename() {
            return this.afterName != null || this.afterParent != null;
        }

        public boolean isStructuralChange() {
            return this.isMoveOrRename() || this.isDeletion();
        }

        private LocalConflictRecord getLocalConflict() {
            return this.getLocalConflict(true);
        }

        private LocalConflictRecord getLocalConflict(boolean createIfMissing) {
            LocalConflictRecord conflict = LocalChangeRecorder.this.conflictTracker.getConflict(this.versionableHandle);
            if (!createIfMissing) {
                return conflict;
            }
            if (conflict == null) {
                conflict = LocalChangeRecorder.this.conflictTracker.createConflict(this.versionableHandle, this.localPath);
            }
            if (conflict.getBeforeStateId() == null) {
                conflict.setBeforeStateId(this.beforeStateId);
            }
            if (conflict.isDeletion() != this.isDeletion()) {
                conflict.setDeletion(this.isDeletion());
            }
            if (!conflict.isContentChange() && this.isContentChange()) {
                conflict.setContentChange(this.isContentChange());
            }
            if (this.versionableHandle.getStateId() != null && !conflict.getVersionableHandle().sameStateId((IItemHandle)this.versionableHandle)) {
                conflict.setVersionableHandle(this.versionableHandle);
            }
            return conflict;
        }

        public void setVersionableHandle(IVersionableHandle versionable) {
            this.versionableHandle = versionable;
        }

        public IVersionableHandle getVersionableHandle() {
            return this.versionableHandle;
        }

        public IVersionableHandle getCommonAncestor() {
            if (this.getVersionableHandle() != null && this.getBeforeStateId() != null) {
                return (IVersionableHandle)this.getVersionableHandle().getItemType().createItemHandle(this.getVersionableHandle().getItemId(), this.getBeforeStateId());
            }
            return null;
        }
    }
}

