/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.ILoadRuleFactory;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.LoadRule;
import com.ibm.team.filesystem.client.internal.load.loadRules.LoadRuleHandler;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.XMLUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class LoadRuleFactory
implements ILoadRuleFactory {
    private static final String SAX_PROPERTIES_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private static final String SAX_FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    private static final String SAX_FEATURES_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String SAX_FEATURES_INCLUDE_XMLNS_ATTRIBUTE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String LOAD_RULE_SCHEMA_LOCATION_PREFIX = "http://com.ibm.team.scm ";
    private static LoadRuleFactory instance;
    private static final String XML_START = "<?xml";

    private LoadRuleFactory() {
    }

    @Override
    public ILoadRule createLoadRule(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle) {
        return new LoadRule(workspaceConnection, componentHandle);
    }

    @Override
    public ILoadRule2 getLoadRule(IWorkspaceConnection connection, IComponentHandle potentialComponentContext, Reader input, IProgressMonitor progress) throws TeamRepositoryException {
        return this.getLoadRule(connection, potentialComponentContext, input, true, progress);
    }

    @Override
    public ILoadRule2 getLoadRule(IWorkspaceConnection connection, IComponentHandle potentialComponentContext, Reader input, boolean allowsNestedShares, IProgressMonitor progress) throws TeamRepositoryException {
        return this.privateGetLoadRule((IConnection)connection, potentialComponentContext, input, allowsNestedShares, progress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ILoadRule2 privateGetLoadRule(IConnection connection, IComponentHandle potentialComponentContext, Reader input, boolean allowsNestedShares, IProgressMonitor progress) throws TeamRepositoryException {
        BufferedReader bufferedInput = new BufferedReader(input);
        try {
            if (potentialComponentContext == null || this.isXMLInput(bufferedInput)) {
                ILoadRule2 iLoadRule2 = this.privateGetLoadRule(connection, bufferedInput, allowsNestedShares, progress);
                return iLoadRule2;
            }
            if (connection instanceof IWorkspaceConnection) {
                ILoadRule2 rule;
                LoadRule oldRule = new LoadRule((IWorkspaceConnection)connection, potentialComponentContext);
                oldRule.addLoadRules(bufferedInput, progress);
                ILoadRule2 iLoadRule2 = rule = oldRule.convertToNewFormat(potentialComponentContext, allowsNestedShares, progress);
                return iLoadRule2;
            }
            throw new IllegalArgumentException();
        }
        catch (IOException e) {
            throw new FileSystemException(NLS.bind((String)Messages.LoadRuleFactory_0, (Object)e.getMessage(), (Object[])new Object[0]), e);
        }
        finally {
            try {
                bufferedInput.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public ILoadRule2 getLoadRule(IWorkspaceConnection connection, Reader input, IProgressMonitor progress) throws TeamRepositoryException {
        return this.getLoadRule(connection, input, true, progress);
    }

    @Override
    public ILoadRule2 getLoadRule(IWorkspaceConnection connection, Reader input, boolean allowsNestedShares, IProgressMonitor progress) throws TeamRepositoryException {
        return this.privateGetLoadRule((IConnection)connection, input, allowsNestedShares, progress);
    }

    public ILoadRule2 privateGetLoadRule(IConnection connection, Reader input, boolean allowsNestedShares, IProgressMonitor progress) throws TeamRepositoryException {
        LoadRuleHandler handler;
        XMLReader parser;
        SAXParserFactory nsParserFactory;
        try {
            nsParserFactory = XMLUtil.getSecureSAXParserFactory();
        }
        catch (SAXNotRecognizedException e) {
            throw new FileSystemException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new FileSystemException(e);
        }
        catch (ParserConfigurationException e) {
            throw new FileSystemException(e);
        }
        nsParserFactory.setNamespaceAware(true);
        nsParserFactory.setValidating(true);
        try {
            parser = nsParserFactory.newSAXParser().getXMLReader();
            handler = new LoadRuleHandler(allowsNestedShares);
            parser.setContentHandler(handler);
            parser.setEntityResolver(handler);
            parser.setErrorHandler(handler);
            parser.setDTDHandler(handler);
            parser.setFeature(SAX_FEATURES_INCLUDE_XMLNS_ATTRIBUTE, true);
            parser.setFeature(SAX_FEATURES_VALIDATION, true);
            parser.setFeature(SAX_FEATURES_VALIDATION_SCHEMA, true);
            URL schemaLocation = this.getClass().getResource("/schema/LoadRule.xsd");
            parser.setProperty(SAX_PROPERTIES_SCHEMA_LOCATION, LOAD_RULE_SCHEMA_LOCATION_PREFIX + schemaLocation.toString());
        }
        catch (SAXNotRecognizedException e) {
            throw new FileSystemException(e);
        }
        catch (ParserConfigurationException e) {
            throw new FileSystemException(e);
        }
        catch (SAXException e) {
            throw new FileSystemException(e);
        }
        try {
            parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "bundleresource,jar:file,file");
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXException e) {
            throw new FileSystemException(e);
        }
        InputSource inputSource = new InputSource(input);
        try {
            parser.parse(inputSource);
        }
        catch (SAXParseException spe) {
            Exception cause = spe.getException();
            if (cause == null) {
                cause = spe;
            }
            if (spe.getSystemId() != null) {
                throw new FileSystemException(NLS.bind((String)Messages.LoadRuleFactory_2, (Object)spe.getSystemId(), (Object[])new Object[]{spe.getLineNumber()}), cause);
            }
            throw new FileSystemException(NLS.bind((String)Messages.LoadRuleFactory_3, (Object)spe.getLocalizedMessage(), (Object[])new Object[0]), cause);
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.LoadRuleFactory_4, e);
        }
        catch (SAXException e) {
            if (e.getException() instanceof TeamRepositoryException) {
                throw (TeamRepositoryException)((Object)e.getException());
            }
            throw new FileSystemException(NLS.bind((String)Messages.LoadRuleFactory_3, (Object)e.getLocalizedMessage(), (Object[])new Object[0]), e);
        }
        List<IStatus> warnings = handler.getWarnings();
        warnings.isEmpty();
        return handler.getLoadRule(connection, progress);
    }

    public static ILoadRuleFactory getInstance() {
        if (instance == null) {
            instance = new LoadRuleFactory();
        }
        return instance;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean isXMLLoadRule(Reader input) {
        BufferedReader bufferedInput = new BufferedReader(input);
        boolean bl = this.isXMLInput(bufferedInput);
        try {
            bufferedInput.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
        catch (IOException e) {
            try {
                bufferedInput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
            catch (Throwable throwable) {
                try {
                    bufferedInput.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private boolean isXMLInput(BufferedReader input) throws IOException {
        boolean result = false;
        input.mark(12);
        char[] buffer = new char[10];
        int len = 0;
        int offset = 0;
        int max = buffer.length;
        while (len != -1 && offset < buffer.length) {
            len = input.read(buffer, offset, max);
            if (len == -1) continue;
            offset += len;
            max -= len;
        }
        String start = new String(buffer, 0, offset);
        if (start.contains(XML_START)) {
            result = true;
        }
        input.reset();
        return result;
    }

    @Override
    public ILoadRule2 getLoadRule(IWorkspaceConnection connection, IComponentHandle componentHandle, IFileItemHandle fileVersionable, IProgressMonitor progress) throws TeamRepositoryException {
        return this.privateGetLoadRule((IConnection)connection, componentHandle, connection.configuration(componentHandle), fileVersionable, true, progress);
    }

    public ILoadRule2 privateGetLoadRule(IConnection connection, IComponentHandle componentHandle, IConfiguration configuration, IFileItemHandle fileVersionable, boolean allowNestedShares, IProgressMonitor progress) throws TeamRepositoryException {
        InputStreamReader reader;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IFileItem file = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)fileVersionable, (IProgressMonitor)monitor.newChild(1));
        InputStream stream = FileSystemCore.getContentManager(connection.teamRepository()).retrieveContentStream((IFileItemHandle)file, file.getContent(), (IProgressMonitor)monitor.newChild(1));
        if (file.getContent().getCharacterEncoding() == null || file.getContent().getCharacterEncoding() == "") {
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            reader = new InputStreamReader(stream, decoder);
        } else {
            try {
                reader = new InputStreamReader(stream, file.getContent().getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new FileSystemException(NLS.bind((String)Messages.LoadRuleFactory_1, (Object)file.getName(), (Object[])new Object[]{file.getContent().getCharacterEncoding()}), e);
            }
        }
        return this.privateGetLoadRule(connection, componentHandle, reader, allowNestedShares, (IProgressMonitor)monitor.newChild(98));
    }

    @Override
    public ILoadRule2 getLoadRule(IWorkspaceConnection connection, IComponentHandle componentHandle, IFileItemHandle fileVersionable, boolean allowNestedShares, IProgressMonitor progress) throws TeamRepositoryException {
        InputStreamReader reader;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IFileItem file = (IFileItem)connection.configuration(componentHandle).fetchCompleteItem((IVersionableHandle)fileVersionable, (IProgressMonitor)monitor.newChild(1));
        InputStream stream = FileSystemCore.getContentManager(connection.teamRepository()).retrieveContentStream((IFileItemHandle)file, file.getContent(), (IProgressMonitor)monitor.newChild(1));
        if (file.getContent().getCharacterEncoding() == null || file.getContent().getCharacterEncoding() == "") {
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            reader = new InputStreamReader(stream, decoder);
        } else {
            try {
                reader = new InputStreamReader(stream, file.getContent().getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new FileSystemException(NLS.bind((String)Messages.LoadRuleFactory_1, (Object)file.getName(), (Object[])new Object[]{file.getContent().getCharacterEncoding()}), e);
            }
        }
        return this.getLoadRule(connection, componentHandle, reader, allowNestedShares, (IProgressMonitor)monitor.newChild(98));
    }

    @Override
    public ILoadRule2 getLoadRule(IBaselineConnection connection, IFileItemHandle fileVersionable, boolean allowNestedShares, IProgressMonitor progress) throws TeamRepositoryException {
        return this.privateGetLoadRule((IConnection)connection, connection.getComponent(), connection.configuration(), fileVersionable, allowNestedShares, progress);
    }
}

