/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.IKeywordExpansionContext;
import com.ibm.team.filesystem.client.internal.KeywordExpansionInputStream;
import com.ibm.team.filesystem.common.FileKeyword;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport2;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class KeywordExpansionContext
implements IKeywordExpansionContext {
    public static final String CLIENT_DATA_KEY = "com.ibm.team.filesystem.client.KeywordExpansion";
    private Map<UUID, AbstractKeywordExpander> expanders = new HashMap<UUID, AbstractKeywordExpander>();

    public static IKeywordExpansionContext createForLoad(IWorkspaceManager manager, List<FileAreaUpdate> updates, SubMonitor monitor) throws TeamRepositoryException {
        KeywordExpansionContext context = new KeywordExpansionContext();
        context.addUpdates(updates);
        context.initializeVersionIdentifiers(manager, (IProgressMonitor)monitor);
        return context;
    }

    public static IKeywordExpansionContext createForUpdate(IWorkspaceManager workspaceManager, FileAreaUpdateReport2 updates, IProgressMonitor monitor) throws TeamRepositoryException {
        KeywordExpansionContext context = new KeywordExpansionContext();
        context.addUpdates(updates.getAdds());
        context.addUpdates(updates.getModifies());
        context.addUpdates(updates.getMoves());
        context.initializeVersionIdentifiers(workspaceManager, monitor);
        return context;
    }

    public static IKeywordExpansionContext createForCheckin(IWorkspaceManager workspaceManager, List<AbstractKeywordExpander> expanders, IProgressMonitor monitor) throws TeamRepositoryException {
        KeywordExpansionContext context = new KeywordExpansionContext();
        context.addExpanders(expanders);
        context.initializeVersionIdentifiers(workspaceManager, monitor);
        return context;
    }

    public static boolean isShareLoadedWithKeywordExpansionEnabled(IShare share) throws FileSystemException {
        ISharingDescriptor sharingDescriptor;
        byte[] clientData;
        if (share != null && (clientData = (sharingDescriptor = share.getSharingDescriptor()).getClientData(CLIENT_DATA_KEY)) != null) {
            return Boolean.valueOf(new String(clientData));
        }
        return false;
    }

    public static boolean isShareLoadedWithKeywordExpansionEnabled(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        IShare share = shareable.getShare(monitor);
        if (share != null) {
            return KeywordExpansionContext.isShareLoadedWithKeywordExpansionEnabled(share);
        }
        return false;
    }

    private KeywordExpansionContext() {
    }

    private void addExpanders(List<AbstractKeywordExpander> expanders) {
        for (AbstractKeywordExpander expander : expanders) {
            this.expanders.put(expander.getStateHandle().getStateId(), expander);
        }
    }

    private void addUpdates(List adds) {
        for (Object object : adds) {
            if (!(object instanceof FileAreaUpdate)) continue;
            FileAreaUpdate update = (FileAreaUpdate)object;
            this.addUpdate(update);
        }
    }

    private void addUpdate(FileAreaUpdate fileAreaUpdate) {
        if (fileAreaUpdate.getAfter() != null && fileAreaUpdate.afterState() instanceof IFileItemHandle) {
            this.expanders.put(fileAreaUpdate.getAfter(), new FileAreaUpdateKeywordExpander(fileAreaUpdate));
        }
    }

    private void initializeVersionIdentifiers(IWorkspaceManager manager, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IVersionableHandle> toFetch = new ArrayList<IVersionableHandle>();
        for (AbstractKeywordExpander expander : this.expanders.values()) {
            toFetch.add(expander.getStateHandle());
        }
        IVersionableIdentifier[] vids = manager.getVersionableIdentifiers(toFetch.toArray(new IVersionableHandle[toFetch.size()]), monitor);
        int i = 0;
        while (i < vids.length) {
            AbstractKeywordExpander expander;
            IVersionableHandle versionableHandle = (IVersionableHandle)toFetch.get(i);
            IVersionableIdentifier vid = vids[i];
            if (vid != null && (expander = this.expanders.get(versionableHandle.getStateId())) != null) {
                expander.setIdentifier(vid);
            }
            ++i;
        }
    }

    @Override
    public boolean isExpansionEnabledFor(IFileItemHandle handle) {
        AbstractKeywordExpander expander = this.getKeywordExpander(handle);
        if (expander == null) {
            return false;
        }
        if (expander.getLineDelimiter().equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE)) {
            return false;
        }
        return !expander.isExpansionExplicitlyDisabled();
    }

    private AbstractKeywordExpander getKeywordExpander(IFileItemHandle handle) {
        if (handle.getStateId() == null) {
            return null;
        }
        return this.expanders.get(handle.getStateId());
    }

    @Override
    public InputStream wrapWithKeywordExpansionStream(IFileItemHandle handle, InputStream in) {
        if (!this.isExpansionEnabledFor(handle)) {
            return in;
        }
        AbstractKeywordExpander expander = this.getKeywordExpander(handle);
        if (expander == null) {
            return in;
        }
        return new KeywordExpansionInputStream(in, expander);
    }

    public static abstract class AbstractKeywordExpander
    implements KeywordExpansionInputStream.IKeywordExpander {
        private IVersionableIdentifier identifier;

        public IVersionableIdentifier getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(IVersionableIdentifier identifier) {
            this.identifier = identifier;
        }

        public abstract IVersionableHandle getStateHandle();

        public abstract FileLineDelimiter getLineDelimiter();

        public boolean isExpansionExplicitlyDisabled() {
            String value = this.getFileProperties().get("scm:keyword");
            if (value != null) {
                return Boolean.valueOf(value) == false;
            }
            return false;
        }

        protected abstract Map<String, String> getFileProperties();

        @Override
        public String getExpansionFor(FileKeyword keyword) {
            switch (keyword) {
                case VERSION_ID: {
                    if (this.getIdentifier() == null) break;
                    return this.getIdentifier().getShortVersionId();
                }
                case LONG_VERSION_ID: {
                    if (this.getIdentifier() == null) break;
                    return this.getIdentifier().getLongVersionId();
                }
                case STATE_ID: {
                    return this.getStateHandle().getStateId().getUuidValue();
                }
                case ITEM_ID: {
                    return this.getStateHandle().getItemId().getUuidValue();
                }
            }
            return "";
        }
    }

    private static class FileAreaUpdateKeywordExpander
    extends AbstractKeywordExpander {
        private final FileAreaUpdate update;

        public FileAreaUpdateKeywordExpander(FileAreaUpdate update) {
            this.update = update;
        }

        @Override
        public String getExpansionFor(FileKeyword keyword) {
            switch (keyword) {
                case NAME: {
                    if (this.update == null) break;
                    return this.update.getName();
                }
                case DATE: {
                    if (this.update == null) break;
                    return this.update.getFileTimestamp().toString();
                }
            }
            return super.getExpansionFor(keyword);
        }

        @Override
        public IVersionableHandle getStateHandle() {
            return this.update.afterState();
        }

        @Override
        public FileLineDelimiter getLineDelimiter() {
            return this.update.getOptionalContent() == null ? FileLineDelimiter.LINE_DELIMITER_NONE : this.update.getOptionalContent().getLineDelimiter();
        }

        @Override
        protected Map<String, String> getFileProperties() {
            return this.update.getProperties();
        }
    }
}

