/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Collision;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.load.InvalidLoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadOverlap;
import com.ibm.team.filesystem.client.internal.load.LoadRequest;
import com.ibm.team.filesystem.client.internal.load.RemovedShare;
import com.ibm.team.filesystem.client.internal.load.ShareableToLoad;
import com.ibm.team.filesystem.client.internal.operations.ILoadEvaluator;
import com.ibm.team.filesystem.client.internal.operations.InvalidLoadRequest;
import com.ibm.team.filesystem.client.internal.operations.LoadEvaluator;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepoIdConnectionComponentTriple;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.OverlapDescription;
import com.ibm.team.filesystem.common.internal.dto.OverlapRequest;
import com.ibm.team.filesystem.common.internal.dto.OverlapResponse;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class HierarchicalLoadEvaluator
extends LoadEvaluator {
    private Map<ISandbox, Set<IRemovedShare>> sharesToRemove = new HashMap<ISandbox, Set<IRemovedShare>>();
    private Map<ILocation, IShareableToLoad> newItems;
    private List<ILoadOverlap> loadOverLaps;
    private List<IShareOutOfSync> sharesOutOfSync;
    private List<IInvalidLoadRequest> invalidLoadRequests;
    private Map<ILocation, ICollision> collisions;
    private Map<ILocation, LoadLocation> treesToLoad;
    private static final ILoadEvaluator.LoadValidations[] SUPPORTED = new ILoadEvaluator.LoadValidations[]{ILoadEvaluator.LoadValidations.ALL_SHARES_TO_REMOVE, ILoadEvaluator.LoadValidations.OVERLAPS, ILoadEvaluator.LoadValidations.COLLISIONS, ILoadEvaluator.LoadValidations.SANDBOX, ILoadEvaluator.LoadValidations.INVALID_REQUEST, ILoadEvaluator.LoadValidations.ALL_NEW_SHARES, ILoadEvaluator.LoadValidations.MULTIPLE_SANDBOX, ILoadEvaluator.LoadValidations.OUT_OF_SYNC_SHARES};

    @Override
    public void doEvaluation(IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 * this.requestsByCFA.size()));
        this.sharesToRemove = new HashMap<ISandbox, Set<IRemovedShare>>();
        this.collisions = new HashMap<ILocation, ICollision>();
        this.treesToLoad = new HashMap<ILocation, LoadLocation>();
        this.newItems = new HashMap<ILocation, IShareableToLoad>();
        this.loadOverLaps = new ArrayList<ILoadOverlap>();
        this.invalidLoadRequests = new ArrayList<IInvalidLoadRequest>();
        this.sharesOutOfSync = new ArrayList<IShareOutOfSync>();
        HashMap<IShare, IConnection> sharesToVerifyInSync = new HashMap<IShare, IConnection>();
        HashSet<ISandbox> allCopyFileAreas = new HashSet<ISandbox>();
        allCopyFileAreas.addAll(SharingManager.getInstance().getRegisteredSandboxes());
        Iterator iterator = this.requestsByCFA.keySet().iterator();
        while (iterator.hasNext()) {
            ISandbox sandbox = (ISandbox)iterator.next();
            if (sandbox.getRoot().equals(sandbox.getRoot().getCanonicalForm())) continue;
            Map requestsByConnection = (Map)this.requestsByCFA.get(sandbox);
            String msg = NLS.bind((String)Messages.HierarchicalLoadEvaluator_0, (Object)sandbox.getRoot().toString());
            for (Map requestsByConfiguration : requestsByConnection.values()) {
                for (Set requests : requestsByConfiguration.values()) {
                    for (LoadRequest request : requests) {
                        InvalidLoadRequest invalid = new InvalidLoadRequest(request, IInvalidLoadRequest.InvalidLoadRequestReason.InvalidSandbox, FileSystemStatusUtil.getStatusFor(4, msg));
                        this.invalidLoadRequests.add(invalid);
                    }
                }
            }
            iterator.remove();
        }
        for (Map.Entry entry : this.requestsByCFA.entrySet()) {
            this.getElementsToLoad((ISandbox)entry.getKey(), (Map)entry.getValue(), sharesToVerifyInSync, (IProgressMonitor)monitor.newChild(90));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!sharesToVerifyInSync.isEmpty()) {
            OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = new OutOfSyncDilemmaHandler(){

                @Override
                public int outOfSync(Collection<IShareOutOfSync> shares) {
                    HierarchicalLoadEvaluator.this.sharesOutOfSync.addAll(shares);
                    return 0;
                }
            };
            VerifySharesOperation verifyInSyncOp = new VerifySharesOperation(outOfSyncDilemmaHandler);
            for (Map.Entry entry : sharesToVerifyInSync.entrySet()) {
                verifyInSyncOp.addToVerify((IConnection)entry.getValue(), (IShare)entry.getKey());
            }
            verifyInSyncOp.run((IProgressMonitor)monitor.newChild(10));
        }
        monitor.done();
    }

    private void getElementsToLoad(ISandbox sandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnection, Map<IShare, IConnection> sharesToVerifyInSync, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(50 + requestsByConnection.size()));
        monitor.setTaskName(Messages.LoadOperation_14);
        HashMap<ILocation, IShare> allShares = new HashMap<ILocation, IShare>();
        HashMap<RepoIdConnectionComponentTriple, Map<UUID, IShare>> existingShares = new HashMap<RepoIdConnectionComponentTriple, Map<UUID, IShare>>();
        this.organizeShares(sandbox, allShares, existingShares, (IProgressMonitor)monitor.newChild(1));
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        HashMap<LoadRequest, LoadLocation> locationsInSandbox = new HashMap<LoadRequest, LoadLocation>();
        for (Map.Entry<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> entry : requestsByConnection.entrySet()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            SubMonitor iterProgress = monitor.newChild(1);
            iterProgress.setWorkRemaining(100);
            IConnection connection = entry.getKey();
            Map<ConfigurationFacade, Set<LoadRequest>> requestsForConnection = entry.getValue();
            ArrayList<OverlapRequest> overlapRequests = new ArrayList<OverlapRequest>(entry.getValue().size());
            HashMap<ConfigurationFacade, Map<UUID, LoadRequest>> toLoad = new HashMap<ConfigurationFacade, Map<UUID, LoadRequest>>();
            HashMap<ConfigurationFacade, Map<UUID, IVersionable>> configurationVersionables = new HashMap<ConfigurationFacade, Map<UUID, IVersionable>>();
            Map<UUID, Map<UUID, ? extends IVersionable>> fullVersionables = this.fetchInfoForLoadEvaluation(connection, requestsForConnection, toLoad, components, existingShares, (IProgressMonitor)iterProgress.newChild(50));
            this.buildOverlapRequestCheckExistance(connection, requestsForConnection, overlapRequests, toLoad, existingShares, configurationVersionables, fullVersionables, (IProgressMonitor)iterProgress.newChild(10));
            if (!overlapRequests.isEmpty()) {
                this.checkItemOverlaps(connection, overlapRequests, toLoad, existingShares, (IProgressMonitor)iterProgress.newChild(30));
            }
            for (Map.Entry toLoadByConfig : toLoad.entrySet()) {
                if (iterProgress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ConfigurationFacade descriptor = (ConfigurationFacade)((Object)toLoadByConfig.getKey());
                for (LoadRequest request : ((Map)toLoadByConfig.getValue()).values()) {
                    IRelativeLocation relativeLoadPath;
                    String pathString;
                    boolean isValid;
                    IVersionable versionable = (IVersionable)((Map)configurationVersionables.get((Object)descriptor)).get(request.getVersionableToLoad().getItemId());
                    if (versionable == null) {
                        throw new IllegalStateException();
                    }
                    boolean isLoadWithAnotherName = false;
                    String loadName = versionable.getName();
                    if (request.getAlternativeName().length() > 0) {
                        loadName = request.getAlternativeName();
                        isLoadWithAnotherName = true;
                    }
                    if (!(isValid = PathUtils.isValidPath(pathString = (relativeLoadPath = request.getRelativeLoadPath()).toString()))) {
                        throw new FileSystemException(NLS.bind((String)Messages.LoadOperation_24, (Object)relativeLoadPath.toString()));
                    }
                    if (loadName != null && !(isValid = PathUtils.isValidPath(String.valueOf('/') + loadName))) {
                        if (isLoadWithAnotherName) {
                            throw new FileSystemException(NLS.bind((String)Messages.LoadOperation_23, (Object)loadName));
                        }
                        throw new FileSystemException(NLS.bind((String)Messages.LoadOperation_25, (Object)loadName));
                    }
                    if (!LoadFilter.include(relativeLoadPath, loadName)) continue;
                    LoadLocation location = new LoadLocation(sandbox, relativeLoadPath, loadName, request.getConnection(), (IComponent)components.get(request.getComponent().getItemId()), request.getVersionableToLoad(), isLoadWithAnotherName);
                    locationsInSandbox.put(request, location);
                }
            }
        }
        monitor.setWorkRemaining(locationsInSandbox.size());
        for (Map.Entry<Object, Map<ConfigurationFacade, Set<LoadRequest>>> entry : locationsInSandbox.entrySet()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            LoadRequest key = (LoadRequest)entry.getKey();
            LoadLocation loadLocation = (LoadLocation)((Object)entry.getValue());
            InvalidLoadLocation invalidLoadLocation = null;
            if (!key.allowsNestedShares()) {
                IRelativeLocation relativeLoadLocation = loadLocation.getLoadPath();
                for (Map.Entry otherEntry : locationsInSandbox.entrySet()) {
                    boolean isCaseSensitive;
                    LoadLocation otherLocation = (LoadLocation)otherEntry.getValue();
                    IRelativeLocation otherRelativeLocation = otherLocation.getLoadPath();
                    boolean bl = isCaseSensitive = loadLocation.getSandbox().isCaseSensitive() && otherLocation.getSandbox().isCaseSensitive();
                    if (!relativeLoadLocation.isPrefixOf(otherRelativeLocation, isCaseSensitive) && !otherRelativeLocation.isPrefixOf(relativeLoadLocation, isCaseSensitive) || relativeLoadLocation.sameLocation(otherRelativeLocation, isCaseSensitive)) continue;
                    if (invalidLoadLocation == null) {
                        invalidLoadLocation = new InvalidLoadLocation((ILoadRequest)entry.getKey());
                    }
                    invalidLoadLocation.addOverlappingLoadRequests((ILoadRequest)otherEntry.getKey());
                }
            }
            if (invalidLoadLocation == null) {
                this.checkForCollision((LoadRequest)entry.getKey(), loadLocation, sharesToVerifyInSync, allShares, (IProgressMonitor)monitor.newChild(1));
                continue;
            }
            this.addInvalidLoadLocation((ILoadRequest)entry.getKey(), invalidLoadLocation);
        }
    }

    private Map<UUID, Map<UUID, ? extends IVersionable>> fetchInfoForLoadEvaluation(IConnection connection, Map<ConfigurationFacade, Set<LoadRequest>> requestsForConnection, Map<ConfigurationFacade, Map<UUID, LoadRequest>> toLoad, Map<UUID, IComponent> components, Map<RepoIdConnectionComponentTriple, Map<UUID, IShare>> existingShares, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<IComponentHandle> componentsToRetrieve = new ArrayList<IComponentHandle>();
        ArrayList<IComponentHandle> interestingComponents = new ArrayList<IComponentHandle>();
        ArrayList<List<? extends IVersionableHandle>> interestingVersionables = new ArrayList<List<? extends IVersionableHandle>>();
        for (Map.Entry<ConfigurationFacade, Set<LoadRequest>> entryByConfig : requestsForConnection.entrySet()) {
            ConfigurationFacade descriptor = entryByConfig.getKey();
            interestingComponents.add(descriptor.getComponentHandle());
            ArrayList<IVersionableHandle> versionables = new ArrayList<IVersionableHandle>();
            interestingVersionables.add(versionables);
            HashMap<UUID, LoadRequest> uuidsToLoad = new HashMap<UUID, LoadRequest>();
            toLoad.put(descriptor, uuidsToLoad);
            for (LoadRequest request : entryByConfig.getValue()) {
                if (!components.containsKey(request.getComponent().getItemId())) {
                    componentsToRetrieve.add(request.getComponent());
                }
                versionables.add(request.getVersionableToLoad());
                LoadRequest requestForVersionable = (LoadRequest)uuidsToLoad.get(request.getVersionableToLoad().getItemId());
                if (requestForVersionable == null) {
                    uuidsToLoad.put(request.getVersionableToLoad().getItemId(), request);
                    continue;
                }
                InvalidLoadLocation invalidLoadLocation = new InvalidLoadLocation(request);
                invalidLoadLocation.addOverlappingLoadRequests(requestForVersionable);
                this.addInvalidLoadLocation(request, invalidLoadLocation);
            }
            Map<UUID, IShare> shares = existingShares.get(new RepoIdConnectionComponentTriple(descriptor.getRepositoryId(), descriptor.getConnectionHandle(), descriptor.getComponentHandle()));
            if (shares == null) continue;
            for (IShare share : shares.values()) {
                ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                LoadRequest request = (LoadRequest)uuidsToLoad.get(sharingDescriptor.getRootVersionable().getItemId());
                if (request != null) {
                    request.setReloadRequest(true);
                    continue;
                }
                versionables.add(sharingDescriptor.getRootVersionable());
            }
        }
        if (!componentsToRetrieve.isEmpty()) {
            List fullComponents = connection.teamRepository().itemManager().fetchCompleteItems(componentsToRetrieve, 0, (IProgressMonitor)monitor.newChild(20));
            for (IComponent component : fullComponents) {
                components.put(component.getItemId(), component);
            }
        }
        return this.fetchCompleteItems(connection, interestingComponents, interestingVersionables, monitor.newChild(80));
    }

    private void buildOverlapRequestCheckExistance(IConnection connection, Map<ConfigurationFacade, Set<LoadRequest>> requestsForConnection, List<OverlapRequest> overlapRequests, Map<ConfigurationFacade, Map<UUID, LoadRequest>> toLoad, Map<RepoIdConnectionComponentTriple, Map<UUID, IShare>> existingShares, Map<ConfigurationFacade, Map<UUID, IVersionable>> configurationVersionables, Map<UUID, Map<UUID, ? extends IVersionable>> fullVersionables, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)requestsForConnection.size());
        for (Map.Entry<ConfigurationFacade, Set<LoadRequest>> entryByConfig : requestsForConnection.entrySet()) {
            SubMonitor iterMonitor = monitor.newChild(1);
            ConfigurationFacade descriptor = entryByConfig.getKey();
            Map<UUID, LoadRequest> uuidsToLoad = toLoad.get((Object)descriptor);
            Map<UUID, IShare> shares = existingShares.get(new RepoIdConnectionComponentTriple(descriptor.getRepositoryId(), descriptor.getConnectionHandle(), descriptor.getComponentHandle()));
            Map<UUID, ? extends IVersionable> fullVersionablesForComponent = fullVersionables.get(descriptor.getComponentHandle().getItemId());
            if (fullVersionablesForComponent == null) continue;
            HashMap<UUID, IVersionable> versionablesRetrieved = new HashMap<UUID, IVersionable>();
            for (IVersionable iVersionable : fullVersionablesForComponent.values()) {
                if (iVersionable == null) continue;
                versionablesRetrieved.put(iVersionable.getItemId(), iVersionable);
            }
            configurationVersionables.put(descriptor, versionablesRetrieved);
            OverlapRequest overlapRequest = FilesystemDTOFactory.eINSTANCE.createOverlapRequest();
            overlapRequest.setContext(connection.getContextHandle());
            overlapRequest.setComponent(descriptor.getComponentHandle());
            iterMonitor.setWorkRemaining(fullVersionablesForComponent.size());
            for (Map.Entry<UUID, ? extends IVersionable> entry : fullVersionablesForComponent.entrySet()) {
                UUID itemId = entry.getKey();
                if (entry.getValue() == null) {
                    Set<IRemovedShare> sharesForRemoval;
                    IShare share;
                    LoadRequest request = uuidsToLoad.get(itemId);
                    if (request != null) {
                        uuidsToLoad.remove(itemId);
                        if (request.isReloadRequest()) {
                            share = shares.get(itemId);
                            sharesForRemoval = this.sharesToRemove.get(share.getSandbox());
                            if (sharesForRemoval == null) {
                                sharesForRemoval = new HashSet<IRemovedShare>();
                                this.sharesToRemove.put(share.getSandbox(), sharesForRemoval);
                            }
                            sharesForRemoval.add(new RemovedShare(share, (IProgressMonitor)iterMonitor.newChild(1)));
                            continue;
                        }
                        IStatus msg = FileSystemStatusUtil.getStatusFor(2, Messages.LoadOperation_16);
                        InvalidLoadRequest invalidLoadRequest = new InvalidLoadRequest(request, IInvalidLoadRequest.InvalidLoadRequestReason.NonExistantItem, msg);
                        this.invalidLoadRequests.add(invalidLoadRequest);
                        continue;
                    }
                    share = shares.get(itemId);
                    sharesForRemoval = this.sharesToRemove.get(share.getSandbox());
                    if (sharesForRemoval == null) {
                        sharesForRemoval = new HashSet<IRemovedShare>();
                        this.sharesToRemove.put(share.getSandbox(), sharesForRemoval);
                    }
                    sharesForRemoval.add(new RemovedShare(share, (IProgressMonitor)iterMonitor.newChild(1)));
                    continue;
                }
                IVersionable versionable = entry.getValue();
                LoadRequest request = uuidsToLoad.get(itemId);
                if (request == null) {
                    overlapRequest.getGroup().add(versionable);
                    continue;
                }
                String loadName = request.getAlternativeName().length() == 0 ? versionable.getName() : request.getAlternativeName();
                if (loadName.indexOf("/") != -1 || loadName.indexOf("\\") != -1 || loadName.length() == 0) {
                    uuidsToLoad.remove(itemId);
                    IStatus msg = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.LoadOperation_17, (Object)loadName));
                    InvalidLoadRequest invalidLoadRequest = new InvalidLoadRequest(request, IInvalidLoadRequest.InvalidLoadRequestReason.InvalidProjectName, msg);
                    this.invalidLoadRequests.add(invalidLoadRequest);
                    continue;
                }
                overlapRequest.getGroup().add(versionable);
            }
            if (overlapRequest.getGroup().size() <= 1) continue;
            overlapRequests.add(overlapRequest);
        }
    }

    private void checkItemOverlaps(IConnection connection, List<OverlapRequest> overlapRequests, Map<ConfigurationFacade, Map<UUID, LoadRequest>> toLoad, Map<RepoIdConnectionComponentTriple, Map<UUID, IShare>> existingShares, IProgressMonitor progress) throws TeamRepositoryException {
        FileSystemManager fsm = (FileSystemManager)FileSystemCore.getFileSystemManager(connection.teamRepository());
        FileSystemServiceProxy fileSystemService = fsm.getFileSystemService();
        List<OverlapResponse> overlapResult = fileSystemService.detectOverlap(overlapRequests, null, progress);
        for (OverlapResponse response : overlapResult) {
            ConfigurationFacade descriptor = new ConfigurationFacade(connection, response.getComponent());
            RepoIdConnectionComponentTriple descriptorForExistingShares = new RepoIdConnectionComponentTriple(connection.teamRepository().getId(), connection.getContextHandle(), response.getComponent());
            Map<UUID, LoadRequest> uuidsToLoad = toLoad.get((Object)descriptor);
            if (uuidsToLoad == null) continue;
            HashMap<UUID, IAncestorReport> ancestorReports = new HashMap<UUID, IAncestorReport>();
            for (IAncestorReport ancestorReport : response.getAncestorReports()) {
                List pairs = ancestorReport.getNameItemPairs();
                ancestorReports.put(((INameItemPair)pairs.get(pairs.size() - 1)).getItem().getItemId(), ancestorReport);
            }
            HashMap<UUID, Collection<IVersionableHandle>> overlapSituations = new HashMap<UUID, Collection<IVersionableHandle>>();
            for (OverlapDescription overlapDescription : response.getOverlapDescriptions()) {
                IVersionableHandle element = overlapDescription.getElement();
                for (IVersionableHandle itemOverlapped : overlapDescription.getOverlappedChildren()) {
                    this.recordOverlap(overlapSituations, element, itemOverlapped);
                    this.recordOverlap(overlapSituations, itemOverlapped, element);
                }
            }
            for (Map.Entry entry : overlapSituations.entrySet()) {
                LoadRequest request = uuidsToLoad.get(entry.getKey());
                if (request == null) continue;
                uuidsToLoad.remove(entry.getKey());
                LoadOverlap loadOverlap = new LoadOverlap(request.getSandbox(), connection, response.getComponent(), (IAncestorReport)ancestorReports.get(entry.getKey()));
                this.loadOverLaps.add(loadOverlap);
                for (IVersionableHandle versionable : (Collection)entry.getValue()) {
                    Map<UUID, IShare> shares = existingShares.get(descriptorForExistingShares);
                    if (shares != null && shares.get(versionable.getItemId()) != null) {
                        loadOverlap.addOverlappingShare(shares.get(versionable.getItemId()));
                    }
                    loadOverlap.addOverlappingItem((IAncestorReport)ancestorReports.get(versionable.getItemId()));
                }
            }
        }
    }

    private void recordOverlap(Map<UUID, Collection<IVersionableHandle>> overlapSituations, IVersionableHandle element, IVersionableHandle itemOverlapped) {
        Collection<IVersionableHandle> overlap = overlapSituations.get(element.getItemId());
        if (overlap == null) {
            overlap = new ArrayList<IVersionableHandle>();
            overlapSituations.put(element.getItemId(), overlap);
        }
        overlap.add(itemOverlapped);
    }

    private void checkForCollision(LoadRequest request, LoadLocation location, Map<IShare, IConnection> sharesToVerifyInSync, Map<ILocation, IShare> sharesInCopyFileArea, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        Collision overWriteCollision = null;
        InvalidLoadLocation invalidLoadLocation = null;
        ISandbox sandbox = location.getSandbox();
        IShareable existingShareableInCFA = sandbox.findShareable(request.getConnection().getContextHandle(), request.getComponent(), request.getVersionableToLoad(), (IProgressMonitor)monitor.newChild(10));
        if (existingShareableInCFA != null && !PathUtils.sameRelativePath(existingShareableInCFA.getLocalPath(), existingShareableInCFA.getSandbox().isCaseSensitive(), location.getLoadPath(), location.getSandbox().isCaseSensitive())) {
            IShare existingShareableShare = existingShareableInCFA.getShare((IProgressMonitor)monitor.newChild(1));
            if (existingShareableInCFA.isShare((IProgressMonitor)monitor.newChild(1)) && existingShareableShare.isLoadedWithAnotherName((IProgressMonitor)monitor.newChild(1)) || location.isLoadWithAnotherName()) {
                if (invalidLoadLocation == null) {
                    invalidLoadLocation = new InvalidLoadLocation(request);
                }
                invalidLoadLocation.setPresentLoadLocation(existingShareableInCFA);
            }
        }
        if (!request.allowsNestedShares()) {
            ILocation fullLoadPath = location.getFullPath();
            for (Map.Entry<ILocation, IShare> entry : sharesInCopyFileArea.entrySet()) {
                boolean isCaseSensitive;
                ILocation sharePath = entry.getKey();
                boolean bl = isCaseSensitive = entry.getValue().getSandbox().isCaseSensitive() && location.getSandbox().isCaseSensitive();
                if (!sharePath.isPrefixOf(fullLoadPath, isCaseSensitive) && !fullLoadPath.isPrefixOf(sharePath, isCaseSensitive) || sharePath.sameLocation(fullLoadPath, isCaseSensitive)) continue;
                if (invalidLoadLocation == null) {
                    invalidLoadLocation = new InvalidLoadLocation(request);
                }
                invalidLoadLocation.addOverlappingShare(entry.getValue());
            }
        }
        if (invalidLoadLocation == null) {
            IShare share;
            IShareable shareable = location.getSandbox().findShareable(location.getLoadPath(), ResourceType.getResourceType(location.getRootToLoad()));
            if (shareable.exists((IProgressMonitor)monitor.newChild(1))) {
                ISharingDescriptor descriptor;
                share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
                overWriteCollision = new Collision(shareable, share, location, true, request.allowsNestedShares());
                if (share != null && (descriptor = share.getSharingDescriptor()).getConnectionHandle().sameItemId((IItemHandle)location.getConnection().getContextHandle()) && descriptor.getComponent().sameItemId((IItemHandle)location.getComponent()) && descriptor.getRootVersionable().sameItemId((IItemHandle)overWriteCollision.getShareable().getVersionable((IProgressMonitor)monitor.newChild(1)))) {
                    sharesToVerifyInSync.put(share, location.getConnection());
                }
            }
            if (this.collisions.containsKey(location.getFullPath())) {
                ICollision collision = this.collisions.get(location.getFullPath());
                collision.getLocations().add(location);
            } else if (this.treesToLoad.containsKey(location.getFullPath())) {
                share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
                Collision collision = new Collision(shareable, share, location, false, request.allowsNestedShares());
                ILoadLocation otherLocation = this.treesToLoad.remove(location.getFullPath());
                this.newItems.remove(location.getFullPath());
                collision.getLocations().add(otherLocation);
                this.collisions.put(location.getFullPath(), collision);
            } else if (overWriteCollision != null) {
                this.collisions.put(location.getFullPath(), overWriteCollision);
            } else {
                this.treesToLoad.put(location.getFullPath(), location);
                this.newItems.put(location.getFullPath(), new ShareableToLoad(shareable, location));
            }
        } else {
            this.addInvalidLoadLocation(request, invalidLoadLocation);
        }
    }

    @Override
    public Map<ISandbox, Set<IRemovedShare>> getSharesToBeRemoved() {
        return this.sharesToRemove;
    }

    @Override
    public Map<ILocation, IShareableToLoad> getNewSharesToLoad() {
        return this.newItems;
    }

    @Override
    public Collection<IShareOutOfSync> getSharesOutOfSync() {
        return this.sharesOutOfSync;
    }

    @Override
    public final Map<ILocation, ICollision> getCollisions() {
        return this.collisions;
    }

    @Override
    public final Collection<LoadLocation> getItemsToLoad() {
        return this.treesToLoad.values();
    }

    @Override
    public Collection<ILoadEvaluator.LoadValidations> getSupportedValidations() {
        return Arrays.asList(SUPPORTED);
    }

    @Override
    public Collection<ILoadOverlap> getLoadOverlaps() {
        return this.loadOverLaps;
    }

    @Override
    public Collection<IInvalidLoadRequest> getInvalidLoadRequests() {
        return this.invalidLoadRequests;
    }
}

