/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader;
import com.ibm.team.filesystem.client.internal.operations.IgnoreFileAgeDBHM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ReadThroughFilesystemAbstraction
implements DefaultIgnoreProvider.IFilesystemAbstraction {
    private HashMap<IShareable, FileRecord> filesystem = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToDisk(IProgressMonitor progress) throws FileSystemException {
        HashMap<IShareable, FileRecord> hashMap = this.filesystem;
        synchronized (hashMap) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(this.filesystem.size() * 3));
            try {
                monitor.setTaskName(Messages.ReadThroughFilesystemAbstraction_STORE_PROGRESS);
                for (Map.Entry<IShareable, FileRecord> entry : this.filesystem.entrySet()) {
                    monitor.subTask(NLS.bind((String)Messages.ReadThroughFilesystemAbstraction_STORE_ITEM, (Object)entry.getKey().getLocalPath()));
                    ByteArrayInputStream in = new ByteArrayInputStream(entry.getValue().bytes);
                    IFileStorage store = ((IShareableInternal)entry.getKey()).getFileStorage();
                    FileOptions options = new FileOptions(false, (Shareable)entry.getKey(), (IProgressMonitor)monitor.newChild(1));
                    if (entry.getKey().exists((IProgressMonitor)monitor.newChild(1))) {
                        store.setContents(options, in, new Shed(null), (IProgressMonitor)monitor.newChild(1));
                        continue;
                    }
                    store.create(options, in, (IProgressMonitor)monitor.newChild(1));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private static byte[] copyIntoByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream store = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int read;
            while ((read = in.read(data)) != -1) {
                store.write(data, 0, read);
            }
        }
        finally {
            try {
                store.close();
            }
            catch (IOException iOException) {}
        }
        return store.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(IShareable file, IProgressMonitor monitor) throws FileSystemException {
        HashMap<IShareable, FileRecord> hashMap = this.filesystem;
        synchronized (hashMap) {
            block4: {
                if (!this.filesystem.containsKey(file)) break block4;
                return true;
            }
        }
        return file.exists(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream read(IShareable file, IProgressMonitor monitor) throws FileSystemException, IgnoreFileLoader.FileInaccessibleException {
        HashMap<IShareable, FileRecord> hashMap = this.filesystem;
        synchronized (hashMap) {
            block14: {
                if (this.filesystem.containsKey(file)) break block14;
                IFileStorage storage = ((Shareable)file).getFileStorage();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                if (file.exists((IProgressMonitor)progress.newChild(1))) {
                    FileOptions options = new FileOptions(false, (Shareable)file, (IProgressMonitor)progress.newChild(1));
                    InputStream inputStream = storage.getContents(options);
                    try {
                        try {
                            this.filesystem.put(file, new FileRecord(ReadThroughFilesystemAbstraction.copyIntoByteArray(inputStream), new IgnoreFileAgeDBHM.DateStamp(0L, 0L)));
                            break block14;
                        }
                        catch (IOException e) {
                            throw new FileSystemException(String.valueOf(Messages.ReadThroughFilesystemAbstraction_EXCEPTION_READING) + file.getLocalPath(), e);
                        }
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return null;
            }
            return new ByteArrayInputStream(this.filesystem.get((Object)file).bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(IShareable file, InputStream in, IProgressMonitor monitor) throws FileSystemException {
        HashMap<IShareable, FileRecord> hashMap = this.filesystem;
        synchronized (hashMap) {
            FileRecord oldRecord = this.filesystem.get(file);
            try {
                try {
                    long time = oldRecord == null ? 0L : oldRecord.lastModified.ideTimeStamp + 1L;
                    this.filesystem.put(file, new FileRecord(ReadThroughFilesystemAbstraction.copyIntoByteArray(in), new IgnoreFileAgeDBHM.DateStamp(time, time)));
                }
                catch (IOException e) {
                    throw new FileSystemException(String.valueOf(Messages.ReadThroughFilesystemAbstraction_EXCEPTION_WRITING) + file.getLocalPath(), e);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgnoreFileAgeDBHM.DateStamp lastModified(IShareable file) {
        FileRecord record;
        HashMap<IShareable, FileRecord> hashMap = this.filesystem;
        synchronized (hashMap) {
            record = this.filesystem.get(file);
        }
        return record == null ? NULL_MOD : record.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(IShareable file, IProgressMonitor monitor) throws FileSystemException {
        FileRecord record;
        HashMap<IShareable, FileRecord> hashMap = this.filesystem;
        synchronized (hashMap) {
            record = this.filesystem.get(file);
        }
        if (record == null) {
            long size = ((Shareable)file).getFileStorage().getSize(monitor);
            if (size == -1L) {
                return -2L;
            }
            return size;
        }
        return record.bytes.length;
    }

    @Override
    public Object clone() {
        return new ReadThroughFilesystemAbstraction();
    }

    private class FileRecord {
        byte[] bytes;
        IgnoreFileAgeDBHM.DateStamp lastModified;

        public FileRecord(byte[] bytes, IgnoreFileAgeDBHM.DateStamp lastModified) {
            this.bytes = bytes;
            this.lastModified = lastModified;
        }
    }
}

