/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalIgnoreRule
extends IgnoreRule {
    public LocalIgnoreRule(IShareable file, DefaultIgnoreProvider provider, String pattern, boolean ignorecase, boolean ignoreWildCards) {
        super(file, provider, pattern, ignorecase, ignoreWildCards);
    }

    @Override
    public boolean isTrivial() {
        return !this.matcher.containsWildcards();
    }

    @Override
    public boolean shouldBeIgnored(IRelativeLocation path) {
        IRelativeLocation root = this.getRootShareableLocalPath();
        if (!root.equals(path.getParent())) {
            return false;
        }
        return super.shouldBeIgnored(path);
    }

    @Override
    public boolean isEffectiveBelow(IShareable shareable) {
        IRelativeLocation path;
        IRelativeLocation root = this.getRootShareableLocalPath();
        return root.equals(path = shareable.getLocalPath()) || root.equals(path.getParent());
    }

    @Override
    public boolean isRecursive() {
        return false;
    }

    @Override
    public String getShortDescription() {
        return NLS.bind((String)Messages.IgnoreUtils_3, (Object[])new Object[]{this.getMatcher().getPattern(), this.getFile().getLocalPath()}, (Object[])new Object[0]);
    }

    @Override
    public String getShortDescriptionCheckingFileExistance(IProgressMonitor monitor) {
        String description = this.getShortDescription();
        try {
            if (this.getFile() == null || !this.getFile().exists(monitor)) {
                description = NLS.bind((String)Messages.LocalIgnoreRule_DESCRIPTION_FROM_DEFAULT_IGNORE, (Object)this.getMatcher().getPattern(), (Object[])new Object[0]);
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return description;
    }
}

