/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class IgnoreRule
implements IIgnoreProvider.IIgnoreRule {
    protected final StringMatcher matcher;
    protected final IShareable file;
    protected final DefaultIgnoreProvider provider;

    public IgnoreRule(IShareable file, DefaultIgnoreProvider provider, String pattern, boolean ignorecase, boolean ignoreWildCards) {
        this.file = file;
        this.provider = provider;
        this.matcher = new StringMatcher(pattern, ignorecase, ignoreWildCards);
    }

    public StringMatcher getMatcher() {
        return this.matcher;
    }

    public boolean isLocal() {
        return !this.isRecursive();
    }

    public IShareable getFile() {
        return this.file;
    }

    @Override
    public final IShareable getRootShareable() {
        return ((Shareable)this.file).getParent();
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }

    public IRelativeLocation getRootShareableLocalPath() {
        return this.file.getLocalPath().removeLastSegments(1);
    }

    public boolean shouldBeIgnored(IRelativeLocation path) {
        String filename = path.getName();
        return this.matcher.match(filename);
    }

    public abstract boolean isTrivial();

    public abstract String getShortDescriptionCheckingFileExistance(IProgressMonitor var1);

    @Override
    public boolean shouldBeIgnored(IShareable shareable) {
        return this.shouldBeIgnored(shareable.getLocalPath());
    }

    @Override
    public abstract boolean isEffectiveBelow(IShareable var1);

    @Override
    public IIgnoreProvider getProvider() {
        return this.provider;
    }

    public String toString() {
        return String.valueOf(this.isRecursive() ? "REC" : "LOCAL") + ":/" + this.matcher.getPattern() + "/";
    }

    public boolean equals(Object obj) {
        if (obj instanceof IgnoreRule) {
            IgnoreRule other = (IgnoreRule)obj;
            return this.matcher.getPattern().equals(other.getMatcher().getPattern()) && this.getFile().equals(other.getFile()) && this.isRecursive() == other.isRecursive();
        }
        return false;
    }

    public int hashCode() {
        return this.matcher.getPattern().hashCode() ^ this.getFile().hashCode();
    }
}

