/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreReason;
import com.ibm.team.filesystem.client.internal.ignore.PathPair;
import com.ibm.team.filesystem.client.internal.utils.ILRUCache;
import com.ibm.team.filesystem.client.internal.utils.LRUCache;
import com.ibm.team.filesystem.client.internal.utils.SynchronizedLRUCache;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class IgnoreManager
implements IIgnoreManager {
    public static final Object IGNORE_FILES_CHANGED_JOB = "IgnoreFilesChangedJob";
    private static String PT_IGNORE_PROVIDER = "ignoreProvider";
    private static String ATTR_CLASS = "class";
    private static String ATTR_NAME = "name";
    private final Object providersLock = new Object();
    HashMap<String, IIgnoreProvider> providers = new HashMap();
    private boolean providersLoadedFromExtensionPoint = false;
    protected EventSource eventSource = new EventSource();
    ILRUCache<PathPair, Boolean> cache = new SynchronizedLRUCache<PathPair, Boolean>(new LRUCache(400));
    private static IgnoreManager instance;
    private IgnoreFilesChangedJob ignoreFilesChangedJob = new IgnoreFilesChangedJob();

    public static synchronized IIgnoreManager getInstance() {
        if (instance == null) {
            instance = new IgnoreManager();
        }
        return instance;
    }

    private IgnoreManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIgnoreProvider(String name, IIgnoreProvider provider, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        Object object = this.providersLock;
        synchronized (object) {
            if (this.providers.containsKey(name)) {
                throw new IllegalStateException(NLS.bind((String)Messages.IgnoreManager_0, (Object)name));
            }
            this.providers = (HashMap)this.providers.clone();
            this.providers.put(name, provider);
            provider.setIgnoreManager(this, this.eventSource, (IProgressMonitor)monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIgnoreProvider(String name) throws NoSuchElementException {
        Object object = this.providersLock;
        synchronized (object) {
            HashMap newProviders = (HashMap)this.providers.clone();
            IIgnoreProvider removed = (IIgnoreProvider)newProviders.remove(name);
            if (removed == null) {
                throw new NoSuchElementException();
            }
            this.providers = newProviders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IIgnoreProvider> getProviders(IProgressMonitor monitor) {
        Object object = this.providersLock;
        synchronized (object) {
            this.loadProvidersFromExtensionPoint(monitor);
            return this.providers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadProvidersFromExtensionPoint(IProgressMonitor progress) {
        try {
            Object object = this.providersLock;
            synchronized (object) {
                block14: {
                    if (!this.providersLoadedFromExtensionPoint) break block14;
                    return;
                }
                this.providersLoadedFromExtensionPoint = true;
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.IgnoreManager_INITIALIZING_PLUGIN_CLASS, (int)1);
                IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_IGNORE_PROVIDER);
                monitor.setWorkRemaining(configs.length);
                IConfigurationElement[] iConfigurationElementArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement config = iConfigurationElementArray[n2];
                    String name = config.getAttribute(ATTR_NAME);
                    monitor.subTask(NLS.bind((String)Messages.IgnoreManager_INITIALIZING_PLUGIN_NAMED, (Object)name));
                    try {
                        IIgnoreProvider provider = (IIgnoreProvider)config.createExecutableExtension(ATTR_CLASS);
                        this.addIgnoreProvider(name, provider, (IProgressMonitor)monitor.newChild(1));
                    }
                    catch (IllegalStateException e) {
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.IgnoreManager_ALREADY_LOADED, (Object)name), e));
                    }
                    catch (FileSystemException e) {
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.IgnoreManager_PROBLEM_STARTING, (Object)name), (Throwable)((Object)e)));
                    }
                    catch (CoreException e) {
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.IgnoreManager_PLUGIN_LOAD_FAILED, (Object)name), e));
                    }
                    ++n2;
                }
            }
        }
        finally {
            if (progress != null) {
                progress.done();
            }
        }
    }

    @Override
    public IIgnoreManager.IIgnoreReason findIgnoreReasons(IShareable shareable, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)NLS.bind((String)Messages.IgnoreManager_FIND_WHY_FILE_OR_FOLDER_IS_IGNORED, (Object)shareable.getLocalPath().toString()), (int)3);
        if (!this.shouldBeIgnored(shareable, (IProgressMonitor)monitor.newChild(1))) {
            return null;
        }
        PathPair fullPath = new PathPair(shareable);
        ISandbox sandbox = shareable.getSandbox();
        IIgnoreProvider.IIgnoreTester[] testers = this.getIgnoreTesters(shareable, (IProgressMonitor)monitor.newChild(1));
        monitor.setWorkRemaining(fullPath.getInnerPath().segmentCount() * testers.length);
        IRelativeLocation walker = new RelativeLocation(new String[0]);
        String[] segments = fullPath.getInnerPath().segments();
        ArrayList<IIgnoreProvider.IIgnoreRule> allRules = new ArrayList<IIgnoreProvider.IIgnoreRule>();
        int i = 0;
        while (i < segments.length) {
            walker = walker.append(segments[i]);
            IIgnoreProvider.IIgnoreTester[] iIgnoreTesterArray = testers;
            int n = testers.length;
            int n2 = 0;
            while (n2 < n) {
                IIgnoreProvider.IIgnoreTester tester = iIgnoreTesterArray[n2];
                List rules = tester.findIgnoreReasons(shareable, walker, (IProgressMonitor)monitor.newChild(1));
                Assert.isNotNull((Object)rules);
                allRules.addAll(rules);
                ++n2;
            }
            if (allRules.size() > 0) {
                IShareable inheritsFrom = null;
                if (i < segments.length - 1) {
                    inheritsFrom = sandbox.findShareable(walker, ResourceType.FOLDER);
                }
                return new IgnoreReason(shareable, allRules, inheritsFrom);
            }
            ++i;
        }
        return null;
    }

    private IIgnoreProvider.IIgnoreTester[] getIgnoreTesters(IShareable shareable, IProgressMonitor monitor) {
        Map<String, IIgnoreProvider> myProviders = this.getProviders(monitor);
        IIgnoreProvider.IIgnoreTester[] testers = new IIgnoreProvider.IIgnoreTester[myProviders.size()];
        int i = 0;
        for (IIgnoreProvider provider : myProviders.values()) {
            testers[i++] = provider.getTester(shareable);
        }
        return testers;
    }

    /*
     * Unable to fully structure code
     */
    private void checkForCacheInvalidation(IIgnoreProvider.IIgnoreTester[] testers, IShareable shareable, IProgressMonitor monitor) {
        block19: {
            requiresInvalidation = new ArrayList<IIgnoreProvider.IIgnoreTester>();
            try {
                var8_5 = testers;
                var7_6 = testers.length;
                var6_7 = 0;
                while (var6_7 < var7_6) {
                    tester = var8_5[var6_7];
                    if (tester.shouldInvalidateCache(shareable, monitor)) {
                        requiresInvalidation.add(tester);
                    }
                    ++var6_7;
                }
            }
            finally {
                if (requiresInvalidation.isEmpty()) break block19;
                try {
                    this.cache.flush();
                }
                finally {
                    ** for (tester : requiresInvalidation)
                }
            }
lbl-1000:
            // 1 sources

            {
                try {
                    tester.cacheInvalidated(shareable);
                }
                catch (Throwable e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                }
                continue;
            }
        }
    }

    @Override
    public boolean shouldBeIgnored(IShareable shareable, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)NLS.bind((String)Messages.IgnoreManager_IS_FILE_OR_FOLDER_IGNORED, (Object)shareable.getLocalPath().toString()), (int)5);
        IIgnoreProvider.IIgnoreTester[] testers = this.getIgnoreTesters(shareable, (IProgressMonitor)monitor.newChild(1));
        this.checkForCacheInvalidation(testers, shareable, (IProgressMonitor)monitor.newChild(1));
        ILocation cfaRoot = shareable.getSandbox().getRoot();
        IRelativeLocation relativePath = shareable.getLocalPath();
        monitor.setWorkRemaining(relativePath.segmentCount() * 2);
        ArrayList<String> segments = new ArrayList<String>(relativePath.segmentCount());
        Boolean shouldIgnore = null;
        while (!relativePath.isEmpty() && shouldIgnore == null) {
            PathPair key = new PathPair(cfaRoot, relativePath);
            shouldIgnore = this.cache.get(key);
            if (shouldIgnore != null) continue;
            segments.add(relativePath.segment(relativePath.segmentCount() - 1));
            relativePath = relativePath.removeLastSegments(1);
        }
        if (shouldIgnore != null) {
            if (segments.isEmpty()) {
                return shouldIgnore;
            }
            if (shouldIgnore.booleanValue()) {
                this.cache.put(new PathPair(shareable), true);
                return true;
            }
        }
        monitor.setWorkRemaining(segments.size());
        IRelativeLocation walker = relativePath;
        int i = segments.size() - 1;
        while (i >= 0) {
            walker = walker.append((String)segments.get(i));
            shouldIgnore = Boolean.FALSE;
            IIgnoreProvider.IIgnoreTester[] iIgnoreTesterArray = testers;
            int n = testers.length;
            int n2 = 0;
            while (n2 < n) {
                IIgnoreProvider.IIgnoreTester tester = iIgnoreTesterArray[n2];
                shouldIgnore = shouldIgnore | tester.shouldBeIgnored(shareable, walker, (IProgressMonitor)monitor.newChild(1));
                ++n2;
            }
            PathPair key = new PathPair(cfaRoot, walker);
            this.cache.put(key, shouldIgnore);
            if (shouldIgnore.booleanValue()) {
                this.cache.put(new PathPair(shareable), true);
                return true;
            }
            --i;
        }
        return false;
    }

    public void addGenericListener(Object category, IListener listener) {
        this.eventSource.addGenericListener(category, listener);
    }

    @Override
    public void addGenericListener(Object[] categories, IListener listener) {
        Object[] objectArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Object category = objectArray[n2];
            this.addGenericListener(category, listener);
            ++n2;
        }
    }

    public void purgeGenericListener(IListener listener) {
        this.eventSource.purgeGenericListener(listener);
    }

    @Override
    public void removeGenericListener(Object[] categories, IListener listener) {
        Object[] objectArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Object category = objectArray[n2];
            this.eventSource.removeGenericListener(category, listener);
            ++n2;
        }
    }

    public void removeGenericListener(Object category, IListener listener) {
        this.eventSource.removeGenericListener(category, listener);
    }

    public void waitForEventsToDrain() {
        while (this.eventSource.internalIsBusy()) {
            try {
                Thread.sleep(4L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIgnoreProvider getIgnoreProvider(String name, IProgressMonitor progress) {
        Object object = this.providersLock;
        synchronized (object) {
            this.loadProvidersFromExtensionPoint(progress);
            if (!this.providers.containsKey(name)) {
                throw new IllegalStateException(NLS.bind((String)Messages.IgnoreManager_5, (Object)name));
            }
            return this.providers.get(name);
        }
    }

    @Override
    public boolean hasUndeliveredEvents() {
        return this.eventSource.internalIsBusy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIgnoreManager createCopy(Collection<? extends IIgnoreManager.ICopyParameter> list, IProgressMonitor progress) {
        Set<Map.Entry<String, IIgnoreProvider>> providers;
        final IgnoreManager copy = new IgnoreManager();
        copy.eventSource = new EventSource();
        copy.cache = new SynchronizedLRUCache<PathPair, Boolean>(new LRUCache());
        copy.providers = new HashMap();
        ArrayList<IIgnoreManager.ICopyParameter> paramWithIgnoreManager = new ArrayList<IIgnoreManager.ICopyParameter>();
        paramWithIgnoreManager.addAll(list);
        paramWithIgnoreManager.add(new IIgnoreManager.IIgnoreManagerCopyParameter(){

            @Override
            public IIgnoreManager getNewIgnoreManager() {
                return copy;
            }

            @Override
            public EventSource getEventQueue() {
                return copy.eventSource;
            }
        });
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
        Object object = this.providersLock;
        synchronized (object) {
            providers = this.getProviders((IProgressMonitor)monitor.newChild(1)).entrySet();
            copy.providersLoadedFromExtensionPoint = this.providersLoadedFromExtensionPoint;
        }
        monitor.setWorkRemaining(providers.size());
        for (Map.Entry<String, IIgnoreProvider> entry : providers) {
            IIgnoreProvider provider = entry.getValue().createCopy(paramWithIgnoreManager, (IProgressMonitor)monitor.newChild(1));
            copy.providers.put(entry.getKey(), provider);
        }
        return copy;
    }

    @Override
    public IIgnoreManager createCopy(IProgressMonitor progress) {
        return this.createCopy(Collections.EMPTY_LIST, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate() {
        Object object = this.providersLock;
        synchronized (object) {
            for (IIgnoreProvider provider : this.providers.values()) {
                provider.deallocate(this);
            }
            this.providers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushInAbsenceOfEvents(Collection<IShareable> roots, IProgressMonitor progress) throws FileSystemException {
        Object object = this.providersLock;
        synchronized (object) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.providers.size());
            for (IIgnoreProvider provider : this.providers.values()) {
                provider.flushInAbsenceOfEvents(roots, (IProgressMonitor)monitor.newChild(1));
            }
        }
        this.cache.flush();
    }

    @Override
    public void ignoreFilesChanged(List<IShareable> ignoreFiles) {
        this.ignoreFilesChangedJob.queueIgnoreFileChanges(ignoreFiles);
    }

    public static class IgnoreFilesChangedJob
    extends Job {
        private static final long MINIMUM_DELAY = 100L;
        private boolean changeQueuedSinceLastCheck = false;
        private Set<IShareable> ignoreFilesChangedQueue = new HashSet<IShareable>();

        public IgnoreFilesChangedJob() {
            super(Messages.IgnoreManager_1);
            this.setSystem(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor progress) {
            ArrayList<IShareable> ignoreFiles;
            Set<IShareable> set = this.ignoreFilesChangedQueue;
            synchronized (set) {
                if (this.changeQueuedSinceLastCheck) {
                    this.changeQueuedSinceLastCheck = false;
                    this.schedule(100L);
                    return Status.OK_STATUS;
                }
                ignoreFiles = new ArrayList<IShareable>(this.ignoreFilesChangedQueue);
                this.ignoreFilesChangedQueue.clear();
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
            DefaultIgnoreProvider dip = (DefaultIgnoreProvider)SharingManager.getInstance().getIgnoreManager().getIgnoreProvider("default", (IProgressMonitor)monitor.newChild(1));
            IStatus filesChangedResult = dip.ignoreFilesChanged(ignoreFiles, (IProgressMonitor)monitor.newChild(1));
            if (!filesChangedResult.isOK()) {
                return filesChangedResult;
            }
            this.schedule(100L);
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueIgnoreFileChanges(Collection<IShareable> changedIgnoreFiles) {
            Set<IShareable> set = this.ignoreFilesChangedQueue;
            synchronized (set) {
                this.ignoreFilesChangedQueue.addAll(changedIgnoreFiles);
                this.changeQueuedSinceLastCheck = true;
                this.schedule(100L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            Set<IShareable> set = this.ignoreFilesChangedQueue;
            synchronized (set) {
                return !this.ignoreFilesChangedQueue.isEmpty();
            }
        }

        public boolean shouldSchedule() {
            return super.shouldRun();
        }

        public boolean belongsTo(Object family) {
            return family == IGNORE_FILES_CHANGED_JOB;
        }
    }
}

