/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnorePattern;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRuleComparator;
import com.ibm.team.filesystem.client.internal.ignore.JazzIgnoreFile;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.RecursiveIgnoreRule;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class IgnoreFileLoader {
    static final byte[] PREAMBLE;
    public static final String PT_IGNORE_FORMAT = "ignoreFileFormat";
    private IIgnoreFileLoader latestLoader = null;
    private Map<Integer, IIgnoreFileLoader> loaders = new HashMap<Integer, IIgnoreFileLoader>();
    private static IgnoreFileLoader instance;

    static {
        try {
            PREAMBLE = "### Jazz Ignore ".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static synchronized IgnoreFileLoader getInstance() {
        if (instance == null) {
            IConfigurationElement[] configs;
            instance = new IgnoreFileLoader();
            int maxVersion = -1;
            IConfigurationElement[] iConfigurationElementArray = configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_IGNORE_FORMAT);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                try {
                    IIgnoreFileLoader loader = (IIgnoreFileLoader)config.createExecutableExtension("class");
                    if (IgnoreFileLoader.instance.loaders.containsKey(loader.getVersion())) {
                        LoggingHelper.error("com.ibm.team.filesystem.client", "Duplicate ignore providers for version " + loader.getVersion(), null);
                    } else {
                        IgnoreFileLoader.instance.loaders.put(loader.getVersion(), loader);
                        maxVersion = Math.max(loader.getVersion(), maxVersion);
                    }
                }
                catch (CoreException e) {
                    LoggingHelper.log(e);
                }
                ++n2;
            }
            if (maxVersion > -1) {
                IgnoreFileLoader.instance.latestLoader = IgnoreFileLoader.instance.loaders.get(maxVersion);
            }
        }
        return instance;
    }

    public byte[] getIgnorePreamble(int version) {
        byte[] versionBytes;
        try {
            versionBytes = Integer.toString(version).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        byte[] toReturn = new byte[PREAMBLE.length + versionBytes.length + 1];
        System.arraycopy(PREAMBLE, 0, toReturn, 0, PREAMBLE.length);
        System.arraycopy(versionBytes, 0, toReturn, PREAMBLE.length, versionBytes.length);
        toReturn[toReturn.length - 1] = 10;
        return toReturn;
    }

    public JazzIgnoreFile load(DefaultIgnoreProvider provider, IShareable content, boolean create, IProgressMonitor progress) throws FileSystemException, FileInaccessibleException {
        return this.load(provider.getFilesystem(), provider, content, create, progress);
    }

    public JazzIgnoreFile load(DefaultIgnoreProvider.IFilesystemAbstraction filesystem, DefaultIgnoreProvider provider, IShareable content, boolean create, IProgressMonitor progress) throws FileSystemException, FileInaccessibleException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)1);
        JazzIgnoreFile file = null;
        file = this.load(filesystem, provider, content, (IProgressMonitor)monitor);
        if (file == null) {
            if (this.isGlobal(content.getLocalPath())) {
                return this.createGlobalIgnoreFile(provider, content);
            }
            if (create) {
                file = new JazzIgnoreFile(provider, content, new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE), DefaultIgnoreProvider.IFilesystemAbstraction.NULL_MOD, -2L);
            }
        }
        monitor.done();
        return file;
    }

    public JazzIgnoreFile createGlobalIgnoreFile(DefaultIgnoreProvider provider, IShareable content) {
        TreeSet<IgnoreRule> rules = new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE);
        rules.add(new LocalIgnoreRule(content, provider, JazzIgnoreFile.DEFAULT_PROP_IGNORE_LOCAL[0], false, false));
        rules.add(new RecursiveIgnoreRule(content, provider, JazzIgnoreFile.DEFAULT_PROP_IGNORE_GLOBAL[0], false, false));
        return new JazzIgnoreFile(provider, content, rules, DefaultIgnoreProvider.IFilesystemAbstraction.NULL_MOD, -2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JazzIgnoreFile load(DefaultIgnoreProvider.IFilesystemAbstraction filesystem, DefaultIgnoreProvider provider, IShareable content, IProgressMonitor progress) throws FileSystemException, FileInaccessibleException {
        SubMonitor monitor;
        IgnoreFileMetadata metadata;
        IIgnoreFileLoader loader;
        InputStream in;
        block23: {
            in = null;
            loader = null;
            metadata = null;
            monitor = SubMonitor.convert((IProgressMonitor)progress, (String)NLS.bind((String)Messages.IgnoreFileLoader_LOADING_FILE, (Object)content.getLocalPath().toString()), (int)10);
            in = filesystem.read(content, (IProgressMonitor)monitor.newChild(2));
            if (in == null) {
                return null;
            }
            try {
                try {
                    monitor.subTask(Messages.IgnoreFileLoader_FINDING_FILE_VERSION_NUMBER);
                    metadata = this.consumeVersionPreamble(in);
                    Map<Integer, IIgnoreFileLoader> map = this.loaders;
                    synchronized (map) {
                        loader = this.loaders.get(metadata.version);
                    }
                }
                catch (IgnoreFileVersionException e) {
                    metadata = new IgnoreFileMetadata();
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (loader == null && (loader = this.latestLoader) == null) {
            return new JazzIgnoreFile(provider, content, new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE), DefaultIgnoreProvider.IFilesystemAbstraction.NULL_MOD, -2L);
        }
        try {
            in = filesystem.read(content, (IProgressMonitor)monitor.newChild(2));
            JazzIgnoreFile jazzIgnoreFile = loader.load(metadata.version, metadata.encoding, filesystem, in, provider, content, (IProgressMonitor)monitor.newChild(6));
            return jazzIgnoreFile;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isGlobal(IRelativeLocation path) {
        return path.segmentCount() == 2;
    }

    private IgnoreFileMetadata consumeVersionPreamble(InputStream toConsume) throws IgnoreFileVersionException, FileSystemException {
        IgnoreFileMetadata metadata = new IgnoreFileMetadata();
        metadata.version = -1;
        metadata.encoding = "UTF-8";
        try {
            int c;
            int r;
            int i = 0;
            while ((r = toConsume.read()) != -1 && i < PREAMBLE.length) {
                if (r == PREAMBLE[i++]) continue;
                throw new IgnoreFileVersionException(NLS.bind((String)Messages.IgnoreFileLoader_6, (Object)i));
            }
            while ((c = toConsume.read()) != -1 && Character.isDigit(c)) {
                metadata.version = metadata.version * 10 + (c - 48);
            }
            if (c == -1) {
                throw new IgnoreFileVersionException(Messages.IgnoreFileLoader_7);
            }
            if (c == 13 || c == 10) {
                return metadata;
            }
            throw new IgnoreFileVersionException(Messages.IgnoreFileLoader_8);
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.IgnoreFileLoader_9);
        }
    }

    public JazzIgnoreFile createNew(IShareable file, DefaultIgnoreProvider provider, SortedSet<IgnoreRule> rules, IProgressMonitor progress) throws FileSystemException {
        if (this.latestLoader == null) {
            return null;
        }
        return this.latestLoader.store(provider.getFilesystem(), provider, file, rules, progress);
    }

    public byte[] asBytes(IRelativeLocation path, SortedSet<IgnoreRule> rules) throws FileSystemException {
        if (this.latestLoader == null) {
            throw new IllegalStateException();
        }
        return this.latestLoader.asBytes(path, rules);
    }

    public Collection<IgnorePattern> getDefaultIgnorePatterns(IRelativeLocation path) {
        if (this.latestLoader == null) {
            throw new IllegalStateException();
        }
        return this.latestLoader.getDefaultIgnorePatterns(path);
    }

    public static class FileInaccessibleException
    extends Exception {
        private static final long serialVersionUID = 5048576172792150059L;
    }

    public static interface IIgnoreFileLoader {
        public JazzIgnoreFile load(int var1, String var2, DefaultIgnoreProvider.IFilesystemAbstraction var3, InputStream var4, IIgnoreProvider var5, IShareable var6, IProgressMonitor var7) throws FileSystemException;

        public JazzIgnoreFile store(DefaultIgnoreProvider.IFilesystemAbstraction var1, DefaultIgnoreProvider var2, IShareable var3, SortedSet<IgnoreRule> var4, IProgressMonitor var5) throws FileSystemException;

        public int getVersion();

        public byte[] asBytes(IRelativeLocation var1, SortedSet<IgnoreRule> var2) throws FileSystemException;

        public Collection<IgnorePattern> getDefaultIgnorePatterns(IRelativeLocation var1);
    }

    private static class IgnoreFileMetadata {
        Integer version = -1;
        String encoding = "UTF-8";

        private IgnoreFileMetadata() {
        }
    }

    public static class IgnoreFileVersionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        IgnoreFileVersionException(String msg) {
            super(msg);
        }
    }
}

