/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ignore.IDefaultIgnoreProviderEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils;
import com.ibm.team.repository.client.util.IEventSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class IgnoreEvent
implements IDefaultIgnoreProviderEvent {
    private final IShareable ignoreFile;
    private final String type;
    private Collection<IShareable> changed;
    private final IIgnoreManager source;
    private final List<Object> categories;
    private Collection<? extends IIgnoreProvider.IIgnoreRule> rules;

    public IgnoreEvent(IIgnoreManager source, IShareable ignoreFile, String type, List categories, Collection<? extends IIgnoreProvider.IIgnoreRule> rules) {
        this.source = source;
        this.ignoreFile = ignoreFile;
        this.type = type;
        if (categories.contains(type)) {
            this.categories = categories;
        } else {
            this.categories = new ArrayList<Object>(categories.size() + 1);
            this.categories.add(type);
            this.categories.addAll(categories);
        }
        this.rules = rules;
    }

    @Override
    public String getChangeType() {
        return this.type;
    }

    @Override
    public boolean isInEffectFor(IShareable shareable) {
        if (this.hasRecursiveRule()) {
            return this.getRoot().getLocalPath().isPrefixOf(shareable.getLocalPath());
        }
        return this.getRoot().getLocalPath().equals(shareable.getLocalPath().getParent());
    }

    private boolean hasRecursiveRule() {
        if (this.rules == null) {
            return true;
        }
        for (IIgnoreProvider.IIgnoreRule iIgnoreRule : this.rules) {
            if (!iIgnoreRule.isGlobal() && !iIgnoreRule.isRecursive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IShareable> getChanged(IProgressMonitor progress) throws FileSystemException {
        if ("unknown".equals(this.getChangeType())) {
            this.changed = null;
        } else if (this.changed == null) {
            this.changed = new LinkedList<IShareable>();
            if ("ignore".equals(this.getChangeType())) {
                this.gatherNewlyIgnored(progress);
            } else if ("unignore".equals(this.getChangeType())) {
                this.gatherNewlyUnignored(progress);
            } else {
                throw new IllegalStateException(NLS.bind((String)Messages.IgnoreEvent_0, (Object)this.getChangeType()));
            }
        }
        return this.changed;
    }

    private void gatherNewlyIgnored(IProgressMonitor progress) throws FileSystemException {
        Assert.isTrue((boolean)"ignore".equals(this.getChangeType()));
        progress.subTask(NLS.bind((String)Messages.IgnoreEvent_1, (Object)this.getRoot().getLocalPath()));
        IgnoreUtils.findIgnoresForRules(this.rules, new IgnoreUtils.IIgnoredShareablesVisitor(){

            @Override
            public void visitShareableIgnoredByRule(IIgnoreProvider.IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) {
                IgnoreEvent.this.changed.add(shareable);
            }

            @Override
            public boolean shouldSkip(IIgnoreProvider.IIgnoreRule rule, IShareable shareable, IProgressMonitor progress) throws FileSystemException {
                IIgnoreManager.IIgnoreReason reason = IgnoreEvent.this.source.findIgnoreReasons(shareable, progress);
                return reason != null && !reason.getRules().contains(rule);
            }
        }, progress);
    }

    private void gatherNewlyUnignored(IProgressMonitor progress) throws FileSystemException {
        Assert.isTrue((boolean)"unignore".equals(this.getChangeType()));
        if (this.rules == null) {
            this.changed = null;
            return;
        }
        progress.subTask(NLS.bind((String)Messages.IgnoreEvent_2, (Object)this.getRoot().getLocalPath()));
        IgnoreUtils.findIgnoresForRules(this.rules, new IgnoreUtils.IIgnoredShareablesVisitor(){

            @Override
            public void visitShareableIgnoredByRule(IIgnoreProvider.IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) {
                IgnoreEvent.this.changed.add(shareable);
            }

            @Override
            public boolean shouldSkip(IIgnoreProvider.IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) {
                return IgnoreEvent.this.source.shouldBeIgnored(shareable, monitor);
            }
        }, progress);
    }

    @Override
    public Collection<IShareable> getOptimalKnownTraversalRoots() {
        if (this.changed != null) {
            return this.changed;
        }
        return Collections.singletonList(this.getRoot());
    }

    @Override
    public IShareable getRoot() {
        return ((Shareable)this.getIgnoreFile()).getParent();
    }

    @Override
    public ISandbox getSandbox() {
        return this.getIgnoreFile().getSandbox();
    }

    @Override
    public Collection<? extends IIgnoreProvider.IIgnoreRule> getRules() {
        return this.rules;
    }

    public List getCategories() {
        return this.categories;
    }

    public IEventSource getEventSource() {
        return this.source;
    }

    public String getEventType() {
        return this.type;
    }

    @Override
    public IShareable getIgnoreFile() {
        return this.ignoreFile;
    }

    public String toString() {
        return "IgnoreEvent(" + (this.hasRecursiveRule() ? "GLOBAL" : "LOCAL") + ", [" + this.getIgnoreFile().getLocalPath() + "], type:" + this.getEventType() + ")";
    }
}

