/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IFileStorageVisitor;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader;
import com.ibm.team.filesystem.client.internal.ignore.IgnorePattern;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRuleComparator;
import com.ibm.team.filesystem.client.internal.ignore.JazzIgnoreFile;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.PathPair;
import com.ibm.team.filesystem.client.internal.ignore.RecursiveIgnoreRule;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.IgnoreFileAgeDBHM;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils;
import com.ibm.team.filesystem.client.internal.utils.LRUCache;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class DefaultIgnoreProvider
extends IgnoreProvider
implements ICopyFileAreaListener {
    public static final String EVENT_EXTERNAL_CHANGE = "external_change";
    private static final List CATEGORY_EXTERNAL_CHANGE = Collections.singletonList("external_change");
    public static final double FILE_CACHE_RATIO = 4.0;
    private static final int FILE_CACHE_MIN = 150;
    private static final int FILE_CACHE_NO_DEFAULT_CFA = 300;
    private final LRUCache<PathPair, JazzIgnoreFile> files;
    private int shareCount;
    private IgnoreFileAgeDBHM fileAges = new IgnoreFileAgeDBHM();
    private boolean shouldInvalidateCache = false;
    private IFilesystemAbstraction filesystem;
    public static final String IGNORE_FILE_NAME = ".jazzignore";
    Set<IShareable> modifiedFiles = new HashSet<IShareable>();

    private IShareable getParentFor(IShareable shareable) {
        return ((Shareable)shareable).getParent();
    }

    public static DefaultIgnoreProvider getDefault(IProgressMonitor progress) {
        return (DefaultIgnoreProvider)SharingManager.getInstance().getIgnoreManager().getIgnoreProvider("default", progress);
    }

    public DefaultIgnoreProvider() {
        this(new PassThroughFilesystemAbstraction());
    }

    public DefaultIgnoreProvider(IFilesystemAbstraction fs) {
        this.filesystem = fs;
        final SharingManager sm = SharingManager.getInstance();
        this.shareCount = 300;
        sm.addListener(this);
        final LRUCache<PathPair, JazzIgnoreFile> lock = this.files = new LRUCache(DefaultIgnoreProvider.computeFileCacheSize(this.shareCount));
        new Job(Messages.DefaultIgnoreProvider_2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int numShares = sm.allShares(monitor).length;
                    Object object = lock;
                    synchronized (object) {
                        int sizeChange = numShares - DefaultIgnoreProvider.this.shareCount;
                        DefaultIgnoreProvider.this.updateSize(sizeChange, null);
                    }
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @Override
    public void change(ICopyFileAreaEvent[] events) {
        int sizeChange = 0;
        LinkedList<IRelativeLocation> removed = null;
        ICopyFileAreaEvent[] iCopyFileAreaEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ICopyFileAreaEvent event = iCopyFileAreaEventArray[n2];
            switch (event.getReason()) {
                case 1: {
                    ++sizeChange;
                    break;
                }
                case 2: {
                    if (removed == null) {
                        removed = new LinkedList<IRelativeLocation>();
                    }
                    removed.add(event.getPath());
                    --sizeChange;
                }
            }
            ++n2;
        }
        if (sizeChange == 0) {
            return;
        }
        this.updateSize(sizeChange, removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSize(int sizeChange, List<IRelativeLocation> removed) {
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.shareCount += sizeChange;
            int desiredCacheSize = DefaultIgnoreProvider.computeFileCacheSize(this.shareCount);
            this.files.setSpaceLimit(desiredCacheSize);
            if (removed != null) {
                for (IRelativeLocation removedSharePath : removed) {
                    Iterator<PathPair> keys = this.files.keys();
                    while (keys.hasNext()) {
                        IRelativeLocation key = keys.next().getInnerPath();
                        if (!removedSharePath.isPrefixOf(key)) continue;
                        keys.remove();
                    }
                }
                this.shouldInvalidateCache = true;
            }
        }
    }

    private static int computeFileCacheSize(int shareCount) {
        return (int)Math.max(150.0, (double)shareCount * 4.0);
    }

    public IgnoreRule getIgnoreRuleFor(IShareable toIgnore, boolean isGlobal) {
        IRelativeLocation path = toIgnore.getLocalPath();
        String lastSegment = path.getName();
        if (isGlobal) {
            return new RecursiveIgnoreRule(this.getGlobalIgnoreShareable(toIgnore), this, lastSegment, false, false);
        }
        return new LocalIgnoreRule(this.getIgnoreShareableForFolder(toIgnore.getSandbox(), path.getParent()), this, lastSegment, false, false);
    }

    public List<IgnoreRule> getIgnoreRulesFor(String pattern, List<? extends IShareable> installationPoints, boolean isGlobal) {
        HashSet<IShareable> roots = new HashSet<IShareable>();
        for (IShareable iShareable : installationPoints) {
            roots.add(iShareable);
        }
        ArrayList<IgnoreRule> arrayList = new ArrayList<IgnoreRule>(roots.size());
        for (IShareable root : roots) {
            IgnoreRule rule = null;
            rule = isGlobal ? new RecursiveIgnoreRule(this.getIgnoreShareableForFolder(root.getSandbox(), root.getLocalPath()), this, pattern, false, false) : new LocalIgnoreRule(this.getIgnoreShareableForFolder(root.getSandbox(), root.getLocalPath()), this, pattern, false, false);
            arrayList.add(rule);
        }
        return arrayList;
    }

    public IIgnoreProvider.IIgnoreRule ignore(IShareable shareable, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
        if (share == null) {
            throw new FileSystemException(String.valueOf(Messages.DefaultIgnoreProvider_3) + shareable.getLocalPath().toString());
        }
        IShareable parent = this.getParentFor(shareable);
        if (parent == null) {
            throw new FileSystemException(NLS.bind((String)Messages.DefaultIgnoreProvider_4, (Object)shareable.getLocalPath().toString()));
        }
        if (!this.canIgnore(shareable, (IProgressMonitor)monitor.newChild(1))) {
            throw new FileSystemException(NLS.bind((String)Messages.DefaultIgnoreProvider_5, (Object)shareable.getLocalPath().toString()));
        }
        IgnoreRule rule = this.getIgnoreRuleFor(shareable, false);
        this.addIgnoreRule(rule, (IProgressMonitor)monitor.newChild(98));
        return rule;
    }

    public void unignore(IShareable shareable, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        try {
            IIgnoreManager.IIgnoreReason reason = this.getIgnoreManager().findIgnoreReasons(shareable, progress);
            if (reason == null) {
                throw new FileSystemException(NLS.bind((String)Messages.DefaultIgnoreProvider_6, (Object)shareable.getLocalPath()));
            }
            if (reason.inherited()) {
                throw new FileSystemException(NLS.bind((String)Messages.DefaultIgnoreProvider_7, (Object)shareable.getLocalPath()));
            }
            monitor.setWorkRemaining(reason.getRules().size());
            for (IIgnoreProvider.IIgnoreRule externalRule : reason.getRules()) {
                this.removeIgnoreRule((IgnoreRule)externalRule, (IProgressMonitor)monitor.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean canIgnore(IShareable shareable, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        if (shareable.getShare((IProgressMonitor)monitor.newChild(1)) == null) {
            return false;
        }
        IRelativeLocation path = shareable.getLocalPath();
        if (path.segmentCount() <= 1) {
            return false;
        }
        return !this.getIgnoreManager().shouldBeIgnored(shareable, (IProgressMonitor)monitor.newChild(1));
    }

    public void accept(Collection<IShareable> roots, final IIgnoreVisitor visitor, IFilesystemAbstraction fs, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(roots.size() * 10));
        final MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 4, Messages.DefaultIgnoreProvider_8, null);
        final IFilesystemAbstraction filesystem = fs == null ? this.filesystem : fs;
        for (IShareable root : roots) {
            final boolean[] visitedGlobalIgnoreFile = new boolean[1];
            ((Shareable)root).getFileStorage().accept(new IFileStorageVisitor(){

                @Override
                public boolean visit(IFileStorage storage, IProgressMonitor monitor) {
                    if (DefaultIgnoreProvider.IGNORE_FILE_NAME.equals(storage.getName())) {
                        JazzIgnoreFile file;
                        try {
                            file = IgnoreFileLoader.getInstance().load(filesystem, DefaultIgnoreProvider.this, storage.getShareable(), false, monitor);
                        }
                        catch (FileSystemException e) {
                            multi.add(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                            return true;
                        }
                        catch (IgnoreFileLoader.FileInaccessibleException e) {
                            return true;
                        }
                        if (file == null) {
                            return true;
                        }
                        if (file.isGlobal()) {
                            visitedGlobalIgnoreFile[0] = true;
                        }
                        visitor.visit(file.getRules());
                    }
                    return true;
                }
            }, Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(9));
            if (visitedGlobalIgnoreFile[0]) continue;
            visitor.visit(this.getGlobalIgnoreFile(root, monitor.newChild(1)).getRules());
        }
        if (multi.getChildren().length > 0) {
            throw new FileSystemStatusException((IStatus)multi);
        }
    }

    private void removeRule(IIgnoreProvider.IIgnoreRule passedRule, IProgressMonitor progress) throws FileSystemException {
        if (!(passedRule instanceof IgnoreRule)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.DefaultIgnoreProvider_9, (Object)passedRule.getClass().getSimpleName()));
        }
        IgnoreRule rule = (IgnoreRule)passedRule;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.DefaultIgnoreProvider_REMOVING_ITEM_FROM_FILE, (int)5);
        JazzIgnoreFile file = this.getIgnoreFileForFolder(rule.getFile().getSandbox(), rule.getRootShareableLocalPath(), false, (IProgressMonitor)monitor.newChild(1));
        if (file == null) {
            return;
        }
        monitor.setTaskName(NLS.bind((String)Messages.DefaultIgnoreProvider_REMOVING_ITEM_FROM_FILE_WITH_NAME, (Object)file.getFile().getLocalPath().toString()));
        ISchedulingRule sr = this.findSchedulingRuleFor(rule.getFile(), (IProgressMonitor)monitor.newChild(1));
        try {
            Job.getJobManager().beginRule(sr, (IProgressMonitor)monitor.newChild(1));
            this.startModifyingFile(rule.getFile());
            try {
                JazzIgnoreFile newFile = file.removeRules(Collections.singleton(rule), (IProgressMonitor)monitor.newChild(1));
                this.updateCacheFor(new PathPair(rule), newFile);
            }
            finally {
                this.stopModifyingFile(rule.getFile(), monitor.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(sr);
            monitor.done();
        }
    }

    @Override
    public IIgnoreProvider.IIgnoreTester getTester(IShareable shareable) {
        return new DefaultIgnoreTester(shareable);
    }

    private void visitIgnoreFilesOnPath(IShareable onBehalfOf, IRelativeLocation currentPath, IIgnorePathVisitor visitor, boolean skipNullIgnoreFiles, IProgressMonitor progress) {
        int segmentCount = currentPath.segmentCount();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)segmentCount);
        int i = 1;
        while (i < segmentCount) {
            boolean keepGoing;
            IRelativeLocation walker = currentPath.uptoSegment(i);
            JazzIgnoreFile ignoreFile = null;
            try {
                ignoreFile = walker.segmentCount() == 1 ? this.getGlobalIgnoreFile(onBehalfOf, mon.newChild(1)) : this.getIgnoreFileForFolder(onBehalfOf.getSandbox(), walker, false, (IProgressMonitor)mon.newChild(1));
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
            if (!(skipNullIgnoreFiles && ignoreFile == null || (keepGoing = visitor.visitIgnoreFiles(onBehalfOf, ignoreFile, mon.newChild(1))))) {
                mon.done();
                return;
            }
            ++i;
        }
    }

    public IFilesystemAbstraction getFilesystem() {
        return this.filesystem;
    }

    private IRelativeLocation getGlobalIgnoreRoot(IShareable shareable) {
        return shareable.getLocalPath().uptoSegment(1);
    }

    private JazzIgnoreFile getGlobalIgnoreFile(IShareable shareable, SubMonitor monitor) throws FileSystemException {
        JazzIgnoreFile file = this.getIgnoreFileForFolder(shareable.getSandbox(), this.getGlobalIgnoreRoot(shareable), false, (IProgressMonitor)monitor);
        if (file == null) {
            file = IgnoreFileLoader.getInstance().createGlobalIgnoreFile(this, shareable);
        }
        return file;
    }

    private IShareable getGlobalIgnoreShareable(IShareable shareable) {
        IRelativeLocation rootPath = this.getGlobalIgnoreRoot(shareable).append(IGNORE_FILE_NAME);
        return shareable.getSandbox().findShareable(rootPath, ResourceType.FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JazzIgnoreFile getIgnoreFileForFolder(ISandbox sandbox, IRelativeLocation folderPath, boolean create, IProgressMonitor progress) throws FileSystemException {
        JazzIgnoreFile file;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        PathPair fullFolderPath = new PathPair(sandbox.getRoot(), folderPath);
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            JazzIgnoreFile existingIgnoreFile = this.getExistingIgnoreFile(fullFolderPath);
            if (existingIgnoreFile != null) {
                return existingIgnoreFile;
            }
            if (this.files.containsKey(fullFolderPath) && !create) {
                return null;
            }
        }
        IShareable ignoreFile = this.getIgnoreShareableForFolder(sandbox, fullFolderPath.getInnerPath());
        try {
            file = IgnoreFileLoader.getInstance().load(this, ignoreFile, create, (IProgressMonitor)monitor.newChild(80));
        }
        catch (IgnoreFileLoader.FileInaccessibleException e) {
            LRUCache<PathPair, JazzIgnoreFile> lRUCache2 = this.files;
            synchronized (lRUCache2) {
                return this.files.get(fullFolderPath);
            }
        }
        LRUCache<PathPair, JazzIgnoreFile> lRUCache3 = this.files;
        synchronized (lRUCache3) {
            this.files.put(fullFolderPath, file);
            if (file == null) {
                this.fileAges.remove(fullFolderPath);
            } else {
                IgnoreFileAgeDBHM.DateStamp lastModified = this.filesystem.lastModified(ignoreFile);
                long size = this.filesystem.size(ignoreFile, (IProgressMonitor)monitor.newChild(10));
                this.fileAges.put(fullFolderPath, lastModified, size);
            }
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JazzIgnoreFile getExistingIgnoreFile(PathPair fullFolderPath) {
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            JazzIgnoreFile file = this.files.get(fullFolderPath);
            if (file != null) {
                return file;
            }
        }
        return null;
    }

    private IShareable getIgnoreShareableForFolder(ISandbox sandbox, IRelativeLocation folderPath) {
        return sandbox.findShareable(folderPath.append(IGNORE_FILE_NAME), ResourceType.FILE);
    }

    public IStatus ignoreFilesChanged(List<IShareable> ignoreFiles, IProgressMonitor progress) {
        MultiStatus errors = new MultiStatus("com.ibm.team.filesystem.client", -1, Messages.DefaultIgnoreProvider_10, null);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        List<IgnoreEvent> events = this.createEventsForIgnoreFileChanges(ignoreFiles, errors, (IProgressMonitor)monitor.newChild(1));
        if (!events.isEmpty()) {
            try {
                this.refreshAndQueue(events, errors, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemException e) {
                errors.add(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
            }
        }
        if (errors.getChildren().length > 0) {
            return errors;
        }
        return Status.OK_STATUS;
    }

    private List<IgnoreEvent> createEventsForIgnoreFileChanges(List<IShareable> ignoreFiles, MultiStatus errors, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(ignoreFiles.size() * 2));
        SharingManager sm = SharingManager.getInstance();
        ArrayList<IgnoreEvent> events = new ArrayList<IgnoreEvent>();
        for (IShareable shareable : ignoreFiles) {
            try {
                ISchedulingRule rule = sm.makeSchedulingRuleForIDE(Collections.singleton(shareable));
                try {
                    Job.getJobManager().beginRule(rule, (IProgressMonitor)monitor.newChild(1));
                    IgnoreEvent event = this.ignoreFileChanged(shareable, (IProgressMonitor)monitor.newChild(1));
                    if (event == null) continue;
                    events.add(event);
                }
                finally {
                    Job.getJobManager().endRule(rule);
                }
            }
            catch (FileSystemException e) {
                errors.add(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
            }
        }
        return events;
    }

    private void refreshShareables(List<IShareable> toRefresh, MultiStatus errors, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(toRefresh.size() * 2));
        for (IShareable shareable : toRefresh) {
            try {
                IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
                if (share == null) continue;
                LocalChangeManager.getInstance().refreshChanges(shareable, (IProgressMonitor)monitor);
            }
            catch (FileSystemException e) {
                if (errors == null) {
                    throw e;
                }
                errors.add(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.DefaultIgnoreProvider_1, (Object)shareable.getLocalPath()), (Throwable)((Object)e)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IgnoreEvent ignoreFileChanged(IShareable shareable, IProgressMonitor progress) throws FileSystemException {
        String type;
        JazzIgnoreFile currentFile;
        block25: {
            boolean exists;
            IShareable parent;
            SubMonitor monitor;
            block22: {
                LRUCache<PathPair, JazzIgnoreFile> lRUCache;
                PathPair parentPath;
                block23: {
                    block24: {
                        JazzIgnoreFile cachedFile;
                        boolean containsKey;
                        Assert.isTrue((boolean)shareable.getLocalPath().getName().equals(IGNORE_FILE_NAME));
                        monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
                        if (this.isBeingModifiedByProvider(shareable)) {
                            return null;
                        }
                        if (!this.shouldReloadIgnoreFile(shareable, (IProgressMonitor)monitor.newChild(1))) {
                            return null;
                        }
                        IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
                        if (share == null) {
                            return null;
                        }
                        parent = this.getParentFor(shareable);
                        if (parent == null) {
                            return null;
                        }
                        if (parent.shouldBeIgnored((IProgressMonitor)monitor.newChild(1))) {
                            return null;
                        }
                        parentPath = new PathPair(shareable.getSandbox().getRoot(), parent.getLocalPath());
                        exists = shareable.exists((IProgressMonitor)monitor.newChild(1));
                        LRUCache<PathPair, JazzIgnoreFile> lRUCache2 = this.files;
                        synchronized (lRUCache2) {
                            containsKey = this.files.containsKey(parentPath);
                            cachedFile = this.files.get(parentPath);
                            this.shouldInvalidateCache = true;
                        }
                        currentFile = null;
                        type = null;
                        if (!containsKey) break block22;
                        if (!exists) break block23;
                        if (cachedFile != null) break block24;
                        lRUCache = this.files;
                        synchronized (lRUCache) {
                            this.files.removeKey(parentPath);
                        }
                        currentFile = this.getIgnoreFileForFolder(shareable.getSandbox(), parent.getLocalPath(), false, (IProgressMonitor)monitor.newChild(1));
                        if (currentFile == null) {
                            lRUCache = this.files;
                            synchronized (lRUCache) {
                                this.files.removeKey(parentPath);
                                this.fileAges.remove(parentPath);
                            }
                            type = "unignore";
                            break block25;
                        } else {
                            type = "ignore";
                        }
                        break block25;
                    }
                    type = "unknown";
                    lRUCache = this.files;
                    synchronized (lRUCache) {
                        this.files.removeKey(parentPath);
                    }
                    currentFile = this.getIgnoreFileForFolder(shareable.getSandbox(), parent.getLocalPath(), false, (IProgressMonitor)monitor.newChild(1));
                    break block25;
                }
                type = "unignore";
                lRUCache = this.files;
                synchronized (lRUCache) {
                    this.files.removeKey(parentPath);
                    this.fileAges.remove(parentPath);
                }
            }
            type = exists ? "unknown" : "unignore";
            currentFile = this.getIgnoreFileForFolder(shareable.getSandbox(), parent.getLocalPath(), false, (IProgressMonitor)monitor.newChild(1));
        }
        SortedSet<IgnoreRule> rules = currentFile == null ? null : currentFile.getRules();
        return new IgnoreEvent(this.getIgnoreManager(), shareable, type, CATEGORY_EXTERNAL_CHANGE, rules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBeingModifiedByProvider(IShareable shareable) {
        Set<IShareable> set = this.modifiedFiles;
        synchronized (set) {
            return this.modifiedFiles.contains(shareable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldReloadIgnoreFile(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        PathPair pair = new PathPair(shareable.getSandbox().getRoot(), shareable.getLocalPath().getParent());
        boolean exists = this.filesystem.exists(shareable, (IProgressMonitor)progress.newChild(1));
        IgnoreFileAgeDBHM.DateStamp lastModified = this.filesystem.lastModified(shareable);
        long size = this.filesystem.size(shareable, (IProgressMonitor)progress.newChild(1));
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            block4: {
                if (!this.fileAges.shouldReload(pair, exists, lastModified, size)) break block4;
                return true;
            }
        }
        return !exists && shareable.getLocalPath().segments().length > 2;
    }

    private void verifyRule(IIgnoreProvider.IIgnoreRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_12);
        }
        if (rule.getProvider() != this) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_13);
        }
        if (!(rule instanceof IgnoreRule)) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_14);
        }
    }

    private void verifyRules(Collection<? extends IIgnoreProvider.IIgnoreRule> rules) {
        for (IIgnoreProvider.IIgnoreRule iIgnoreRule : rules) {
            this.verifyRule(iIgnoreRule);
        }
    }

    public void addIgnoreRule(IIgnoreProvider.IIgnoreRule externalRule, IProgressMonitor progress) throws FileSystemException {
        this.addIgnoreRules(Collections.singleton(externalRule), progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheFor(PathPair parentPath, JazzIgnoreFile file) {
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.files.put(parentPath, file);
            if (file == null) {
                this.fileAges.remove(parentPath);
            } else {
                this.fileAges.put(parentPath, file.getLastModified(), file.getSize());
            }
        }
    }

    private ISchedulingRule findSchedulingRuleFor(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        IShare share = shareable.getShare(monitor);
        if (share == null) {
            return null;
        }
        return SharingManager.getInstance().getTrackingRule(share.getSandbox().getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnoreRules(Collection<? extends IIgnoreProvider.IIgnoreRule> allRules, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        monitor.setTaskName(Messages.DefaultIgnoreProvider_15);
        this.verifyRules(allRules);
        Map<JazzIgnoreFile, Collection<IgnoreRule>> rulesByOwner = this.groupRulesByOwner(allRules, monitor.newChild(10));
        monitor.setWorkRemaining(rulesByOwner.size() * 6);
        for (Map.Entry<JazzIgnoreFile, Collection<IgnoreRule>> entry : rulesByOwner.entrySet()) {
            Collection<IgnoreRule> rules;
            JazzIgnoreFile file = entry.getKey();
            Collection<IgnoreRule> added = file.computeComplement(rules = entry.getValue());
            if (added.isEmpty()) continue;
            IShareable shareable = file.getFile();
            ISchedulingRule rule = this.findSchedulingRuleFor(shareable, (IProgressMonitor)monitor.newChild(1));
            try {
                Job.getJobManager().beginRule(rule, (IProgressMonitor)monitor.newChild(1));
                this.startModifyingFile(shareable);
                try {
                    JazzIgnoreFile newFile = file.addRules(added, (IProgressMonitor)monitor.newChild(1));
                    this.updateCacheFor(new PathPair(file.getRootShareable()), newFile);
                    LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
                    synchronized (lRUCache) {
                        this.shouldInvalidateCache = true;
                    }
                }
                finally {
                    this.stopModifyingFile(shareable, monitor.newChild(1));
                }
            }
            finally {
                Job.getJobManager().endRule(rule);
            }
            IgnoreEvent event = new IgnoreEvent(this.getIgnoreManager(), file.getFile(), "ignore", Collections.EMPTY_LIST, rules);
            this.refreshAndQueue(Collections.singletonList(event), null, (IProgressMonitor)monitor.newChild(1));
        }
    }

    private Map<JazzIgnoreFile, Collection<IgnoreRule>> groupRulesByOwner(Collection<? extends IIgnoreProvider.IIgnoreRule> rules, SubMonitor monitor) throws FileSystemException {
        HashMap<JazzIgnoreFile, Collection<IgnoreRule>> grouping = new HashMap<JazzIgnoreFile, Collection<IgnoreRule>>();
        monitor.beginTask(Messages.DefaultIgnoreProvider_CATEGORIZING_IGNORE_RULES_BY_FILENAME, rules.size());
        for (IIgnoreProvider.IIgnoreRule iIgnoreRule : rules) {
            IgnoreRule rule = (IgnoreRule)iIgnoreRule;
            JazzIgnoreFile owner = this.getIgnoreFileForFolder(rule.getFile().getSandbox(), rule.getRootShareableLocalPath(), true, (IProgressMonitor)monitor.newChild(1));
            Collection<IgnoreRule> associatedWithFile = grouping.get(owner);
            if (associatedWithFile == null) {
                associatedWithFile = new LinkedList<IgnoreRule>();
                grouping.put(owner, associatedWithFile);
            }
            associatedWithFile.add(rule);
        }
        monitor.done();
        return grouping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IIgnoreProvider.IIgnoreRule> void removeIgnoreRule(T externalRule, IProgressMonitor progress) throws FileSystemException {
        this.verifyRule(externalRule);
        IgnoreRule rule = (IgnoreRule)externalRule;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)4);
        this.removeRule(rule, (IProgressMonitor)monitor.newChild(1));
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.shouldInvalidateCache = true;
        }
        IgnoreEvent event = new IgnoreEvent(this.getIgnoreManager(), rule.getFile(), "unignore", Collections.EMPTY_LIST, Collections.singletonList(rule));
        this.refreshAndQueue(Collections.singletonList(event), null, (IProgressMonitor)monitor.newChild(1));
        monitor.done();
    }

    public void removeIgnoreRules(List<? extends IIgnoreProvider.IIgnoreRule> externalRules, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)externalRules.size());
        for (IIgnoreProvider.IIgnoreRule iIgnoreRule : externalRules) {
            this.removeIgnoreRule(iIgnoreRule, (IProgressMonitor)monitor.newChild(1));
        }
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startModifyingFile(IShareable file) {
        Set<IShareable> set = this.modifiedFiles;
        synchronized (set) {
            if (!this.modifiedFiles.add(file)) {
                throw new RuntimeException(NLS.bind((String)Messages.DefaultIgnoreProvider_16, (Object)file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopModifyingFile(IShareable file, SubMonitor monitor) {
        Set<IShareable> set = this.modifiedFiles;
        synchronized (set) {
            if (!this.modifiedFiles.remove(file)) {
                throw new RuntimeException(NLS.bind((String)Messages.DefaultIgnoreProvider_17, (Object)file));
            }
        }
        this.ignoreFilesChanged(Collections.singletonList(file), (IProgressMonitor)monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFileCache() {
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.files.flush();
            this.fileAges.clear();
            this.shouldInvalidateCache = true;
        }
    }

    @Override
    protected IgnoreProvider createCopyInternal(Collection<IIgnoreManager.ICopyParameter> params, IIgnoreManager ignoreManager, IProgressMonitor progress) {
        IFilesystemAbstraction abs = null;
        for (IIgnoreManager.ICopyParameter param : params) {
            IDefaultIgnoreProviderCopyReason myReason;
            IFilesystemAbstraction preferred;
            if (!(param instanceof IDefaultIgnoreProviderCopyReason) || (preferred = (myReason = (IDefaultIgnoreProviderCopyReason)param).useFilesystemAbstraction(this.filesystem)) == null) continue;
            assert (abs == null) : "IFilesystemAbstraction set twice. Original: " + abs + " new: " + preferred;
            abs = preferred;
        }
        if (abs == null) {
            abs = (IFilesystemAbstraction)this.filesystem.clone();
        }
        return new DefaultIgnoreProvider(abs);
    }

    private void refreshAndQueue(List<IgnoreEvent> events, MultiStatus errors, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        List<IShareable> toRefresh = IgnoreUtils.findShareablesToRefresh(events, errors, (IProgressMonitor)monitor.newChild(1));
        this.refreshShareables(toRefresh, errors, (IProgressMonitor)monitor.newChild(1));
        this.queueEvents(events);
    }

    private void queueEvents(List<IgnoreEvent> events) {
        for (IgnoreEvent ignoreEvent : events) {
            this.queueEvent(ignoreEvent);
        }
    }

    public byte[] getIgnoreFileContents(IRelativeLocation path, Collection<String> globalPatterns, Collection<String> localPatterns) throws FileSystemException {
        boolean isGlobal;
        boolean bl = isGlobal = path.segmentCount() == 1;
        if (!isGlobal && globalPatterns != null) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_19);
        }
        TreeSet<IgnoreRule> rules = new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE);
        if (globalPatterns != null) {
            for (String pattern : globalPatterns) {
                rules.add(new RecursiveIgnoreRule(null, this, pattern, false, false));
            }
        }
        if (localPatterns != null) {
            for (String pattern : localPatterns) {
                rules.add(new LocalIgnoreRule(null, this, pattern, false, false));
            }
        }
        return IgnoreFileLoader.getInstance().asBytes(path.append(IGNORE_FILE_NAME), rules);
    }

    public Collection<IgnorePattern> getDefaultIgnorePatterns(IRelativeLocation path) {
        if (path.segmentCount() < 1) {
            throw new IllegalArgumentException();
        }
        return IgnoreFileLoader.getInstance().getDefaultIgnorePatterns(path.append(IGNORE_FILE_NAME));
    }

    @Override
    public void deallocate(IIgnoreManager ignoreManager) {
        super.deallocate(ignoreManager);
        SharingManager.getInstance().removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCacheSize() {
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            return this.files.getSpaceLimit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushInAbsenceOfEvents(Collection<IShareable> roots, IProgressMonitor progress) throws FileSystemException {
        LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            if (roots == null) {
                this.files.flush();
                return;
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(roots.size() * this.files.getCurrentSpace() * 2));
            for (IShareable root : roots) {
                if (root == null || root.getLocalPath().segmentCount() < 2 || root.isShare((IProgressMonitor)monitor.newChild(1))) {
                    monitor.worked(this.files.getCurrentSpace());
                    continue;
                }
                IShareable parent = null;
                PathPair rootPair = new PathPair(root);
                Iterator<PathPair> i = this.files.keys();
                while (i.hasNext()) {
                    PathPair loc = i.next();
                    if (rootPair.isPrefixOf(loc)) {
                        if (parent == null) {
                            parent = ((Shareable)root).getParent();
                        }
                        boolean remove = false;
                        try {
                            long size = this.filesystem.size(parent, (IProgressMonitor)monitor.newChild(1));
                            if (this.fileAges.shouldReload(loc, this.filesystem.exists(parent, (IProgressMonitor)monitor.newChild(1)), this.filesystem.lastModified(parent), size)) {
                                remove = true;
                            }
                        }
                        catch (FileSystemException e) {
                            remove = true;
                        }
                        if (!remove) continue;
                        i.remove();
                        continue;
                    }
                    monitor.worked(1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordIgnoreFileTimestamp(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        if (shareable.getLocalPath().getName().equals(IGNORE_FILE_NAME)) {
            LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
            synchronized (lRUCache) {
                IgnoreFileAgeDBHM.DateStamp lastModified = this.filesystem.lastModified(shareable);
                long size = this.filesystem.size(shareable, monitor);
                this.fileAges.put(new PathPair(shareable.getSandbox().getRoot(), shareable.getLocalPath().removeLastSegments(1)), lastModified, size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnoreFileModified(IShareable shareable, IProgressMonitor monitor) {
        try {
            if (shareable.getLocalPath().getName().equals(IGNORE_FILE_NAME)) {
                LRUCache<PathPair, JazzIgnoreFile> lRUCache = this.files;
                synchronized (lRUCache) {
                    IgnoreFileAgeDBHM.DateStamp currentModified = this.filesystem.lastModified(shareable);
                    long currentSize = this.filesystem.size(shareable, monitor);
                    return this.fileAges.shouldReload(new PathPair(shareable.getSandbox().getRoot(), shareable.getLocalPath().removeLastSegments(1)), true, currentModified, currentSize);
                }
            }
        }
        catch (FileSystemException e) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
        }
        return true;
    }

    private class DefaultIgnoreTester
    implements IIgnoreProvider.IIgnoreTester {
        public DefaultIgnoreTester(IShareable shareable) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean shouldInvalidateCache(IShareable shareable, IProgressMonitor monitor) {
            LRUCache lRUCache = DefaultIgnoreProvider.this.files;
            synchronized (lRUCache) {
                if (DefaultIgnoreProvider.this.shouldInvalidateCache) {
                    return true;
                }
            }
            final List[] changedIgnoreFiles = new List[1];
            IIgnorePathVisitor v = new IIgnorePathVisitor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean visitIgnoreFiles(IShareable onBehalfOf, JazzIgnoreFile ignoreFile, SubMonitor subMonitor) {
                    boolean isStale;
                    try {
                        isStale = ignoreFile.isStale((IProgressMonitor)subMonitor);
                    }
                    catch (FileSystemException e) {
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                        return false;
                    }
                    if (isStale) {
                        PathPair path = new PathPair(onBehalfOf.getSandbox().getRoot(), ignoreFile.getRootPath());
                        LRUCache lRUCache = DefaultIgnoreProvider.this.files;
                        synchronized (lRUCache) {
                            DefaultIgnoreProvider.this.files.removeKey(path);
                        }
                        if (changedIgnoreFiles[0] == null) {
                            changedIgnoreFiles[0] = new ArrayList();
                        }
                        changedIgnoreFiles[0].add(ignoreFile.getFile());
                    }
                    return true;
                }
            };
            DefaultIgnoreProvider.this.visitIgnoreFilesOnPath(shareable, shareable.getLocalPath(), v, true, monitor);
            if (changedIgnoreFiles[0] == null) {
                return false;
            }
            SharingManager.getInstance().getIgnoreManager().ignoreFilesChanged(changedIgnoreFiles[0]);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cacheInvalidated(IShareable shareable) {
            LRUCache lRUCache = DefaultIgnoreProvider.this.files;
            synchronized (lRUCache) {
                DefaultIgnoreProvider.this.shouldInvalidateCache = false;
            }
        }

        @Override
        public boolean shouldBeIgnored(IShareable shareable, final IRelativeLocation path, IProgressMonitor progress) {
            final int segmentCount = path.segmentCount();
            if (segmentCount < 2) {
                return false;
            }
            final boolean[] result = new boolean[1];
            IIgnorePathVisitor v = new IIgnorePathVisitor(){

                @Override
                public boolean visitIgnoreFiles(IShareable onBehalfOf, JazzIgnoreFile ignoreFile, SubMonitor subMonitor) {
                    boolean isCurrentDir = ignoreFile.getRootPath().segmentCount() == segmentCount - 1;
                    for (IgnoreRule rule : ignoreFile.getRules()) {
                        if (!rule.isRecursive() && !isCurrentDir || !rule.shouldBeIgnored(path)) continue;
                        result[0] = true;
                        return false;
                    }
                    return true;
                }
            };
            DefaultIgnoreProvider.this.visitIgnoreFilesOnPath(shareable, path, v, true, progress);
            return result[0];
        }

        @Override
        public List<IIgnoreProvider.IIgnoreRule> findIgnoreReasons(IShareable shareable, final IRelativeLocation path, IProgressMonitor progress) {
            final int segmentCount = path.segmentCount();
            if (segmentCount < 2) {
                return Collections.emptyList();
            }
            final ArrayList<IIgnoreProvider.IIgnoreRule> result = new ArrayList<IIgnoreProvider.IIgnoreRule>(2);
            IIgnorePathVisitor v = new IIgnorePathVisitor(){

                @Override
                public boolean visitIgnoreFiles(IShareable onBehalfOf, JazzIgnoreFile ignoreFile, SubMonitor subMonitor) {
                    boolean isCurrentDir = ignoreFile.getRootPath().segmentCount() == segmentCount - 1;
                    for (IgnoreRule rule : ignoreFile.getRules()) {
                        if (!rule.isRecursive() && !isCurrentDir || !rule.shouldBeIgnored(path)) continue;
                        result.add(rule);
                    }
                    return result.isEmpty();
                }
            };
            DefaultIgnoreProvider.this.visitIgnoreFilesOnPath(shareable, path, v, true, progress);
            return result;
        }
    }

    public static interface IDefaultIgnoreProviderCopyReason
    extends IIgnoreManager.ICopyParameter {
        public IFilesystemAbstraction useFilesystemAbstraction(IFilesystemAbstraction var1);
    }

    public static interface IFilesystemAbstraction
    extends Cloneable {
        public static final IgnoreFileAgeDBHM.DateStamp NULL_MOD = new IgnoreFileAgeDBHM.DateStamp(0L, -1L);
        public static final long NULL_SIZE = -2L;

        public boolean exists(IShareable var1, IProgressMonitor var2) throws FileSystemException;

        public InputStream read(IShareable var1, IProgressMonitor var2) throws FileSystemException, IgnoreFileLoader.FileInaccessibleException;

        public void write(IShareable var1, InputStream var2, IProgressMonitor var3) throws FileSystemException;

        public IgnoreFileAgeDBHM.DateStamp lastModified(IShareable var1);

        public long size(IShareable var1, IProgressMonitor var2) throws FileSystemException;

        public Object clone();
    }

    private static interface IIgnorePathVisitor {
        public boolean visitIgnoreFiles(IShareable var1, JazzIgnoreFile var2, SubMonitor var3);
    }

    public static interface IIgnoreVisitor {
        public void visit(Collection<IgnoreRule> var1);
    }

    public static class PassThroughFilesystemAbstraction
    implements IFilesystemAbstraction {
        @Override
        public boolean exists(IShareable file, IProgressMonitor progress) throws FileSystemException {
            return file.exists(progress);
        }

        @Override
        public InputStream read(final IShareable file, IProgressMonitor progress) throws FileSystemException, IgnoreFileLoader.FileInaccessibleException {
            final SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
            final InputStream[] stream = new InputStream[1];
            try {
                if (file.exists((IProgressMonitor)monitor.newChild(1))) {
                    SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemRunnable(){

                        @Override
                        public void run() throws TeamRepositoryException {
                            FileOptions options = new FileOptions(true, (Shareable)file, (IProgressMonitor)monitor.newChild(1));
                            stream[0] = ((Shareable)file).getFileStorage().getContents(options);
                        }
                    });
                }
            }
            catch (TeamRepositoryException e) {
                throw new IgnoreFileLoader.FileInaccessibleException();
            }
            return stream[0];
        }

        @Override
        public void write(IShareable file, InputStream in, IProgressMonitor monitor) throws FileSystemException {
            IFileStorage store = ((Shareable)file).getFileStorage();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            FileOptions options = new FileOptions(false, (Shareable)file, (IProgressMonitor)progress.newChild(1));
            if (file.exists((IProgressMonitor)progress.newChild(1))) {
                store.setContents(options, in, new Shed(null), (IProgressMonitor)progress.newChild(99));
            } else {
                store.create(options, in, monitor);
            }
        }

        @Override
        public IgnoreFileAgeDBHM.DateStamp lastModified(IShareable file) {
            try {
                return new IgnoreFileAgeDBHM.DateStamp(((Shareable)file).getFileStorage());
            }
            catch (FileSystemException e) {
                return NULL_MOD;
            }
        }

        @Override
        public long size(IShareable file, IProgressMonitor monitor) throws FileSystemException {
            try {
                SharingManager.getInstance().disableChangeMonitoring();
                long size = ((Shareable)file).getFileStorage().getSize(monitor);
                if (size == -1L) {
                    return -2L;
                }
                long l = size;
                return l;
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }

        @Override
        public Object clone() {
            return new PassThroughFilesystemAbstraction();
        }
    }
}

