/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.gc;

import com.ibm.team.filesystem.common.internal.gc.CommonContextUtilities;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public final class ContextUtilities {
    private ContextUtilities() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    public static IProjectAreaHandle getProjectArea(IWorkspaceHandle handle, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        return CommonContextUtilities.getProjectArea((IWorkspaceHandle)handle, (CommonContextUtilities.IItemFetcher)new ItemFetcher(repo), (IProgressMonitor)monitor);
    }

    public static IProjectAreaHandle getProjectArea(IWorkspace workspace, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        return CommonContextUtilities.getProjectArea((IWorkspace)workspace, (CommonContextUtilities.IItemFetcher)new ItemFetcher(repo), (IProgressMonitor)monitor);
    }

    public static IProjectAreaHandle getProjectArea(IBaselineSetHandle handle, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        return CommonContextUtilities.getProjectArea((IBaselineSetHandle)handle, (CommonContextUtilities.IItemFetcher)new ItemFetcher(repo), (IProgressMonitor)monitor);
    }

    public static IProjectAreaHandle getProjectArea(IBaselineSet snapshot, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        return CommonContextUtilities.getProjectArea((IBaselineSet)snapshot, (CommonContextUtilities.IItemFetcher)new ItemFetcher(repo), (IProgressMonitor)monitor);
    }

    private static final class ItemFetcher
    implements CommonContextUtilities.IItemFetcher {
        private final ITeamRepository repo;

        public ItemFetcher(ITeamRepository repo) {
            this.repo = repo;
        }

        public <T extends IItem> Map<UUID, T> fetchCompleteItems(Collection<? extends IItemHandle> itemHandles, Class<T> type, IProgressMonitor monitor) throws TeamRepositoryException {
            List handleList = NewCollection.arrayList(itemHandles);
            List items = this.repo.itemManager().fetchCompleteItems(handleList, 0, monitor);
            HashMap result = NewCollection.hashMap();
            Iterator handleIter = handleList.iterator();
            Iterator itemIter = items.iterator();
            while (itemIter.hasNext()) {
                result.put(((IItemHandle)handleIter.next()).getItemId(), (IItem)type.cast(itemIter.next()));
            }
            return result;
        }

        public <T extends IItem> T fetchCompleteItem(IItemHandle itemHandle, Class<T> type, IProgressMonitor monitor) throws TeamRepositoryException, ItemNotFoundException {
            return (T)((IItem)type.cast(this.repo.itemManager().fetchCompleteItem(itemHandle, 0, monitor)));
        }
    }
}

