/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.era;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.FunctionCache;
import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.era.EraRootComputer;
import com.ibm.team.filesystem.client.internal.era.HistoryDescriptorFunction;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IChangeHistoryDescriptor;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class StaticEraDescriptor
extends EraDescriptor {
    private IChangeHistory changeHistory;
    private UUID eraIdentifier;
    private UUID workspaceIdentifier;

    public StaticEraDescriptor(IChangeHistory changeHistory) {
        if (changeHistory.isLive()) {
            throw new IllegalArgumentException();
        }
        this.changeHistory = changeHistory;
        this.eraIdentifier = this.changeHistory.getEraIdentifier();
        IConnection connection = this.changeHistory.getConnection();
        this.workspaceIdentifier = connection instanceof IWorkspaceConnection ? connection.getContextHandle().getItemId() : null;
    }

    @Override
    protected IRemoteFunction<ItemId<IFolder>> getRootComputer() {
        return new EraRootComputer(this.changeHistory);
    }

    @Override
    public ITeamRepository getRepository() {
        return this.changeHistory.teamRepository();
    }

    @Override
    public IChangeHistory getChangeHistory() {
        return this.changeHistory;
    }

    @Override
    protected List<EraDescriptor> doGetPreviousEras(int entryCount, IProgressMonitor monitor) throws TeamRepositoryException {
        int remain;
        LinkedList<EraDescriptor> result = new LinkedList<EraDescriptor>();
        EraDescriptor current = this;
        int found = 0;
        while (!((EraDescriptor)current).isEmpty() && found < entryCount) {
            IChangeHistoryDescriptor descriptor = FunctionCache.getDefault().getCachedValue(new HistoryDescriptorFunction(((EraDescriptor)current).getChangeHistory()));
            if (descriptor == null) break;
            result.addFirst(current);
            found += descriptor.recent().size();
            current = this.getPreviousEraFromHistoryDescriptor(descriptor);
        }
        if (!((EraDescriptor)current).isEmpty() && (remain = entryCount - found) > 0) {
            IChangeHistory changeHistory = ((EraDescriptor)current).getChangeHistory();
            List descriptors = changeHistory.getHistoryDescriptors(entryCount, true, monitor);
            EraDescriptor currentEra = current;
            ListIterator iter = descriptors.listIterator(descriptors.size());
            while (iter.hasPrevious()) {
                IChangeHistoryDescriptor previous = (IChangeHistoryDescriptor)iter.previous();
                FunctionCache.getDefault().addToCache(new HistoryDescriptorFunction(((EraDescriptor)currentEra).getChangeHistory()), previous);
                result.addFirst(currentEra);
                currentEra = this.getPreviousEraFromHistoryDescriptor(previous);
            }
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public List<DeliveryInfo> getDeliveries(IProgressMonitor monitor) throws TeamRepositoryException {
        ClientRepositoryUtil.checkCanceled(monitor);
        IChangeHistoryDescriptor descriptor = FunctionCache.getDefault().compute(new HistoryDescriptorFunction(this.changeHistory), false, monitor);
        return DeliveryInfo.createFromChangeHistory(descriptor.recent());
    }

    @Override
    public EraDescriptor getPreviousEra(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ClientRepositoryUtil.checkCanceled(monitor);
        IChangeHistoryDescriptor descriptor = FunctionCache.getDefault().compute(new HistoryDescriptorFunction(this.changeHistory), false, (IProgressMonitor)progress);
        return this.getPreviousEraFromHistoryDescriptor(descriptor);
    }

    private EraDescriptor getPreviousEraFromHistoryDescriptor(IChangeHistoryDescriptor descriptor) throws TeamRepositoryException {
        IChangeHistory previous = descriptor.previousHistory();
        if (previous == null) {
            return EraDescriptor.createEmptyEra(this.getRepository(), this.getComponent());
        }
        return EraDescriptor.createStaticDescriptor(previous);
    }

    @Override
    public ItemId<IComponent> getComponent() {
        return ItemUtil.getComponent((IComponentHandle)this.changeHistory.getComponent());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eraIdentifier == null ? 0 : this.eraIdentifier.hashCode());
        result = 31 * result + (this.workspaceIdentifier == null ? 0 : this.workspaceIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StaticEraDescriptor other = (StaticEraDescriptor)obj;
        if (this.eraIdentifier == null ? other.eraIdentifier != null : !this.eraIdentifier.equals((Object)other.eraIdentifier)) {
            return false;
        }
        return !(this.workspaceIdentifier == null ? other.workspaceIdentifier != null : !this.workspaceIdentifier.equals((Object)other.workspaceIdentifier));
    }

    @Override
    public Map<ItemId<IChangeSet>, StateId<IChangeSet>> getActiveChangeSetStates() {
        return Collections.emptyMap();
    }

    @Override
    protected Map<String, ItemId<IVersionable>> doFetchChildren(ItemId<IFolder> handle, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            return ItemLists.mapOfHandlesToMapOfIds((Map)this.changeHistory.configuration().childEntries((IFolderHandle)handle.toHandle(), monitor));
        }
        catch (ItemNotFoundException e) {
            return Collections.emptyMap();
        }
    }

    @Override
    public List<DeliveryInfo> findChangeSetsAffecting(ItemId<?> item, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeHistory changeHistory = this.changeHistory;
        return EraDescriptor.getDeliveryInfo(changeHistory, item, maxResults, monitor);
    }

    @Override
    public ItemId<IFolder> getRoot(IProgressMonitor monitor) throws TeamRepositoryException {
        return FunctionCache.getDefault().compute(new EraRootComputer(this.changeHistory), false, monitor);
    }

    public String toString() {
        return "StaticEraDescriptor(" + this.changeHistory.getEraIdentifier().getUuidValue() + ")";
    }

    @Override
    protected Map<ItemId<IVersionable>, VersionablePath> doResolve(Collection<ItemId<IVersionable>> versionables, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            IConfiguration config = this.changeHistory.configuration();
            return ConnectionUtil.resolvePaths(config, versionables, monitor);
        }
        catch (ItemNotFoundException e) {
            return Collections.emptyMap();
        }
    }
}

