/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.era;

import com.ibm.team.filesystem.client.internal.ClientConfigurationChangeFactory;
import com.ibm.team.filesystem.client.internal.FunctionCache;
import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EmptyEraDescriptor;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.ConflictInfo;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraCache;
import com.ibm.team.filesystem.client.internal.namespace.impl.ParentComputer;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.ResolvedConfigurationChangePaths;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ClientEraDescriptor
extends EraDescriptor {
    private List<DeliveryInfo> changeSets;
    private int startRange;
    private int numChangeSets;
    private EraDescriptor previousEra;
    private int cachedHashCode;
    private Map<ItemId<IChangeSet>, StateId<IChangeSet>> activeChangeSets;
    private ITeamRepository repository;
    private ItemId<IComponent> component;
    private IRemoteFunction<ItemId<IFolder>> rootComputer;
    private ConflictInfo conflictInfo;

    public ClientEraDescriptor(ITeamRepository repository, EraDescriptor previousEra, List<DeliveryInfo> changeSets, Map<ItemId<IChangeSet>, StateId<IChangeSet>> activeChangeSets, int rangeStart, int rangeLength, ItemId<IComponent> component, ConflictInfo conflictInfo, IRemoteFunction<ItemId<IFolder>> rootComputer) {
        if (previousEra == null || changeSets == null || activeChangeSets == null || component == null) {
            throw new IllegalArgumentException("");
        }
        if (changeSets.isEmpty()) {
            throw new IllegalArgumentException("CachedEraDescriptor must contain at least one change set");
        }
        if (!changeSets.isEmpty() && !(changeSets.iterator().next() instanceof DeliveryInfo)) {
            throw new IllegalArgumentException("expecting a list of DeliveryInfo");
        }
        this.previousEra = previousEra;
        this.changeSets = changeSets;
        this.activeChangeSets = activeChangeSets;
        this.repository = repository;
        this.startRange = rangeStart;
        this.numChangeSets = rangeLength;
        this.component = component;
        this.rootComputer = rootComputer;
        this.conflictInfo = conflictInfo;
    }

    @Override
    protected IRemoteFunction<ItemId<IFolder>> getRootComputer() {
        return this.rootComputer;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isEmpty() {
        if (!this.changeSets.isEmpty()) {
            return false;
        }
        if (this.previousEra == null) {
            return true;
        }
        return this.previousEra.isEmpty();
    }

    @Override
    public IChangeHistory getChangeHistory() {
        return null;
    }

    private static int computeCollectionHashcode(Collection<?> toCompute) {
        int hash = 0;
        for (Object next : toCompute) {
            hash += next.hashCode();
        }
        return hash;
    }

    private static <K, V> boolean mapsEqual(Map<K, V> list1, Map<K, V> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (Map.Entry<K, V> next : list1.entrySet()) {
            V list2Value = list2.get(next.getKey());
            if (list2Value != null && list2Value.equals(next.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean listsEqual(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator<?> iter2 = list2.iterator();
        for (Object next1 : list1) {
            Object next2;
            if (next1.equals(next2 = iter2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.startRange;
            result = 31 * result + this.numChangeSets;
            result = 31 * result + ClientEraDescriptor.computeCollectionHashcode(this.privateGetDeliveries());
            result = 31 * result + ClientEraDescriptor.computeCollectionHashcode(this.activeChangeSets.values());
            this.cachedHashCode = result = 31 * result + (this.previousEra == null ? 0 : this.previousEra.hashCode());
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientEraDescriptor other = (ClientEraDescriptor)obj;
        if (!ClientEraDescriptor.listsEqual(this.privateGetDeliveries(), other.privateGetDeliveries())) {
            return false;
        }
        if (this.numChangeSets != other.numChangeSets) {
            return false;
        }
        if (this.startRange != other.startRange) {
            return false;
        }
        if (!ClientEraDescriptor.mapsEqual(this.activeChangeSets, other.activeChangeSets)) {
            return false;
        }
        if (this.previousEra == null ? other.previousEra != null : !this.previousEra.equals(other.previousEra)) {
            return false;
        }
        return !(this.conflictInfo == null ? other.conflictInfo != null : other.conflictInfo == null || !this.conflictInfo.equals(other.conflictInfo));
    }

    @Override
    public EraDescriptor getPreviousEra(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.previousEra;
    }

    @Override
    public Map<ItemId<IChangeSet>, StateId<IChangeSet>> getActiveChangeSetStates() {
        return this.activeChangeSets;
    }

    @Override
    public EraDescriptor discardLast(int changeSetsToDiscard, IProgressMonitor monitor) throws TeamRepositoryException {
        if (changeSetsToDiscard == 0) {
            return this;
        }
        if (changeSetsToDiscard < this.numChangeSets) {
            HashMap activeChangeSets = this.getActiveChangeSetStates();
            List<DeliveryInfo> toRemoveList = this.changeSets.subList(this.startRange + this.numChangeSets - changeSetsToDiscard, this.startRange + this.numChangeSets);
            if (!activeChangeSets.isEmpty()) {
                HashMap newActiveChangeSets = NewCollection.hashMap();
                newActiveChangeSets.putAll(activeChangeSets);
                for (DeliveryInfo toRemove : toRemoveList) {
                    newActiveChangeSets.remove(toRemove.getChangeSet());
                }
                activeChangeSets = newActiveChangeSets;
            }
            if (activeChangeSets.isEmpty()) {
                activeChangeSets = Collections.emptyMap();
            }
            return ClientEraDescriptor.createDescriptor(this.getRepository(), this.previousEra, this.changeSets, activeChangeSets, this.startRange, this.numChangeSets - changeSetsToDiscard, this.getComponent(), this.conflictInfo, this.rootComputer);
        }
        return super.discardLast(changeSetsToDiscard, monitor);
    }

    @Override
    protected List<EraDescriptor> doGetPreviousEras(int entryCount, IProgressMonitor monitor) throws TeamRepositoryException {
        int remain = entryCount - this.numChangeSets;
        ArrayList<EraDescriptor> result = new ArrayList<EraDescriptor>();
        if (remain > 0) {
            result.addAll(this.previousEra.getPreviousEras(remain, monitor));
        }
        result.add(this);
        return result;
    }

    private List<DeliveryInfo> privateGetDeliveries() {
        return this.changeSets.subList(this.startRange, this.startRange + this.numChangeSets);
    }

    @Override
    public List<DeliveryInfo> getDeliveries(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.changeSets.subList(this.startRange, this.startRange + this.numChangeSets);
    }

    @Override
    public ItemId<IComponent> getComponent() {
        return this.component;
    }

    @Override
    protected Map<String, ItemId<IVersionable>> doFetchChildren(ItemId<IFolder> handle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<String, ItemId<IVersionable>> previousResult = this.previousEra.fetchChildren(handle, (IProgressMonitor)progress.newChild(50));
        ParentComputer parentComputer = EraCache.getDefault().fetchParentComputer(this, (IProgressMonitor)progress.newChild(50));
        HashMap childNames = NewCollection.hashMap();
        for (Map.Entry<String, ItemId<IVersionable>> next : previousResult.entrySet()) {
            Iterator<ItemId<IVersionable>> nextVersionable = next.getValue();
            if (parentComputer.hasChanged((ItemId<IVersionable>)nextVersionable)) {
                ItemId<IFolder> newParent = parentComputer.getParent((ItemId<IVersionable>)nextVersionable);
                if (!newParent.equals(handle)) continue;
                String newName = parentComputer.getName((ItemId<IVersionable>)nextVersionable);
                childNames.put(next.getValue(), newName);
                continue;
            }
            childNames.put(next.getValue(), next.getKey());
        }
        List<ItemId<IVersionable>> newChildren = parentComputer.getChildren(handle);
        for (ItemId<IVersionable> nextChild : newChildren) {
            String newName = parentComputer.getName(nextChild);
            childNames.put(nextChild, newName);
        }
        HashMap result = NewCollection.hashMap();
        for (Map.Entry next : childNames.entrySet()) {
            result.put((String)next.getValue(), (ItemId)next.getKey());
        }
        return result;
    }

    public static EraDescriptor createDescriptor(ITeamRepository repository, EraDescriptor previous, List<DeliveryInfo> changeSets, Map<ItemId<IChangeSet>, StateId<IChangeSet>> activeChangeSets, int rangeStart, int rangeLength, ItemId<IComponent> component, IRemoteFunction<ItemId<IFolder>> rootComputer) {
        return ClientEraDescriptor.createDescriptor(repository, previous, changeSets, activeChangeSets, rangeStart, rangeLength, component, null, rootComputer);
    }

    public static EraDescriptor createDescriptor(ITeamRepository repository, EraDescriptor previous, List<DeliveryInfo> changeSets, Map<ItemId<IChangeSet>, StateId<IChangeSet>> activeChangeSets, int rangeStart, int rangeLength, ItemId<IComponent> component, ConflictInfo conflictInfo, IRemoteFunction<ItemId<IFolder>> rootComputer) {
        if (previous == null) {
            previous = new EmptyEraDescriptor(repository, component);
        }
        if (changeSets.isEmpty()) {
            return previous;
        }
        return new ClientEraDescriptor(repository, previous, changeSets, activeChangeSets, rangeStart, rangeLength, component, conflictInfo, rootComputer);
    }

    @Override
    public List<DeliveryInfo> findChangeSetsAffecting(ItemId<?> item, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        if (maxResults == 0) {
            return Collections.emptyList();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List<DeliveryInfo> deliveries = this.getDeliveries((IProgressMonitor)progress.newChild(30));
        List<IChangeSet> changeSets = EraCache.getDefault().fetchChangeSets(this, (IProgressMonitor)progress.newChild(30));
        HashMap changeSetMap = NewCollection.hashMap();
        for (IChangeSet next : changeSets) {
            if (next == null) continue;
            changeSetMap.put(new ItemId((IItemHandle)next), next);
        }
        ArrayList reversedResult = NewCollection.arrayList();
        ArrayList reversedDeliveries = NewCollection.arrayList((int)deliveries.size());
        reversedDeliveries.addAll(deliveries);
        Collections.reverse(reversedDeliveries);
        for (DeliveryInfo next : reversedDeliveries) {
            IChange change;
            if (reversedResult.size() >= maxResults) break;
            IChangeSet changeSet = (IChangeSet)changeSetMap.get(next.getChangeSet());
            if (changeSet == null || (change = ChangeSetUtil.getChangeFor((IChangeSet)changeSet, item)) == null) continue;
            reversedResult.add(next);
        }
        List<DeliveryInfo> previousResults = this.previousEra.findChangeSetsAffecting(item, maxResults - reversedResult.size(), (IProgressMonitor)progress.newChild(40));
        ArrayList result = NewCollection.arrayList();
        result.addAll(previousResults);
        Collections.reverse(reversedResult);
        result.addAll(reversedResult);
        return result;
    }

    @Override
    public ItemId<IFolder> getRoot(IProgressMonitor monitor) throws TeamRepositoryException {
        return FunctionCache.getDefault().compute(this.rootComputer, false, monitor);
    }

    @Override
    protected Map<ItemId<IVersionable>, VersionablePath> doResolve(Collection<ItemId<IVersionable>> versionables, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List siloed = ItemLists.makeSiloed(versionables, this.component);
        IPathResolver previousResolver = new IPathResolver(){

            public Map<SiloedItemId<IVersionable>, VersionablePath> resolve(Collection<SiloedItemId<IVersionable>> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
                List unsiloed = ItemLists.unSilo(unresolved, (ItemId)ClientEraDescriptor.this.component);
                Map<ItemId<IVersionable>, VersionablePath> resolved = ClientEraDescriptor.this.previousEra.resolve(unsiloed, monitor);
                Map result = ClientEraDescriptor.this.createSiloedMap(resolved);
                return result;
            }
        };
        List<IChangeSet> changeSetList = EraCache.getDefault().fetchChangeSets(this, (IProgressMonitor)progress.newChild(25));
        ConfigurationChange netChange = ClientConfigurationChangeFactory.createChange(this.getRepository(), changeSetList, (IProgressMonitor)progress.newChild(25));
        ResolvedConfigurationChangePaths paths = ResolvedConfigurationChangePaths.resolve((IPathResolver)previousResolver, (ConfigurationChange)netChange, (IProgressMonitor)progress.newChild(25));
        Map resolved = paths.getPathResolver(false).resolve((Collection)siloed, (IProgressMonitor)progress.newChild(25));
        HashMap<ItemId<IVersionable>, VersionablePath> result = new HashMap<ItemId<IVersionable>, VersionablePath>();
        for (SiloedItemId next : resolved.keySet()) {
            result.put((ItemId<IVersionable>)next.getItemId(), (VersionablePath)resolved.get(next));
        }
        return result;
    }

    private Map<SiloedItemId<IVersionable>, VersionablePath> createSiloedMap(Map<ItemId<IVersionable>, VersionablePath> resolved) {
        HashMap<SiloedItemId<IVersionable>, VersionablePath> result = new HashMap<SiloedItemId<IVersionable>, VersionablePath>();
        for (ItemId<IVersionable> next : resolved.keySet()) {
            VersionablePath nextPath = resolved.get(next);
            result.put((SiloedItemId<IVersionable>)SiloedItemId.create(next, this.component), nextPath);
        }
        return result;
    }

    @Override
    public boolean isConflictPoint(IVersionableHandle afterState) {
        if (this.conflictInfo != null) {
            return this.conflictInfo.isConflictPoint(afterState);
        }
        return false;
    }
}

