/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.core;

import com.ibm.team.filesystem.client.CopyFileAreaLockedByOtherProcess;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.AsyncSavePDBHMJob;
import com.ibm.team.filesystem.client.internal.DiskBackedMapManager;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.ILocalConflictMetadata;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.ItemHandleHelper;
import com.ibm.team.filesystem.client.internal.LockableMap;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingDescriptorsMap;
import com.ibm.team.filesystem.client.internal.SharingMetaMetaDataProperties;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.api.storage.AbstractSharingMetadata;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.core.LoadedComponentsStore;
import com.ibm.team.filesystem.client.internal.core.LocalConflictMetadata;
import com.ibm.team.filesystem.client.internal.core.MetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.utils.FilesystemLock;
import com.ibm.team.filesystem.client.internal.utils.IPersistentFlag;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.filesystem.client.internal.utils.PersistentFlag;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.LocaleUtil;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.gc.LinkUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class SharingMetadata2
extends AbstractSharingMetadata {
    public static final String JAZZLOCK_NAME = ".jazzlock";
    public static final String JAZZ_CASEMODE_NAME = ".case-sensitivity-mode";
    private static final String JAZZ_CASE_SENSITIVE_MODE = "case-sensitive";
    private static final String JAZZ_CASE_INSENSITIVE_MODE = "case-insensitive";
    public static final int DEFAULT_PAGING_SIZE = 2500;
    private int pagingSize = 2500;
    static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    public static final String SCM_DESCRIPTORS = ".descriptors.dat";
    public static final String SCM_INVERSE_DESCRIPTORS = ".inversedescriptors.dat";
    public static final String SCM_ITEM_INFOS = ".iteminfo.dat";
    public static final String SCM_INVERSE_ITEM_INFOS = ".inverseiteminfo.dat";
    public static final String SCM_LOADED_COMPONENTS = ".components";
    public static final String SCM_META_META = ".metameta";
    public static final String SCM_COMPLETED_FLAGS = ".flags";
    protected static final String SCM_FLAG_MAP_MGR = ".mapMgr";
    protected static final String SCM_FLAG_DESCRIPTORS = ".descriptors";
    protected static final String SCM_FLAG_INVERSE_ITEM_INFOS = ".inverseItemInfos";
    protected static final String SCM_FLAG_LOADED_COMPONENTS = ".loadedComponents";
    public static final String SCM_FLAG_IS_CORRUPT = ".isCorrupt";
    private final ILocation cfaRootLocation;
    private final IPath metadataRoot;
    private ReadWriteLock globalLock;
    private ReadWriteLock globalLockForLocalConflicts;
    private PersistentDiskBackedHashMap<StringWrapper, ISharingDescriptor> descriptors;
    private InverseSharingDescriptorMap inverseDescriptors;
    private SharingMetaMetaDataProperties metaMeta;
    private Object metaMetaLock;
    private PersistentDiskBackedHashMap<String, Map<ISharingMetadata.IConnectionComponent, InverseFileItemInfo>> inverseItemInfos;
    private Object inverseItemInfosLock;
    private PersistentDiskBackedHashMap<ISharingMetadata.IConnectionComponent, LoadedConfigurationDescriptor> loadedComponents;
    private Object loadedComponentsLock;
    private MetadataDiskBackedMapManager mapMgr;
    private PersistentHeapManager heapMgr;
    private boolean isCaseSensitive;
    private final PersistentBusyFlag mapMgrFlag;
    private final PersistentBusyFlag descriptorsFlag;
    private final PersistentBusyFlag inverseDescriptorsFlag;
    private final PersistentBusyFlag metaMetaFlag;
    private final PersistentBusyFlag inverseItemInfosFlag;
    private final PersistentBusyFlag loadedComponentsFlag;
    private final PersistentBusyFlag persistentMetadataFlag;
    private final PersistentBusyFlag localConflictFlag;
    private AsyncSavePDBHMJob saveInverseDescriptorsJob;
    private AsyncSavePDBHMJob saveDescriptorsJob;
    private AsyncSavePDBHMJob saveMetaMetaJob;
    private AsyncSavePDBHMJob saveInverseMapJob;
    private AsyncSavePDBHMJob saveLoadedComponentsJob;
    final FilesystemLock fsLock;
    private final Object corruptionLock = new Object();
    private final IPersistentFlag isCorruptFlag;
    final HashSet<ICorruptCopyFileAreaListener> corruptionListeners = new HashSet();
    final MetadataChangeTracker metadataChangeTracker;
    private LocalConflictMetadata localConflictMetadata;

    public SharingMetadata2(ILocation copyFileAreaRoot, boolean isCaseSensitive, ILocation metadataRootLocation) throws FileSystemException {
        this.cfaRootLocation = copyFileAreaRoot;
        this.metadataRoot = (IPath)metadataRootLocation.getAdapter(IPath.class);
        if (this.metadataRoot == null) {
            throw new IllegalStateException("Invalid metadata root " + metadataRootLocation.toString());
        }
        this.globalLock = new ReadWriteLock();
        this.globalLockForLocalConflicts = new ReadWriteLock();
        boolean metadataRootAlreadyExists = this.metadataRoot.toFile().exists();
        this.fsLock = new FilesystemLock(this.metadataRoot.append(JAZZLOCK_NAME));
        this.ensureExclusiveCFAAccess(null);
        IPath flagDir = this.metadataRoot.append(SCM_COMPLETED_FLAGS);
        this.mapMgrFlag = new PersistentBusyFlag(flagDir.append(".metadata.isComplete").toFile());
        this.descriptorsFlag = new PersistentBusyFlag(flagDir.append(".descriptors.isComplete").toFile());
        this.inverseDescriptorsFlag = new PersistentBusyFlag(flagDir.append(".inverseDescriptors.isComplete").toFile());
        this.metaMetaFlag = new PersistentBusyFlag(flagDir.append(".metameta.isComplete").toFile());
        this.inverseItemInfosFlag = new PersistentBusyFlag(flagDir.append(".inverseItemInfos.isComplete").toFile());
        this.loadedComponentsFlag = new PersistentBusyFlag(flagDir.append(".loadedComponents.isComplete").toFile());
        this.persistentMetadataFlag = new PersistentBusyFlag(flagDir.append(".persistentMetadata.isComplete").toFile());
        this.localConflictFlag = new PersistentBusyFlag(flagDir.append(".localConflict.isComplete").toFile());
        if (flagDir.toFile().exists() && this.localConflictFlag.isBusy()) {
            this.localConflictFlag.setComplete(null);
        }
        this.isCorruptFlag = new PersistentFlag(flagDir.append(SCM_FLAG_IS_CORRUPT).toFile());
        this.validateFlags(flagDir);
        this.mapMgr = new MetadataDiskBackedMapManager(this.globalLock, this.mapMgrFlag);
        this.heapMgr = new PersistentHeapManager();
        this.saveDescriptorsJob = new AsyncSavePDBHMJob(Messages.SharingMetadata2_7, this.descriptorsFlag, this, this){

            @Override
            protected PersistentDiskBackedHashMap<?, ?> getMapToPesist() {
                return SharingMetadata2.this.descriptors;
            }
        };
        this.saveInverseDescriptorsJob = new AsyncSavePDBHMJob(Messages.SharingMetadata2_7, this.inverseDescriptorsFlag, this, this){

            @Override
            protected PersistentDiskBackedHashMap<?, ?> getMapToPesist() {
                return SharingMetadata2.this.inverseDescriptors;
            }
        };
        this.inverseItemInfosLock = new Object();
        this.saveInverseMapJob = new AsyncSavePDBHMJob(Messages.SharingMetadata2_8, this.inverseItemInfosFlag, this.inverseItemInfosLock, this){

            @Override
            protected PersistentDiskBackedHashMap<?, ?> getMapToPesist() {
                return SharingMetadata2.this.inverseItemInfos;
            }
        };
        this.loadedComponentsLock = new Object();
        this.saveLoadedComponentsJob = new AsyncSavePDBHMJob(Messages.SharingMetadata2_9, this.loadedComponentsFlag, this.loadedComponentsLock, this){

            @Override
            protected PersistentDiskBackedHashMap<?, ?> getMapToPesist() {
                return SharingMetadata2.this.loadedComponents;
            }
        };
        this.metaMetaLock = new Object();
        this.saveMetaMetaJob = new AsyncSavePDBHMJob(Messages.SharingMetadata2_67, this.metaMetaFlag, this.metaMetaLock, this){

            @Override
            protected PersistentDiskBackedHashMap<?, ?> getMapToPesist() {
                if (SharingMetadata2.this.metaMeta != null) {
                    return SharingMetadata2.this.metaMeta.getMapToPersist();
                }
                return null;
            }
        };
        this.isCaseSensitive = isCaseSensitive;
        if (!metadataRootAlreadyExists) {
            this.updateCaseModeFile();
        } else {
            this.validateCaseModeFile();
        }
        this.metadataChangeTracker = new MetadataChangeTracker(this, this.metadataRoot, this.persistentMetadataFlag, this.globalLock);
    }

    public void updateCaseModeFile() throws FileSystemException {
        java.nio.file.Path metadataRootPath = this.metadataRoot.toFile().toPath();
        java.nio.file.Path caseModeMarkerPath = metadataRootPath.resolve(JAZZ_CASEMODE_NAME);
        File caseModeMarkerFile = caseModeMarkerPath.toFile();
        try {
            if (caseModeMarkerFile.exists() || caseModeMarkerFile.createNewFile()) {
                FileWriter out = new FileWriter(caseModeMarkerFile, false);
                out.write(this.isCaseSensitive ? JAZZ_CASE_SENSITIVE_MODE : JAZZ_CASE_INSENSITIVE_MODE);
                out.close();
            }
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }

    private void validateCaseModeFile() throws FileSystemException {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            java.nio.file.Path metadataRootPath = this.metadataRoot.toFile().toPath();
            java.nio.file.Path caseModeMarkerPath = metadataRootPath.resolve(JAZZ_CASEMODE_NAME);
            File caseModeMarkerFile = caseModeMarkerPath.toFile();
            if (!caseModeMarkerFile.exists()) {
                if (this.isCaseSensitive) {
                    this.updateCaseModeFile();
                } else {
                    this.setCorrupt(true, "MacOS file system is case-insensitive. Sandbox is pre-6.0.5, must be upgraded by repairing the sandbox.", null);
                }
            } else {
                try {
                    String fileSystemCaseMode;
                    String savedCaseMode = new String(Files.readAllBytes(caseModeMarkerPath));
                    String string = fileSystemCaseMode = this.isCaseSensitive ? JAZZ_CASE_SENSITIVE_MODE : JAZZ_CASE_INSENSITIVE_MODE;
                    if (!savedCaseMode.equals(fileSystemCaseMode)) {
                        this.setCorrupt(true, "MacOS file system case sensitivity mode does not match the sandbox. Sandbox must be repaired.", null);
                    }
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        }
    }

    private void validateFlags(IPath flagDir) {
        if (FileSystemCore.isShutDown()) {
            return;
        }
        if (!flagDir.toFile().exists()) {
            if (!flagDir.toFile().mkdirs()) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, Messages.SharingMetadata2_10, null));
                return;
            }
            this.mapMgrFlag.setComplete(null);
            this.descriptorsFlag.setComplete(null);
            this.metaMetaFlag.setComplete(null);
            this.inverseDescriptorsFlag.setComplete(null);
            this.inverseItemInfosFlag.setComplete(null);
            this.loadedComponentsFlag.setComplete(null);
            this.persistentMetadataFlag.setComplete(null);
            this.localConflictFlag.setComplete(null);
            this.setCorrupt(false, "First run", null);
            return;
        }
        if (this.isCorruptFlag.getState() || this.mapMgrFlag.isBusy() || this.descriptorsFlag.isBusy() || this.metadataRoot.append(SCM_META_META).toFile().exists() && this.metaMetaFlag.isBusy() || this.inverseItemInfosFlag.isBusy() || this.loadedComponentsFlag.isBusy() || this.persistentMetadataFlag.isBusy() || this.localConflictFlag.isBusy()) {
            this.setCorrupt(true, "isCorruptFlag: " + this.isCorruptFlag.getState() + " mapMgrFlag: " + this.mapMgrFlag.isBusy() + " descriptorsFlag: " + this.descriptorsFlag.isBusy() + " metaMetaFlag: " + (this.metadataRoot.append(SCM_META_META).toFile().exists() && this.metaMetaFlag.isBusy()) + " inverseDescriptorsFlag: " + this.inverseDescriptorsFlag.isBusy() + " inverseItemInfosFlag: " + this.inverseItemInfosFlag.isBusy() + " loadedComponentsFlag: " + this.loadedComponentsFlag.isBusy() + " persistentMetadataFlag: " + this.persistentMetadataFlag.isBusy() + " localConflictFlag: " + this.localConflictFlag.isBusy(), null);
        }
    }

    private IPath getLocation(IPath path) {
        return this.metadataRoot.append(path);
    }

    private void initInverseItemInfos() throws IOException, FileSystemException {
        if (this.inverseItemInfos == null) {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            File f = this.metadataRoot.append(SCM_INVERSE_ITEM_INFOS).toFile();
            try {
                this.inverseItemInfos = new InverseMetadataStore(f);
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Corruption on inverseItemItemInfos load: " + f.toString(), e);
                throw e;
            }
            this.inverseItemInfos.persist();
        }
    }

    private void initLoadedComponents() throws IOException, FileSystemException {
        if (this.loadedComponents == null) {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            File f = this.metadataRoot.append(SCM_LOADED_COMPONENTS).toFile();
            try {
                this.loadedComponents = new LoadedComponentsStore(this.heapMgr, f);
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Corruption on loadedComponents load: " + f.toString(), e);
                throw e;
            }
            this.loadedComponents.persist();
        }
    }

    private void initDescriptors() throws IOException, FileSystemException {
        if (this.descriptors == null) {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            File f = this.metadataRoot.append(SCM_DESCRIPTORS).toFile();
            this.initPagingSize();
            try {
                this.descriptors = new SharingDescriptorsMap(f, this.isCaseSensitive, this.pagingSize);
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Corruption on descriptors load: " + f.toString(), e);
                throw e;
            }
            this.descriptors.persist();
            File f2 = this.metadataRoot.append(SCM_INVERSE_DESCRIPTORS).toFile();
            try {
                this.inverseDescriptors = new InverseSharingDescriptorMap(f2, this.pagingSize);
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Corruption on inverse descriptors load: " + f.toString(), e);
                throw e;
            }
            if (this.descriptors.size() != this.inverseDescriptors.size()) {
                this.inverseDescriptors.clear();
                for (Map.Entry e : this.descriptors.entrySet()) {
                    Path path = new Path(null, ((StringWrapper)e.getKey()).toString());
                    ISharingDescriptor desc = (ISharingDescriptor)e.getValue();
                    this.inverseDescriptors.put(new ShareRoot(desc.getRootVersionable(), desc.getComponent(), desc.getConnectionHandle()), (IPath)path);
                }
            }
            this.inverseDescriptors.persist();
        }
    }

    private void initMetaMeta() throws IOException, FileSystemException {
        if (this.metaMeta == null) {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            File f = this.metadataRoot.append(SCM_META_META).toFile();
            try {
                this.metaMeta = new SharingMetaMetaDataProperties(f);
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Corruption on meta meta load: " + f.toString(), e);
                throw e;
            }
            this.metaMeta.getMapToPersist().persist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLocalConflicts() throws FileSystemException {
        ReadWriteLock readWriteLock = this.globalLockForLocalConflicts;
        synchronized (readWriteLock) {
            if (this.localConflictMetadata == null) {
                this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
                this.localConflictMetadata = new LocalConflictMetadata(this, this.metadataRoot, this.localConflictFlag, this.globalLockForLocalConflicts);
            }
        }
    }

    @Override
    public void accept(IVisitor visitor, IRelativeLocation base, int depth, boolean mutable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress;
        Directory initial;
        block10: {
            block11: {
                block8: {
                    block9: {
                        initial = null;
                        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        try {
                            FileItemInfo info;
                            if (base.isEmpty()) break block8;
                            initial = this.loadDirectory(base.getParent().toPath(), mutable);
                            try {
                                info = (FileItemInfo)initial.entries().get(new StringWrapper(base.getName(), this.isCaseSensitive));
                            }
                            catch (DBHMException e) {
                                this.setCorrupt(e);
                                throw new FileSystemException(NLS.bind((String)Messages.SharingMetadata2_11, (Object)base.toString(), (Object[])new Object[0]), e);
                            }
                            if (info == null || visitor.visit(base, info, (IProgressMonitor)progress.newChild(5))) break block8;
                            if (initial == null) break block9;
                            this.releaseDirectory(initial);
                        }
                        catch (Throwable throwable) {
                            if (initial != null) {
                                this.releaseDirectory(initial);
                            }
                            progress.done();
                            throw throwable;
                        }
                    }
                    progress.done();
                    return;
                }
                if (depth != 0) break block10;
                if (initial == null) break block11;
                this.releaseDirectory(initial);
            }
            progress.done();
            return;
        }
        Collection<IRelativeLocation> allShares = this.allShares(base);
        HashSet<IRelativeLocation> shares = new HashSet<IRelativeLocation>(allShares);
        this.acceptAll(visitor, base, depth, mutable, shares, (IProgressMonitor)progress.newChild(95));
        if (initial != null) {
            this.releaseDirectory(initial);
        }
        progress.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptAll(IVisitor visitor, IRelativeLocation base, int depth, boolean mutable, Set<IRelativeLocation> shares, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Directory current = this.loadDirectory(base.toPath(), mutable);
        try {
            HashMap copy;
            HashSet<StringWrapper> skip = new HashSet<StringWrapper>();
            IPath[] childPaths = null;
            try {
                Map map = current.entries();
                synchronized (map) {
                    copy = new HashMap(current.entries());
                    childPaths = current.children();
                }
            }
            finally {
                this.releaseDirectory(current);
                current = null;
            }
            SubMonitor subProgress = progress.newChild(10);
            subProgress.setWorkRemaining(copy.size());
            for (Map.Entry entry : copy.entrySet()) {
                FileItemInfo info = (FileItemInfo)entry.getValue();
                StringWrapper sw = (StringWrapper)entry.getKey();
                IRelativeLocation entryPath = base.append(sw.toString());
                if (shares.contains(entryPath) || visitor.visit(entryPath, info, (IProgressMonitor)subProgress.newChild(1))) continue;
                skip.add(sw);
            }
            subProgress.done();
            if (depth == 1) {
                return;
            }
            try {
                --depth;
                progress.setWorkRemaining(childPaths.length - skip.size());
                int i = 0;
                while (i < childPaths.length) {
                    IPath childPath = childPaths[i];
                    if (!shares.contains(new RelativeLocation(childPath.segments())) && !skip.contains(new StringWrapper(childPath.lastSegment(), this.isCaseSensitive))) {
                        this.acceptAll(visitor, new RelativeLocation(childPath.segments()), depth, mutable, shares, (IProgressMonitor)progress.newChild(1));
                    }
                    ++i;
                }
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw new FileSystemException(Messages.SharingMetadata2_12, e);
            }
        }
        finally {
            progress.done();
        }
    }

    private IPath getRemotePath(IVersionableHandle base, IComponentHandle component, IContextHandle connection) throws FileSystemException {
        Object object = this.inverseItemInfosLock;
        synchronized (object) {
            try {
                IRelativeLocation root;
                this.initInverseItemInfos();
                ArrayList<String> segments = new ArrayList<String>();
                int pathLength = 0;
                while (true) {
                    Map inverseMap;
                    if ((root = this.getPathForShareRoot(base, component, connection)) != null) break;
                    try {
                        inverseMap = (Map)this.inverseItemInfos.get((Object)base.getItemId().getUuidValue());
                    }
                    catch (DBHMException e) {
                        this.setCorrupt(e);
                        throw e;
                    }
                    if (inverseMap == null) {
                        throw new FileSystemException(NLS.bind((String)Messages.SharingMetadata2_13, (Object)base.getItemId().getUuidValue(), (Object[])new Object[0]));
                    }
                    InverseFileItemInfo info = (InverseFileItemInfo)inverseMap.get(new ConnectionComponent(connection, component));
                    if (info == null) {
                        throw new FileSystemException(NLS.bind((String)Messages.SharingMetadata2_14, (Object)base.getItemId().getUuidValue(), (Object[])new Object[0]));
                    }
                    if (info.getParent() == null || info.getName() == null) {
                        throw new FileSystemException(NLS.bind((String)Messages.SharingMetadata2_15, (Object)base.getItemId().getUuidValue(), (Object[])new Object[0]));
                    }
                    pathLength += info.getName().length();
                    segments.add(info.getName());
                    base = info.getParent();
                }
                String rootPath = root.toPath().removeTrailingSeparator().toString();
                StringBuffer path = new StringBuffer(rootPath.length() + pathLength + segments.size());
                path.append(rootPath);
                ListIterator i = segments.listIterator(segments.size());
                while (i.hasPrevious()) {
                    String segment = (String)i.previous();
                    path.append('/');
                    path.append(segment);
                }
                return new Path(null, path.toString());
            }
            catch (DBHMException e) {
                throw new FileSystemException(Messages.SharingMetadata2_16, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_17, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(IRemoteVisitor visitor, IVersionableHandle base, IComponentHandle component, IContextHandle connection, int depth, boolean mutable, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.globalLock.acquireWrite();
        try {
            try {
                Object object = this.inverseItemInfosLock;
                synchronized (object) {
                    this.initInverseItemInfos();
                    ArrayList<IVersionableHandle> toVisitItem = new ArrayList<IVersionableHandle>();
                    ArrayList<IPath> toVisitPath = new ArrayList<IPath>();
                    ArrayList<Integer> toVisitDepth = new ArrayList<Integer>();
                    toVisitItem.add(base);
                    toVisitPath.add(this.getRemotePath(base, component, connection));
                    toVisitDepth.add(0);
                    ConnectionComponent cc = new ConnectionComponent(connection, component);
                    do {
                        int idx = toVisitItem.size() - 1;
                        IVersionableHandle item = (IVersionableHandle)toVisitItem.remove(idx);
                        Map inverseMap = (Map)this.inverseItemInfos.get((Object)item.getItemId().getUuidValue());
                        IPath path = (IPath)toVisitPath.remove(idx);
                        if (inverseMap == null) {
                            throw new FileSystemException(NLS.bind((String)Messages.SharingMetadata2_18, (Object)item.getItemId().getUuidValue(), (Object[])new Object[]{path.toOSString(), component.getItemId().getUuidValue(), connection.getItemId().getUuidValue()}));
                        }
                        InverseFileItemInfo info = (InverseFileItemInfo)inverseMap.get(cc);
                        if (info == null) {
                            throw new FileSystemException(NLS.bind((String)Messages.SharingMetadata2_18, (Object)item.getItemId().getUuidValue(), (Object[])new Object[]{path.toOSString(), component.getItemId().getUuidValue(), connection.getItemId().getUuidValue()}));
                        }
                        Integer visitingDepth = (Integer)toVisitDepth.remove(idx);
                        progress.setWorkRemaining(toVisitItem.size() + 1);
                        boolean visitChildren = visitor.visit(info, (IProgressMonitor)progress.newChild(1));
                        if (depth == visitingDepth || !visitChildren) continue;
                        Integer childDepth = visitingDepth + 1;
                        for (Map.Entry<String, IVersionableHandle> entry : info.getRemoteChildren().entrySet()) {
                            String name = entry.getKey();
                            IVersionableHandle child = entry.getValue();
                            toVisitItem.add(child);
                            toVisitPath.add(path.append(name));
                            toVisitDepth.add(childDepth);
                        }
                    } while (!toVisitItem.isEmpty());
                }
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw new FileSystemException(Messages.SharingMetadata2_20, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_21, e);
            }
        }
        finally {
            this.globalLock.release();
            progress.done();
        }
    }

    private Directory loadDirectory(IPath path, boolean exclusive) throws FileSystemException {
        IPath canonicalPath = this.getCanonicalPath(path, true);
        try {
            this.ensureExclusiveCFAAccess((IProgressMonitor)TempHelper.MONITOR);
            return (Directory)this.mapMgr.loadMap(canonicalPath, exclusive, path);
        }
        catch (DBHMException e) {
            this.setCorrupt(true, "Problem reading Directory at " + canonicalPath, e);
            throw new FileSystemException(Messages.DiskBackedMapManager_0, e);
        }
    }

    private IPath getCanonicalPath(IPath path, boolean convertCase) {
        if (this.isCaseSensitive || !convertCase) {
            return path.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator();
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            sb.append('/');
            sb.append(LocaleUtil.fileSystemNormalization((String)segment));
            ++n2;
        }
        return new Path(null, sb.toString()).makeAbsolute();
    }

    private void releaseDirectory(Directory dir) throws FileSystemException {
        this.mapMgr.releaseMap(dir);
    }

    @Override
    public synchronized IRelativeLocation[] allShares() throws FileSystemException {
        try {
            this.initDescriptors();
            return this.inverseDescriptors.allShares(this.isCaseSensitive);
        }
        catch (DBHMException e) {
            throw new FileSystemException(Messages.SharingMetadata2_22, e);
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.SharingMetadata2_23, e);
        }
    }

    @Override
    public synchronized Collection<IRelativeLocation> allShares(IRelativeLocation parent) throws FileSystemException {
        try {
            IRelativeLocation[] allShares;
            this.initDescriptors();
            ArrayList<IRelativeLocation> result = new ArrayList<IRelativeLocation>();
            parent = parent.getCanonicalForm(this.isCaseSensitive, true);
            IRelativeLocation[] iRelativeLocationArray = allShares = this.allShares();
            int n = allShares.length;
            int n2 = 0;
            while (n2 < n) {
                IRelativeLocation p = iRelativeLocationArray[n2];
                if (parent.isPrefixOf(p.getCanonicalForm(this.isCaseSensitive, true))) {
                    result.add(p);
                }
                ++n2;
            }
            return result;
        }
        catch (DBHMException e) {
            throw new FileSystemException(Messages.SharingMetadata2_22, e);
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.SharingMetadata2_23, e);
        }
    }

    @Override
    public void clear() throws FileSystemException {
        this.clear(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(boolean releaseCfaLock) throws FileSystemException {
        this.closeLocalConflictMetadata(null);
        this.globalLock.acquireWrite();
        try {
            this.metadataChangeTracker.close();
            this.mapMgr.closeAll((IPath)Path.ROOT);
            Object object = this.inverseItemInfosLock;
            synchronized (object) {
                Object object2 = this.loadedComponentsLock;
                synchronized (object2) {
                    SharingMetadata2 sharingMetadata2 = this;
                    synchronized (sharingMetadata2) {
                        try {
                            DBHMException exception = null;
                            if (this.descriptors != null) {
                                block37: {
                                    try {
                                        this.descriptors.close();
                                    }
                                    catch (DBHMException e) {
                                        if (exception != null) break block37;
                                        exception = e;
                                    }
                                }
                                this.descriptors = null;
                            }
                            if (this.inverseDescriptors != null) {
                                block38: {
                                    try {
                                        this.inverseDescriptors.close();
                                    }
                                    catch (DBHMException e) {
                                        if (exception != null) break block38;
                                        exception = e;
                                    }
                                }
                                this.inverseDescriptors = null;
                            }
                            if (this.metaMeta != null) {
                                block39: {
                                    try {
                                        this.metaMeta.getMapToPersist().close();
                                    }
                                    catch (DBHMException e) {
                                        if (exception != null) break block39;
                                        exception = e;
                                    }
                                }
                                this.metaMeta = null;
                            }
                            if (this.loadedComponents != null) {
                                block40: {
                                    try {
                                        this.loadedComponents.close();
                                    }
                                    catch (DBHMException e) {
                                        if (exception != null) break block40;
                                        exception = e;
                                    }
                                }
                                this.loadedComponents = null;
                            }
                            if (this.inverseItemInfos != null) {
                                block41: {
                                    try {
                                        this.inverseItemInfos.close();
                                    }
                                    catch (DBHMException e) {
                                        if (exception != null) break block41;
                                        exception = e;
                                    }
                                }
                                this.inverseItemInfos = null;
                            }
                            this.setPagingSize(2500);
                            if (exception != null) {
                                throw exception;
                            }
                        }
                        catch (DBHMException e) {
                            this.setCorrupt(true, "Problem in " + (this.metaMeta == null ? "" : "metameta? ") + (this.descriptors == null ? "" : "descriptors? ") + (this.loadedComponents == null ? "" : "loadedComponents? ") + (this.inverseItemInfos == null ? "" : "inverseItemInfos?"), e);
                        }
                        catch (IOException e) {
                            this.setCorrupt(true, "Problem in " + (this.metaMeta == null ? "" : "metameta? ") + (this.descriptors == null ? "" : "descriptors? ") + (this.loadedComponents == null ? "" : "loadedComponents? ") + (this.inverseItemInfos == null ? "" : "inverseItemInfos?"), e);
                        }
                        try {
                            if (releaseCfaLock) {
                                this.releaseExclusiveCFAAccess(null);
                                this.deleteDeeply(EFS.getLocalFileSystem().getStore(this.metadataRoot), null);
                            } else {
                                IFileStore[] metadataContents;
                                IFileStore[] iFileStoreArray = metadataContents = EFS.getLocalFileSystem().getStore(this.metadataRoot).childStores(0, null);
                                int n = metadataContents.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFileStore metadataContent = iFileStoreArray[n2];
                                    if (!metadataContent.getName().equals(JAZZLOCK_NAME)) {
                                        this.deleteDeeply(metadataContent, null);
                                    }
                                    ++n2;
                                }
                            }
                        }
                        catch (CoreException e) {
                            throw FileSystemStatusException.fromCoreException(Messages.SharingMetadata2_26, e);
                        }
                    }
                }
            }
        }
        finally {
            this.globalLock.release();
        }
    }

    private void deleteDeeply(IFileStore file, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            file.delete(0, (IProgressMonitor)progress.newChild(1));
        }
        catch (CoreException e) {
            if (!this.isCaseSensitive && !this.containsFile(file, (IProgressMonitor)progress.newChild(1))) {
                LoggingHelper.log(e);
                return;
            }
            throw e;
        }
    }

    private boolean containsFile(IFileStore file, IProgressMonitor monitor) {
        SubMonitor progress;
        block3: {
            try {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                IFileInfo info = file.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
                if (info.isDirectory()) break block3;
                return true;
            }
            catch (CoreException e) {
                LoggingHelper.log(e);
                return true;
            }
        }
        return this.containsChildFile(file, (IProgressMonitor)progress.newChild(1));
    }

    private boolean containsChildFile(IFileStore file, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IFileInfo[] childInfos = file.childInfos(0, (IProgressMonitor)progress.newChild(1));
        boolean hasSubfile = false;
        progress.setWorkRemaining(childInfos.length);
        IFileInfo[] iFileInfoArray = childInfos;
        int n = childInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo childInfo = iFileInfoArray[n2];
            if (!childInfo.isDirectory()) {
                return true;
            }
            IFileStore childFile = file.getChild(childInfo.getName());
            if (hasSubfile |= this.containsChildFile(childFile, (IProgressMonitor)progress.newChild(1))) break;
            ++n2;
        }
        return hasSubfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLocalConflictMetadata(MultiStatus status) throws FileSystemException {
        ReadWriteLock readWriteLock = this.globalLockForLocalConflicts;
        synchronized (readWriteLock) {
            if (this.localConflictMetadata != null) {
                this.globalLockForLocalConflicts.acquireWrite();
                try {
                    this.localConflictMetadata.close();
                    if (status != null) {
                        this.localConflictFlag.setComplete(status);
                    }
                }
                finally {
                    this.localConflictMetadata = null;
                    this.globalLockForLocalConflicts.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws FileSystemException {
        MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", -1, Messages.SharingMetadata2_27, null);
        this.closeLocalConflictMetadata(status);
        this.globalLock.acquireWrite();
        try {
            try {
                this.metadataChangeTracker.close();
                this.mapMgr.closeAll((IPath)Path.ROOT);
                Object object = this.inverseItemInfosLock;
                synchronized (object) {
                    Object object2 = this.loadedComponentsLock;
                    synchronized (object2) {
                        SharingMetadata2 sharingMetadata2 = this;
                        synchronized (sharingMetadata2) {
                            DBHMException exception = null;
                            if (this.descriptors != null) {
                                block32: {
                                    try {
                                        this.descriptors.close();
                                    }
                                    catch (DBHMException e) {
                                        if (exception != null) break block32;
                                        exception = e;
                                    }
                                }
                                this.descriptors = null;
                            }
                            this.descriptorsFlag.setComplete(status);
                            if (this.inverseDescriptors != null) {
                                block33: {
                                    try {
                                        this.inverseDescriptors.close();
                                    }
                                    catch (DBHMException e) {
                                        if (exception != null) break block33;
                                        exception = e;
                                    }
                                }
                                this.inverseDescriptors = null;
                            }
                            this.inverseDescriptorsFlag.setComplete(status);
                            if (this.metaMeta != null) {
                                block34: {
                                    try {
                                        this.metaMeta.getMapToPersist().close();
                                    }
                                    catch (DBHMException e) {
                                        if (exception != null) break block34;
                                        exception = e;
                                    }
                                }
                                this.metaMeta = null;
                            }
                            this.metaMetaFlag.setComplete(status);
                            if (this.loadedComponents != null) {
                                block35: {
                                    try {
                                        this.loadedComponents.close();
                                    }
                                    catch (DBHMException e) {
                                        if (exception != null) break block35;
                                        exception = e;
                                    }
                                }
                                this.loadedComponents = null;
                            }
                            this.loadedComponentsFlag.setComplete(status);
                            if (this.inverseItemInfos != null) {
                                block36: {
                                    try {
                                        this.inverseItemInfos.close();
                                    }
                                    catch (DBHMException e) {
                                        if (exception != null) break block36;
                                        exception = e;
                                    }
                                }
                                this.inverseItemInfos = null;
                            }
                            this.inverseItemInfosFlag.setComplete(status);
                            this.setPagingSize(2500);
                            if (exception != null) {
                                throw exception;
                            }
                        }
                    }
                }
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Problem in " + (this.metaMeta == null ? "" : "metameta? ") + (this.descriptors == null ? "" : "descriptors? ") + (this.loadedComponents == null ? "" : "loadedComponents? ") + (this.inverseItemInfos == null ? "" : "inverseItemInfos?"), e);
                throw new FileSystemException(Messages.SharingMetadata2_28, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_29, e);
            }
        }
        finally {
            this.globalLock.release();
            if (status.getChildren().length > 0) {
                LoggingHelper.log((IStatus)status);
            }
        }
    }

    private FileItemInfo deleteFileItemInfo(IPath path, IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo info;
        this.globalLock.acquireWrite();
        try {
            block11: {
                if (path.segmentCount() != 0) {
                    Directory dir = this.loadDirectory(path.removeLastSegments(1), true);
                    try {
                        try {
                            info = (FileItemInfo)dir.entries().remove(new StringWrapper(path.lastSegment(), this.isCaseSensitive));
                            break block11;
                        }
                        catch (DBHMException e) {
                            this.setCorrupt(e);
                            throw new FileSystemException(NLS.bind((String)Messages.SharingMetadata2_30, (Object)path.toString(), (Object[])new Object[0]), e);
                        }
                    }
                    finally {
                        this.releaseDirectory(dir);
                    }
                }
                info = null;
            }
            this.mapMgr.closeAll(path);
            IFileStore store = EFS.getLocalFileSystem().getStore(this.getLocation(path));
            try {
                this.deleteDeeply(store, monitor);
            }
            catch (CoreException e) {
                throw new FileSystemException(NLS.bind((String)Messages.SharingMetadata2_31, (Object)this.getLocation(path).toOSString(), (Object[])new Object[0]), e);
            }
        }
        finally {
            this.globalLock.release();
        }
        return info;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    private FileItemInfo getFileItemInfo(IPath path) throws FileSystemException {
        if (path.segmentCount() == 0) {
            return null;
        }
        path = path.makeAbsolute();
        Directory dir = this.loadDirectory(path.removeLastSegments(1), false);
        try {
            FileItemInfo fileItemInfo = (FileItemInfo)dir.entries().get(new StringWrapper(path.lastSegment(), this.isCaseSensitive));
            return fileItemInfo;
        }
        catch (DBHMException e) {
            this.setCorrupt(e);
            throw new FileSystemException(Messages.SharingMetadata2_32, e);
        }
        finally {
            this.releaseDirectory(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<StringWrapper, FileItemInfo> getChildInfos(IPath path) throws FileSystemException {
        path = path.makeAbsolute();
        Directory dir = this.loadDirectory(path, false);
        try {
            HashMap<StringWrapper, FileItemInfo> copy;
            Map entries;
            Map map = entries = dir.entries();
            synchronized (map) {
                copy = new HashMap<StringWrapper, FileItemInfo>(entries);
            }
            HashMap<StringWrapper, FileItemInfo> hashMap = copy;
            return hashMap;
        }
        catch (DBHMException e) {
            this.setCorrupt(e);
            throw new FileSystemException(Messages.SharingMetadata2_33, e);
        }
        finally {
            this.releaseDirectory(dir);
        }
    }

    @Override
    public InverseFileItemInfo getFileItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemException {
        Object object = this.inverseItemInfosLock;
        synchronized (object) {
            Map inverseMap;
            block7: {
                this.initInverseItemInfos();
                inverseMap = (Map)this.inverseItemInfos.get((Object)item.getItemId().getUuidValue());
                if (inverseMap != null) break block7;
                return null;
            }
            try {
                return (InverseFileItemInfo)inverseMap.get(new ConnectionComponent(connection, component));
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw new FileSystemException(Messages.SharingMetadata2_34, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_35, e);
            }
        }
    }

    @Override
    public Collection<ISharingMetadata.IConnectionComponent> getLocations(IVersionableHandle item) throws FileSystemException {
        Object object = this.inverseItemInfosLock;
        synchronized (object) {
            try {
                Map inverseMap;
                this.initInverseItemInfos();
                try {
                    inverseMap = (Map)this.inverseItemInfos.get((Object)item.getItemId().getUuidValue());
                }
                catch (DBHMException e) {
                    this.setCorrupt(e);
                    throw e;
                }
                if (inverseMap == null) {
                    return Collections.emptyList();
                }
                return new ArrayList<ISharingMetadata.IConnectionComponent>(inverseMap.keySet());
            }
            catch (DBHMException e) {
                throw new FileSystemException(Messages.SharingMetadata2_36, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_37, e);
            }
        }
    }

    private synchronized ISharingDescriptor findSharingDescriptor(IPath path) throws FileSystemException {
        this.initDescriptors();
        try {
            path = this.getCanonicalPath(path, false);
            int numSegments = path.segmentCount();
            while (numSegments >= 0) {
                ISharingDescriptor result = (ISharingDescriptor)this.descriptors.get((Object)new StringWrapper(this.getCanonicalPath(path.uptoSegment(numSegments), false).toString(), this.isCaseSensitive));
                if (result != null) {
                    return result;
                }
                --numSegments;
            }
            return null;
        }
        catch (DBHMException e) {
            try {
                this.setCorrupt(e);
                throw e;
            }
            catch (DBHMException e2) {
                throw new FileSystemException(Messages.SharingMetadata2_38, e2);
            }
            catch (IOException e3) {
                throw new FileSystemException(Messages.SharingMetadata2_39, e3);
            }
        }
    }

    private synchronized ISharingMetadata.ISharingDescriptorPath findSharingDescriptorPath(IPath path) throws FileSystemException {
        final ISharingDescriptor desc = this.findSharingDescriptor(path);
        if (desc == null) {
            return null;
        }
        IPath dPath = (IPath)this.inverseDescriptors.get(new ShareRoot(desc.getRootVersionable(), desc.getComponent(), desc.getConnectionHandle()));
        final RelativeLocation relativeLocation = dPath == null ? null : new RelativeLocation(dPath.segments());
        return new ISharingMetadata.ISharingDescriptorPath(){

            @Override
            public ISharingDescriptor getDescriptor() {
                return desc;
            }

            @Override
            public IRelativeLocation getPath() {
                return relativeLocation;
            }
        };
    }

    private synchronized ISharingDescriptor getSharingDescriptor(IPath sharePath) throws FileSystemException {
        try {
            this.initDescriptors();
            try {
                return (ISharingDescriptor)this.descriptors.get((Object)new StringWrapper(this.getCanonicalPath(sharePath, false).toString(), this.isCaseSensitive));
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw e;
            }
        }
        catch (DBHMException e) {
            throw new FileSystemException(Messages.SharingMetadata2_38, e);
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.SharingMetadata2_39, e);
        }
    }

    private void setCorrupt(DBHMException e) {
        this.setCorrupt(true, null, e);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized IRelativeLocation getPathForShareRoot(IVersionableHandle root, IComponentHandle component, IContextHandle connection) throws FileSystemException {
        try {
            this.initDescriptors();
            try {
                IPath dPath = (IPath)this.inverseDescriptors.get(new ShareRoot(root, component, connection));
                if (dPath == null) {
                    return null;
                }
                return new RelativeLocation(dPath.segments());
            }
            catch (DBHMException e) {
                try {
                    this.setCorrupt(e);
                    throw e;
                }
                catch (DBHMException e2) {
                    throw new FileSystemException(Messages.SharingMetadata2_40, e2);
                }
            }
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.SharingMetadata2_41, e);
        }
    }

    private FileItemInfo moveFileItemInfo(IPath sourcePath, IPath destinationPath) throws FileSystemException {
        FileItemInfo sourceInfo;
        block17: {
            IPath canonicalDest;
            sourcePath = this.getCanonicalPath(sourcePath, false);
            destinationPath = this.getCanonicalPath(destinationPath, false);
            IPath canonicalSource = this.getCanonicalPath(sourcePath, true);
            if (!canonicalSource.equals((Object)(canonicalDest = this.getCanonicalPath(destinationPath, true)))) {
                Assert.isLegal((!canonicalSource.isPrefixOf(canonicalDest) ? 1 : 0) != 0, (String)("Canonical source: " + canonicalSource + " - canonical dest: " + canonicalDest));
                Assert.isLegal((!canonicalDest.isPrefixOf(canonicalSource) ? 1 : 0) != 0, (String)("Canonical source: " + canonicalSource + " - canonical dest: " + canonicalDest));
            }
            this.globalLock.acquireWrite();
            try {
                IPath sourceBucketPath = canonicalSource.removeLastSegments(1);
                Directory source = this.loadDirectory(sourceBucketPath, true);
                try {
                    IPath destinationBucketPath = canonicalDest.removeLastSegments(1);
                    boolean sameParent = sourceBucketPath.equals((Object)destinationBucketPath);
                    Directory destination = sameParent ? source : this.loadDirectory(destinationBucketPath, true);
                    try {
                        try {
                            sourceInfo = (FileItemInfo)source.entries().remove(new StringWrapper(sourcePath.lastSegment(), this.isCaseSensitive));
                            if (sourceInfo != null) {
                                destination.entries().put(new StringWrapper(destinationPath.lastSegment(), this.isCaseSensitive), sourceInfo);
                            }
                        }
                        catch (DBHMException e) {
                            this.setCorrupt(e);
                            throw new FileSystemException(Messages.SharingMetadata2_42, e);
                        }
                    }
                    finally {
                        if (!sameParent) {
                            this.releaseDirectory(destination);
                        }
                    }
                }
                finally {
                    this.releaseDirectory(source);
                }
                this.mapMgr.closeAll(canonicalSource);
                this.mapMgr.closeAll(canonicalDest);
                IFileStore sourceStore = EFS.getLocalFileSystem().getStore(this.getLocation(sourcePath));
                IFileStore destinationStore = EFS.getLocalFileSystem().getStore(this.getLocation(destinationPath));
                if (!sourceStore.fetchInfo().exists()) break block17;
                try {
                    sourceStore.move(destinationStore, 0, null);
                }
                catch (CoreException e) {
                    throw new FileSystemException(Messages.SharingMetadata2_43, e);
                }
            }
            finally {
                this.globalLock.release();
            }
        }
        return sourceInfo;
    }

    private FileItemInfo setFileItemInfo(IPath path, FileItemInfo itemInfo) throws FileSystemException {
        path = path.makeAbsolute();
        Directory dir = this.loadDirectory(path.removeLastSegments(1), true);
        try {
            FileItemInfo oldInfo = itemInfo == null ? (FileItemInfo)dir.entries().remove(new StringWrapper(path.lastSegment(), this.isCaseSensitive)) : dir.entries().put(new StringWrapper(path.lastSegment(), this.isCaseSensitive), itemInfo);
            FileItemInfo fileItemInfo = oldInfo;
            return fileItemInfo;
        }
        catch (DBHMException e) {
            this.setCorrupt(e);
            throw new FileSystemException(Messages.SharingMetadata2_44, e);
        }
        finally {
            this.releaseDirectory(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InverseFileItemInfo setFileItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, InverseFileItemInfo itemInfo, IProgressMonitor monitor) throws FileSystemException {
        InverseFileItemInfo oldInfo;
        if (itemInfo != null && !item.sameItemId((IItemHandle)itemInfo.getVersionableHandle())) {
            throw new IllegalArgumentException();
        }
        Object object = this.inverseItemInfosLock;
        synchronized (object) {
            try {
                this.initInverseItemInfos();
                try {
                    this.setBusy(this.inverseItemInfosFlag);
                    Map inverseMap = (Map)this.inverseItemInfos.get((Object)item.getItemId().getUuidValue());
                    if (inverseMap == null) {
                        inverseMap = Collections.emptyMap();
                    }
                    LinkedHashMap<ConnectionComponent, InverseFileItemInfo> newMap = new LinkedHashMap<ConnectionComponent, InverseFileItemInfo>(inverseMap);
                    ConnectionComponent cc = new ConnectionComponent((IContextHandle)connection.getItemType().createItemHandle(connection.getItemId(), null), (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(component.getItemId(), null));
                    oldInfo = (InverseFileItemInfo)inverseMap.get(cc);
                    if (itemInfo == null) {
                        newMap.remove(cc);
                    } else {
                        newMap.put(cc, itemInfo);
                    }
                    if (newMap.isEmpty()) {
                        this.inverseItemInfos.remove((Object)item.getItemId().getUuidValue());
                    } else {
                        this.inverseItemInfos.put((Object)item.getItemId().getUuidValue(), newMap);
                    }
                    this.saveInverseMapJob.requestSave();
                }
                catch (DBHMException e) {
                    this.setCorrupt(e);
                    throw e;
                }
            }
            catch (DBHMException e) {
                throw new FileSystemException(Messages.SharingMetadata2_45, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_46, e);
            }
        }
        this.metadataChangeTracker.handleFileItemInfoSet(item, component, connection, oldInfo, itemInfo, monitor);
        return oldInfo;
    }

    private synchronized ISharingDescriptor setSharingDescriptor(IPath sharePath, ISharingDescriptor descriptor, IProgressMonitor monitor) throws FileSystemException {
        try {
            this.initDescriptors();
            try {
                ISharingDescriptor oldDesc;
                this.setBusy(this.descriptorsFlag);
                this.setBusy(this.inverseDescriptorsFlag);
                sharePath = this.getCanonicalPath(sharePath, false);
                StringWrapper wrapped = new StringWrapper(sharePath.toString(), this.isCaseSensitive);
                if (descriptor == null) {
                    oldDesc = (ISharingDescriptor)this.descriptors.remove((Object)wrapped);
                    if (oldDesc != null) {
                        this.inverseDescriptors.remove(new ShareRoot(oldDesc.getRootVersionable(), oldDesc.getComponent(), oldDesc.getConnectionHandle()));
                    }
                } else {
                    IPath oldPath;
                    ShareRoot oldRoot;
                    oldDesc = (ISharingDescriptor)this.descriptors.put((Object)wrapped, (Object)descriptor);
                    ShareRoot newRoot = new ShareRoot(descriptor.getRootVersionable(), descriptor.getComponent(), descriptor.getConnectionHandle());
                    if (oldDesc != null && !(oldRoot = new ShareRoot(oldDesc.getRootVersionable(), oldDesc.getComponent(), oldDesc.getConnectionHandle())).equals(newRoot)) {
                        this.inverseDescriptors.remove(oldRoot);
                    }
                    if ((oldPath = this.inverseDescriptors.put(newRoot, sharePath)) != null && !sharePath.equals((Object)oldPath) && !this.getCanonicalPath(sharePath, true).equals((Object)this.getCanonicalPath(oldPath, true))) {
                        throw new FileSystemException(NLS.bind((String)Messages.SharingMetadata2_47, (Object[])new Object[]{oldPath, sharePath}, (Object[])new Object[0]));
                    }
                }
                this.saveDescriptorsJob.requestSave();
                this.saveInverseDescriptorsJob.requestSave();
                return oldDesc;
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw e;
            }
        }
        catch (DBHMException e) {
            throw new FileSystemException(Messages.SharingMetadata2_48, e);
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.SharingMetadata2_49, e);
        }
    }

    private void setBusy(PersistentBusyFlag flag) {
        MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", -1, NLS.bind((String)Messages.SharingMetadata2_50, (Object)flag, (Object[])new Object[0]), null);
        flag.setBusy(multi);
        if (!multi.isOK()) {
            LoggingHelper.log((IStatus)multi);
        }
    }

    @Override
    public synchronized Map<IRelativeLocation, ISharingDescriptor> getSharingDescriptors(IComponentHandle component, IContextHandle connectionHandle) throws FileSystemException {
        try {
            Set entrySet;
            this.initDescriptors();
            HashMap<IRelativeLocation, ISharingDescriptor> result = new HashMap<IRelativeLocation, ISharingDescriptor>();
            try {
                entrySet = this.descriptors.entrySet();
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw e;
            }
            for (Map.Entry entry : entrySet) {
                ISharingDescriptor descriptor = (ISharingDescriptor)entry.getValue();
                if (descriptor == null || !descriptor.getConnectionHandle().sameItemId((IItemHandle)connectionHandle) || !descriptor.getComponent().sameItemId((IItemHandle)component)) continue;
                result.put(new RelativeLocation(new Path(null, ((StringWrapper)entry.getKey()).toString()).segments()), descriptor);
            }
            return result;
        }
        catch (DBHMException e) {
            throw new FileSystemException(Messages.SharingMetadata2_51, e);
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.SharingMetadata2_52, e);
        }
    }

    @Override
    public synchronized Map<IRelativeLocation, ISharingDescriptor> getSharingDescriptors() throws FileSystemException {
        try {
            Set entrySet;
            this.initDescriptors();
            HashMap<IRelativeLocation, ISharingDescriptor> result = new HashMap<IRelativeLocation, ISharingDescriptor>();
            try {
                entrySet = this.descriptors.entrySet();
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw e;
            }
            for (Map.Entry entry : entrySet) {
                ISharingDescriptor descriptor = (ISharingDescriptor)entry.getValue();
                result.put(new RelativeLocation(new Path(null, ((StringWrapper)entry.getKey()).toString()).segments()), descriptor);
            }
            return result;
        }
        catch (DBHMException e) {
            throw new FileSystemException(Messages.SharingMetadata2_51, e);
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.SharingMetadata2_52, e);
        }
    }

    public String toDebugString() {
        final StringBuffer result = new StringBuffer();
        try {
            this.accept(new IVisitor(){

                @Override
                public boolean visit(IRelativeLocation path, FileItemInfo entry, IProgressMonitor monitor) {
                    result.append(path.toString());
                    result.append(" -> ");
                    result.append(entry.getVersionableHandle().getItemId());
                    result.append('\n');
                    return true;
                }
            }, new RelativeLocation(new String[0]), Integer.MAX_VALUE, false, null);
        }
        catch (FileSystemException e) {
            StringWriter output = new StringWriter();
            PrintWriter pw = new PrintWriter(output);
            e.printStackTrace(pw);
            pw.flush();
            result.append(output);
        }
        return result.toString();
    }

    @Override
    public Collection<LoadedConfigurationDescriptor> allLoadedComponents(IProgressMonitor monitor) throws FileSystemException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                this.initLoadedComponents();
                return new ArrayList<LoadedConfigurationDescriptor>(this.loadedComponents.values());
            }
            catch (DBHMException e) {
                throw new FileSystemException(Messages.SharingMetadata2_53, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_54, e);
            }
        }
    }

    @Override
    public LoadedConfigurationDescriptor componentLoaded(LoadedConfigurationDescriptor desc, IProgressMonitor monitor) throws FileSystemException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                this.initLoadedComponents();
                this.setBusy(this.loadedComponentsFlag);
                LoadedConfigurationDescriptor oldDesc = (LoadedConfigurationDescriptor)this.loadedComponents.put((Object)new ConnectionComponent(desc.connectionHandle, desc.componentHandle), (Object)desc);
                this.saveLoadedComponentsJob.requestSave();
                return oldDesc;
            }
            catch (DBHMException e) {
                this.setCorrupt(e);
                throw new FileSystemException(Messages.SharingMetadata2_57, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_58, e);
            }
        }
    }

    @Override
    public LoadedConfigurationDescriptor componentUnloaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                LoadedConfigurationDescriptor oldDesc;
                this.initLoadedComponents();
                this.setBusy(this.loadedComponentsFlag);
                try {
                    oldDesc = (LoadedConfigurationDescriptor)this.loadedComponents.remove((Object)new ConnectionComponent(connection, component));
                }
                catch (DBHMException e) {
                    this.setCorrupt(e);
                    throw e;
                }
                this.saveLoadedComponentsJob.requestSave();
                return oldDesc;
            }
            catch (DBHMException e) {
                throw new FileSystemException(Messages.SharingMetadata2_59, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_60, e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean hasShares(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        try {
            ShareRoot r;
            this.initDescriptors();
            Iterator iterator = this.inverseDescriptors.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(r = (ShareRoot)iterator.next()).cc.getComponent().sameItemId((IItemHandle)component) || !r.cc.getConnection().sameItemId((IItemHandle)connection));
            return true;
        }
        catch (DBHMException e) {
            this.setCorrupt(e);
            throw new FileSystemException(Messages.SharingMetadata2_61, e);
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.SharingMetadata2_62, e);
        }
    }

    @Override
    public boolean isLoaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        Object object = this.loadedComponentsLock;
        synchronized (object) {
            try {
                this.initLoadedComponents();
                try {
                    return this.loadedComponents.containsKey((Object)new ConnectionComponent(connection, component));
                }
                catch (DBHMException e) {
                    this.setCorrupt(e);
                    throw e;
                }
            }
            catch (DBHMException e) {
                throw new FileSystemException(Messages.SharingMetadata2_63, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_64, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCorruptionListener(ICorruptCopyFileAreaListener listener) {
        Object object = this.corruptionLock;
        synchronized (object) {
            if (this.isCorruptFlag.getState()) {
                listener.corrupt(this.getCorruptionEvent());
            }
            this.corruptionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCorruptionListener(ICorruptCopyFileAreaListener listener) {
        Object object = this.corruptionLock;
        synchronized (object) {
            this.corruptionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCorrupt(boolean newValue, String debugExplanation, Throwable cause) {
        if (FileSystemCore.isShutDown()) {
            return;
        }
        Object object = this.corruptionLock;
        synchronized (object) {
            if (newValue == this.isCorruptFlag.getState()) {
                return;
            }
            try {
                this.isCorruptFlag.setState(newValue);
            }
            catch (IOException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Could not write corruption bit", e));
            }
            if (newValue) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, debugExplanation == null ? null : debugExplanation, cause));
            }
            ICorruptCopyFileAreaEvent event = this.getCorruptionEvent();
            for (ICorruptCopyFileAreaListener listener : this.corruptionListeners) {
                listener.corrupt(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ICorruptCopyFileAreaEvent getCorruptionEvent() {
        Object object = this.corruptionLock;
        synchronized (object) {
            final boolean localCorrupt = this.isCorruptFlag.getState();
            return new ICorruptCopyFileAreaEvent(){

                @Override
                public boolean isCorrupt() {
                    return localCorrupt;
                }

                @Override
                public ILocation getRoot() {
                    return SharingMetadata2.this.cfaRootLocation;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCorrupted() {
        Object object = this.corruptionLock;
        synchronized (object) {
            return this.isCorruptFlag.getState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureExclusiveCFAAccess(IProgressMonitor progress) throws FileSystemException {
        FilesystemLock filesystemLock = this.fsLock;
        synchronized (filesystemLock) {
            IStatus status;
            if (!this.fsLock.isAcquired() && !(status = this.fsLock.acquire(progress)).isOK()) {
                throw new CopyFileAreaLockedByOtherProcess(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseExclusiveCFAAccess(IProgressMonitor progress) {
        FilesystemLock filesystemLock = this.fsLock;
        synchronized (filesystemLock) {
            IStatus status = this.fsLock.release(progress);
            if (!status.isOK()) {
                LoggingHelper.log(status);
            }
        }
    }

    @Override
    public void release(boolean eraseMetadata) throws FileSystemException {
        if (eraseMetadata) {
            this.clear(true);
        } else {
            this.close();
            this.releaseExclusiveCFAAccess(null);
        }
    }

    @Override
    public MetadataChangeTracker getMetadataChangeTracker() {
        return this.metadataChangeTracker;
    }

    @Override
    public ILocalConflictMetadata getLocalConflictMetadata() throws FileSystemException {
        this.initLocalConflicts();
        return this.localConflictMetadata;
    }

    @Override
    public FileItemInfo deleteFileItemInfo(IRelativeLocation path, IProgressMonitor monitor) throws FileSystemException {
        return this.deleteFileItemInfo(path.toPath(), monitor);
    }

    @Override
    public IRelativeLocation findConflictingShare(IRelativeLocation sharePath) throws FileSystemException {
        return this.getSharingDescriptor(sharePath) == null ? null : sharePath;
    }

    @Override
    public ISharingDescriptor findSharingDescriptor(IRelativeLocation path) throws FileSystemException {
        return this.findSharingDescriptor(path.toPath());
    }

    @Override
    public ISharingMetadata.ISharingDescriptorPath findSharingDescriptorPath(IRelativeLocation path) throws FileSystemException {
        return this.findSharingDescriptorPath(path.toPath());
    }

    @Override
    public Map<StringWrapper, FileItemInfo> getChildInfos(IRelativeLocation path) throws FileSystemException {
        return this.getChildInfos(path.toPath());
    }

    @Override
    public FileItemInfo getFileItemInfo(IRelativeLocation path) throws FileSystemException {
        return this.getFileItemInfo(path.toPath());
    }

    @Override
    public ILocation getRoot() {
        return this.cfaRootLocation;
    }

    @Override
    public ISharingDescriptor getSharingDescriptor(IRelativeLocation sharePath) throws FileSystemException {
        return this.getSharingDescriptor(sharePath.toPath());
    }

    @Override
    public FileItemInfo moveFileItemInfo(IRelativeLocation sourcePath, IRelativeLocation destinationPath) throws FileSystemException {
        return this.moveFileItemInfo(sourcePath.toPath(), destinationPath.toPath());
    }

    @Override
    public FileItemInfo setFileItemInfo(IRelativeLocation path, FileItemInfo itemInfo) throws FileSystemException {
        return this.setFileItemInfo(path.toPath(), itemInfo);
    }

    @Override
    public ISharingDescriptor setSharingDescriptor(IRelativeLocation sharePath, ISharingDescriptor descriptor, IProgressMonitor monitor) throws FileSystemException {
        return this.setSharingDescriptor(sharePath.toPath(), descriptor, monitor);
    }

    @Override
    public Date getLastSandboxListenerEvent() throws FileSystemException {
        Object object = this.metaMetaLock;
        synchronized (object) {
            try {
                this.initMetaMeta();
                return this.metaMeta.getLastSandboxListenerEvent();
            }
            catch (DBHMException e) {
                throw new FileSystemException(Messages.SharingMetadata2_65, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_65, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markSandboxListenerEvent(Date date) throws FileSystemException {
        Object object = this.metaMetaLock;
        synchronized (object) {
            try {
                this.initMetaMeta();
                this.setBusy(this.metaMetaFlag);
                this.metaMeta.markSandboxListenerEvent(date);
                this.saveMetaMetaJob.requestSave();
            }
            catch (DBHMException e) {
                throw new FileSystemException(Messages.SharingMetadata2_66, e);
            }
            catch (IOException e) {
                throw new FileSystemException(Messages.SharingMetadata2_66, e);
            }
        }
    }

    private void initPagingSize() throws FileSystemException {
        String userDefinedPagingSize = System.getProperty("SCM_MAX_METADATA_PAGING_SIZE");
        if (userDefinedPagingSize != null) {
            try {
                this.pagingSize = Math.max(2500, Integer.parseInt(userDefinedPagingSize));
            }
            catch (NumberFormatException e) {
                throw new FileSystemException(Messages.SharingMetadata2_68, e);
            }
        }
    }

    @Override
    public void setPagingSize(int pagingSize) {
        if (System.getProperty("SCM_MAX_METADATA_PAGING_SIZE") == null) {
            this.pagingSize = Math.max(2500, pagingSize);
        }
    }

    @Override
    public int getPagingSize() {
        return this.pagingSize;
    }

    public static class ConnectionComponent
    implements ISharingMetadata.IConnectionComponent {
        private final IContextHandle connectionHandle;
        private final IComponentHandle component;

        public ConnectionComponent(IContextHandle connectionHandle, IComponentHandle component) {
            this.connectionHandle = connectionHandle;
            this.component = component;
        }

        @Override
        public IComponentHandle getComponent() {
            return this.component;
        }

        @Override
        public IContextHandle getConnection() {
            return this.connectionHandle;
        }

        public int hashCode() {
            return this.connectionHandle.getItemId().getUuidValue().hashCode() ^ this.component.getItemId().getUuidValue().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConnectionComponent)) {
                return false;
            }
            ConnectionComponent other = (ConnectionComponent)obj;
            return this.connectionHandle.sameItemId((IItemHandle)other.connectionHandle) && this.component.sameItemId((IItemHandle)other.component);
        }

        public String toString() {
            return "Connection: " + this.connectionHandle.getItemId().toString() + " Component: " + this.component.getItemId().toString();
        }
    }

    class Directory
    extends LockableMap<StringWrapper, FileItemInfo> {
        protected final IPath realPath;
        protected boolean doInit;

        public Directory(IPath path, IPath realPath) {
            super(path, null);
            this.realPath = realPath;
            this.doInit = true;
            this.init(SharingMetadata2.this.getLocation(realPath).append(SharingMetadata2.SCM_ITEM_INFOS).toFile());
        }

        @Override
        protected void init(File f) {
            if (this.doInit) {
                super.init(f);
            }
        }

        @Override
        protected void initEntries() {
            try {
                this.entries = new MetadataStore(SharingMetadata2.this.getLocation(this.getRealPath()).append(SharingMetadata2.SCM_ITEM_INFOS).toFile());
            }
            catch (DBHMException e) {
                SharingMetadata2.this.setCorrupt(e);
                throw e;
            }
        }

        public IPath[] children() {
            File[] childDirs = SharingMetadata2.this.getLocation(this.getRealPath()).toFile().listFiles(DIRECTORY_FILTER);
            if (childDirs == null) {
                return new IPath[0];
            }
            IPath[] childPaths = new IPath[childDirs.length];
            int i = 0;
            while (i < childDirs.length) {
                childPaths[i] = this.getRealPath().append(childDirs[i].getName());
                ++i;
            }
            return childPaths;
        }

        public IPath getRealPath() {
            return this.realPath;
        }
    }

    class InverseMetadataStore
    extends Store<String, Map<ISharingMetadata.IConnectionComponent, InverseFileItemInfo>> {
        private static final int METADATA_VERSION = 1;
        private static final int IS_FOLDER = 1;
        private static final int IS_CONTENT_CHANGED = 2;
        private static final int HAS_PARENT = 4;
        private static final int IS_REMOTE = 8;
        private static final int IS_ORIGINAL_EXECUTABLE = 16;
        private static final int HAS_LINE_DELIMITER = 32;
        private static final int IS_FLAGS_EXTENDED = 32;
        private static final int HAS_CHANGED_PROPERTIES = 64;
        private static final int IS_EXECUTABLE = 128;
        private static final int HAS_PREDECESSOR_HINT_HASH = 256;
        private static final int HAS_ORIGINAL_ENCODING = 512;
        private static final int HAS_ORIGINAL_PROPERTIES = 1024;
        private static final int HAS_LAST_CONTENT_CHANGE_CHECK_STAMP = 2048;
        private static final int HAS_LOCAL_PARENT = 4096;
        private static final int HAS_REMOTE_CHILDREN = 8192;
        private static final int HAS_LOCAL_NAME = 16384;
        private static final int IS_LOADED_WITH_ALTERNATIVE_NAME = 32768;
        private static final int IS_SYMBOLIC_LINK = 2;
        private static final int HAS_REMOVED_PROPERTIES = 4;
        private static final int IS_DIRECTORY_LINK = 8;
        private static final int IS_ORIGINAL_DIRECTORY_LINK = 16;
        private static final int HAS_EXTERNAL_LINKS = 64;
        private static final int HAS_ORIGINAL_EXTERNAL_LINKS = 128;
        private static final byte FILE_TYPE = 1;
        private static final byte FOLDER_TYPE = 2;
        private static final byte LINK_TYPE = 3;

        public InverseMetadataStore(File file) {
            super(file, SharingMetadata2.this.heapMgr);
        }

        protected void writeCustomMetadata(DataOutputStream out) throws IOException {
            super.writeCustomMetadata(out);
            out.writeInt(1);
        }

        protected void readCustomMetadata(DataInputStream in) throws IOException {
            super.readCustomMetadata(in);
            int v = in.readInt();
            if (v != 1) {
                throw new IllegalArgumentException("Metadata version mismatch " + v + " != " + 1);
            }
        }

        protected long persistStream(ByteArrayOutputStream out) throws IOException {
            long offset = this.heap.allocate((long)out.size());
            out.writeTo(this.heap.getOutputStream(offset));
            return offset;
        }

        protected long writeObject(Object o, int flags) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            if ((flags & 1) != 0) {
                dos.writeUTF((String)o);
                return this.persistStream(out);
            }
            Map inverseMap = (Map)o;
            dos.writeInt(inverseMap.size());
            for (Map.Entry e : inverseMap.entrySet()) {
                boolean hasLocalParent;
                boolean hasLocalName;
                boolean hasParent;
                ISharingMetadata.IConnectionComponent component = (ISharingMetadata.IConnectionComponent)e.getKey();
                InverseFileItemInfo info = (InverseFileItemInfo)e.getValue();
                dos.writeUTF(component.getConnection().getItemType().getName());
                dos.writeUTF(component.getConnection().getItemType().getNamespaceURI());
                dos.writeUTF(component.getConnection().getItemId().getUuidValue());
                dos.writeUTF(component.getComponent().getItemId().getUuidValue());
                boolean isRemote = info.getVersionableHandle().hasStateId();
                int fiFlags = isRemote ? 8 : 0;
                int fiFlags2 = 0;
                boolean bl = hasParent = info.getParent() != null;
                if (hasParent) {
                    fiFlags |= 4;
                }
                boolean bl2 = hasLocalName = info.getLocalName() != null;
                if (hasLocalName) {
                    fiFlags |= 0x4000;
                }
                boolean bl3 = hasLocalParent = info.getLocalParent() != null;
                if (hasLocalParent) {
                    fiFlags |= 0x1000;
                }
                if (info.isLoadedWithAnotherName()) {
                    fiFlags |= 0x8000;
                }
                boolean folder = info.isFolder();
                boolean file = info.isFile();
                boolean hasLineDelimiter = false;
                boolean hasPredecessorHintHash = false;
                boolean hasOriginalEncoding = false;
                boolean hasOriginalProperties = false;
                boolean hasChangedProperties = false;
                boolean hasRemovedProperties = false;
                boolean hasOriginalContentProperties = false;
                boolean hasLastContentChangeCheckStamp = false;
                boolean hasRemoteChildren = false;
                if (folder) {
                    fiFlags |= 1;
                    if (!info.getRemoteChildren().isEmpty()) {
                        hasRemoteChildren = true;
                        fiFlags |= 0x2000;
                    }
                } else if (file) {
                    if (info.isContentChanged()) {
                        fiFlags |= 2;
                    }
                    if (info.isOriginalExecutable()) {
                        fiFlags |= 0x10;
                    }
                    if (info.getLineDelimiter() != null) {
                        hasLineDelimiter = true;
                        fiFlags |= 0x20;
                    }
                    if (info.getContentType() != null) {
                        hasChangedProperties = true;
                        fiFlags |= 0x40;
                    }
                    if (isRemote) {
                        hasOriginalProperties = true;
                        fiFlags |= 0x400;
                    }
                    if (info.isExecutable()) {
                        fiFlags |= 0x80;
                    }
                    if (info.getStoredPredecessorHintHash() != null) {
                        hasPredecessorHintHash = true;
                        fiFlags |= 0x100;
                    }
                    if (info.getStoredEncoding() != null) {
                        hasOriginalEncoding = true;
                        fiFlags |= 0x200;
                    }
                    if (info.getStoredNumLineDelimiters() != -1L) {
                        hasOriginalContentProperties = true;
                        fiFlags |= 0x400;
                    }
                    if (info.getLastContentChangeCheckStamp() != -1L) {
                        hasLastContentChangeCheckStamp = true;
                        fiFlags |= 0x800;
                    }
                } else {
                    fiFlags |= 1;
                    fiFlags |= 0x20;
                    fiFlags2 |= 2;
                    if (info.isContentChanged()) {
                        fiFlags |= 2;
                    }
                    if (info.isDirectoryLink()) {
                        fiFlags2 |= 8;
                    }
                    if (info.isOriginalDirectoryLink()) {
                        fiFlags2 |= 0x10;
                    }
                }
                if (!info.getOriginalProperties().isEmpty()) {
                    hasOriginalProperties = true;
                    fiFlags |= 0x400;
                }
                if (!info.getChangedProperties().isEmpty()) {
                    hasChangedProperties = true;
                    fiFlags |= 0x40;
                }
                if (!info.getRemovedProperties().isEmpty()) {
                    hasRemovedProperties = true;
                    if (folder) {
                        fiFlags2 |= 1;
                    }
                    fiFlags |= 1;
                    fiFlags |= 0x20;
                    fiFlags2 |= 4;
                }
                if (info.getExternalLinks() != null) {
                    if (folder) {
                        fiFlags2 |= 1;
                    }
                    fiFlags |= 1;
                    fiFlags |= 0x20;
                    fiFlags2 |= 0x40;
                }
                if (info.getOriginalExternalLinks() != null) {
                    if (folder) {
                        fiFlags2 |= 1;
                    }
                    fiFlags |= 1;
                    fiFlags |= 0x20;
                    fiFlags2 |= 0x80;
                }
                dos.writeShort(fiFlags);
                if ((fiFlags & 1) != 0 && (fiFlags & 0x20) != 0) {
                    dos.writeShort(fiFlags2);
                }
                IVersionableHandle h = info.getVersionableHandle();
                dos.writeUTF(h.getItemId().getUuidValue());
                if (isRemote) {
                    dos.writeUTF(h.getStateId().getUuidValue());
                }
                if (hasParent) {
                    dos.writeUTF(info.getParent().getItemId().getUuidValue());
                    dos.writeUTF(info.getName());
                }
                if (hasLocalName) {
                    dos.writeUTF(info.getLocalName());
                }
                if (hasLocalParent) {
                    dos.writeUTF(info.getLocalParent().getItemId().getUuidValue());
                }
                if (folder) {
                    if (hasRemoteChildren) {
                        if (this.hasLinks(info.getRemoteChildren())) {
                            this.writeRemoteFilesFoldersAndLinks(dos, info.getRemoteChildren());
                        } else {
                            this.writeRemoteFilesAndFolders(dos, info.getRemoteChildren());
                        }
                    }
                    if (hasOriginalProperties) {
                        dos.writeInt(info.getOriginalProperties().size());
                        for (Map.Entry entry : info.getOriginalProperties().entrySet()) {
                            dos.writeUTF((String)entry.getKey());
                            dos.writeUTF((String)entry.getValue());
                        }
                    }
                    if (hasChangedProperties) {
                        dos.writeInt(info.getChangedProperties().size());
                        for (Map.Entry entry : info.getChangedProperties().entrySet()) {
                            dos.writeUTF((String)entry.getKey());
                            dos.writeUTF((String)entry.getValue());
                        }
                    }
                    if (hasRemovedProperties) {
                        dos.writeInt(info.getRemovedProperties().size());
                        for (String string : info.getRemovedProperties()) {
                            dos.writeUTF(string);
                        }
                    }
                } else if (file) {
                    if (hasLineDelimiter) {
                        dos.writeInt(info.getLineDelimiter().dbValue());
                    }
                    if (hasChangedProperties) {
                        if (info.getContentType() != null) {
                            dos.writeInt(1 + info.getChangedProperties().size());
                            dos.writeUTF("contentType");
                            dos.writeUTF(info.getContentType());
                        } else {
                            dos.writeInt(info.getChangedProperties().size());
                        }
                        for (Map.Entry entry : info.getChangedProperties().entrySet()) {
                            dos.writeUTF((String)entry.getKey());
                            dos.writeUTF((String)entry.getValue());
                        }
                    }
                    if (isRemote) {
                        if (hasLastContentChangeCheckStamp) {
                            dos.writeLong(info.getLastContentChangeCheckStamp());
                        }
                        dos.writeUTF(info.getHash().toString());
                        dos.writeLong(info.getContentLength());
                        dos.writeInt(info.getOriginalLineDelimiter().dbValue());
                    }
                    if (hasOriginalProperties) {
                        if (isRemote) {
                            dos.writeInt(1 + info.getOriginalProperties().size());
                            dos.writeUTF("contentType");
                            dos.writeUTF(info.getOriginalContentType());
                        } else {
                            dos.writeInt(info.getOriginalProperties().size());
                        }
                        for (Map.Entry entry : info.getOriginalProperties().entrySet()) {
                            dos.writeUTF((String)entry.getKey());
                            dos.writeUTF((String)entry.getValue());
                        }
                    }
                    if (isRemote) {
                        if (hasPredecessorHintHash) {
                            dos.writeUTF(info.getStoredPredecessorHintHash().toString());
                        }
                        dos.writeLong(info.getStoredSize());
                        if (hasOriginalEncoding) {
                            dos.writeUTF(info.getStoredEncoding());
                        }
                        dos.writeUTF(info.getStoredHash().toString());
                        if (hasOriginalContentProperties) {
                            dos.writeInt(1);
                            dos.writeUTF("numLineDelim");
                            dos.writeUTF(Long.toString(info.getStoredNumLineDelimiters()));
                        } else {
                            dos.writeInt(0);
                        }
                    }
                    if (hasRemovedProperties) {
                        dos.writeInt(info.getRemovedProperties().size());
                        for (String string : info.getRemovedProperties()) {
                            dos.writeUTF(string);
                        }
                    }
                } else {
                    if (isRemote) {
                        String string = info.getHash().toString();
                        dos.writeUTF(string);
                        String storedHashString = info.getStoredHash().toString();
                        dos.writeUTF(storedHashString);
                    }
                    if (hasOriginalProperties) {
                        dos.writeInt(info.getOriginalProperties().size());
                        for (Map.Entry entry : info.getOriginalProperties().entrySet()) {
                            dos.writeUTF((String)entry.getKey());
                            dos.writeUTF((String)entry.getValue());
                        }
                    }
                    if (hasChangedProperties) {
                        dos.writeInt(info.getChangedProperties().size());
                        for (Map.Entry entry : info.getChangedProperties().entrySet()) {
                            dos.writeUTF((String)entry.getKey());
                            dos.writeUTF((String)entry.getValue());
                        }
                    }
                    if (hasRemovedProperties) {
                        dos.writeInt(info.getRemovedProperties().size());
                        for (String string : info.getRemovedProperties()) {
                            dos.writeUTF(string);
                        }
                    }
                }
                if (info.getExternalLinks() != null) {
                    LinkUtils.writeToStream((ExternalLinks)info.getExternalLinks(), (DataOutputStream)dos);
                }
                if (info.getOriginalExternalLinks() == null) continue;
                LinkUtils.writeToStream((ExternalLinks)info.getOriginalExternalLinks(), (DataOutputStream)dos);
            }
            return this.persistStream(out);
        }

        private boolean hasLinks(Map<String, IVersionableHandle> remoteChildren) {
            for (IVersionableHandle child : remoteChildren.values()) {
                if (!(child instanceof ISymbolicLinkHandle)) continue;
                return true;
            }
            return false;
        }

        private void writeRemoteFilesFoldersAndLinks(DataOutputStream dos, Map<String, IVersionableHandle> remoteChildren) throws IOException {
            dos.writeInt(-1);
            dos.writeInt(remoteChildren.size());
            for (Map.Entry<String, IVersionableHandle> childEntry : remoteChildren.entrySet()) {
                String name = childEntry.getKey();
                IVersionableHandle child = childEntry.getValue();
                int itemType = child instanceof IFileItemHandle ? 1 : (child instanceof IFolderHandle ? 2 : (child instanceof ISymbolicLinkHandle ? 3 : 0));
                dos.writeByte(itemType);
                dos.writeUTF(name);
                dos.writeUTF(child.getItemId().getUuidValue());
            }
        }

        private void writeRemoteFilesAndFolders(DataOutputStream dos, Map<String, IVersionableHandle> remoteChildren) throws IOException {
            dos.writeInt(remoteChildren.size());
            Iterator<Map.Entry<String, IVersionableHandle>> entryIt = remoteChildren.entrySet().iterator();
            Iterator<IVersionableHandle> j = remoteChildren.values().iterator();
            while (j.hasNext()) {
                int folderFlags = 0;
                int k = 8;
                while (k != 0 && j.hasNext()) {
                    folderFlags = folderFlags << 1 | (j.next() instanceof IFolderHandle ? 1 : 0);
                    --k;
                }
                dos.writeByte(folderFlags);
                k = 8 - k;
                while (k != 0) {
                    Map.Entry<String, IVersionableHandle> childEntry = entryIt.next();
                    String name = childEntry.getKey();
                    IVersionableHandle child = childEntry.getValue();
                    dos.writeUTF(name);
                    dos.writeUTF(child.getItemId().getUuidValue());
                    --k;
                }
            }
        }

        protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
            DataInputStream dis = new DataInputStream(in);
            if ((flags & 1) != 0) {
                return dis.readUTF();
            }
            int size = dis.readInt();
            LinkedHashMap<ConnectionComponent, InverseFileItemInfo> inverseMap = new LinkedHashMap<ConnectionComponent, InverseFileItemInfo>((int)((float)size / 0.75f));
            int i = size;
            while (i != 0) {
                long storedNumLineDelimiters;
                ContentHash predecessorHintHash;
                String originalEncoding;
                String originalContentType;
                FileLineDelimiter originalLineDelimiter;
                boolean originalExecutable;
                boolean executable;
                String contentType;
                FileLineDelimiter lineDelimiter;
                long lastContentChangeCheckStamp;
                long storedContentSize;
                long contentLength;
                String value;
                String propertyName;
                ContentHash storedHash;
                ContentHash hash;
                boolean originalDirectoryLink;
                boolean directoryLink;
                Map remoteChildren;
                boolean contentChanged;
                ISymbolicLinkHandle v;
                IFolderHandle localParent;
                String localName;
                IFolderHandle parent;
                String name = dis.readUTF();
                String namespace = dis.readUTF();
                IItemType type = IItemType.IRegistry.INSTANCE.getItemType(name, namespace);
                String itemId = dis.readUTF();
                IContextHandle connectionHandle = (IContextHandle)type.createItemHandle(UUID.valueOf((String)itemId), null);
                itemId = dis.readUTF();
                IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null);
                ConnectionComponent key = new ConnectionComponent(connectionHandle, component);
                short fiFlags = dis.readShort();
                short fiFlags2 = (fiFlags & 1) != 0 && (fiFlags & 0x20) != 0 ? dis.readShort() : (short)0;
                boolean isRemote = (fiFlags & 8) != 0;
                boolean hasOriginalProperties = (fiFlags & 0x400) != 0;
                boolean hasChangedProperties = (fiFlags & 0x40) != 0;
                boolean hasRemovedProperties = (fiFlags2 & 4) != 0;
                itemId = dis.readUTF();
                UUID stateId = isRemote ? UUID.valueOf((String)dis.readUTF()) : null;
                if ((fiFlags & 4) != 0) {
                    UUID parentId = UUID.valueOf((String)dis.readUTF());
                    parent = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(parentId, null);
                    name = dis.readUTF();
                } else {
                    parent = null;
                    name = null;
                }
                if ((fiFlags & 0x4000) != 0) {
                    localName = dis.readUTF();
                } else {
                    localParent = null;
                    localName = null;
                }
                if ((fiFlags & 0x1000) != 0) {
                    UUID parentId = UUID.valueOf((String)dis.readUTF());
                    localParent = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(parentId, null);
                } else {
                    localParent = null;
                }
                HashMap<String, String> originalProperties = new HashMap<String, String>();
                HashMap<String, String> changedProperties = new HashMap<String, String>();
                HashSet<String> removedProperties = new HashSet<String>();
                boolean isLoadedWithAlternativeName = (fiFlags & 0x8000) != 0;
                if ((fiFlags2 & 2) != 0) {
                    v = (ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), stateId);
                    contentChanged = (fiFlags & 2) != 0;
                    remoteChildren = Collections.EMPTY_MAP;
                    directoryLink = (fiFlags2 & 8) != 0;
                    boolean bl = originalDirectoryLink = (fiFlags2 & 0x10) != 0;
                    if (isRemote) {
                        String hashString = dis.readUTF();
                        hash = ContentHash.valueOf((String)hashString);
                        String storedHashString = dis.readUTF();
                        storedHash = ContentHash.valueOf((String)storedHashString);
                    } else {
                        hash = null;
                        storedHash = null;
                    }
                    if (hasOriginalProperties) {
                        int count = dis.readInt();
                        int j = 0;
                        while (j < count) {
                            propertyName = dis.readUTF();
                            value = dis.readUTF();
                            originalProperties.put(propertyName, value);
                            ++j;
                        }
                    }
                    if (hasChangedProperties) {
                        int count = dis.readInt();
                        int j = 0;
                        while (j < count) {
                            propertyName = dis.readUTF();
                            value = dis.readUTF();
                            changedProperties.put(propertyName, value);
                            ++j;
                        }
                    }
                    if (hasRemovedProperties) {
                        int count = dis.readInt();
                        int j = 0;
                        while (j < count) {
                            propertyName = dis.readUTF();
                            removedProperties.add(propertyName);
                            ++j;
                        }
                    }
                    contentLength = -1L;
                    storedContentSize = -1L;
                    lastContentChangeCheckStamp = -1L;
                    lineDelimiter = null;
                    contentType = null;
                    executable = false;
                    originalExecutable = false;
                    originalLineDelimiter = null;
                    originalContentType = null;
                    originalEncoding = null;
                    predecessorHintHash = null;
                    storedNumLineDelimiters = -1L;
                } else if ((fiFlags & 1) != 0 && (fiFlags & 0x20) == 0 || (fiFlags2 & 1) != 0) {
                    v = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), stateId);
                    contentChanged = false;
                    lastContentChangeCheckStamp = -1L;
                    hash = null;
                    contentLength = -1L;
                    storedContentSize = -1L;
                    storedHash = null;
                    if ((fiFlags & 0x2000) != 0) {
                        int numChildren = dis.readInt();
                        if (numChildren == -1) {
                            numChildren = dis.readInt();
                            remoteChildren = this.readRemoteFilesFoldersAndLinks(dis, numChildren);
                        } else {
                            remoteChildren = this.readRemoteFilesAndFolders(dis, numChildren);
                        }
                    } else {
                        remoteChildren = Collections.EMPTY_MAP;
                    }
                    if (hasOriginalProperties) {
                        int count = dis.readInt();
                        int j = 0;
                        while (j < count) {
                            propertyName = dis.readUTF();
                            value = dis.readUTF();
                            originalProperties.put(propertyName, value);
                            ++j;
                        }
                    }
                    if (hasChangedProperties) {
                        int count = dis.readInt();
                        int j = 0;
                        while (j < count) {
                            propertyName = dis.readUTF();
                            value = dis.readUTF();
                            changedProperties.put(propertyName, value);
                            ++j;
                        }
                    }
                    if (hasRemovedProperties) {
                        int count = dis.readInt();
                        int j = 0;
                        while (j < count) {
                            propertyName = dis.readUTF();
                            removedProperties.add(propertyName);
                            ++j;
                        }
                    }
                    lineDelimiter = null;
                    contentType = null;
                    executable = false;
                    originalExecutable = false;
                    directoryLink = false;
                    originalDirectoryLink = false;
                    originalLineDelimiter = null;
                    originalContentType = null;
                    originalEncoding = null;
                    predecessorHintHash = null;
                    storedNumLineDelimiters = -1L;
                } else {
                    String propertyValue;
                    v = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), stateId);
                    contentChanged = (fiFlags & 2) != 0;
                    executable = (fiFlags & 0x80) != 0;
                    originalExecutable = (fiFlags & 0x10) != 0;
                    directoryLink = false;
                    originalDirectoryLink = false;
                    lineDelimiter = (fiFlags & 0x20) != 0 ? FileLineDelimiter.getLineDelimiter((int)dis.readInt()) : null;
                    contentType = null;
                    if ((fiFlags & 0x40) != 0) {
                        int numFileItemProperties = dis.readInt();
                        int j = 0;
                        while (j < numFileItemProperties) {
                            propertyName = dis.readUTF();
                            propertyValue = dis.readUTF();
                            if (propertyName.equals("contentType")) {
                                contentType = propertyValue;
                            } else {
                                changedProperties.put(propertyName, propertyValue);
                            }
                            ++j;
                        }
                    }
                    remoteChildren = Collections.EMPTY_MAP;
                    if (isRemote) {
                        lastContentChangeCheckStamp = (fiFlags & 0x800) != 0 ? dis.readLong() : -1L;
                        hash = ContentHash.valueOf((String)dis.readUTF());
                        contentLength = dis.readLong();
                        originalLineDelimiter = FileLineDelimiter.getLineDelimiter((int)dis.readInt());
                    } else {
                        lastContentChangeCheckStamp = -1L;
                        hash = null;
                        contentLength = -1L;
                        originalLineDelimiter = null;
                    }
                    originalContentType = null;
                    if ((fiFlags & 0x400) != 0) {
                        int numFileItemProperties = dis.readInt();
                        int j = 0;
                        while (j < numFileItemProperties) {
                            propertyName = dis.readUTF();
                            propertyValue = dis.readUTF();
                            if (propertyName.equals("contentType")) {
                                originalContentType = propertyValue;
                            } else {
                                originalProperties.put(propertyName, propertyValue);
                            }
                            ++j;
                        }
                    }
                    if (isRemote) {
                        predecessorHintHash = (fiFlags & 0x100) != 0 ? ContentHash.valueOf((String)dis.readUTF()) : null;
                        storedContentSize = dis.readLong();
                        originalEncoding = (fiFlags & 0x200) != 0 ? dis.readUTF() : null;
                        storedHash = ContentHash.valueOf((String)dis.readUTF());
                        storedNumLineDelimiters = -1L;
                        int originalContentPropertiesSize = dis.readInt();
                        int j = 0;
                        while (j < originalContentPropertiesSize) {
                            propertyName = dis.readUTF();
                            propertyValue = dis.readUTF();
                            if (propertyName.equals("numLineDelim")) {
                                storedNumLineDelimiters = Long.parseLong(propertyValue);
                            }
                            ++j;
                        }
                    } else {
                        predecessorHintHash = null;
                        storedContentSize = -1L;
                        originalEncoding = null;
                        storedHash = null;
                        storedNumLineDelimiters = -1L;
                    }
                    if (hasRemovedProperties) {
                        int count = dis.readInt();
                        int j = 0;
                        while (j < count) {
                            propertyName = dis.readUTF();
                            removedProperties.add(propertyName);
                            ++j;
                        }
                    }
                }
                ExternalLinks externalLinks = null;
                if ((fiFlags2 & 0x40) != 0) {
                    externalLinks = ExternalLinks.createFromStream((DataInputStream)dis);
                }
                ExternalLinks originalExternalLinks = null;
                if ((fiFlags2 & 0x80) != 0) {
                    originalExternalLinks = ExternalLinks.createFromStream((DataInputStream)dis);
                }
                InverseFileItemInfo value2 = new InverseFileItemInfo((IVersionableHandle)v, contentChanged, lastContentChangeCheckStamp, parent, name, isLoadedWithAlternativeName, remoteChildren, localParent, localName, hash, contentLength, originalLineDelimiter, lineDelimiter, originalContentType, contentType, predecessorHintHash, storedContentSize, originalEncoding, storedHash, storedNumLineDelimiters, executable, originalExecutable, directoryLink, originalDirectoryLink, originalProperties, removedProperties, changedProperties, externalLinks, originalExternalLinks);
                inverseMap.put(key, value2);
                --i;
            }
            return Collections.unmodifiableMap(inverseMap);
        }

        private Map<String, IVersionableHandle> readRemoteFilesAndFolders(DataInputStream dis, int numChildren) throws IOException {
            LinkedHashMap<String, IVersionableHandle> remoteChildren = new LinkedHashMap((int)((double)numChildren / 0.75));
            while (numChildren != 0) {
                int folderFlags = dis.readUnsignedByte();
                int mask = 1 << Math.min(numChildren - 1, 7);
                while (mask != 0) {
                    String childName = dis.readUTF();
                    IItemType childType = (folderFlags & mask) == 0 ? IFileItem.ITEM_TYPE : IFolder.ITEM_TYPE;
                    IVersionableHandle childHandle = (IVersionableHandle)childType.createItemHandle(UUID.valueOf((String)dis.readUTF()), null);
                    remoteChildren.put(childName, childHandle);
                    --numChildren;
                    mask >>= 1;
                }
            }
            remoteChildren = Collections.unmodifiableMap(remoteChildren);
            return remoteChildren;
        }

        private Map<String, IVersionableHandle> readRemoteFilesFoldersAndLinks(DataInputStream dis, int numChildren) throws IOException {
            LinkedHashMap<String, IVersionableHandle> remoteChildren = new LinkedHashMap((int)((double)numChildren / 0.75));
            while (numChildren != 0) {
                IItemType childType;
                int typeFlag = dis.readUnsignedByte();
                switch (typeFlag) {
                    case 1: {
                        childType = IFileItem.ITEM_TYPE;
                        break;
                    }
                    case 2: {
                        childType = IFolder.ITEM_TYPE;
                        break;
                    }
                    case 3: {
                        childType = ISymbolicLink.ITEM_TYPE;
                        break;
                    }
                    default: {
                        childType = IFileItem.ITEM_TYPE;
                    }
                }
                String childName = dis.readUTF();
                IVersionableHandle childHandle = (IVersionableHandle)childType.createItemHandle(UUID.valueOf((String)dis.readUTF()), null);
                remoteChildren.put(childName, childHandle);
                --numChildren;
            }
            remoteChildren = Collections.unmodifiableMap(remoteChildren);
            return remoteChildren;
        }
    }

    static class InverseSharingDescriptorMap
    extends PersistentDiskBackedHashMap<ShareRoot, IPath> {
        private static final int METADATA_VERSION = 1;
        IRelativeLocation[] sharesCache;

        public InverseSharingDescriptorMap(File file) {
            this(file, 2500);
        }

        public InverseSharingDescriptorMap(File file, int pagingSize) {
            super(17L, 0.75, pagingSize, file);
        }

        protected long writeObject(Object o, int flags) throws IOException {
            if ((flags & 1) != 0) {
                return super.writeObject(o, flags);
            }
            return super.writeObject((Object)((IPath)o).toOSString(), flags);
        }

        protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
            if ((flags & 1) != 0) {
                return new ObjectInputStream(in).readObject();
            }
            return new Path((String)super.readObject(in, flags));
        }

        protected void writeCustomMetadata(DataOutputStream out) throws IOException {
            super.writeCustomMetadata(out);
            out.writeInt(1);
        }

        protected void readCustomMetadata(DataInputStream in) throws IOException {
            super.readCustomMetadata(in);
            try {
                int v = in.readInt();
                if (v != 1) {
                    throw new IllegalArgumentException("Metadata version mismatch " + v + " != " + 1);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }

        public synchronized IRelativeLocation[] allShares(boolean isCaseSensitive) {
            if (this.sharesCache != null) {
                return this.sharesCache;
            }
            Collection paths = this.values();
            IRelativeLocation[] result = new IRelativeLocation[this.size()];
            int i = 0;
            for (IPath path : paths) {
                result[i] = isCaseSensitive ? new RelativeLocation(path.segments()) : new RelativeLocationWithCF(path.segments());
                ++i;
            }
            this.sharesCache = result;
            return result;
        }

        public synchronized IPath put(ShareRoot key, IPath value) {
            this.sharesCache = null;
            return (IPath)super.put((Object)key, (Object)value);
        }

        public synchronized void close() throws IOException {
            this.sharesCache = null;
            super.close();
        }

        public synchronized IPath remove(Object key) {
            this.sharesCache = null;
            return (IPath)super.remove(key);
        }
    }

    class MetadataDiskBackedMapManager
    extends DiskBackedMapManager<StringWrapper, FileItemInfo> {
        public MetadataDiskBackedMapManager(ReadWriteLock lock, PersistentBusyFlag busyFlag) {
            super(lock, busyFlag, SharingMetadata2.this);
        }

        @Override
        protected LockableMap<StringWrapper, FileItemInfo> getLockableMap(IPath path, IPath realPath) {
            return new Directory(path, realPath);
        }

        public void closeAll(IPath basePath) throws FileSystemException {
            basePath = SharingMetadata2.this.getCanonicalPath(basePath, true);
            Assert.isTrue((this.lock.threadWrites() > 0 ? 1 : 0) != 0);
            MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.SharingMetadata2_4, null);
            Iterator i = this.inUse.values().iterator();
            while (i.hasNext()) {
                LockableMap current = (LockableMap)i.next();
                if (!basePath.isPrefixOf(current.getPath())) continue;
                try {
                    i.remove();
                    current.close();
                }
                catch (DBHMException e) {
                    SharingMetadata2.this.setCorrupt(true, "Corruption detected on " + basePath, e);
                    result.add(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_5, (Object)current.getPath(), (Object[])new Object[0]), e));
                }
                catch (IOException e) {
                    result.add(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.SharingMetadata2_6, (Object)current.getPath(), (Object[])new Object[0]), e));
                }
                this.lockedExclusively.remove(current.getPath());
            }
            if (this.lockedExclusively.isEmpty()) {
                this.getSaveJob().getBusyFlag().setComplete(result);
            }
            if (!result.isOK()) {
                throw new FileSystemStatusException((IStatus)result);
            }
        }
    }

    class MetadataStore
    extends Store<StringWrapper, FileItemInfo> {
        private static final int METADATA_VERSION = 1;
        private static final int IS_FOLDER = 1;
        private static final int IS_CONTENT_CHANGED = 2;
        private static final int HAS_PARENT = 4;
        private static final int IS_REMOTE = 8;
        private static final int IS_ORIGINAL_EXECUTABLE = 16;
        private static final int HAS_LINE_DELIMITER = 32;
        private static final int HAS_CURRENT_PROPERTIES = 64;
        private static final int IS_EXECUTABLE = 128;
        private static final int HAS_PREDECESSOR_HINT_HASH = 256;
        private static final int HAS_ORIGINAL_ENCODING = 512;
        private static final int HAS_ORIGINAL_PROPERTIES = 1024;
        private static final int HAS_LAST_CONTENT_CHANGE_CHECK_STAMP = 2048;
        private static final int IS_LOADED_WITH_ANOTHER_NAME = 4096;
        private static final int IS_SYMBOLIC_LINK = 8192;
        private static final int IS_DIRECTORY_LINK = 16384;
        private static final int IS_FLAGS_EXTENDED = 32768;
        private static final int IS_ORIGINAL_DIRECTORY_LINK = 1;
        private static final int HAS_EXTERNAL_LINKS = 2;
        private static final int HAS_ORIGINAL_EXTERNAL_LINKS = 4;

        public MetadataStore(File file) {
            super(file, SharingMetadata2.this.heapMgr);
        }

        protected void writeCustomMetadata(DataOutputStream out) throws IOException {
            super.writeCustomMetadata(out);
            out.writeInt(1);
        }

        protected void readCustomMetadata(DataInputStream in) throws IOException {
            super.readCustomMetadata(in);
            int v = in.readInt();
            if (v != 1) {
                throw new IllegalArgumentException("Metadata version mismatch " + v + " != " + 1);
            }
        }

        protected long persistStream(ByteArrayOutputStream out) throws IOException {
            long offset = this.heap.allocate((long)out.size());
            out.writeTo(this.heap.getOutputStream(offset));
            return offset;
        }

        protected long writeObject(Object o, int flags) throws IOException {
            boolean hasParent;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            if ((flags & 1) != 0) {
                dos.writeUTF(o.toString());
                return this.persistStream(out);
            }
            FileItemInfo info = (FileItemInfo)o;
            boolean isRemote = info.getVersionableHandle().hasStateId();
            int fiFlags = isRemote ? 8 : 0;
            int fiFlags2 = 0;
            boolean bl = hasParent = info.getParent() != null;
            if (hasParent) {
                fiFlags |= 4;
            }
            boolean folder = info.isFolder();
            boolean file = info.isFile();
            boolean hasLineDelimiter = false;
            boolean hasContentType = false;
            boolean hasPredecessorHintHash = false;
            boolean hasOriginalEncoding = false;
            boolean hasOriginalContentProperties = false;
            boolean hasLastContentChangeCheckStamp = false;
            if (folder) {
                fiFlags |= 1;
            } else if (file) {
                if (info.isContentChanged()) {
                    fiFlags |= 2;
                }
                if (info.isOriginalExecutable()) {
                    fiFlags |= 0x10;
                }
                if (info.getLineDelimiter() != null) {
                    hasLineDelimiter = true;
                    fiFlags |= 0x20;
                }
                if (info.getContentType() != null) {
                    hasContentType = true;
                    fiFlags |= 0x40;
                }
                if (isRemote) {
                    fiFlags |= 0x400;
                }
                if (info.isExecutable()) {
                    fiFlags |= 0x80;
                }
                if (info.getStoredPredecessorHintHash() != null) {
                    hasPredecessorHintHash = true;
                    fiFlags |= 0x100;
                }
                if (info.getStoredEncoding() != null) {
                    hasOriginalEncoding = true;
                    fiFlags |= 0x200;
                }
                if (info.getStoredNumLineDelimiters() != -1L) {
                    hasOriginalContentProperties = true;
                }
                if (info.getLastContentChangeCheckStamp() != -1L) {
                    hasLastContentChangeCheckStamp = true;
                    fiFlags |= 0x800;
                }
            } else {
                fiFlags |= 0x2000;
                if (info.isContentChanged()) {
                    fiFlags |= 2;
                }
                if (info.isDirectoryLink()) {
                    fiFlags |= 0x4000;
                }
                if (info.isOriginalDirectoryLink()) {
                    fiFlags |= 0x8000;
                    fiFlags2 |= 1;
                }
            }
            if (info.isLoadedWithAnotherName()) {
                fiFlags |= 0x1000;
            }
            if (info.getExternalLinks() != null) {
                fiFlags |= 0x8000;
                fiFlags2 |= 2;
            }
            if (info.getOriginalExternalLinks() != null) {
                fiFlags |= 0x8000;
                fiFlags2 |= 4;
            }
            dos.writeShort(fiFlags);
            if ((fiFlags & 0x8000) != 0) {
                dos.writeShort(fiFlags2);
            }
            IVersionableHandle h = info.getVersionableHandle();
            dos.writeUTF(h.getItemId().getUuidValue());
            if (isRemote) {
                dos.writeUTF(h.getStateId().getUuidValue());
            }
            if (hasParent) {
                dos.writeUTF(info.getParent().getItemId().getUuidValue());
                dos.writeUTF(info.getName());
            }
            if (file) {
                if (hasLineDelimiter) {
                    dos.writeInt(info.getLineDelimiter().dbValue());
                }
                if (hasContentType) {
                    dos.writeInt(1);
                    dos.writeUTF("contentType");
                    dos.writeUTF(info.getContentType());
                } else {
                    dos.writeInt(0);
                }
                if (isRemote) {
                    if (hasLastContentChangeCheckStamp) {
                        dos.writeLong(info.getLastContentChangeCheckStamp());
                    }
                    dos.writeUTF(info.getHash().toString());
                    dos.writeLong(info.getContentLength());
                    dos.writeInt(info.getOriginalLineDelimiter().dbValue());
                    dos.writeInt(1);
                    dos.writeUTF("contentType");
                    dos.writeUTF(info.getOriginalContentType());
                    if (hasPredecessorHintHash) {
                        dos.writeUTF(info.getStoredPredecessorHintHash().toString());
                    }
                    dos.writeLong(info.getStoredSize());
                    if (hasOriginalEncoding) {
                        dos.writeUTF(info.getStoredEncoding());
                    }
                    dos.writeUTF(info.getStoredHash().toString());
                    if (hasOriginalContentProperties) {
                        dos.writeInt(1);
                        dos.writeUTF("numLineDelim");
                        dos.writeUTF(Long.toString(info.getStoredNumLineDelimiters()));
                    } else {
                        dos.writeInt(0);
                    }
                }
            } else if (!folder && isRemote) {
                String hashString = info.getHash().toString();
                dos.writeUTF(hashString);
                String storedHashString = info.getStoredHash().toString();
                dos.writeUTF(storedHashString);
            }
            if (info.getExternalLinks() != null) {
                LinkUtils.writeToStream((ExternalLinks)info.getExternalLinks(), (DataOutputStream)dos);
            }
            if (info.getOriginalExternalLinks() != null) {
                LinkUtils.writeToStream((ExternalLinks)info.getOriginalExternalLinks(), (DataOutputStream)dos);
            }
            return this.persistStream(out);
        }

        protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
            long storedNumLineDelimiters;
            String originalEncoding;
            ContentHash predecessorHintHash;
            String originalContentType;
            FileLineDelimiter originalLineDelimiter;
            long contentLength;
            boolean originalExecutable;
            boolean executable;
            String contentType;
            FileLineDelimiter lineDelimiter;
            long lastContentChangeCheckStamp;
            long storedContentSize;
            ContentHash storedHash;
            ContentHash hash;
            boolean originalDirectoryLink;
            boolean directoryLink;
            boolean contentChanged;
            ISymbolicLinkHandle v;
            String name;
            IFolderHandle parent;
            DataInputStream dis = new DataInputStream(in);
            if ((flags & 1) != 0) {
                return new StringWrapper(dis.readUTF(), SharingMetadata2.this.isCaseSensitive);
            }
            short fiFlags = dis.readShort();
            short fiFlags2 = (fiFlags & 0x8000) != 0 ? dis.readShort() : (short)0;
            boolean isRemote = (fiFlags & 8) != 0;
            UUID itemId = UUID.valueOf((String)dis.readUTF());
            UUID stateId = isRemote ? UUID.valueOf((String)dis.readUTF()) : null;
            if ((fiFlags & 4) != 0) {
                UUID parentId = UUID.valueOf((String)dis.readUTF());
                parent = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(parentId, null);
                name = dis.readUTF();
            } else {
                parent = null;
                name = null;
            }
            boolean loadedWithAnotherName = (fiFlags & 0x1000) != 0;
            if ((fiFlags & 0x2000) != 0) {
                v = (ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle(itemId, stateId);
                contentChanged = (fiFlags & 2) != 0;
                directoryLink = (fiFlags & 0x4000) != 0;
                boolean bl = originalDirectoryLink = (fiFlags2 & 1) != 0;
                if (isRemote) {
                    String hashString = dis.readUTF();
                    hash = ContentHash.valueOf((String)hashString);
                    String storedHashString = dis.readUTF();
                    storedHash = ContentHash.valueOf((String)storedHashString);
                } else {
                    contentChanged = false;
                    hash = null;
                    storedHash = null;
                }
                storedContentSize = -1L;
                lastContentChangeCheckStamp = -1L;
                lineDelimiter = null;
                contentType = null;
                executable = false;
                originalExecutable = false;
                contentLength = -1L;
                originalLineDelimiter = null;
                originalContentType = null;
                predecessorHintHash = null;
                originalEncoding = null;
                storedNumLineDelimiters = -1L;
            } else if ((fiFlags & 1) != 0) {
                v = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(itemId, stateId);
                contentChanged = false;
                lastContentChangeCheckStamp = -1L;
                hash = null;
                storedContentSize = -1L;
                storedHash = null;
                lineDelimiter = null;
                contentType = null;
                executable = false;
                originalExecutable = false;
                directoryLink = false;
                originalDirectoryLink = false;
                contentLength = -1L;
                originalLineDelimiter = null;
                originalContentType = null;
                predecessorHintHash = null;
                originalEncoding = null;
                storedNumLineDelimiters = -1L;
            } else {
                String propertyValue;
                String propertyName;
                int i;
                int numFileItemProperties;
                v = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(itemId, stateId);
                contentChanged = (fiFlags & 2) != 0;
                executable = (fiFlags & 0x80) != 0;
                originalExecutable = (fiFlags & 0x10) != 0;
                directoryLink = false;
                originalDirectoryLink = false;
                lineDelimiter = (fiFlags & 0x20) != 0 ? FileLineDelimiter.getLineDelimiter((int)dis.readInt()) : null;
                contentType = null;
                if ((fiFlags & 0x40) != 0) {
                    numFileItemProperties = dis.readInt();
                    i = 0;
                    while (i < numFileItemProperties) {
                        propertyName = dis.readUTF();
                        propertyValue = dis.readUTF();
                        if (propertyName.equals("contentType")) {
                            contentType = propertyValue;
                        }
                        ++i;
                    }
                } else {
                    dis.readInt();
                }
                if (isRemote) {
                    lastContentChangeCheckStamp = (fiFlags & 0x800) != 0 ? dis.readLong() : -1L;
                    hash = ContentHash.valueOf((String)dis.readUTF());
                    contentLength = dis.readLong();
                    originalLineDelimiter = FileLineDelimiter.getLineDelimiter((int)dis.readInt());
                    originalContentType = null;
                    if ((fiFlags & 0x400) != 0) {
                        numFileItemProperties = dis.readInt();
                        i = 0;
                        while (i < numFileItemProperties) {
                            propertyName = dis.readUTF();
                            propertyValue = dis.readUTF();
                            if (propertyName.equals("contentType")) {
                                originalContentType = propertyValue;
                            }
                            ++i;
                        }
                    }
                    predecessorHintHash = (fiFlags & 0x100) != 0 ? ContentHash.valueOf((String)dis.readUTF()) : null;
                    storedContentSize = dis.readLong();
                    originalEncoding = (fiFlags & 0x200) != 0 ? dis.readUTF() : null;
                    storedHash = ContentHash.valueOf((String)dis.readUTF());
                    storedNumLineDelimiters = -1L;
                    int originalContentPropertiesSize = dis.readInt();
                    i = 0;
                    while (i < originalContentPropertiesSize) {
                        propertyName = dis.readUTF();
                        propertyValue = dis.readUTF();
                        if (propertyName.equals("numLineDelim")) {
                            storedNumLineDelimiters = Long.parseLong(propertyValue);
                        }
                        ++i;
                    }
                } else {
                    lastContentChangeCheckStamp = -1L;
                    hash = null;
                    contentLength = -1L;
                    originalLineDelimiter = null;
                    originalContentType = null;
                    predecessorHintHash = null;
                    storedContentSize = -1L;
                    originalEncoding = null;
                    storedHash = null;
                    storedNumLineDelimiters = -1L;
                }
            }
            ExternalLinks externalLinks = null;
            if ((fiFlags2 & 2) != 0) {
                externalLinks = ExternalLinks.createFromStream((DataInputStream)dis);
            }
            ExternalLinks originalExternalLinks = null;
            if ((fiFlags2 & 4) != 0) {
                originalExternalLinks = ExternalLinks.createFromStream((DataInputStream)dis);
            }
            return new FileItemInfo((IVersionableHandle)v, contentChanged, lastContentChangeCheckStamp, parent, name, loadedWithAnotherName, hash, contentLength, originalLineDelimiter, lineDelimiter, originalContentType, contentType, predecessorHintHash, storedContentSize, originalEncoding, storedHash, storedNumLineDelimiters, executable, originalExecutable, directoryLink, originalDirectoryLink, externalLinks, originalExternalLinks);
        }
    }

    static class RelativeLocationWithCF
    extends RelativeLocation {
        private static final long serialVersionUID = -5816281151597283137L;
        IRelativeLocation canonicalForm;

        public RelativeLocationWithCF(String[] locationParts) {
            super(locationParts);
        }

        @Override
        public IRelativeLocation getCanonicalForm(boolean isCaseSensitive, boolean convertCase) {
            if (isCaseSensitive || !convertCase || this.isEmpty()) {
                return this;
            }
            if (this.canonicalForm == null) {
                this.canonicalForm = super.getCanonicalForm(isCaseSensitive, convertCase);
            }
            return this.canonicalForm;
        }
    }

    public static class ShareRoot
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static int METADATA_VERSION = 0;
        private static final byte FILE = 0;
        private static final byte FOLDER = 1;
        private static final byte LINK = 2;
        private transient IVersionableHandle root;
        private transient ConnectionComponent cc;

        public ShareRoot(IVersionableHandle root, IComponentHandle component, IContextHandle connection) {
            if (root == null) {
                throw new IllegalArgumentException();
            }
            this.cc = new ConnectionComponent(connection, component);
            this.root = root;
        }

        public IVersionableHandle getRootVersionable() {
            return this.root;
        }

        public ConnectionComponent getConnectionComponent() {
            return this.cc;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ShareRoot)) {
                return false;
            }
            ShareRoot other = (ShareRoot)obj;
            return this.root.sameItemId((IItemHandle)other.root) && other.cc.equals(this.cc);
        }

        public int hashCode() {
            return this.root.getItemId().hashCode() ^ this.cc.hashCode();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(METADATA_VERSION);
            out.writeUTF(ItemHandleHelper.toString((IItemHandle)this.cc.getComponent()));
            out.writeBoolean(this.cc.getConnection().getItemType() == IBaseline.ITEM_TYPE);
            out.writeUTF(ItemHandleHelper.toString((IItemHandle)this.cc.getConnection()));
            if (this.root instanceof IFileItemHandle) {
                out.writeByte(0);
            } else if (this.root instanceof IFolderHandle) {
                out.writeByte(1);
            } else if (this.root instanceof ISymbolicLinkHandle) {
                out.writeByte(2);
            } else {
                throw new IllegalStateException();
            }
            out.writeUTF(ItemHandleHelper.toString((IItemHandle)this.root));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            if (version != METADATA_VERSION) {
                throw new ClassNotFoundException(NLS.bind((String)Messages.SharingDescriptor_0, (Object[])new Object[]{version, METADATA_VERSION}, (Object[])new Object[0]));
            }
            IComponentHandle component = (IComponentHandle)ItemHandleHelper.fromString(IComponent.ITEM_TYPE, in.readUTF());
            IItemType connectionType = in.readBoolean() ? IBaseline.ITEM_TYPE : IWorkspace.ITEM_TYPE;
            IContextHandle connectionHandle = (IContextHandle)ItemHandleHelper.fromString(connectionType, in.readUTF());
            this.cc = new ConnectionComponent(connectionHandle, component);
            byte type = in.readByte();
            if (type == 0) {
                this.root = (IVersionableHandle)ItemHandleHelper.fromString(IFileItem.ITEM_TYPE, in.readUTF());
            } else if (type == 1) {
                this.root = (IVersionableHandle)ItemHandleHelper.fromString(IFolder.ITEM_TYPE, in.readUTF());
            } else if (type == 2) {
                this.root = (IVersionableHandle)ItemHandleHelper.fromString(ISymbolicLink.ITEM_TYPE, in.readUTF());
            }
        }

        public String toString() {
            return "Versionable: " + this.root.getItemId().toString() + "(" + this.root.getItemType().getName() + ") " + this.cc.toString();
        }
    }
}

