/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.core;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.FileSystemCoreActivator;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class MetadataUpdateJob
extends Job {
    private static final long MAX_LOCK_TIME = 500L;
    private static final long SCHEDULING_DELAY = 200L;
    private static final Log log = LoggingHelper.getLog(MetadataUpdateJob.class);
    private static MetadataUpdateJob instance;
    private final Map<ILocation, Map<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>> updates = new HashMap<ILocation, Map<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>>();
    private boolean workspaceReady = false;
    private ThreadLocal<Boolean> updating = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    private static boolean isDebugEnabled() {
        return log != null && log.isDebugEnabled();
    }

    private static boolean isTraceEnabled() {
        return log != null && log.isTraceEnabled();
    }

    private static void trace(String message, Throwable e) {
        if (log != null) {
            log.trace((Object)message, e);
        }
    }

    private static void debug(String message) {
        if (log != null) {
            log.debug((Object)message);
        }
    }

    private static synchronized MetadataUpdateJob getInstance() {
        if (instance == null) {
            instance = new MetadataUpdateJob();
            instance.setSystem(true);
        }
        return instance;
    }

    public static void queueUpdate(ManagedFileStore managedFileStore, boolean updateChildren) {
        if (MetadataUpdateJob.isTraceEnabled()) {
            String message = "Request to update metadata for " + managedFileStore.getCfaPath().append(managedFileStore.getLocalPath()).toOSString();
            if (updateChildren) {
                message = String.valueOf(message) + " including children";
            }
            Exception exception = new Exception("Metadata Update Queued");
            exception.fillInStackTrace();
            exception.printStackTrace();
            MetadataUpdateJob.trace(message, exception);
        }
        MetadataUpdateJob.getInstance().queue(new UpdateRequest(managedFileStore, updateChildren));
    }

    public MetadataUpdateJob() {
        super(Messages.MetadataUpdateJob_JobName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(UpdateRequest updateRequest) {
        Map<ILocation, Map<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>> map = this.updates;
        synchronized (map) {
            if (!this.updating.get().booleanValue()) {
                IRelativeLocation localPath;
                UpdateRequest existingRequest;
                IRelativeLocation sharePath;
                ILocation cfaPath = updateRequest.getCfaPath();
                Map<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>> cfaUpdates = this.updates.get(cfaPath);
                if (cfaUpdates == null) {
                    cfaUpdates = new HashMap<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>();
                    this.updates.put(cfaPath, cfaUpdates);
                }
                if ((sharePath = updateRequest.getLockPath()) == null) {
                    return;
                }
                TreeMap<IRelativeLocation, UpdateRequest> shareUpdates = cfaUpdates.get(sharePath);
                if (shareUpdates == null) {
                    shareUpdates = new TreeMap(new Comparator<IRelativeLocation>(){

                        @Override
                        public int compare(IRelativeLocation path1, IRelativeLocation path2) {
                            int segments = Math.min(path1.segmentCount(), path2.segmentCount());
                            int i = 0;
                            while (i < segments) {
                                int c = path1.segment(i).compareTo(path2.segment(i));
                                if (c != 0) {
                                    return c;
                                }
                                ++i;
                            }
                            return path1.segmentCount() - path2.segmentCount();
                        }
                    });
                    cfaUpdates.put(sharePath, shareUpdates);
                }
                if ((existingRequest = shareUpdates.get(localPath = updateRequest.getLocalPath())) == null) {
                    shareUpdates.put(localPath, updateRequest);
                } else {
                    shareUpdates.put(localPath, updateRequest.combine(existingRequest));
                }
            }
        }
        this.schedule(200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requeue(ILocation cfaPath, IRelativeLocation lockPath, TreeMap<IRelativeLocation, UpdateRequest> skippedUpdates) {
        Map<ILocation, Map<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>> map = this.updates;
        synchronized (map) {
            IRelativeLocation sharePath;
            TreeMap<IRelativeLocation, UpdateRequest> shareUpdates;
            Map<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>> cfaUpdates = this.updates.get(cfaPath);
            if (cfaUpdates == null) {
                cfaUpdates = new HashMap<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>();
                this.updates.put(cfaPath, cfaUpdates);
            }
            if ((shareUpdates = cfaUpdates.get(sharePath = lockPath)) == null) {
                cfaUpdates.put(sharePath, skippedUpdates);
            } else {
                for (UpdateRequest updateRequest : skippedUpdates.values()) {
                    IRelativeLocation localPath = updateRequest.getLocalPath();
                    UpdateRequest existingRequest = shareUpdates.get(localPath);
                    if (existingRequest == null) {
                        shareUpdates.put(localPath, updateRequest);
                        continue;
                    }
                    shareUpdates.put(localPath, updateRequest.combine(existingRequest));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRun() {
        Map<ILocation, Map<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>> map = this.updates;
        synchronized (map) {
            return !this.updates.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.isWorkspaceReady()) {
            this.schedule(2000L);
            return Status.OK_STATUS;
        }
        while (true) {
            TreeMap<IRelativeLocation, UpdateRequest> next = null;
            ILocation cfaPath = null;
            IRelativeLocation lockPath = null;
            Map<ILocation, Map<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>> map = this.updates;
            synchronized (map) {
                if (this.updates.isEmpty()) {
                    if (!FileSystemCore.isShutDown()) {
                        this.schedule(200L);
                    }
                    return Status.OK_STATUS;
                }
                Iterator<Map.Entry<ILocation, Map<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>>> cfaIterator = this.updates.entrySet().iterator();
                Map.Entry<ILocation, Map<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>> cfaUpdates = cfaIterator.next();
                cfaPath = cfaUpdates.getKey();
                Iterator<Map.Entry<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>> shareIterator = cfaUpdates.getValue().entrySet().iterator();
                if (shareIterator.hasNext()) {
                    Map.Entry<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>> shareUpdates = shareIterator.next();
                    lockPath = shareUpdates.getKey();
                    next = shareUpdates.getValue();
                    shareIterator.remove();
                    if (!shareIterator.hasNext()) {
                        cfaIterator.remove();
                    }
                } else {
                    cfaIterator.remove();
                }
            }
            if (next == null) continue;
            progress.setWorkRemaining(100);
            try {
                this.process(cfaPath, lockPath, next, progress.newChild(1));
            }
            catch (OperationCanceledException e) {
                this.requeue(cfaPath, lockPath, next);
                this.schedule(200L);
                throw e;
            }
        }
    }

    public boolean isWorkspaceReady() {
        block18: {
            if (!this.workspaceReady) {
                BundleContext context = FileSystemCoreActivator.getBundleContext();
                if (context == null) {
                    this.workspaceReady = true;
                } else {
                    ServiceTracker bundleTracker = this.getPackageAdminServiceTracker(context);
                    try {
                        try {
                            PackageAdmin bundleAdmin = (PackageAdmin)bundleTracker.getService();
                            if (bundleAdmin == null) {
                                this.workspaceReady = true;
                                break block18;
                            }
                            Bundle[] bundles = bundleAdmin.getBundles("org.eclipse.core.resources", null);
                            if (bundles.length != 1) {
                                this.workspaceReady = true;
                                break block18;
                            }
                            this.workspaceReady = bundles[0].getState() == 32;
                        }
                        catch (Exception e) {
                            this.workspaceReady = true;
                            try {
                                if (bundleTracker != null) {
                                    bundleTracker.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    finally {
                        try {
                            if (bundleTracker != null) {
                                bundleTracker.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return this.workspaceReady;
    }

    private ServiceTracker getPackageAdminServiceTracker(BundleContext context) {
        ServiceTracker bundleTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        bundleTracker.open();
        return bundleTracker;
    }

    private void process(ILocation cfaPath, IRelativeLocation lockPath, TreeMap<IRelativeLocation, UpdateRequest> toUpdate, SubMonitor monitor) {
        block18: {
            monitor.setWorkRemaining(100);
            try {
                monitor.subTask(NLS.bind((String)Messages.MetadataUpdateJob_WaitingSubTask, (Object)cfaPath));
                CFALockUtil.LockResult lock = CFALockUtil.createAndLockForUpdateOfChildren(cfaPath, lockPath, true, (IProgressMonitor)monitor.newChild(1));
                long startTime = System.currentTimeMillis();
                if (MetadataUpdateJob.isDebugEnabled()) {
                    MetadataUpdateJob.debug("Processing metadata updates for share " + cfaPath.append(lockPath).toOSString());
                }
                if (lock.code == 0) {
                    boolean changeFound = false;
                    try {
                        monitor.setWorkRemaining(toUpdate.size() + 1);
                        Iterator<UpdateRequest> iterator = toUpdate.values().iterator();
                        while (iterator.hasNext()) {
                            UpdateRequest updateRequest = iterator.next();
                            if (monitor.isCanceled() || this.isTimeToStop(startTime, changeFound)) {
                                if (MetadataUpdateJob.isDebugEnabled()) {
                                    MetadataUpdateJob.debug("Processing time expired. Requeuing request to update " + updateRequest.store.getCfaPath().append(updateRequest.store.getLocalPath()).toOSString());
                                }
                                monitor.subTask(Messages.MetadataUpdateJob_TimedoutSubtask);
                                throw new OperationCanceledException();
                            }
                            try {
                                this.updating.set(true);
                                changeFound |= updateRequest.update(monitor.newChild(1));
                                iterator.remove();
                            }
                            finally {
                                this.updating.set(false);
                            }
                        }
                    }
                    finally {
                        CFALockUtil.endBatching(lock, monitor.newChild(1));
                    }
                    if (MetadataUpdateJob.isDebugEnabled()) {
                        MetadataUpdateJob.debug("Processing completed in " + (System.currentTimeMillis() - startTime) + "ms for share " + cfaPath.append(lockPath).toOSString());
                    }
                    break block18;
                }
                if (monitor.isCanceled()) {
                    if (MetadataUpdateJob.isDebugEnabled()) {
                        MetadataUpdateJob.debug("Processing canceled. Requeuing request to update " + cfaPath.append(lockPath).toOSString());
                    }
                    throw new OperationCanceledException();
                }
                if (MetadataUpdateJob.isDebugEnabled()) {
                    MetadataUpdateJob.debug("Lock result of " + lock.code + " so processing skipped for " + cfaPath.append(lockPath).toOSString());
                }
            }
            catch (FileSystemException e) {
                LoggingHelper.log("com.ibm.team.filesystem.client", e);
            }
        }
    }

    private boolean isTimeToStop(long startTime, boolean changeFound) {
        if (changeFound || FileSystemCore.isShutDown()) {
            return false;
        }
        return System.currentTimeMillis() - startTime > 500L;
    }

    public boolean belongsTo(Object family) {
        if (family == CopyFileAreaManager.instance) {
            return true;
        }
        if (family == LocalChangeManager.getInstance()) {
            return true;
        }
        return super.belongsTo(family);
    }

    public int getUpdateCount() {
        int count = 0;
        for (Map.Entry<ILocation, Map<IRelativeLocation, TreeMap<IRelativeLocation, UpdateRequest>>> urs : this.updates.entrySet()) {
            count += 1 + urs.getValue().size();
        }
        return count;
    }

    private static class UpdateRequest {
        private final ManagedFileStore store;
        private final boolean updateChildren;
        private final boolean updateElement;

        public UpdateRequest(ManagedFileStore store, boolean updateChildren) {
            this(store, updateChildren, !updateChildren);
        }

        public UpdateRequest(ManagedFileStore store, boolean updateChildren, boolean updateElement) {
            this.store = store;
            this.updateChildren = updateChildren;
            this.updateElement = updateElement;
        }

        public boolean update(SubMonitor monitor) {
            try {
                monitor.subTask(NLS.bind((String)Messages.MetadataUpdateJob_UpdatingMetadataSubTask, (Object)this.store.getCfaPath().append(this.store.getLocalPath())));
                if (MetadataUpdateJob.isDebugEnabled()) {
                    String message = "Updating metadata for " + this.store.getCfaPath().append(this.store.getLocalPath()).toOSString();
                    if (this.updateChildren) {
                        message = String.valueOf(message) + " including children";
                    }
                    MetadataUpdateJob.debug(message);
                }
                boolean changeFound = this.store.ensureMetadataUpToDate(this.updateElement, this.updateChildren, (IProgressMonitor)monitor);
                if (MetadataUpdateJob.isDebugEnabled() && changeFound) {
                    String message = "Metadata updated for " + this.store.getCfaPath().append(this.store.getLocalPath()).toOSString();
                    if (this.updateChildren) {
                        message = String.valueOf(message) + " including children";
                    }
                    MetadataUpdateJob.debug(message);
                }
                return changeFound;
            }
            catch (FileSystemException e) {
                LoggingHelper.log("com.ibm.team.filesystem.client", e);
                return false;
            }
        }

        public IRelativeLocation getLockPath() {
            if (!this.store.getLocalPath().isEmpty()) {
                return new RelativeLocation(this.store.getLocalPath().segment(0));
            }
            return null;
        }

        public UpdateRequest combine(UpdateRequest existing) {
            if (existing == null) {
                return this;
            }
            if (existing.updateChildren && existing.updateElement) {
                return existing;
            }
            if (this.updateChildren && this.updateElement) {
                return this;
            }
            if (existing.updateChildren == this.updateChildren && existing.updateElement == this.updateElement) {
                return existing;
            }
            return new UpdateRequest(this.store, this.updateChildren || existing.updateChildren, this.updateElement || existing.updateElement);
        }

        public ILocation getCfaPath() {
            return this.store.getCfaPath();
        }

        public IRelativeLocation getLocalPath() {
            return this.store.getLocalPath();
        }
    }
}

