/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.core;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.DiskBackedMapManager;
import com.ibm.team.filesystem.client.internal.ICorruptible;
import com.ibm.team.filesystem.client.internal.ILocalConflictMetadata;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.LockableMap;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictRecord;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class LocalConflictMetadata
implements ILocalConflictMetadata {
    private static final String SCM_LOCAL_CONFLICT_PREFIX = ".conflicts";
    private static final String SCM_LOCAL_CONFLICT_SUFFIX = ".dat";
    private final PersistentHeapManager heapMgr;
    private final LocalConflictDiskBackedMapManager mapMgr;
    private final ISharingMetadata metadata;
    private final IPath metadataRoot;

    public LocalConflictMetadata(ISharingMetadata metadata, IPath metadataRoot, PersistentBusyFlag persistentMetadataFlag, ReadWriteLock globalLock) {
        this.metadata = metadata;
        this.metadataRoot = metadataRoot;
        this.heapMgr = new PersistentHeapManager();
        this.mapMgr = new LocalConflictDiskBackedMapManager(globalLock, persistentMetadataFlag, metadata);
    }

    void close() throws FileSystemException {
        this.mapMgr.closeAll();
    }

    private LockableMap<UUID, LocalConflictRecord> getMapFor(IComponentHandle component, IContextHandle connection) throws FileSystemException {
        return this.getMapFor(component, connection, true);
    }

    private LockableMap<UUID, LocalConflictRecord> getMapFor(IComponentHandle component, IContextHandle connection, boolean exclusive) throws FileSystemException {
        Path path = new Path(SCM_LOCAL_CONFLICT_PREFIX + component.getItemId().getUuidValue() + "_" + connection.getItemId().getUuidValue() + SCM_LOCAL_CONFLICT_SUFFIX);
        try {
            return this.mapMgr.loadMap((IPath)path, exclusive, (IPath)path);
        }
        catch (DBHMException e) {
            this.metadata.setCorrupt(true, "Failed to get map for " + path.toString(), e);
            throw new FileSystemException(Messages.DiskBackedMapManager_0, e);
        }
    }

    private void releaseMap(LockableMap<UUID, LocalConflictRecord> map) throws FileSystemException {
        this.mapMgr.releaseMap(map);
    }

    @Override
    public Collection<LocalConflictRecord> getLocalConflicts(IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        ArrayList<LocalConflictRecord> result = new ArrayList<LocalConflictRecord>();
        LockableMap<UUID, LocalConflictRecord> map = this.getMapFor(component, connection, false);
        try {
            for (Map.Entry<UUID, LocalConflictRecord> e : map.entries().entrySet()) {
                result.add(e.getValue());
            }
        }
        finally {
            this.releaseMap(map);
        }
        return result;
    }

    @Override
    public void setLocalConflicts(IContextHandle connection, IComponentHandle component, Collection<LocalConflictRecord> conflicts, IProgressMonitor monitor) throws FileSystemException {
        LockableMap<UUID, LocalConflictRecord> map = this.getMapFor(component, connection);
        try {
            HashSet<UUID> existing = new HashSet<UUID>();
            for (Map.Entry<UUID, LocalConflictRecord> e : map.entries().entrySet()) {
                existing.add(e.getKey());
            }
            for (LocalConflictRecord record : conflicts) {
                map.entries().put(record.getVersionableHandle().getItemId(), record);
                existing.remove(record.getVersionableHandle().getItemId());
            }
            for (UUID uuid : existing) {
                map.entries().remove(uuid);
            }
        }
        finally {
            this.releaseMap(map);
        }
    }

    protected class LocalConflictDiskBackedMapManager
    extends DiskBackedMapManager<UUID, LocalConflictRecord> {
        public LocalConflictDiskBackedMapManager(ReadWriteLock lock, PersistentBusyFlag flag, ICorruptible corruptible) {
            super(lock, flag, corruptible);
        }

        @Override
        protected LockableMap<UUID, LocalConflictRecord> getLockableMap(IPath path, IPath realPath) {
            return new LocalConflictMap(path);
        }
    }

    protected class LocalConflictMap
    extends LockableMap<UUID, LocalConflictRecord> {
        public LocalConflictMap(IPath path) {
            super(path, LocalConflictMetadata.this.metadataRoot.append(path).toFile());
        }

        @Override
        protected void initEntries() {
            try {
                this.entries = new LocalConflictRecordStore(LocalConflictMetadata.this.metadataRoot.append(this.getPath()).toFile(), LocalConflictMetadata.this.heapMgr);
            }
            catch (DBHMException e) {
                LocalConflictMetadata.this.metadata.setCorrupt(true, e.getMessage(), e);
                throw e;
            }
        }
    }

    protected static class LocalConflictRecordStore
    extends Store<UUID, LocalConflictRecord> {
        private static final int METADATA_VERSION = 0;
        private static final int HAS_LOCAL_PATH = 1;
        private static final int HAS_VERSIONABLE = 2;
        private static final int IS_DELETION = 4;
        private static final int HAS_STATE_ID = 8;
        private static final int HAS_VERSIONABLE_STATE_ID = 16;
        private static final int HAS_SANDBOX = 32;
        private static final int IS_MOD_CONFLICT = 64;
        private static final int IS_CONTENT_CHANGE = 128;
        private static final int IS_PROPERTY_CONFLICT = 256;
        private static final int IS_MOVE_CONFLICT = 512;
        private static final int HAS_DELETED_DURING_REPLAY = 1024;

        public LocalConflictRecordStore(File file, PersistentHeapManager mgr) {
            super(file, mgr);
        }

        protected void writeCustomMetadata(DataOutputStream out) throws IOException {
            super.writeCustomMetadata(out);
            out.writeInt(0);
        }

        protected void readCustomMetadata(DataInputStream in) throws IOException {
            super.readCustomMetadata(in);
            int v = in.readInt();
            if (v != 0) {
                throw new IllegalArgumentException("Metadata version mismatch " + v + " != " + 0);
            }
        }

        private long persistStream(ByteArrayOutputStream out) throws IOException {
            long offset = this.heap.allocate((long)out.size());
            out.writeTo(this.heap.getOutputStream(offset));
            return offset;
        }

        protected long writeObject(Object o, int flags) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            if ((flags & 1) != 0) {
                UUID id = (UUID)o;
                dos.writeUTF(id.getUuidValue());
                return this.persistStream(out);
            }
            this.write(dos, (LocalConflictRecord)o);
            return this.persistStream(out);
        }

        protected void freeObject(long offset, int flags) throws IOException {
            if ((flags & 1) != 0) {
                super.freeObject(offset, flags);
            }
        }

        protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
            DataInputStream dis = new DataInputStream(in);
            if ((flags & 1) != 0) {
                return UUID.valueOf((String)dis.readUTF());
            }
            return this.readLocalConflictRecord(dis);
        }

        private void write(DataOutputStream out, LocalConflictRecord o) throws IOException {
            int flags = 0;
            if (o.getLocalPath() != null) {
                flags |= 1;
            }
            if (o.getVersionableHandle() != null) {
                flags |= 2;
                if (o.getVersionableHandle().getStateId() != null) {
                    flags |= 0x10;
                }
            }
            if (o.isDeletion()) {
                flags |= 4;
            }
            if (o.getBeforeStateId() != null) {
                flags |= 8;
            }
            if (o.getSandbox() != null) {
                flags |= 0x20;
            }
            if (o.isContentChange()) {
                flags |= 0x80;
            }
            if (o.isModificationConflict()) {
                flags |= 0x40;
            }
            if (o.isPropertyConflict()) {
                flags |= 0x100;
            }
            if (o.isMoveOrRenameConflict()) {
                flags |= 0x200;
            }
            if (o.getDeletedDuringReplay() != null) {
                flags |= 0x400;
                if (o.getDeletedDuringReplay().getStateId() != null) {
                    flags |= 0x10;
                }
            }
            out.writeInt(flags);
            if ((flags & 1) != 0) {
                String[] segments = o.getLocalPath().toPath().segments();
                out.writeInt(segments.length);
                int i = 0;
                int max = segments.length;
                while (i < max) {
                    out.writeUTF(segments[i]);
                    ++i;
                }
            }
            if ((flags & 2) != 0) {
                out.writeUTF(o.getVersionableHandle().getItemType().getName());
                out.writeUTF(o.getVersionableHandle().getItemType().getNamespaceURI());
                out.writeUTF(o.getVersionableHandle().getItemId().getUuidValue());
                if ((flags & 0x10) != 0) {
                    out.writeUTF(o.getVersionableHandle().getStateId().getUuidValue());
                }
            }
            if ((flags & 8) != 0) {
                out.writeUTF(o.getBeforeStateId().getUuidValue());
            }
            if ((flags & 0x20) != 0) {
                ILocation sandboxRoot = o.getSandbox().getRoot();
                out.writeUTF(sandboxRoot.getStorageId());
                out.writeUTF(sandboxRoot.toString());
            }
            if ((flags & 0x400) != 0) {
                out.writeUTF(o.getDeletedDuringReplay().getItemType().getName());
                out.writeUTF(o.getDeletedDuringReplay().getItemType().getNamespaceURI());
                out.writeUTF(o.getDeletedDuringReplay().getItemId().getUuidValue());
            }
        }

        private LocalConflictRecord readLocalConflictRecord(DataInputStream dis) throws IOException {
            String itemId;
            String itemTypeNamespace;
            String[] segments;
            int flags = dis.readInt();
            if ((flags & 1) != 0) {
                int length = dis.readInt();
                segments = new String[length];
                int i = 0;
                int max = segments.length;
                while (i < max) {
                    segments[i] = dis.readUTF();
                    ++i;
                }
            } else {
                throw new IOException(Messages.LocalConflictMetadata_0);
            }
            Object location = new RelativeLocation(segments);
            LocalConflictRecord record = new LocalConflictRecord((IRelativeLocation)location);
            record.setDeletion((flags & 4) != 0);
            record.setContentChange((flags & 0x80) != 0);
            record.setModificationConflict((flags & 0x40) != 0);
            record.setPropertyConflict((flags & 0x100) != 0);
            record.setMoveOrRenameConflict((flags & 0x200) != 0);
            if ((flags & 2) != 0) {
                IItemType type;
                String itemTypeName = dis.readUTF();
                itemTypeNamespace = dis.readUTF();
                itemId = dis.readUTF();
                String stateId = null;
                if ((flags & 0x10) != 0) {
                    stateId = dis.readUTF();
                }
                if ((type = IItemType.IRegistry.INSTANCE.getItemType(itemTypeName, itemTypeNamespace)) != null) {
                    IItemHandle handle = type.createItemHandle(UUID.valueOf((String)itemId), stateId == null ? null : UUID.valueOf((String)stateId));
                    record.setVersionableHandle((IVersionableHandle)handle);
                }
            }
            if ((flags & 8) != 0) {
                record.setBeforeStateId(UUID.valueOf((String)dis.readUTF()));
            }
            if ((flags & 0x20) != 0) {
                String rootStorageId = dis.readUTF();
                String rootLocationStr = dis.readUTF();
                location = SharingManager.getInstance().getStorageManager(rootStorageId).createLocation(rootLocationStr);
                record.setSandbox(SharingManager.getInstance().getSandbox((ILocation)location, false));
            }
            if ((flags & 0x400) != 0) {
                String itemTypeName = dis.readUTF();
                itemTypeNamespace = dis.readUTF();
                itemId = dis.readUTF();
                IItemType type = IItemType.IRegistry.INSTANCE.getItemType(itemTypeName, itemTypeNamespace);
                if (type != null) {
                    IItemHandle handle = type.createItemHandle(UUID.valueOf((String)itemId), null);
                    record.setDeletedDuringReplay((IVersionableHandle)handle);
                }
            }
            return record;
        }
    }
}

