/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.core;

import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.client.internal.core.SharingMetadata2;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;

public class LoadedComponentsStore
extends Store<ISharingMetadata.IConnectionComponent, LoadedConfigurationDescriptor> {
    private static final int METADATA_VERSION_0 = 0;
    private static final int METADATA_VERSION_1 = 1;
    private final Log traceLog;

    public LoadedComponentsStore(PersistentHeapManager mgr, File file) {
        super(file, mgr);
        Log log = LoggingHelper.getLog(LoadedComponentsStore.class);
        this.traceLog = log != null && log.isTraceEnabled() ? log : null;
    }

    private void traceIfEnabled(String message) {
        if (this.traceLog != null && this.traceLog.isTraceEnabled()) {
            this.traceLog.trace((Object)message);
        }
    }

    protected void writeCustomMetadata(DataOutputStream out) throws IOException {
        super.writeCustomMetadata(out);
        out.writeInt(1);
    }

    protected void readCustomMetadata(DataInputStream in) throws IOException {
        super.readCustomMetadata(in);
        int v = in.readInt();
        if (v != 0 && v != 1) {
            throw new IllegalArgumentException(NLS.bind((String)"Metadata version {0} doesn't match {1} or {2}", (Object[])new Object[]{v, 0, 1}, (Object[])new Object[0]));
        }
    }

    protected long persistStream(ByteArrayOutputStream out) throws IOException {
        long offset = this.heap.allocate((long)out.size());
        out.writeTo(this.heap.getOutputStream(offset));
        return offset;
    }

    protected long writeObject(Object o, int flags) throws IOException {
        boolean isKey = (flags & 1) != 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(out);
        if (isKey) {
            SharingMetadata2.ConnectionComponent cc = (SharingMetadata2.ConnectionComponent)o;
            IContextHandle connection = cc.getConnection();
            IComponentHandle component = cc.getComponent();
            dos.writeUTF(component.getItemId().getUuidValue());
            dos.writeUTF(connection.getItemType().getName());
            dos.writeUTF(connection.getItemType().getNamespaceURI());
            dos.writeUTF(connection.getItemId().getUuidValue());
        } else {
            LoadedConfigurationDescriptor cd = (LoadedConfigurationDescriptor)o;
            IContextHandle connection = cd.connectionHandle;
            String connectionName = cd.connectionName;
            String componentName = cd.componentName;
            IComponentHandle component = cd.componentHandle;
            UUID id = cd.id;
            dos.writeUTF(component.getItemId().getUuidValue());
            dos.writeUTF(connection.getItemType().getName());
            dos.writeUTF(connection.getItemType().getNamespaceURI());
            dos.writeUTF(connection.getItemId().getUuidValue());
            dos.writeUTF("");
            dos.writeUTF(id.getUuidValue());
            dos.writeUTF(connectionName);
            dos.writeUTF(componentName);
            if (cd.workspaceComponentState != -1L) {
                this.traceIfEnabled(NLS.bind((String)"LoadedComponentsStore#writeObject: Writing the workspace component state for component: \"{0}\", with workspace context: \"{1}\", to: \"{2}\".", (Object[])new String[]{componentName, connectionName, String.valueOf(cd.workspaceComponentState)}, (Object[])new Object[0]));
                String componentState = Long.toString(cd.workspaceComponentState);
                dos.writeUTF(componentState);
            } else {
                this.traceIfEnabled(NLS.bind((String)"LoadedComponentsStore#writeObject: Unsetting the workspace component state for component: \"{0}\", with workspace context: \"{1}\".", (Object)componentName, (Object[])new Object[]{connectionName}));
            }
        }
        return this.persistStream(out);
    }

    protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
        boolean isKey = (flags & 1) != 0;
        DataInputStream dis = new DataInputStream(in);
        if (isKey) {
            UUID id = UUID.valueOf((String)dis.readUTF());
            IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(id, null);
            String name = dis.readUTF();
            String uri = dis.readUTF();
            IItemType type = IItemType.IRegistry.INSTANCE.getItemType(name, uri);
            id = UUID.valueOf((String)dis.readUTF());
            IContextHandle connection = (IContextHandle)type.createItemHandle(id, null);
            return new SharingMetadata2.ConnectionComponent(connection, component);
        }
        UUID id = UUID.valueOf((String)dis.readUTF());
        IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(id, null);
        String name = dis.readUTF();
        String uri = dis.readUTF();
        IItemType type = IItemType.IRegistry.INSTANCE.getItemType(name, uri);
        id = UUID.valueOf((String)dis.readUTF());
        IContextHandle connection = (IContextHandle)type.createItemHandle(id, null);
        dis.readUTF();
        id = UUID.valueOf((String)dis.readUTF());
        String connectionName = dis.readUTF();
        String componentName = dis.readUTF();
        long workspaceComponentState = -1L;
        try {
            String componentStateString = dis.readUTF();
            if (componentStateString != null) {
                workspaceComponentState = Long.parseLong(componentStateString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.traceIfEnabled(NLS.bind((String)"LoadedComponentsStore#readObject: The value of workspace component state for component: \"{0}\", with workspace context: \"{1}\", post reading the metadata: \"{2}\".", (Object[])new String[]{componentName, connectionName, String.valueOf(workspaceComponentState)}, (Object[])new Object[0]));
        return new LoadedConfigurationDescriptor(id, connection, connectionName, component, componentName, workspaceComponentState);
    }
}

