/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.validator;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.ItemComponentConnection;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.ChangedInfosMapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.HeapValidator;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class LocalConflictsMapValidator
extends DiskBackedHashMapEntriesValidator {
    private static final int METADATA_VERSION = 0;
    private static final String SCM_LOCAL_CONFLICT_PREFIX = ".conflicts";
    protected static final String SCM_LOCAL_CONFLICT_SEPARATOR = "_";
    private static final String SCM_LOCAL_CONFLICT_SUFFIX = ".dat";
    protected static final int UUID_LENGTH = 23;
    private static final int HAS_LOCAL_PATH = 1;
    private static final int HAS_VERSIONABLE = 2;
    private static final int IS_DELETION = 4;
    private static final int HAS_STATE_ID = 8;
    private static final int HAS_VERSIONABLE_STATE_ID = 16;
    private static final int HAS_SANDBOX = 32;
    private static final int IS_MOD_CONFLICT = 64;
    private static final int IS_CONTENT_CHANGE = 128;
    private static final int IS_PROPERTY_CONFLICT = 256;
    private static final int IS_MOVE_CONFLICT = 512;
    private static final int HAS_DELETED_DURING_REPLAY = 1024;
    private static final int MAX_FLAG_VALUE = 2048;
    private File cfaRoot;
    protected String componentId;
    protected String connectionId;

    public LocalConflictsMapValidator(File rootFile, HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        super(hv, gv);
        this.cfaRoot = rootFile;
    }

    @Override
    public void beginValidation() throws IOException {
        super.beginValidation();
        this.componentId = null;
        this.connectionId = null;
        boolean valid = false;
        String fn = this.hv.getHeapFile().getName();
        if (fn.length() == SCM_LOCAL_CONFLICT_PREFIX.length() + 23 + SCM_LOCAL_CONFLICT_SEPARATOR.length() + 23 + SCM_LOCAL_CONFLICT_SUFFIX.length()) {
            this.componentId = fn.substring(SCM_LOCAL_CONFLICT_PREFIX.length(), SCM_LOCAL_CONFLICT_PREFIX.length() + 23);
            this.connectionId = fn.substring(SCM_LOCAL_CONFLICT_PREFIX.length() + 23 + SCM_LOCAL_CONFLICT_SEPARATOR.length(), SCM_LOCAL_CONFLICT_PREFIX.length() + 23 + SCM_LOCAL_CONFLICT_SEPARATOR.length() + 23);
            if (this.isValidUUID(this.componentId) && this.isValidUUID(this.connectionId) && fn.startsWith(SCM_LOCAL_CONFLICT_PREFIX) && fn.endsWith(SCM_LOCAL_CONFLICT_SUFFIX) && fn.substring(SCM_LOCAL_CONFLICT_PREFIX.length() + 23, SCM_LOCAL_CONFLICT_PREFIX.length() + 23 + SCM_LOCAL_CONFLICT_SEPARATOR.length()).equals(SCM_LOCAL_CONFLICT_SEPARATOR)) {
                valid = true;
            }
        }
        if (!valid) {
            this.log.append("Invalid local conflicts map file name: " + fn + "\n");
        }
        if (!this.hv.getHeapFile().getParentFile().equals(this.cfaRoot)) {
            this.log.append("Invalid local conflicts map location " + this.hv.getHeapFile() + " relative to root " + this.cfaRoot + "\n");
        }
    }

    @Override
    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        if (keyIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on changed infos key of entry at " + entryOffset + "\n");
        }
        if (valueIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on changed infos value of entry at " + entryOffset + "\n");
        }
        LocalConflictsKey k = this.validateKey(entryOffset, keyOffset, hash, raf);
        LocalConflictValue v = this.validateValue(entryOffset, valueOffset, k, raf);
        if (k != null && v != null && this.componentId != null && this.connectionId != null) {
            ItemComponentConnection icc = new ItemComponentConnection();
            icc.setComponentId(this.componentId);
            icc.setConnectionId(this.connectionId);
            icc.setItemId(k.uuid);
            this.gv.addLocalConflictInfo(icc, v);
        }
    }

    protected LocalConflictsKey validateKey(long entryOffset, long keyOffset, int hashCode, RAFWrapper raf) throws IOException {
        if (keyOffset < 0L || keyOffset >= this.hv.getWorkingAreaSize()) {
            this.log.append("The changed infos key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(keyOffset);
        try {
            String uuid = this.validateUUID("local conflict key", keyOffset, "item id", raf);
            if (uuid == null) {
                return null;
            }
            int uuidHashCode = UUID.valueOf((String)uuid).hashCode();
            if (hashCode != uuidHashCode) {
                this.log.append("The entry at " + entryOffset + " contains a hash code (" + hashCode + ") for local conflict key at " + keyOffset + " with UUID \"" + uuid + "\" whose hash code is " + uuidHashCode + "\n");
            }
            LocalConflictsKey result = new LocalConflictsKey(uuid);
            this.addKey(result, entryOffset, keyOffset, "local conflict");
            LocalConflictsKey localConflictsKey = result;
            return localConflictsKey;
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(keyOffset, this.getPosition() - keyOffset, "Local conflicts key"));
        }
    }

    protected LocalConflictValue validateValue(long entryOffset, long valueOffset, LocalConflictsKey k, RAFWrapper raf) throws IOException {
        if (valueOffset < 0L || valueOffset > this.hv.getWorkingAreaSize()) {
            this.log.append("The local conflicts value pointer is at an impossible location " + valueOffset + " at " + entryOffset + "\n");
            return null;
        }
        try {
            String itemId;
            String itemTypeNamespace;
            this.setPosition(valueOffset);
            LocalConflictValue record = new LocalConflictValue();
            String fieldDesc = "local conflicts";
            long flags = this.validateInt(fieldDesc, valueOffset, "flags", raf);
            if (flags > 2048L) {
                this.log.append("Impossible local conflicts flags " + flags + " at offset " + valueOffset + "\n");
            }
            record.setDeletion((flags & 4L) != 0L);
            record.setContentChange((flags & 0x80L) != 0L);
            record.setModificationConflict((flags & 0x40L) != 0L);
            record.setPropertyConflict((flags & 0x100L) != 0L);
            record.setMoveOrRenameConflict((flags & 0x200L) != 0L);
            if ((flags & 1L) != 0L) {
                long segmentCount = this.validateInt(fieldDesc, valueOffset, "local path segment count", raf);
                String[] segments = new String[(int)segmentCount];
                int i = 0;
                while ((long)i < segmentCount) {
                    segments[i] = this.validateString(fieldDesc, valueOffset, "local path segment " + i, raf);
                    ++i;
                }
                RelativeLocation location = new RelativeLocation(segments);
                record.setLocalPath(location);
            }
            if ((flags & 2L) != 0L) {
                IItemType type;
                String itemTypeName = this.validateString(fieldDesc, valueOffset, "item type name", raf);
                itemTypeNamespace = this.validateString(fieldDesc, valueOffset, "item type namespace", raf);
                this.validateItemType(itemTypeName, itemTypeNamespace, IVersionableHandle.class, fieldDesc, valueOffset, "item type");
                itemId = this.validateUUID(fieldDesc, valueOffset, "item id", raf);
                String stateId = null;
                if ((flags & 0x10L) != 0L) {
                    stateId = this.validateUUID(fieldDesc, valueOffset, "item state id", raf);
                }
                if ((type = IItemType.IRegistry.INSTANCE.getItemType(itemTypeName, itemTypeNamespace)) != null) {
                    IItemHandle handle = type.createItemHandle(UUID.valueOf((String)itemId), stateId == null ? null : UUID.valueOf((String)stateId));
                    record.setVersionableHandle((IVersionableHandle)handle);
                }
            }
            if ((flags & 8L) != 0L) {
                String stateId = this.validateUUID(fieldDesc, valueOffset, "state id", raf);
                record.setBeforeStateId(UUID.valueOf((String)stateId));
            }
            if ((flags & 0x20L) != 0L) {
                String rootStorageId = this.validateString(fieldDesc, valueOffset, "storageId", raf);
                String rootLocationStr = this.validateString(fieldDesc, valueOffset, "storage location", raf);
                ILocation location = SharingManager.getInstance().getStorageManager(rootStorageId).createLocation(rootLocationStr);
                record.setSandbox(SharingManager.getInstance().getSandbox(location, false));
            }
            if ((flags & 0x400L) != 0L) {
                String itemTypeName = this.validateString(fieldDesc, valueOffset, "deleted item type name", raf);
                itemTypeNamespace = this.validateString(fieldDesc, valueOffset, "deleted item type namespace", raf);
                this.validateItemType(itemTypeName, itemTypeNamespace, IVersionableHandle.class, fieldDesc, valueOffset, "deleted item type");
                itemId = this.validateUUID(fieldDesc, valueOffset, "deleted item id", raf);
                IItemType type = IItemType.IRegistry.INSTANCE.getItemType(itemTypeName, itemTypeNamespace);
                if (type != null) {
                    IItemHandle handle = type.createItemHandle(UUID.valueOf((String)itemId), null);
                    record.setDeletedDuringReplay((IVersionableHandle)handle);
                }
            }
            LocalConflictValue localConflictValue = record;
            return localConflictValue;
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(valueOffset, this.getPosition() - valueOffset, "Local Conflict Value"));
        }
    }

    @Override
    public boolean validateCustomMetadata(DataInputStream in) throws IOException {
        int v = in.readInt();
        if (v != 0) {
            this.log.append("Metadata version mismatch for inverse item info map: " + v + " != " + 0);
            return false;
        }
        return true;
    }

    public static class LocalConflictValue
    implements Serializable {
        private static final long serialVersionUID = 2172703556717808574L;
        private IRelativeLocation localPath;
        private VersionableHandle handle;
        private UUID stateId;
        private VersionableHandle deleted;
        private String sandbox;
        private boolean deletion;
        private boolean contentChange;
        private boolean modConflict;
        private boolean propertyConflict;
        private boolean moveOrRenameConflict;

        public void setLocalPath(IRelativeLocation location) {
            this.localPath = location;
        }

        public void setVersionableHandle(IVersionableHandle handle) {
            this.handle = new VersionableHandle(handle);
        }

        public void setBeforeStateId(UUID stateId) {
            this.stateId = stateId;
        }

        public void setDeletedDuringReplay(IVersionableHandle deleted) {
            this.deleted = new VersionableHandle(deleted);
        }

        public void setSandbox(ISandbox sandbox) {
            this.sandbox = sandbox.getRoot().toString();
        }

        public void setDeletion(boolean deletion) {
            this.deletion = deletion;
        }

        public void setContentChange(boolean contentChange) {
            this.contentChange = contentChange;
        }

        public void setModificationConflict(boolean modConflict) {
            this.modConflict = modConflict;
        }

        public void setPropertyConflict(boolean propertyConflict) {
            this.propertyConflict = propertyConflict;
        }

        public void setMoveOrRenameConflict(boolean moveOrRenameConflict) {
            this.moveOrRenameConflict = moveOrRenameConflict;
        }

        public IRelativeLocation getLocalPath() {
            return this.localPath;
        }

        public VersionableHandle getHandle() {
            return this.handle;
        }

        public void setHandle(IVersionableHandle handle) {
            this.setVersionableHandle(handle);
        }

        public UUID getStateId() {
            return this.stateId;
        }

        public void setStateId(UUID stateId) {
            this.stateId = stateId;
        }

        public VersionableHandle getDeleted() {
            return this.deleted;
        }

        public void setDeleted(IVersionableHandle deleted) {
            this.setDeletedDuringReplay(deleted);
        }

        public boolean isModConflict() {
            return this.modConflict;
        }

        public void setModConflict(boolean modConflict) {
            this.modConflict = modConflict;
        }

        public String getSandbox() {
            return this.sandbox;
        }

        public boolean isDeletion() {
            return this.deletion;
        }

        public boolean isContentChange() {
            return this.contentChange;
        }

        public boolean isPropertyConflict() {
            return this.propertyConflict;
        }

        public boolean isMoveOrRenameConflict() {
            return this.moveOrRenameConflict;
        }
    }

    public static class LocalConflictsKey
    implements Serializable {
        private static final long serialVersionUID = 7800148469585372132L;
        protected String uuid;

        public LocalConflictsKey(String uuid) {
            this.uuid = uuid;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ChangedInfosMapValidator.ChangedInfosKey)) {
                return false;
            }
            return ((ChangedInfosMapValidator.ChangedInfosKey)obj).uuid.equals(this.uuid);
        }

        public String toString() {
            return this.uuid;
        }
    }

    public static class VersionableHandle
    implements Serializable {
        private UUID uuid;
        private UUID state;
        private String typeName;
        private String typeNamesapce;
        private static final long serialVersionUID = 4486275374883846495L;

        public VersionableHandle(IVersionableHandle handle) {
            this.uuid = handle.getItemId();
            this.state = handle.getStateId();
            this.typeName = handle.getItemType().getName();
            this.typeNamesapce = handle.getItemType().getNamespaceURI();
        }

        public UUID getItemId() {
            return this.uuid;
        }

        public UUID getStateId() {
            return this.state;
        }
    }
}

