/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.validator;

import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.HeapValidator;
import com.ibm.team.filesystem.client.internal.core.SharingMetadata2;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class InverseSharingDescriptorsMapValidator
extends DiskBackedHashMapEntriesValidator {
    protected boolean isCaseSensitive;
    protected File cfaRoot;

    public InverseSharingDescriptorsMapValidator(File rootFile, boolean caseSensitive, HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        super(hv, gv);
        this.cfaRoot = rootFile;
        this.isCaseSensitive = caseSensitive;
    }

    @Override
    public void beginValidation() throws IOException {
        super.beginValidation();
        if (!this.hv.getHeapFile().getName().equals(".inversedescriptors.dat")) {
            this.log.append("Invalid inverse sharing descriptors map file name " + this.hv.getHeapFile() + "\n");
        }
        if (!this.hv.getHeapFile().getParentFile().equals(this.cfaRoot)) {
            this.log.append("Invalid inverse sharing descriptors map location " + this.hv.getHeapFile() + " relative to root " + this.cfaRoot + "\n");
        }
    }

    @Override
    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        if (keyIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on sharing descriptors key of entry at " + entryOffset + "\n");
        }
        if (valueIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on sharing descriptors value of entry at " + entryOffset + "\n");
        }
        SharingMetadata2.ShareRoot share = this.validateKey(entryOffset, keyOffset, hash, raf);
        IPath path = this.validateValue(entryOffset, valueOffset, raf);
        if (path != null && share != null) {
            this.gv.addInverseSharingDescriptor(path, share, this.log);
        }
    }

    private SharingMetadata2.ShareRoot validateKey(long entryOffset, long keyOffset, int hash, RAFWrapper raf) throws IOException {
        if (keyOffset < 0L || keyOffset > this.hv.getWorkingAreaSize()) {
            this.log.append("The inverse sharing descriptors key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(keyOffset);
        ObjectInputStream oin = new ObjectInputStream(new ByteBufferInputStream(raf));
        Object o = null;
        boolean success = true;
        try {
            o = oin.readObject();
        }
        catch (Exception e) {
            this.logThrowable(e);
            success = false;
        }
        SharingMetadata2.ShareRoot result = null;
        if (success) {
            if (o == null) {
                this.log.append("The inverse sharing descriptor key read at offset " + keyOffset + " is null\n");
            } else if (!(o instanceof SharingMetadata2.ShareRoot)) {
                this.log.append("The inverse sharing descriptor key read at offset " + keyOffset + " is of an unknown type " + o.getClass().getName() + "\n");
            } else {
                SharingMetadata2.ConnectionComponent cc;
                SharingMetadata2.ShareRoot desc;
                result = desc = (SharingMetadata2.ShareRoot)o;
                if (desc.getRootVersionable() == null) {
                    this.log.append("The inverse sharing descriptor key read at offset " + keyOffset + " has a null root versionable\n");
                }
                if ((cc = desc.getConnectionComponent()) == null) {
                    this.log.append("The inverse sharing descriptor key read at offset " + keyOffset + " has a null connection/component entry\n");
                } else {
                    if (cc.getComponent() == null) {
                        this.log.append("The inverse sharing descriptor key read at offset " + keyOffset + " has a null component\n");
                    }
                    if (cc.getConnection() == null) {
                        this.log.append("The inverse sharing descriptor key read at offset " + keyOffset + " has a null connection\n");
                    }
                    if (desc.getRootVersionable() != null) {
                        this.addKey(result, entryOffset, keyOffset, "inverse sharing descriptor");
                    }
                }
                if (hash != result.hashCode()) {
                    this.log.append("The entry at " + entryOffset + " contains a hash code (" + hash + ") for inverse sharing descriptor key at " + keyOffset + " with hash " + result.hashCode() + "\n");
                }
                this.hv.claim(new HeapValidator.HeapClaimant(keyOffset, this.getPosition() - keyOffset, "Inverse Sharing Descriptors Key"));
            }
        }
        return result;
    }

    private IPath validateValue(long entryOffset, long valueOffset, RAFWrapper raf) throws IOException {
        if (valueOffset < 0L || valueOffset > this.hv.getWorkingAreaSize()) {
            this.log.append("The sharing descriptors value pointer is at an impossible location " + valueOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(valueOffset);
        ObjectInputStream oin = new ObjectInputStream(new ByteBufferInputStream(raf));
        Object o = null;
        boolean success = true;
        try {
            o = oin.readObject();
        }
        catch (Exception e) {
            this.logThrowable(e);
            success = false;
        }
        Path result = null;
        if (success) {
            if (o == null) {
                this.log.append("The inverse sharing descriptor value read at offset " + valueOffset + " is null\n");
            } else if (!(o instanceof String)) {
                this.log.append("The inverse sharing descriptor value read at offset " + valueOffset + " is of an unknown type " + o.getClass().getName() + "\n");
            } else {
                Path p;
                String path = (String)o;
                result = p = new Path(null, path);
                if (!p.isAbsolute()) {
                    this.log.append("Inverse sharing descriptor path \"" + p + "\" is not absolute at offset " + valueOffset + "\n");
                }
                if (p.isUNC()) {
                    this.log.append("Inverse sharing descriptor path \"" + p + "\" is a UNC path at offset " + valueOffset + "\n");
                }
                if (p.hasTrailingSeparator()) {
                    this.log.append("Inverse sharing descriptor path \"" + p + "\" has a trailing separator at offset " + valueOffset + "\n");
                }
                if (p.segmentCount() < 1) {
                    this.log.append("Inverse sharing descriptor path \"" + p + "\" does not have any segments at " + valueOffset + "\n");
                }
                int i = 0;
                while (i < p.segmentCount()) {
                    if (!p.isValidSegment(p.segment(i))) {
                        this.log.append("The segment \"" + p.segment(i) + "\" of sharing descriptor path \"" + p + "\" at " + valueOffset + " is not valid\n");
                    }
                    ++i;
                }
                this.hv.claim(new HeapValidator.HeapClaimant(valueOffset, this.getPosition() - valueOffset, "Inverse sharing descriptors Value"));
            }
        }
        return result;
    }

    protected class ByteBufferInputStream
    extends InputStream {
        protected RAFWrapper raf;
        protected long top;
        boolean closed;

        public ByteBufferInputStream(RAFWrapper raf) {
            this.raf = raf;
            this.top = InverseSharingDescriptorsMapValidator.this.hv.getWorkingAreaSize();
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (InverseSharingDescriptorsMapValidator.this.getPosition() >= this.top) {
                return -1;
            }
            if (InverseSharingDescriptorsMapValidator.this.buf.remaining() == 0) {
                this.fill();
            }
            return InverseSharingDescriptorsMapValidator.this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (InverseSharingDescriptorsMapValidator.this.getPosition() >= this.top) {
                return -1;
            }
            if (InverseSharingDescriptorsMapValidator.this.buf.remaining() == 0) {
                this.fill();
            }
            int read = Math.min(len, InverseSharingDescriptorsMapValidator.this.buf.remaining());
            InverseSharingDescriptorsMapValidator.this.buf.get(b, off, read);
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            long realOffset = InverseSharingDescriptorsMapValidator.this.getPosition();
            if (realOffset >= this.top) {
                return 0L;
            }
            if ((n = Math.min(this.top - realOffset, n)) <= (long)InverseSharingDescriptorsMapValidator.this.buf.remaining()) {
                InverseSharingDescriptorsMapValidator.this.buf.position((int)((long)InverseSharingDescriptorsMapValidator.this.buf.position() + n));
            } else {
                InverseSharingDescriptorsMapValidator.this.buf.position(InverseSharingDescriptorsMapValidator.this.buf.limit());
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        protected void fill() throws IOException {
            int currRead;
            InverseSharingDescriptorsMapValidator.this.buf.compact();
            do {
                if ((currRead = this.raf.getFile().getChannel().read(InverseSharingDescriptorsMapValidator.this.buf, InverseSharingDescriptorsMapValidator.this.currentOffset)) == -1) {
                    throw new EOFException();
                }
                InverseSharingDescriptorsMapValidator.this.currentOffset += (long)currRead;
            } while (currRead == 0);
            InverseSharingDescriptorsMapValidator.this.buf.flip();
        }
    }
}

