/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.validator;

import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import com.ibm.team.internal.repository.rcp.util.FileChannelUtil;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;

public class HeapValidator {
    protected static final int HEAP_TRAILER_SIZE = 16;
    protected static final long MAGIC = -2401053086532404614L;
    protected static final int MIN_SIZE = 8;
    public static final int HEADER_SIZE = 9;
    protected static final int TRAILER_SIZE = 8;
    protected static final int PREDECESSOR_USED_FLAG = 1;
    protected static final int SUCCESSOR_USED_FLAG = 2;
    protected static final int ALL_FLAGS = 3;
    protected PersistentDiskBackedHashMap<Long, Long> allocated;
    protected File allocatedF = File.createTempFile("allocated", null);
    protected PersistentDiskBackedHashMap<Long, Long> free;
    protected File freeF;
    protected PersistentDiskBackedHashMap<Long, HeapClaimant> claimed;
    protected File claimedF;
    protected PersistentDiskBackedHashMap<Long, Long> unclaimed;
    protected File unclaimedF;
    protected byte[] userData;
    protected byte[] bTreeData;
    protected long workingAreaSize;
    protected StringBuilder log;
    protected File heapFile;

    public HeapValidator() throws IOException {
        boolean success = false;
        try {
            this.allocated = new PersistentDiskBackedHashMap(this.allocatedF);
            this.freeF = File.createTempFile("free", null);
            this.free = new PersistentDiskBackedHashMap(this.freeF);
            this.claimedF = File.createTempFile("claimed", null);
            this.claimed = new PersistentDiskBackedHashMap<Long, HeapClaimant>(this.claimedF){

                protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                    return new ObjectInputStream(in).readObject();
                }
            };
            this.unclaimedF = File.createTempFile("unclaimed", null);
            this.unclaimed = new PersistentDiskBackedHashMap(this.unclaimedF);
            success = true;
        }
        finally {
            if (!success) {
                this.cleanUp();
            }
        }
    }

    public void beginValidation(File f, RAFWrapper raf, StringBuilder log) throws IOException {
        this.log = log;
        this.heapFile = f;
        this.userData = null;
        this.bTreeData = null;
        this.workingAreaSize = -1L;
        this.validatePersistentStructure(raf);
        this.validateHeapStructure(raf);
    }

    public StringBuilder getLog() {
        return this.log;
    }

    public File getHeapFile() {
        return this.heapFile;
    }

    public Map<Long, Long> getAllocatedMap() {
        return this.allocated;
    }

    public Map<Long, Long> getUnclaimed() {
        return this.unclaimed;
    }

    public Map<Long, Long> getFreeMap() {
        return this.free;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public byte[] getBTreeData() {
        return this.bTreeData;
    }

    public long getWorkingAreaSize() {
        return this.workingAreaSize;
    }

    public void validatePersistentStructure(RAFWrapper raf) {
        this.workingAreaSize = -1L;
        try {
            long userDataLen;
            boolean userDataLenBad;
            boolean bTreeDataLenBad;
            long len = raf.getFile().length();
            if (len < 16L) {
                this.log.append("File too short to be a heap file (" + len + " bytes)\n");
                return;
            }
            long offset = len - 16L;
            ByteBuffer buf = ByteBuffer.allocate(16);
            FileChannelUtil.readFully((ByteBuffer)buf, (long)offset, (RAFWrapper)raf, (boolean)true);
            buf.rewind();
            long sig = buf.getLong();
            if (sig != -2401053086532404614L) {
                this.log.append("The file contains the wrong signature (" + sig + ")\n");
                return;
            }
            long bTreeDataLen = buf.getInt();
            boolean bl = bTreeDataLenBad = bTreeDataLen > offset || bTreeDataLen < 0L;
            if (bTreeDataLenBad) {
                this.log.append("Invalid B-Tree persisted data length (" + bTreeDataLen + ")\n");
            }
            boolean bl2 = userDataLenBad = (userDataLen = (long)buf.getInt()) > offset || userDataLen < 0L;
            if (userDataLenBad) {
                this.log.append("Invalid user persisted data length (" + userDataLen + ")\n");
            }
            if (!bTreeDataLenBad && !userDataLenBad && bTreeDataLen + userDataLen > offset) {
                this.log.append("Invalid total persisted data length (B-Tree: " + bTreeDataLen + ", User: " + userDataLen + ")\n");
                return;
            }
            if (bTreeDataLenBad || userDataLenBad) {
                return;
            }
            this.workingAreaSize = offset - bTreeDataLen - userDataLen;
            byte[] data = new byte[(int)bTreeDataLen];
            if (bTreeDataLen != 0L) {
                buf = ByteBuffer.wrap(data);
                FileChannelUtil.readFully((ByteBuffer)buf, (long)this.workingAreaSize, (RAFWrapper)raf, (boolean)true);
            }
            this.bTreeData = data;
            data = new byte[(int)userDataLen];
            if (userDataLen != 0L) {
                buf = ByteBuffer.wrap(data);
                FileChannelUtil.readFully((ByteBuffer)buf, (long)(this.workingAreaSize + bTreeDataLen), (RAFWrapper)raf, (boolean)true);
            }
            this.userData = data;
        }
        catch (IOException e) {
            this.logThrowable(e);
        }
    }

    protected void validateHeapStructure(RAFWrapper raf) {
        try {
            long fileSize = raf.getFile().length();
            if (this.workingAreaSize == -1L) {
                this.workingAreaSize = fileSize;
            }
            ByteBuffer buf = ByteBuffer.allocate(17);
            long currentSize = -1L;
            long offset = 0L;
            while (true) {
                boolean succFree;
                long size;
                byte flags;
                if (offset == 0L) {
                    if (offset + 9L > this.workingAreaSize) {
                        this.log.append("Not enough space remaining in file to read header, offset: " + offset + ", working area: " + this.workingAreaSize + ", file size: " + fileSize + "\n");
                        break;
                    }
                    buf.limit(9);
                    FileChannelUtil.readFully((ByteBuffer)buf, (long)offset, (RAFWrapper)raf, (boolean)true);
                    buf.rewind();
                    flags = buf.get();
                    size = buf.getLong();
                    offset += 9L;
                } else {
                    buf.rewind();
                    if (currentSize != -1L) {
                        if (offset + 9L + 8L > this.workingAreaSize) {
                            this.log.append("Not enough space remaining in file to read header, offset: " + offset + ", working area: " + this.workingAreaSize + ", file size: " + fileSize + "\n");
                            break;
                        }
                        buf.limit(17);
                        FileChannelUtil.readFully((ByteBuffer)buf, (long)offset, (RAFWrapper)raf, (boolean)true);
                        buf.rewind();
                        long prevSize = buf.getLong();
                        flags = buf.get();
                        size = buf.getLong();
                        if (prevSize != currentSize) {
                            this.log.append("Header and trailer disagree on cell size at offset " + offset + " (Header: " + currentSize + " Trailer: " + prevSize + ")\n");
                        }
                        offset += 17L;
                    } else {
                        if (offset + 9L > this.workingAreaSize) {
                            this.log.append("Not enough space remaining in file to read header, offset: " + offset + ", working area: " + this.workingAreaSize + ", file size: " + fileSize + "\n");
                            break;
                        }
                        buf.limit(9);
                        FileChannelUtil.readFully((ByteBuffer)buf, (long)offset, (RAFWrapper)raf, (boolean)true);
                        buf.rewind();
                        flags = buf.get();
                        size = buf.getLong();
                        offset += 9L;
                    }
                }
                if ((flags & 0xFFFFFFFC) != 0) {
                    this.log.append("Unknown flags " + Integer.toHexString(flags) + " at offset " + offset + "\n");
                }
                boolean predFree = (flags & 1) == 0;
                boolean bl = succFree = (flags & 2) == 0;
                if (predFree && currentSize == -1L) {
                    this.log.append("Mismatch between header and trailer flags at offset " + offset + ". Header says allocated, trailer says free\n");
                } else if (!predFree && currentSize != -1L) {
                    this.log.append("Mismatch between header and trailer flags at offset " + offset + ". Header says free, trailer says allocated\n");
                }
                if (size < 8L) {
                    this.log.append("Found cell size " + size + " at offset " + offset + " which is less than minimum allowed size.\n");
                    if (size < 0L) break;
                }
                if (size + offset > this.workingAreaSize || size + offset < size) {
                    this.log.append("Found cell size " + size + " at offset " + offset + " which extends beyond working area of size " + this.workingAreaSize + ".\n");
                }
                if (succFree && size + offset >= this.workingAreaSize) {
                    this.log.append("Found free cell of size " + size + " at offset " + offset + " which is the last cell in working area of size " + this.workingAreaSize + ".\n");
                }
                if (succFree) {
                    this.free.put((Object)offset, (Object)size);
                } else {
                    this.allocated.put((Object)offset, (Object)size);
                    this.unclaimed.put((Object)offset, (Object)size);
                }
                if (size + offset < this.workingAreaSize && size + offset >= size) {
                    if (succFree) {
                        offset += size - 8L;
                        currentSize = size;
                        continue;
                    }
                    offset += size;
                    currentSize = -1L;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.logThrowable(e);
        }
    }

    public void endValidation(boolean logUnclaimed) {
        if (logUnclaimed) {
            for (Map.Entry<Long, Long> e : this.getUnclaimed().entrySet()) {
                this.log.append("The allocated cell of size " + e.getValue() + " at offset " + e.getKey() + " is unused in the course of validating the map.\nPerhaps the entry validator needs to check this key and value?");
            }
        }
        this.allocated.clear();
        this.free.clear();
        this.claimed.clear();
        this.unclaimed.clear();
    }

    public void cleanUp() throws IOException {
        block56: {
            try {
                if (this.allocatedF == null) break block56;
                try {
                    if (this.allocated != null) {
                        this.allocated.close();
                        this.allocated = null;
                    }
                }
                finally {
                    this.allocatedF.delete();
                }
            }
            finally {
                block57: {
                    try {
                        if (this.freeF == null) break block57;
                        try {
                            if (this.free != null) {
                                this.free.close();
                                this.free = null;
                            }
                        }
                        finally {
                            this.freeF.delete();
                        }
                    }
                    finally {
                        block58: {
                            try {
                                if (this.claimedF == null) break block58;
                                try {
                                    if (this.claimed != null) {
                                        this.claimed.close();
                                        this.claimed = null;
                                    }
                                }
                                finally {
                                    this.claimedF.delete();
                                }
                            }
                            finally {
                                if (this.unclaimedF != null) {
                                    try {
                                        if (this.unclaimed != null) {
                                            this.unclaimed.close();
                                            this.unclaimed = null;
                                        }
                                    }
                                    finally {
                                        this.unclaimedF.delete();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void claim(HeapClaimant cl) {
        Long size = (Long)this.allocated.get((Object)cl.getOffset());
        if (size == null) {
            this.log.append("The " + cl.getDesc() + " at offset " + cl.getOffset() + " is not marked as allocated\n");
        } else if (cl.getSize() >= 0L && size < cl.getSize()) {
            this.log.append("The " + cl.getDesc() + " at offset " + cl.getOffset() + " is in an allocated block of size " + size + " which is smaller than " + cl.getSize() + ", the size needed for the " + cl.getDesc() + "\n");
        } else if (cl.getSize() < 8L && 25L <= size) {
            this.log.append("The " + cl.getDesc() + " at offset " + cl.getOffset() + " is in an allocated block of size " + size + " which should have been split since the size needed is " + cl.getSize() + "\n");
        } else if (cl.getSize() >= 8L && cl.getSize() + 9L + 8L <= size) {
            this.log.append("The " + cl.getDesc() + " at offset " + cl.getOffset() + " is in an allocated block of size " + size + " which should have been split since the size needed is " + cl.getSize() + "\n");
        }
        this.unclaimed.remove((Object)cl.getOffset());
        HeapClaimant other = (HeapClaimant)this.claimed.put((Object)cl.getOffset(), (Object)cl);
        if (other != null) {
            this.log.append("The offset " + cl.getOffset() + " is being used by a " + cl.getDesc() + " of size " + cl.getSize() + " and also a " + other.getDesc() + " of size " + other.getSize());
        }
    }

    protected void logThrowable(Throwable e) {
        CharArrayWriter out = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(out);
        e.printStackTrace(pw);
        pw.flush();
        this.log.append(out.toCharArray());
    }

    public static class HeapClaimant
    implements Serializable {
        private static final long serialVersionUID = -3309769443460743520L;
        protected long offset;
        protected long size;
        protected String desc;

        public HeapClaimant(long offset, long size, String desc) {
            this.offset = offset;
            this.size = size;
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getSize() {
            return this.size;
        }
    }
}

