/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.validator;

import com.ibm.team.filesystem.client.internal.copyfileareas.RandomAccessFileInputStream;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.HeapValidator;
import com.ibm.team.internal.repository.rcp.util.FileChannelUtil;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;

public class DiskBackedHashMapValidator {
    protected static final int DATA_SIZE = 37;
    protected static final int FORMAT_VERSION = 1;
    protected static final long TABLE_CELL_SIZE = 30L;
    protected static final int LINKED_CELL_SIZE = 29;
    protected static final int ENTRY_KEY_HEAPADT_FLAG = 1;
    protected static final int ENTRY_VALUE_HEAPADT_FLAG = 2;
    protected static final int ALL_FLAGS = 3;
    protected HeapValidator hv;
    protected StringBuilder log;
    protected DiskBackedHashMapEntriesValidator dbhmev;
    protected byte format;
    protected long tablePtr;
    protected long size;
    protected long capacity;
    protected long numHeapADTs;

    public DiskBackedHashMapValidator(HeapValidator hv, DiskBackedHashMapEntriesValidator dbhmev, RAFWrapper raf) throws IOException {
        this.hv = hv;
        this.log = hv.getLog();
        this.dbhmev = dbhmev;
        this.validateMap(raf);
    }

    protected void initMapParms() throws IOException {
        this.tablePtr = -1L;
        byte[] data = this.hv.getUserData();
        if (data == null) {
            this.log.append("DiskBackedHashMap data is null\n");
            return;
        }
        if (data.length != 0 && data[0] != 1) {
            this.format = data[0];
            this.log.append("Unknown DiskBackedHashMap format: " + this.format + "\n");
        }
        if (data.length != 37) {
            this.log.append("The DiskBackedHashMap data size is " + data.length + "\n");
            return;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data, 1, data.length - 1));
        long tablePtr = in.readLong();
        this.size = in.readLong();
        this.capacity = in.readLong();
        this.numHeapADTs = in.readLong();
        boolean pass = true;
        if (tablePtr < 0L || tablePtr > this.hv.getWorkingAreaSize()) {
            this.log.append("DiskBackedHashMap table pointer is at an impossible location " + tablePtr + "\n");
            pass = false;
        }
        if (this.size < 0L || this.size * 29L > this.hv.getWorkingAreaSize()) {
            this.log.append("Invalid DiskBackedHashMap size " + this.size + "\n");
        }
        if (this.capacity < 0L || this.capacity * 30L > this.hv.getWorkingAreaSize()) {
            this.log.append("Invalid DiskBackedHashMap capacity " + this.capacity + "\n");
            pass = false;
        } else if (this.capacity * 30L + tablePtr > this.hv.getWorkingAreaSize()) {
            this.log.append("Invalid DiskBackedHashMap capacity " + this.capacity + " for table ptr " + tablePtr + "\n");
            pass = false;
        }
        if (this.numHeapADTs < 0L) {
            this.log.append("Invalid number of Heap ADTs in DiskBackedHashMap " + this.numHeapADTs + "\n");
        } else if (this.numHeapADTs > this.size * 2L) {
            this.log.append("Invalid number of Heap ADTs in DiskBackedHashMap " + this.numHeapADTs + " for size " + this.size + "\n");
        }
        if (!pass) {
            return;
        }
        if (!this.dbhmev.validateCustomMetadata(in)) {
            pass = false;
        }
        this.hv.claim(new HeapValidator.HeapClaimant(tablePtr, this.capacity * 30L, "DiskBackHashMap main table"));
        this.tablePtr = tablePtr;
    }

    protected void validateMap(RAFWrapper raf) throws IOException {
        try {
            this.dbhmev.beginValidation();
            this.initMapParms();
            if (this.tablePtr == -1L) {
                return;
            }
            try {
                long found = 0L;
                DataInputStream in = new DataInputStream(new BufferedInputStream(new RandomAccessFileInputStream(this.tablePtr, this.capacity * 30L, raf, this.log)));
                long foundHeapADTs = 0L;
                long max = raf.getFile().length();
                ByteBuffer linkedEntry = ByteBuffer.allocate(29);
                long i = 0L;
                while (i < this.capacity) {
                    byte isAvailable = in.readByte();
                    int hashCode = in.readInt();
                    long keyOffset = in.readLong();
                    long valueOffset = in.readLong();
                    byte flags = in.readByte();
                    long nextEntryOffset = in.readLong();
                    if (isAvailable != 0 && isAvailable != 1) {
                        this.log.append("Unexpected DiskBackedHashMap table entry used flag with value " + isAvailable + " read at table cell " + i + "\n");
                    }
                    if (isAvailable == 0) {
                        boolean valueIsHeapADT;
                        ++found;
                        if ((flags & 0xFFFFFFFC) != 0) {
                            this.log.append("Unexpected DiskBackedHashMap table entry with flags " + flags + " read at table cell " + i + "\n");
                        }
                        if (((long)hashCode & 0xFFFFFFFFL) % this.capacity != i) {
                            this.log.append("The hash code for DiskBackedHashmap table entry at cell " + i + " is " + ((long)hashCode & 0xFFFFFFFFL) + " but capacity is " + this.capacity + "\n");
                        }
                        boolean keyIsHeapADT = (flags & 1) != 0;
                        boolean bl = valueIsHeapADT = (flags & 2) != 0;
                        if (nextEntryOffset < -1L || nextEntryOffset + 29L > max) {
                            this.log.append("Next DiskBackedHashMap entry is found at an impossible offset " + nextEntryOffset + " read at table cell " + i + "\n");
                            nextEntryOffset = -1L;
                        }
                        if (keyIsHeapADT) {
                            ++foundHeapADTs;
                        }
                        if (valueIsHeapADT) {
                            ++foundHeapADTs;
                        }
                        this.dbhmev.validateEntry(this.tablePtr + i * 30L, keyOffset, keyIsHeapADT, valueOffset, valueIsHeapADT, hashCode, raf);
                        while (nextEntryOffset != -1L) {
                            this.hv.claim(new HeapValidator.HeapClaimant(nextEntryOffset, 29L, "DiskBackedHashMap linked entry"));
                            linkedEntry.rewind();
                            FileChannelUtil.readFully((ByteBuffer)linkedEntry, (long)nextEntryOffset, (RAFWrapper)raf, (boolean)true);
                            linkedEntry.rewind();
                            hashCode = linkedEntry.getInt();
                            keyOffset = linkedEntry.getLong();
                            valueOffset = linkedEntry.getLong();
                            flags = linkedEntry.get();
                            long nextNextEntryOffset = linkedEntry.getLong();
                            ++found;
                            if ((flags & 0xFFFFFFFC) != 0) {
                                this.log.append("Unexpected DiskBackedHashMap linked entry with flags " + flags + " read at table cell " + i + ", offset " + nextEntryOffset + "\n");
                            }
                            if (((long)hashCode & 0xFFFFFFFFL) % this.capacity != i) {
                                this.log.append("The hash code for DiskBackedHashmap linked entry " + nextEntryOffset + " at table cell " + i + " is " + ((long)hashCode & 0xFFFFFFFFL) + " but capacity is " + this.capacity + "\n");
                            }
                            keyIsHeapADT = (flags & 1) != 0;
                            valueIsHeapADT = (flags & 2) != 0;
                            long curOff = nextEntryOffset;
                            if (nextNextEntryOffset < -1L || nextNextEntryOffset + 29L > max) {
                                this.log.append("Next DiskBackedHashMap entry is found at an impossible offset " + nextNextEntryOffset + " read at table cell " + i + ", offset " + nextEntryOffset + "\n");
                                nextEntryOffset = -1L;
                            } else {
                                nextEntryOffset = nextNextEntryOffset;
                            }
                            if (keyIsHeapADT) {
                                ++foundHeapADTs;
                            }
                            if (valueIsHeapADT) {
                                ++foundHeapADTs;
                            }
                            this.dbhmev.validateEntry(curOff, keyOffset, keyIsHeapADT, valueOffset, valueIsHeapADT, hashCode, raf);
                        }
                    }
                    ++i;
                }
                if (this.size != found) {
                    this.log.append("The persisted size is " + this.size + " but found " + found + " entries while traversing the DiskBackedHashMap\n");
                }
                if (this.numHeapADTs != foundHeapADTs) {
                    this.log.append("The persisted number of Heap ADTs is " + this.numHeapADTs + " but found " + foundHeapADTs + " while traversing the DiskBackedHashMap\n");
                }
            }
            catch (IOException e) {
                this.logThrowable(e);
            }
        }
        finally {
            this.dbhmev.endValidation();
        }
    }

    public void cleanUp() {
    }

    protected void logThrowable(Throwable e) {
        CharArrayWriter out = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(out);
        e.printStackTrace(pw);
        pw.flush();
        this.log.append(out.toCharArray());
    }
}

