/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.validator;

import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.HeapValidator;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import com.ibm.team.internal.repository.rcp.util.StringCoder;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Type;
import com.ibm.team.scm.common.ContentHash;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import org.eclipse.emf.ecore.EClass;

public class DiskBackedHashMapEntriesValidator {
    public static final long NULL_PTR = -1L;
    protected HeapValidator hv;
    protected GlobalMetadataValidator gv;
    protected StringBuilder log;
    protected File keysF;
    protected PersistentDiskBackedHashMap<Object, KeyInfo> keys;
    protected ByteBuffer buf;
    protected long currentOffset;

    public DiskBackedHashMapEntriesValidator(HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        this.hv = hv;
        this.gv = gv;
        this.buf = ByteBuffer.allocate(1024);
        this.keysF = File.createTempFile("keys", null);
        boolean success = false;
        try {
            this.keys = new PersistentDiskBackedHashMap<Object, KeyInfo>(this.keysF){

                protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                    return new ObjectInputStream(in).readObject();
                }
            };
            success = true;
        }
        finally {
            if (!success) {
                this.cleanUp();
            }
        }
    }

    public void beginValidation() throws IOException {
        this.log = this.hv.getLog();
        this.buf.clear();
        this.currentOffset = 0L;
    }

    protected void setPosition(long pos) {
        this.buf.clear();
        this.buf.limit(0);
        this.currentOffset = pos;
    }

    protected long getPosition() {
        return this.currentOffset - (long)this.buf.remaining();
    }

    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        if (keyOffset != -1L && (keyOffset < 0L || keyOffset >= this.hv.getWorkingAreaSize())) {
            this.log.append("The item info key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
        }
        if (valueOffset != -1L && (valueOffset < 0L || valueOffset > this.hv.getWorkingAreaSize())) {
            this.log.append("The inverse item info value pointer is at an impossible location " + valueOffset + " at " + entryOffset + "\n");
        }
    }

    protected void addKey(Object key, long entryOffset, long keyOffset, String mapDesc) {
        KeyInfo oldKey = (KeyInfo)this.keys.put(key, (Object)new KeyInfo(key, keyOffset, entryOffset));
        if (oldKey != null) {
            this.log.append("The " + mapDesc + " map contains multiple references to the same key: (");
            this.log.append(oldKey.key + " at offset " + oldKey.keyOffset + " entry " + oldKey.entryOffset);
            this.log.append(") and (" + key + " at offset " + keyOffset + " entry " + entryOffset + ")\n");
        }
    }

    protected FileLineDelimiter validateLineDelimeter(int value, String fieldDesc, long fieldOffset, String strDesc) {
        FileLineDelimiter result = FileLineDelimiter.getLineDelimiter((int)value);
        if (result == null) {
            this.log.append("The " + fieldDesc + " contains an invalid " + strDesc + " \"" + value + "\" at offset " + fieldOffset + "\n");
        }
        return result;
    }

    protected String validateHandle(String fieldDesc, long fieldOffset, String strDesc, RAFWrapper raf) throws IOException {
        String str = this.validateString(fieldDesc, fieldOffset, strDesc, raf);
        if (str == null) {
            return null;
        }
        int idx = str.indexOf(124);
        if (idx == -1) {
            if (!this.isValidUUID(str)) {
                this.log.append("The " + fieldDesc + " contains an invalid " + strDesc + " \"" + str + "\" at offset " + fieldOffset + "\n");
            }
        } else {
            if (!this.isValidUUID(str.substring(0, idx))) {
                this.log.append("The " + fieldDesc + " contains an invalid " + strDesc + " item id \"" + str + "\" at offset " + fieldOffset + "\n");
            }
            if (!this.isValidUUID(str.substring(idx + 1))) {
                this.log.append("The " + fieldDesc + " contains an invalid " + strDesc + " state id\"" + str + "\" at offset " + fieldOffset + "\n");
            }
        }
        return str;
    }

    protected boolean isValidUUID(String s) {
        if (s != s.trim()) {
            return false;
        }
        try {
            UUID.valueOf((String)s);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        switch (s.charAt(s.length() - 1)) {
            case 'A': 
            case 'Q': 
            case 'g': 
            case 'w': {
                return true;
            }
        }
        return false;
    }

    protected void validateItemType(String name, String ns, Object type, String fieldDesc, long fieldOffset, String strDesc) {
        if (name == null || ns == null) {
            return;
        }
        IItemType t = IItemType.IRegistry.INSTANCE.getItemType(name, ns);
        if (t == null) {
            this.log.append("The " + fieldDesc + " contains an invalid " + strDesc + " \"" + ns + "#" + name + "\" at offset " + fieldOffset + "\n");
            return;
        }
        if (t.isAbstract()) {
            this.log.append("The " + fieldDesc + " contains a " + strDesc + " \"" + ns + "#" + name + "\" at offset " + fieldOffset + " that is abstract\n");
        }
        if (type instanceof Type) {
            Type baseType = (Type)type;
            EClass cls = ItemUtil.getTypeEClass((Type)((Type)t));
            EClass base = ItemUtil.getTypeEClass((Type)baseType);
            if (!base.isSuperTypeOf(cls)) {
                this.log.append("The " + fieldDesc + " contains a " + strDesc + " \"" + ns + "#" + name + "\" at offset " + fieldOffset + " that is not a subtype of \"" + baseType.getNamespaceURI() + "#" + baseType.getName() + "\"\n");
            }
        } else {
            boolean isAssignableFrom;
            Class base = (Class)type;
            EClass cls = ItemUtil.getTypeEClass((Type)((Type)t));
            boolean bl = isAssignableFrom = !base.isAssignableFrom(cls.getInstanceClass());
            if (isAssignableFrom) {
                this.log.append("The " + fieldDesc + " contains a " + strDesc + " \"" + ns + "#" + name + "\" at offset " + fieldOffset + " that is not a subtype of \"" + base.getName() + "\"\n");
            }
        }
    }

    protected String validateUUID(String fieldDesc, long fieldOffset, String strDesc, RAFWrapper raf) throws IOException {
        String str = this.validateString(fieldDesc, fieldOffset, strDesc, raf);
        if (str == null) {
            return null;
        }
        if (!this.isValidUUID(str)) {
            this.log.append("The " + fieldDesc + " contains an invalid " + strDesc + " \"" + str + "\" at offset " + fieldOffset + "\n");
        }
        return str;
    }

    protected int validateByte(String fieldDesc, long fieldOffset, String strDesc, RAFWrapper raf) throws IOException {
        if (this.getPosition() >= this.hv.getWorkingAreaSize()) {
            this.log.append("The " + fieldDesc + " pointer at " + fieldOffset + " does not have enough room to store the byte field " + strDesc + "\n");
            return -1;
        }
        if (this.buf.remaining() == 0) {
            this.buf.compact();
            do {
                int read;
                if ((read = raf.getFile().getChannel().read(this.buf, this.currentOffset)) == -1) {
                    throw new EOFException();
                }
                this.currentOffset += (long)read;
            } while (this.buf.position() == 0);
            this.buf.flip();
        }
        return this.buf.get() & 0xFF;
    }

    protected long validateInt(String fieldDesc, long fieldOffset, String strDesc, RAFWrapper raf) throws IOException {
        if (this.getPosition() + 4L > this.hv.getWorkingAreaSize()) {
            this.log.append("The " + fieldDesc + " pointer at " + fieldOffset + " does not have enough room to store the int field " + strDesc + "\n");
            return -1L;
        }
        if (this.buf.remaining() < 4) {
            this.buf.compact();
            do {
                int read;
                if ((read = raf.getFile().getChannel().read(this.buf, this.currentOffset)) == -1) {
                    throw new EOFException();
                }
                this.currentOffset += (long)read;
            } while (this.buf.position() < 4);
            this.buf.flip();
        }
        return (long)this.buf.getInt() & 0xFFFFFFFFL;
    }

    protected long validateShort(String fieldDesc, long fieldOffset, String strDesc, RAFWrapper raf) throws IOException {
        if (this.getPosition() + 2L > this.hv.getWorkingAreaSize()) {
            this.log.append("The " + fieldDesc + " pointer at " + fieldOffset + " does not have enough room to store the short field " + strDesc + "\n");
            return -1L;
        }
        if (this.buf.remaining() < 2) {
            this.buf.compact();
            do {
                int read;
                if ((read = raf.getFile().getChannel().read(this.buf, this.currentOffset)) == -1) {
                    throw new EOFException();
                }
                this.currentOffset += (long)read;
            } while (this.buf.position() < 2);
            this.buf.flip();
        }
        return (long)this.buf.getShort() & 0xFFFFL;
    }

    protected long[] validateLong(String fieldDesc, long fieldOffset, String strDesc, RAFWrapper raf) throws IOException {
        if (this.getPosition() + 8L > this.hv.getWorkingAreaSize()) {
            this.log.append("The " + fieldDesc + " pointer at " + fieldOffset + " does not have enough room to store the long field " + strDesc + "\n");
            return new long[]{-1L, -1L};
        }
        if (this.buf.remaining() < 8) {
            this.buf.compact();
            do {
                int read;
                if ((read = raf.getFile().getChannel().read(this.buf, this.currentOffset)) == -1) {
                    throw new EOFException();
                }
                this.currentOffset += (long)read;
            } while (this.buf.position() < 8);
            this.buf.flip();
        }
        long[] lArray = new long[2];
        lArray[0] = this.buf.getLong();
        return lArray;
    }

    protected String validateString(String fieldDesc, long fieldOffset, String strDesc, RAFWrapper raf) throws IOException {
        String str;
        if (this.getPosition() + 2L > this.hv.getWorkingAreaSize()) {
            this.log.append("The " + fieldDesc + " pointer at " + fieldOffset + " does not have enough room to store the length field for " + strDesc + "\n");
            return null;
        }
        if (this.buf.remaining() < 2) {
            this.buf.compact();
            while (this.buf.position() < 2) {
                int read = raf.getFile().getChannel().read(this.buf, this.currentOffset);
                if (read == -1) {
                    throw new EOFException();
                }
                this.currentOffset += (long)read;
            }
            this.buf.flip();
        }
        int length = this.buf.getShort() & 0xFFFF;
        if (this.getPosition() + (long)length > this.hv.getWorkingAreaSize()) {
            this.log.append("The " + fieldDesc + " contains a " + strDesc + " length of impossible size " + length + " at offset " + fieldOffset + "\n");
            return null;
        }
        if (length == 0) {
            return "";
        }
        byte[] uuid = new byte[length + 2];
        uuid[0] = (byte)(length >> 8);
        uuid[1] = (byte)length;
        int read = Math.min(length, this.buf.remaining());
        this.buf.get(uuid, 2, read);
        while (read != length) {
            this.buf.compact();
            int currRead = raf.getFile().getChannel().read(this.buf, this.currentOffset);
            if (currRead == -1) {
                throw new EOFException();
            }
            this.currentOffset += (long)currRead;
            this.buf.flip();
            currRead = Math.min(length - read, currRead);
            this.buf.get(uuid, read + 2, currRead);
            read += currRead;
        }
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(uuid));
            str = in.readUTF();
        }
        catch (UTFDataFormatException e) {
            this.log.append("The " + fieldDesc + " contains a " + strDesc + " of length " + length + " at offset " + fieldOffset + " that is not a valid UTF-8 byte sequence\n");
            return null;
        }
        return str;
    }

    protected ContentHash validateContentHash(String fieldDesc, long fieldOffset, String strDesc, RAFWrapper raf) throws IOException {
        String hash = this.validateString(fieldDesc, fieldOffset, strDesc, raf);
        if (hash == null) {
            return null;
        }
        if (hash.length() != 43) {
            this.log.append("The " + fieldDesc + " contains the " + strDesc + ": \"" + hash + "\" of length " + hash.length() + " at offset " + fieldOffset + " that is not a valid hash length\n");
            return null;
        }
        if (!StringCoder.isValidCode((String)hash)) {
            this.log.append("The " + fieldDesc + " contains the " + strDesc + ": \"" + hash + "\"" + " at offset " + fieldOffset + " that is not a valid hash\n");
            return null;
        }
        return ContentHash.valueOf((String)hash);
    }

    public void endValidation() {
        this.keys.clear();
    }

    public void cleanUp() throws IOException {
        this.buf = null;
        if (this.keysF != null) {
            try {
                if (this.keys != null) {
                    this.keys.close();
                    this.keys = null;
                }
            }
            finally {
                this.keysF.delete();
            }
        }
    }

    protected void logThrowable(Throwable e) {
        CharArrayWriter out = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(out);
        e.printStackTrace(pw);
        pw.flush();
        this.log.append(out.toCharArray());
    }

    public boolean validateCustomMetadata(DataInputStream in) throws IOException {
        return true;
    }

    protected static class KeyInfo
    implements Serializable {
        private static final long serialVersionUID = -1092621090890727314L;
        protected Object key;
        protected long keyOffset;
        protected long entryOffset;

        public KeyInfo(Object key, long keyOffset, long entryOffset) {
            this.key = key;
            this.keyOffset = keyOffset;
            this.entryOffset = entryOffset;
        }

        public Object getKey() {
            return this.key;
        }

        public long getEntryOffset() {
            return this.entryOffset;
        }

        public long getKeyOffset() {
            return this.keyOffset;
        }
    }
}

