/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.migration;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.BTreeContentValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.BTreeValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.DiskBackedHashMapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.HeapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.SharingDescriptorsMapValidator;
import com.ibm.team.filesystem.client.internal.core.SharingMetadataFactory;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.File;
import java.io.IOException;

public class MigrationUtil {
    public static GlobalMetadataValidator.SharingInfoWrapper[] readOldSharingDescriptors(ILocation cfaRoot) throws IOException {
        if (!CopyFileAreaManager.instance.hasOldMetaDataFolder(cfaRoot)) {
            return new GlobalMetadataValidator.SharingInfoWrapper[0];
        }
        boolean caseSensitive = cfaRoot.isCaseSensitive();
        ILocation workspaceMetadata = SharingMetadataFactory.getOldMetadataPathForRoot(cfaRoot);
        File workspaceMetadataFile = new File(workspaceMetadata.toOSString());
        GlobalMetadataValidator gv = new GlobalMetadataValidator();
        HeapValidator hv = null;
        BTreeContentValidator btc = null;
        BTreeValidator btv = null;
        SharingDescriptorsMapValidator sdmv = null;
        try {
            hv = new HeapValidator();
            btc = new BTreeContentValidator(hv);
            btv = new BTreeValidator(hv, btc);
            sdmv = new SharingDescriptorsMapValidator(workspaceMetadataFile, caseSensitive, hv, gv);
            File descFile = new File(workspaceMetadataFile, ".descriptors.dat");
            RAFWrapper raf = new RAFWrapper(descFile, "r");
            StringBuilder buf = new StringBuilder();
            gv.beginValidation(caseSensitive);
            try {
                hv.beginValidation(descFile, raf, buf);
                try {
                    btv.beginValidation(raf);
                    new DiskBackedHashMapValidator(hv, sdmv, raf).cleanUp();
                }
                finally {
                    btv.endValidation();
                }
            }
            finally {
                try {
                    hv.endValidation(true);
                }
                finally {
                    raf.getFile().close();
                }
            }
            GlobalMetadataValidator.SharingInfoWrapper[] sharingInfoWrapperArray = gv.getSharingInfos();
            return sharingInfoWrapperArray;
        }
        finally {
            StringBuilder b = new StringBuilder();
            gv.endValidation(b);
            try {
                gv.cleanup();
            }
            catch (IOException iOException) {}
            if (hv != null) {
                try {
                    hv.cleanUp();
                }
                catch (IOException iOException) {}
            }
            if (btv != null) {
                try {
                    btv.cleanUp();
                }
                catch (IOException iOException) {}
            }
            if (btc != null) {
                try {
                    btc.cleanUp();
                }
                catch (IOException iOException) {}
            }
            if (sdmv != null) {
                try {
                    sdmv.cleanUp();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

