/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.migration;

import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.ChangedInfosValue;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.ForwardInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.InverseInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.ItemComponentConnection;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.LoadedComponent;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.ValidationItemHandle;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.WCChangedInfoKey;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.LocaleUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GlobalMetadataValidator {
    protected boolean isCaseSensitive;
    protected File lcf;
    protected PersistentDiskBackedHashMap<LoadedComponent, Object> loadedComponents;
    protected File sif;
    protected PersistentDiskBackedHashMap<IRelativeLocation, SharingInfoWrapper> sharingInfo;
    protected File isif;
    protected PersistentDiskBackedHashMap<ItemComponentConnection, IRelativeLocation> inverseSharingInfo;
    protected File cif;
    protected PersistentDiskBackedHashMap<WCChangedInfoKey, ChangedInfosValue> changedItems;
    protected File fif;
    protected PersistentDiskBackedHashMap<String, ForwardInfoWrapper> forwardInfo;
    protected File ifif;
    protected PersistentDiskBackedHashMap<ItemComponentConnection, String> inverseForwardInfo;
    protected File iif;
    protected PersistentDiskBackedHashMap<ItemComponentConnection, InverseInfo> inverseInfo;
    protected File vif;
    protected PersistentDiskBackedHashMap<ItemComponentConnection, String> visitedItems;
    protected boolean descriptorsComplete;
    protected String descriptorsFN;
    protected boolean inverseItemInfosComplete;
    protected String inverseItemInfosFN;
    protected boolean loadedComponentsComplete;
    protected String loadedComponentsFN;
    protected boolean metadataComplete;
    protected String metadataFN;
    protected boolean persistentMetadataComplete;
    protected String persistentMetadataFN;
    protected boolean metadataCorrupt;
    protected String metadataCorruptFN;

    public void beginValidation(boolean isCaseSensitive) throws IOException {
        this.isCaseSensitive = isCaseSensitive;
        this.descriptorsComplete = false;
        this.inverseItemInfosComplete = false;
        this.loadedComponentsComplete = false;
        this.metadataComplete = false;
        this.persistentMetadataComplete = false;
        this.metadataCorrupt = false;
        if (isCaseSensitive) {
            this.descriptorsFN = ".descriptors.isComplete";
            this.inverseItemInfosFN = ".inverseItemInfos.isComplete";
            this.loadedComponentsFN = ".loadedComponents.isComplete";
            this.metadataFN = ".metadata.isComplete";
            this.persistentMetadataFN = ".persistentMetadata.isComplete";
            this.metadataCorruptFN = ".isCorrupt";
        } else {
            this.descriptorsFN = ".descriptors.iscomplete";
            this.inverseItemInfosFN = ".inverseiteminfos.iscomplete";
            this.loadedComponentsFN = ".loadedcomponents.iscomplete";
            this.metadataFN = ".metadata.iscomplete";
            this.persistentMetadataFN = ".persistentmetadata.iscomplete";
            this.metadataCorruptFN = ".iscorrupt";
        }
        this.lcf = File.createTempFile("loadedcomponents", null);
        this.loadedComponents = new PersistentDiskBackedHashMap<LoadedComponent, Object>(this.lcf){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        this.sif = File.createTempFile("sharinginfo", null);
        this.sharingInfo = new PersistentDiskBackedHashMap<IRelativeLocation, SharingInfoWrapper>(this.sif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        this.cif = File.createTempFile("changeditems", null);
        this.changedItems = new PersistentDiskBackedHashMap<WCChangedInfoKey, ChangedInfosValue>(this.cif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        this.fif = File.createTempFile("forwardinfo", null);
        this.forwardInfo = new PersistentDiskBackedHashMap<String, ForwardInfoWrapper>(this.fif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        this.iif = File.createTempFile("inverseinfo", null);
        this.inverseInfo = new PersistentDiskBackedHashMap<ItemComponentConnection, InverseInfo>(this.iif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
    }

    public boolean addFlag(String fn) {
        if (!this.isCaseSensitive) {
            fn = LocaleUtil.fileSystemNormalization((String)fn);
        }
        if (this.descriptorsFN.equals(fn)) {
            this.descriptorsComplete = true;
            return true;
        }
        if (this.inverseItemInfosFN.equals(fn)) {
            this.inverseItemInfosComplete = true;
            return true;
        }
        if (this.loadedComponentsFN.equals(fn)) {
            this.loadedComponentsComplete = true;
            return true;
        }
        if (this.metadataFN.equals(fn)) {
            this.metadataComplete = true;
            return true;
        }
        if (this.persistentMetadataFN.equals(fn)) {
            this.persistentMetadataComplete = true;
            return true;
        }
        if (this.metadataCorruptFN.equals(fn)) {
            this.metadataCorrupt = true;
            return true;
        }
        return false;
    }

    public void addLoadedComponent(LoadedComponent lc) throws IOException {
        this.loadedComponents.put((Object)lc, null);
    }

    public void addSharingDescriptor(IRelativeLocation path, com.ibm.team.filesystem.client.internal.copyfileareas.migration.SharingDescriptor desc) throws IOException {
        IRelativeLocation normal = path;
        if (!this.isCaseSensitive) {
            normal = path.getCanonicalForm(this.isCaseSensitive, true);
        }
        this.sharingInfo.put((Object)normal, (Object)new SharingInfoWrapper(path, desc));
    }

    public void addModifiedInfo(WCChangedInfoKey key, ChangedInfosValue value) throws IOException {
        this.changedItems.put((Object)key, (Object)value);
    }

    public void addForwardInfo(IPath path, ForwardInfo info) throws IOException {
        String sPath;
        String normal = sPath = path.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator().toString();
        if (!this.isCaseSensitive) {
            normal = LocaleUtil.fileSystemNormalization((String)sPath);
        }
        this.forwardInfo.put((Object)normal, (Object)new ForwardInfoWrapper(sPath, info));
    }

    public void addInverseInfo(ItemComponentConnection key, InverseInfo info) throws IOException {
        this.inverseInfo.put((Object)key, (Object)info);
    }

    public void endValidation(StringBuilder log) throws IOException {
        this.validateFlags(log);
        this.buildInverseForwardInfoMap(log);
        this.checkInverseForwardMapAgreement(log);
        this.checkParentChildAgreement(log);
        this.checkRemoteTreeConsistency(log);
        this.checkChangesInverseMapAgreement(log);
    }

    protected void validateFlags(StringBuilder log) {
        if (!this.descriptorsComplete) {
            log.append("The sharing descriptors map is not marked as complete\n");
        }
        if (!this.inverseItemInfosComplete) {
            log.append("The inverse item infos map is not marked as complete\n");
        }
        if (!this.loadedComponentsComplete) {
            log.append("The loaded descriptors map is not marked as complete\n");
        }
        if (!this.metadataComplete) {
            log.append("The forward item infos map is not marked as complete\n");
        }
        if (!this.persistentMetadataComplete) {
            log.append("The changed items map is not marked as complete\n");
        }
        if (this.metadataCorrupt) {
            log.append("The metadata is marked as corrupt\n");
        }
    }

    protected void buildInverseForwardInfoMap(StringBuilder log) throws IOException {
        this.ifif = File.createTempFile("inverseforwardinfo", null);
        this.inverseForwardInfo = new PersistentDiskBackedHashMap<ItemComponentConnection, String>((long)(this.forwardInfo.size() * 4 / 3), this.ifif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        for (Map.Entry e : this.forwardInfo.entrySet()) {
            String normalPath = (String)e.getKey();
            SharingInfoWrapper siw = this.getSharingInfo(normalPath);
            ForwardInfoWrapper fiw = (ForwardInfoWrapper)e.getValue();
            if (siw == null) {
                log.append("Failed to find sharing descriptor for " + (fiw.info.isFolder() ? "folder" : "file") + " " + fiw.info.getItemId() + " at \"" + fiw.path + "\"\n");
                continue;
            }
            ItemComponentConnection icc = new ItemComponentConnection();
            icc.setComponentId(siw.desc.getComponent().getItemId().getUuidValue());
            icc.setConnectionId(siw.desc.getConnectionHandle().getItemId().getUuidValue());
            icc.setConnectionType(siw.desc.getConnectionHandle().getItemType().getName());
            icc.setConnectionTypeNS(siw.desc.getConnectionHandle().getItemType().getNamespaceURI());
            icc.setItemId(fiw.info.getItemId());
            String oldPath = (String)this.inverseForwardInfo.put((Object)icc, (Object)normalPath);
            if (oldPath != null) {
                ForwardInfoWrapper oldFiw = (ForwardInfoWrapper)this.forwardInfo.get((Object)oldPath);
                log.append("The " + (fiw.info.isFolder() ? "folder" : "file") + " " + fiw.info.getItemId() + " of component " + siw.desc.getComponent().getItemId().getUuidValue() + " (" + siw.desc.getComponentName() + ") of " + siw.desc.getConnectionHandle().getItemType().getNamespaceURI() + "#" + siw.desc.getConnectionHandle().getItemType().getName() + " " + siw.desc.getConnectionHandle().getItemId().getUuidValue() + " (" + siw.desc.getConnectionName() + ") is shared at \"" + siw.path + "\" but conflicts with " + (oldFiw.info.isFolder() ? "folder" : "file") + " shared at \"" + oldFiw.path + "\"\n");
            }
            if (this.inverseInfo.containsKey((Object)icc)) continue;
            log.append("The " + (fiw.info.isFolder() ? "folder" : "file") + " " + fiw.info.getItemId() + " of component " + siw.desc.getComponent().getItemId().getUuidValue() + " (" + siw.desc.getComponentName() + ") of " + siw.desc.getConnectionHandle().getItemType().getNamespaceURI() + "#" + siw.desc.getConnectionHandle().getItemType().getName() + " " + siw.desc.getConnectionHandle().getItemId().getUuidValue() + " (" + siw.desc.getConnectionName() + ") is shared at \"" + siw.path + "\" but has no inverse info\n");
        }
    }

    protected void checkInverseForwardMapAgreement(StringBuilder log) throws IOException {
        for (Map.Entry e : this.inverseInfo.entrySet()) {
            ItemComponentConnection icc = (ItemComponentConnection)e.getKey();
            InverseInfo ii = (InverseInfo)e.getValue();
            boolean isShareRoot = this.inverseSharingInfo.containsKey((Object)icc);
            String path = (String)this.inverseForwardInfo.get((Object)icc);
            ForwardInfoWrapper fiw = null;
            if (path != null) {
                fiw = (ForwardInfoWrapper)this.forwardInfo.get((Object)path);
            }
            if (isShareRoot) {
                if (ii.getStateId() == null) {
                    log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" is a share root but does not have a state id\n");
                }
            } else if (ii.getStateId() != null && ii.getRemoteParentId() == null) {
                log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" is not a share root, has a state id but no remote parent\n");
            }
            if (isShareRoot || ii.getLocalParentId() != null) {
                if (fiw == null) {
                    log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" " + (isShareRoot ? "is a share root" : "has local parent " + ii.getLocalParentId()) + " but does not have forward info\n");
                    continue;
                }
                this.compareInfos(fiw, path, ii, icc, log);
                continue;
            }
            if (fiw != null) {
                log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" does not have a local parent, but appears in the forward map at \"" + fiw.path + "\"\n");
            }
            if (ii.getRemoteParentId() != null) continue;
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" does not have a remote or local parent and is not a share root\n");
        }
    }

    protected void compareInfos(ForwardInfoWrapper fiw, String normalizedPath, InverseInfo ii, ItemComponentConnection icc, StringBuilder log) throws IOException {
        Path path;
        boolean isShareRoot;
        if (fiw.info.isFolder() != ii.isFolder()) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" is marked as " + (fiw.info.isFolder() ? "folder" : "file") + " in the forward map\n");
        }
        if (fiw.info.getStateId() == null && ii.getStateId() != null || fiw.info.getStateId() != null && !fiw.info.getStateId().equals(ii.getStateId())) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has state id " + ii.getStateId() + " in the inverse map but state id " + fiw.info.getStateId() + " in the forward map\n");
        }
        if (fiw.info.getLastModification() != ii.getLastModification()) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has modification stamp " + ii.getLastModification() + " in the inverse map but modification stamp " + fiw.info.getLastModification() + " in the forward map\n");
        }
        if (fiw.info.getRemoteParentId() == null && ii.getRemoteParentId() != null || fiw.info.getRemoteParentId() != null && !fiw.info.getRemoteParentId().equals(ii.getRemoteParentId())) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote parent id " + ii.getRemoteParentId() + " in the inverse map but remote parent id " + fiw.info.getRemoteParentId() + " in the forward map\n");
        }
        if (fiw.info.getRemoteName() == null && ii.getRemoteName() != null || fiw.info.getRemoteName() != null && !fiw.info.getRemoteName().equals(ii.getRemoteName())) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote name \"" + ii.getRemoteName() + "\" in the inverse map but remote name \"" + fiw.info.getRemoteName() + "\" in the forward map\n");
        }
        if (fiw.info.getLocalSize() != ii.getLocalSize()) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local size " + ii.getLocalSize() + " in the inverse map but local size " + fiw.info.getLocalSize() + " in the forward map\n");
        }
        if (fiw.info.getLocalChecksum() == null && ii.getLocalChecksum() != null || fiw.info.getLocalChecksum() != null && !fiw.info.getLocalChecksum().equals((Object)ii.getLocalChecksum())) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local checksum " + (ii.getLocalChecksum() == null ? "null" : Long.valueOf(ii.getLocalChecksum().getValue())) + " in the inverse map but local checksum " + (fiw.info.getLocalChecksum() == null ? "null" : Long.valueOf(fiw.info.getLocalChecksum().getValue())) + " in the forward map\n");
        }
        if (fiw.info.getLocalLineDelimiter() != ii.getLocalLineDelimiter()) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local line delimiter " + ii.getLocalLineDelimiter() + " in the inverse map but local line delimiter " + fiw.info.getLocalLineDelimiter() + " in the forward map\n");
        }
        if (fiw.info.getRemoteLineDelimiter() != ii.getRemoteLineDelimiter()) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote line delimiter " + ii.getRemoteLineDelimiter() + " in the inverse map but remote line delimiter " + fiw.info.getRemoteLineDelimiter() + " in the forward map\n");
        }
        if (fiw.info.getLocalContentType() == null && ii.getLocalContentType() != null || fiw.info.getLocalContentType() != null && !fiw.info.getLocalContentType().equals(ii.getLocalContentType())) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local content type \"" + ii.getLocalContentType() + "\" in the inverse map but local content type \"" + fiw.info.getLocalContentType() + "\" in the forward map\n");
        }
        if (fiw.info.getRemoteContentType() == null && ii.getRemoteContentType() != null || fiw.info.getRemoteContentType() != null && !fiw.info.getRemoteContentType().equals(ii.getRemoteContentType())) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote content type \"" + ii.getRemoteContentType() + "\" in the inverse map but remote content type \"" + fiw.info.getRemoteContentType() + "\" in the forward map\n");
        }
        if (fiw.info.getContentId() == null && ii.getContentId() != null || fiw.info.getContentId() != null && !fiw.info.getContentId().equals(ii.getContentId())) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has content id " + ii.getContentId() + " in the inverse map but content id " + fiw.info.getContentId() + " in the forward map\n");
        }
        if (fiw.info.getDeltaPredecessor() == null && ii.getDeltaPredecessor() != null || fiw.info.getDeltaPredecessor() != null && !fiw.info.getDeltaPredecessor().equals(ii.getDeltaPredecessor())) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has delta predecessor " + ii.getDeltaPredecessor() + " in the inverse map but delta predecessor " + fiw.info.getDeltaPredecessor() + " in the forward map\n");
        }
        if (fiw.info.getRemoteSize() != ii.getRemoteSize()) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote size " + ii.getRemoteSize() + " in the inverse map but remote size " + fiw.info.getRemoteSize() + " in the forward map\n");
        }
        if (fiw.info.getRemoteEncoding() == null && ii.getRemoteEncoding() != null || fiw.info.getRemoteEncoding() != null && !fiw.info.getRemoteEncoding().equals(ii.getRemoteEncoding())) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote encoding \"" + ii.getRemoteEncoding() + "\" in the inverse map but remote encoding \"" + fiw.info.getRemoteEncoding() + "\" in the forward map\n");
        }
        if (fiw.info.getRemoteChecksum() != ii.getRemoteChecksum()) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has remote checksum " + ii.getRemoteChecksum() + " in the inverse map but remote checksum " + fiw.info.getRemoteChecksum() + " in the forward map\n");
        }
        if (fiw.info.getNumLineDelimiters() != ii.getNumLineDelimiters()) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has " + ii.getNumLineDelimiters() + " line delimiters in the inverse map but " + fiw.info.getNumLineDelimiters() + " line delimiters in the forward map\n");
        }
        if (fiw.info.isRemoteExecutable() != ii.isRemoteExecutable()) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" is marked as" + (ii.isRemoteExecutable() ? "" : " not") + " remotely executable in the inverse map but" + (fiw.info.isRemoteExecutable() ? "" : " not") + " remotely executable in the forward map\n");
        }
        if (fiw.info.isLocalExecutable() != ii.isLocalExecutable()) {
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" is marked as" + (ii.isLocalExecutable() ? "" : " not") + " locally executable in the inverse map but" + (fiw.info.isLocalExecutable() ? "" : " not") + " locally executable in the forward map\n");
        }
        if (!(isShareRoot = this.sharingInfo.containsKey((Object)normalizedPath)) && (path = new Path(null, normalizedPath)).segmentCount() >= 1) {
            String localName;
            String localParentId;
            ForwardInfoWrapper parent = (ForwardInfoWrapper)this.forwardInfo.get((Object)path.removeLastSegments(1).toString());
            if (parent != null) {
                localParentId = parent.info.getItemId();
                localName = new Path(null, fiw.path).lastSegment();
            } else {
                localParentId = null;
                localName = null;
            }
            if (localParentId == null && ii.getLocalParentId() != null || localParentId != null && !localParentId.equals(ii.getLocalParentId())) {
                log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local parent " + ii.getLocalParentId() + " in the inverse map but local parent " + localParentId + " in the forward map\n");
            }
            if (localName == null && ii.getLocalName() != null || localName != null && !localName.equals(ii.getLocalName())) {
                log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " at local path \"" + fiw.path + "\" has local name \"" + ii.getLocalName() + "\" in the inverse map but local name \"" + localName + "\" in the forward map\n");
            }
        }
    }

    protected void checkParentChildAgreement(StringBuilder log) throws IOException {
        ItemComponentConnection picc = new ItemComponentConnection();
        for (Map.Entry e : this.inverseInfo.entrySet()) {
            ItemComponentConnection icc = (ItemComponentConnection)e.getKey();
            InverseInfo ii = (InverseInfo)e.getValue();
            boolean isShareRoot = this.inverseSharingInfo.containsKey((Object)icc);
            if (!isShareRoot) {
                InverseInfo parent;
                if (ii.getRemoteParentId() != null) {
                    picc.setComponentId(icc.getComponentId());
                    picc.setConnectionId(icc.getConnectionId());
                    picc.setConnectionType(icc.getConnectionType());
                    picc.setConnectionTypeNS(icc.getConnectionTypeNS());
                    picc.setItemId(ii.getRemoteParentId());
                    parent = (InverseInfo)this.inverseInfo.get((Object)picc);
                    if (parent == null) {
                        log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote parent " + ii.getRemoteParentId() + " but the inverse map does not have such an item\n");
                    } else {
                        ValidationItemHandle child;
                        if (!parent.isFolder()) {
                            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote parent " + ii.getRemoteParentId() + " but the parent is marked as a file in the inverse map\n");
                        }
                        if ((child = parent.getRemoteChildren().get(ii.getRemoteName())) == null) {
                            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote parent " + ii.getRemoteParentId() + " but the parent doesn't contain such a remote child\n");
                        } else if (!child.getItemId().equals(ii.getItemId())) {
                            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote parent " + ii.getRemoteParentId() + " but the parent contains a " + (child.isFolder() ? "folder " : "file ") + child.getItemId() + " at that path\n");
                        } else if (!child.isFolder() == ii.isFolder()) {
                            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote parent " + ii.getRemoteParentId() + " but the parent says it's a " + (child.isFolder() ? "folder\n" : "file\n"));
                        }
                    }
                }
                if (ii.getLocalParentId() != null) {
                    picc.setComponentId(icc.getComponentId());
                    picc.setConnectionId(icc.getConnectionId());
                    picc.setConnectionType(icc.getConnectionType());
                    picc.setConnectionTypeNS(icc.getConnectionTypeNS());
                    picc.setItemId(ii.getLocalParentId());
                    parent = (InverseInfo)this.inverseInfo.get((Object)picc);
                    if (parent == null) {
                        log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has local parent " + ii.getLocalParentId() + " but the inverse map does not have such an item\n");
                    } else {
                        if (!parent.isFolder()) {
                            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has local parent " + ii.getLocalParentId() + " but the parent is marked as a file in the inverse map\n");
                        }
                        if (parent.getLocalParentId() == null && !this.inverseSharingInfo.containsKey((Object)picc)) {
                            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has local parent " + ii.getLocalParentId() + " but the parent doesn't have a local parent and is not a share root\n");
                        }
                    }
                }
            }
            for (Map.Entry<String, ValidationItemHandle> ch : ii.getRemoteChildren().entrySet()) {
                IRelativeLocation sharePath;
                String name = ch.getKey();
                ValidationItemHandle child = ch.getValue();
                picc.setComponentId(icc.getComponentId());
                picc.setConnectionId(icc.getConnectionId());
                picc.setConnectionType(icc.getConnectionType());
                picc.setConnectionTypeNS(icc.getConnectionTypeNS());
                picc.setItemId(child.getItemId());
                if (!this.inverseInfo.containsKey((Object)picc)) {
                    log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote child " + (child.isFolder() ? "folder " : "file ") + child.getItemId() + " (" + name + ") but the inverse map doesn't contain info for it\n");
                }
                if ((sharePath = (IRelativeLocation)this.inverseSharingInfo.get((Object)picc)) == null) continue;
                sharePath = ((SharingInfoWrapper)this.sharingInfo.get((Object)sharePath)).path;
                log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote child " + (child.isFolder() ? "folder " : "file ") + child.getItemId() + " (" + name + ") but it is the root for the share at \"" + sharePath + "\"\n");
            }
        }
    }

    protected void checkRemoteTreeConsistency(StringBuilder log) throws IOException {
        this.vif = File.createTempFile("visiteditems", null);
        this.visitedItems = new PersistentDiskBackedHashMap<ItemComponentConnection, String>((long)(this.inverseInfo.size() * 4 / 3), this.vif){

            protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                return new ObjectInputStream(in).readObject();
            }
        };
        block0: for (Map.Entry e : this.inverseInfo.entrySet()) {
            ItemComponentConnection icc = (ItemComponentConnection)e.getKey();
            boolean hasChildren = false;
            InverseInfo ii = (InverseInfo)e.getValue();
            HashSet<String> visited = new HashSet<String>();
            while (this.visitedItems.put((Object)icc, (Object)"") == null) {
                if (!visited.add(icc.getItemId())) {
                    log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has a cycle in its remote tree structure\n");
                    continue block0;
                }
                boolean isShareRoot = this.inverseSharingInfo.containsKey((Object)icc);
                if (isShareRoot) continue block0;
                if (ii.getRemoteParentId() == null) {
                    if (!hasChildren) continue block0;
                    log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has remote children but no remote parent and it's not a share root\n");
                    continue block0;
                }
                hasChildren = true;
                ItemComponentConnection picc = new ItemComponentConnection();
                picc.setComponentId(icc.getComponentId());
                picc.setConnectionId(icc.getConnectionId());
                picc.setConnectionType(icc.getConnectionType());
                picc.setConnectionTypeNS(icc.getConnectionTypeNS());
                picc.setItemId(ii.getRemoteParentId());
                ii = (InverseInfo)this.inverseInfo.get((Object)picc);
                if (ii == null) continue block0;
                icc = picc;
            }
        }
    }

    protected void checkChangesInverseMapAgreement(StringBuilder log) throws IOException {
        for (Map.Entry e : this.inverseInfo.entrySet()) {
            ItemComponentConnection icc = (ItemComponentConnection)e.getKey();
            InverseInfo ii = (InverseInfo)e.getValue();
            WCChangedInfoKey key = new WCChangedInfoKey(icc.getComponentId(), icc.getConnectionId(), icc.getItemId(), ii.isFolder());
            ChangedInfosValue v = (ChangedInfosValue)this.changedItems.get((Object)key);
            boolean changed = this.isInverseChange(icc, ii);
            if (changed) {
                if (v == null || !v.isInverseMapChanged()) {
                    log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has an inverse map change but it is not marked in the change map\n");
                }
            } else if (v != null && v.isInverseMapChanged()) {
                log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" does not have an inverse map change but it is marked as changed in the change map\n");
            }
            if (ii.isFolder() || ii.getLastModification() != -1L || ii.getStateId() == null || ii.getLocalParentId() == null || v != null && v.isForwardMapChanged()) continue;
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has a null stamp but it is not marked in the change map\n");
        }
        for (Map.Entry e : this.changedItems.entrySet()) {
            WCChangedInfoKey key = (WCChangedInfoKey)e.getKey();
            ChangedInfosValue v = (ChangedInfosValue)e.getValue();
            ItemComponentConnection icc = new ItemComponentConnection();
            icc.setComponentId(key.getComponent());
            icc.setConnectionId(key.getConnection());
            icc.setItemId(key.getItemId());
            InverseInfo ii = (InverseInfo)this.inverseInfo.get((Object)icc);
            if (ii == null) {
                log.append("The " + (key.isFolder() ? "folder" : "file") + " " + key.getItemId() + " of component " + key.getComponent() + " of " + key.getConnection() + " does not have an inverse map entry but it is marked as changed in the change map\n");
                continue;
            }
            if (ii.isFolder() != key.isFolder()) {
                log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" is marked as a " + (key.isFolder() ? "folder" : "file") + "in the change map\n");
            }
            if (!v.isForwardMapChanged()) continue;
            if (this.inverseSharingInfo.containsKey((Object)icc)) {
                log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" is a share root but is marked has having a forward map change\n");
                continue;
            }
            if (ii.getLocalParentId() != null) continue;
            log.append("The " + (ii.isFolder() ? "folder" : "file") + " " + ii.getItemId() + " of component " + icc.getComponentId() + " of " + icc.getConnectionTypeNS() + "#" + icc.getConnectionType() + " " + icc.getConnectionId() + " local name: \"" + ii.getLocalName() + "\" remote name: \"" + ii.getRemoteName() + "\" has no local parent but is marked as having a forward map change\n");
        }
    }

    protected boolean isInverseChange(ItemComponentConnection icc, InverseInfo ii) {
        if (this.inverseSharingInfo.containsKey((Object)icc)) {
            return false;
        }
        if (ii.getLocalLineDelimiter() != ii.getRemoteLineDelimiter()) {
            return true;
        }
        if (ii.getLocalContentType() == null && ii.getRemoteContentType() != null || ii.getLocalContentType() != null && !ii.getLocalContentType().equals(ii.getRemoteContentType())) {
            return true;
        }
        if (ii.getLocalName() == null && ii.getRemoteName() != null || ii.getLocalName() != null && !ii.getLocalName().equals(ii.getRemoteName())) {
            return true;
        }
        return ii.getLocalParentId() == null && ii.getRemoteParentId() != null || ii.getLocalParentId() != null && !ii.getLocalParentId().equals(ii.getRemoteParentId());
    }

    protected SharingInfoWrapper getSharingInfo(String path) throws IOException {
        Path p = new Path(null, path);
        SharingInfoWrapper w;
        while ((w = (SharingInfoWrapper)this.sharingInfo.get((Object)p.toString())) == null) {
            if (p.segmentCount() == 0) {
                return null;
            }
            p = p.removeLastSegments(1);
        }
        return w;
    }

    public void cleanup() throws IOException {
        block788: {
            try {
                if (this.lcf == null) break block788;
                try {
                    if (this.loadedComponents != null) {
                        this.loadedComponents.close();
                    }
                }
                finally {
                    this.lcf.delete();
                }
            }
            finally {
                block789: {
                    try {
                        if (this.sif == null) break block789;
                        try {
                            if (this.sharingInfo != null) {
                                this.sharingInfo.close();
                            }
                        }
                        finally {
                            this.sif.delete();
                        }
                    }
                    finally {
                        block790: {
                            try {
                                if (this.isif == null) break block790;
                                try {
                                    if (this.inverseSharingInfo != null) {
                                        this.inverseSharingInfo.close();
                                    }
                                }
                                finally {
                                    this.isif.delete();
                                }
                            }
                            finally {
                                block791: {
                                    try {
                                        if (this.cif == null) break block791;
                                        try {
                                            if (this.changedItems != null) {
                                                this.changedItems.close();
                                            }
                                        }
                                        finally {
                                            this.cif.delete();
                                        }
                                    }
                                    finally {
                                        block792: {
                                            try {
                                                if (this.fif == null) break block792;
                                                try {
                                                    if (this.forwardInfo != null) {
                                                        this.forwardInfo.close();
                                                    }
                                                }
                                                finally {
                                                    this.fif.delete();
                                                }
                                            }
                                            finally {
                                                block793: {
                                                    try {
                                                        if (this.ifif == null) break block793;
                                                        try {
                                                            if (this.inverseForwardInfo != null) {
                                                                this.inverseForwardInfo.close();
                                                            }
                                                        }
                                                        finally {
                                                            this.ifif.delete();
                                                        }
                                                    }
                                                    finally {
                                                        block794: {
                                                            try {
                                                                if (this.iif == null) break block794;
                                                                try {
                                                                    if (this.inverseInfo != null) {
                                                                        this.inverseInfo.close();
                                                                    }
                                                                }
                                                                finally {
                                                                    this.iif.delete();
                                                                }
                                                            }
                                                            finally {
                                                                if (this.vif != null) {
                                                                    try {
                                                                        if (this.visitedItems != null) {
                                                                            this.visitedItems.close();
                                                                        }
                                                                    }
                                                                    finally {
                                                                        this.vif.delete();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected SharingInfoWrapper[] getSharingInfos() {
        return this.sharingInfo.values().toArray(new SharingInfoWrapper[this.sharingInfo.size()]);
    }

    protected static class ForwardInfoWrapper
    implements Serializable {
        private static final long serialVersionUID = -5447035710263334711L;
        public String path;
        public ForwardInfo info;

        public ForwardInfoWrapper(String path, ForwardInfo info) {
            this.path = path;
            this.info = info;
        }
    }

    public static class SharingInfoWrapper
    implements Serializable {
        private static final long serialVersionUID = -7255152426405908735L;
        public com.ibm.team.filesystem.client.internal.copyfileareas.migration.SharingDescriptor desc;
        public IRelativeLocation path;

        public SharingInfoWrapper(IRelativeLocation path, com.ibm.team.filesystem.client.internal.copyfileareas.migration.SharingDescriptor desc) {
            this.path = path;
            this.desc = desc;
        }

        public ISharingDescriptor getSharingDescriptor() {
            return new SharingDescriptor(this.desc.getRepositoryUri(), this.desc.getRepositoryId(), this.desc.getConnectionHandle(), this.desc.getConnectionName(), this.desc.getComponent(), this.desc.getComponentName(), (IVersionableHandle)this.desc.getRootFolder(), this.desc.getLoadRoot(), this.desc.getClientData());
        }
    }
}

