/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.metadata.validator;

import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.ForwardInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.InverseInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.ItemComponentConnection;
import com.ibm.team.filesystem.client.internal.copyfileareas.LoadedComponent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ValidationItemHandle;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.LocalConflictsMapValidator;
import com.ibm.team.filesystem.client.internal.core.SharingMetadata2;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.LocaleUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public class MetaDatasCollector
extends GlobalMetadataValidator {
    public static final String SECTION_METAMETA_DATE = "================= Metameta date ====================";
    public static final String SECTION_FORWARD_INFO = "================= Forward Info =====================";
    public static final String SECTION_INVERSE_SHARING_INFO = "================= Inverse Sharing Info =============";
    public static final String SECTION_SHARING_INFO = "================= Sharing info =====================";
    public static final String SECTION_COMPONENT = "================= .component =======================";
    public static final String SECTION_INVERSE_INFO = "================= Inverse Info =====================";
    public static final String TERMINATOR = "----------------------------------------------------";
    public static final String SUBSECTION_REMOTE_CHILDREN = "----- remote children ---------";
    public static final String SUBSECTION_CHANGED_PROPERTIES = "----- changed properties ------";
    public static final String SUBSECTION_ORIGINAL_PROPERTIES = "----- original properties -----";
    public static final String SECTION_LOCAL_CONCLICT = "================= Local Conflict =====================";
    public static final SimpleDateFormat DATE_RFC2822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
    private final PrintWriter writer;

    public MetaDatasCollector(PrintWriter out) {
        this.writer = out;
    }

    @Override
    public void addSharingDescriptor(IPath path, ISharingDescriptor desc, StringBuilder log) throws IOException {
        String sPath;
        super.addSharingDescriptor(path, desc, log);
        String normal = sPath = path.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator().toString();
        if (!this.isCaseSensitive) {
            normal = LocaleUtil.fileSystemNormalization((String)sPath);
        }
        this.dumpSharingInfo(normal, desc);
    }

    @Override
    public void addInverseSharingDescriptor(IPath path, SharingMetadata2.ShareRoot share, StringBuilder log) {
        String sPath;
        super.addInverseSharingDescriptor(path, share, log);
        ItemComponentConnection itemComponentConnection = new ItemComponentConnection(share);
        String normal = sPath = path.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator().toString();
        this.dumpInverseSharingInfo(itemComponentConnection, normal);
    }

    @Override
    public void addForwardInfo(IPath path, ForwardInfo info) throws IOException {
        String sPath;
        super.addForwardInfo(path, info);
        String normal = sPath = path.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator().toString();
        this.dumpForwardInfo(normal, info);
    }

    @Override
    public void addInverseInfo(ItemComponentConnection key, InverseInfo info) throws IOException {
        super.addInverseInfo(key, info);
        this.dumpInverseForwardInfo(key, info);
    }

    @Override
    public void addLoadedComponent(LoadedComponent lc) throws IOException {
        super.addLoadedComponent(lc);
        this.dumpComponent(lc);
    }

    @Override
    public void addLocalConflictInfo(ItemComponentConnection key, LocalConflictsMapValidator.LocalConflictValue info) throws IOException {
        super.addLocalConflictInfo(key, info);
        this.dumpLocalConflictInfo(key, info);
    }

    private void dumpComponent(LoadedComponent lc) {
        this.writer.println(SECTION_COMPONENT);
        this.writer.println("connection ID     : " + lc.getConnectionId());
        this.writer.println("connection type   : " + lc.getConnectionType());
        this.writer.println("connection type NS: " + lc.getConnectionTypeNS());
        this.writer.println("component ID      : " + lc.getComponentId());
        this.writer.println(TERMINATOR);
        this.writer.println();
    }

    @Override
    public void endValidation(StringBuilder log) throws IOException {
        super.endValidation(log);
        this.dumpMetametaDate();
    }

    private void dumpMetametaDate() {
        this.writer.println(SECTION_METAMETA_DATE);
        Date lastSandboxListenerEvent = this.getLastSandboxListenerEvent();
        if (lastSandboxListenerEvent != null) {
            this.writer.println(".metameta date: " + DATE_RFC2822.format(lastSandboxListenerEvent));
        }
        this.writer.println(TERMINATOR);
        this.writer.println();
    }

    private void dumpInverseForwardInfo(ItemComponentConnection itemComponentConnection, InverseInfo info) {
        this.writer.println(SECTION_INVERSE_INFO);
        this.writer.println("item ID             : " + itemComponentConnection.getItemId());
        this.writer.println("component ID        : " + itemComponentConnection.getComponentId());
        this.writer.println("connection ID       : " + itemComponentConnection.getConnectionId());
        this.writer.println("connection type     : " + itemComponentConnection.getConnectionType());
        this.dumpForwardInfo(info);
        this.writer.println("local parent ID     : " + info.getLocalParentId());
        this.writer.println("local name          : " + info.getLocalName());
        if (info.getRemovedProperties().size() > 0) {
            this.writer.println("removed properties: " + info.getRemovedProperties());
        }
        this.dumpProperties(this.writer, SUBSECTION_ORIGINAL_PROPERTIES, info.getOriginalProperties());
        this.dumpProperties(this.writer, SUBSECTION_CHANGED_PROPERTIES, info.getChangedProperties());
        Map<String, ValidationItemHandle> remoteChildren = info.getRemoteChildren();
        if (remoteChildren != null && !remoteChildren.isEmpty()) {
            this.writer.println(SUBSECTION_REMOTE_CHILDREN);
            for (Map.Entry<String, ValidationItemHandle> child : remoteChildren.entrySet()) {
                ValidationItemHandle value = child.getValue();
                this.writer.println("   " + value.getTypeString() + "/" + value.getItemId());
            }
        }
        this.writer.println(TERMINATOR);
        this.writer.println();
    }

    private void dumpProperties(PrintWriter writer, String title, Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        writer.println(title);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            writer.println("   " + entry.getKey() + " : " + entry.getValue());
        }
    }

    protected void dumpForwardInfo(String path, ForwardInfo info) {
        this.writer.println(SECTION_FORWARD_INFO);
        this.writer.println("path                : " + path);
        this.dumpForwardInfo(info);
        this.writer.println(TERMINATOR);
        this.writer.println();
    }

    private void dumpForwardInfo(ForwardInfo info) {
        this.writer.println("item ID             : " + info.getItemId());
        this.writer.println("state ID            : " + info.getStateId());
        this.writer.println("remote parent ID    : " + info.getRemoteParentId());
        this.writer.println("remote name         : " + info.getRemoteName());
        this.writer.println("local line delim    : " + info.getLocalLineDelimiter());
        this.writer.println("remote line delim   : " + info.getRemoteLineDelimiter());
        this.writer.println("local content type  : " + info.getLocalContentType());
        this.writer.println("remote content type : " + info.getRemoteContentType());
        this.writer.println("local size          : " + info.getLocalSize());
        this.writer.println("remote size         : " + info.getRemoteSize());
        this.writer.println("remote encoding     : " + info.getRemoteEncoding());
        this.writer.println("num line delimiters : " + info.getNumLineDelimiters());
        this.writer.println("remote executable   : " + info.isRemoteExecutable());
        this.writer.println("local executable    : " + info.isLocalExecutable());
        this.writer.println("content changed     : " + info.isContentChanged());
        this.writer.println("loaded with another name: " + info.isLoadedWithAnotherName());
        this.writer.println("last content change check stamp: " + info.getLastContentChangeCheckStamp());
        this.writer.println("hash                : " + info.getHash());
        this.writer.println("predecessor hint hash: " + info.getPredecessorHintHash());
        this.writer.println("stored hash         : " + info.getStoredHash());
        this.writer.println("item type           : " + info.getTypeString());
    }

    private void dumpInverseSharingInfo(ItemComponentConnection itemComponentConnection, String normalizedPath) {
        this.writer.println(SECTION_INVERSE_SHARING_INFO);
        this.writer.println("path              : " + normalizedPath);
        this.writer.println("item ID           : " + itemComponentConnection.getItemId());
        this.writer.println("component ID      : " + itemComponentConnection.getComponentId());
        this.writer.println("connection ID     : " + itemComponentConnection.getConnectionId());
        this.writer.println("connection type   : " + itemComponentConnection.getConnectionType());
        this.writer.println("connection type NS: " + itemComponentConnection.getConnectionTypeNS());
        this.writer.println(TERMINATOR);
        this.writer.println();
    }

    private void dumpSharingInfo(String path, ISharingDescriptor descriptor) {
        this.writer.println(SECTION_SHARING_INFO);
        this.writer.println("path                 : " + path);
        this.writer.println("component name       : " + descriptor.getComponentName());
        this.writer.println("connection name      : " + descriptor.getConnectionName());
        IComponentHandle component = descriptor.getComponent();
        this.writer.println("component item ID    : " + component.getItemId().getUuidValue());
        if (component.hasStateId()) {
            this.writer.println("component state ID   : " + component.getStateId().getUuidValue());
        }
        IContextHandle connectionHandle = descriptor.getConnectionHandle();
        this.writer.println("connection item ID   : " + connectionHandle.getItemId().getUuidValue());
        if (connectionHandle.hasStateId()) {
            this.writer.println("connection state ID  : " + connectionHandle.getStateId().getUuidValue());
        }
        this.writer.println("repository ID        : " + descriptor.getRepositoryId().getUuidValue());
        IVersionableHandle versionable = descriptor.getRootVersionable();
        this.writer.println("versionable item ID  : " + versionable.getItemId().getUuidValue());
        this.writer.println("versionable state ID : " + versionable.getStateId().getUuidValue());
        Map<String, byte[]> clientData = ((SharingDescriptor)descriptor).getClientData();
        if (clientData != null && clientData.size() > 0) {
            this.writer.println("----- client data -----");
            for (Map.Entry<String, byte[]> cd : clientData.entrySet()) {
                this.writer.println("   - " + cd.getKey() + " : " + new String(cd.getValue()));
            }
        }
        this.writer.println(TERMINATOR);
        this.writer.println();
    }

    private void dumpLocalConflictInfo(ItemComponentConnection key, LocalConflictsMapValidator.LocalConflictValue info) {
        this.writer.println(SECTION_LOCAL_CONCLICT);
        this.writer.println("path                   : " + info.getLocalPath().toString());
        this.writer.println("item ID                : " + key.getItemId());
        this.writer.println("component ID           : " + key.getComponentId());
        this.writer.println("connection ID          : " + key.getConnectionId());
        if (info.getSandbox() != null) {
            this.writer.println("sandbox              : " + info.getSandbox().toString());
        }
        if (info.getHandle() != null) {
            this.writer.println("versionable item ID  : " + info.getHandle().getItemId().getUuidValue());
            if (info.getHandle().getStateId() != null) {
                this.writer.println("versionable state ID : " + info.getHandle().getStateId().getUuidValue());
            }
        }
        if (info.getStateId() != null) {
            this.writer.println("before state ID      : " + info.getStateId().getUuidValue());
        }
        if (info.getDeleted() != null) {
            this.writer.println("deleted item ID      : " + info.getDeleted().getItemId().getUuidValue());
        }
        this.writer.println("is deletion           : " + info.isDeletion());
        this.writer.println("is mod conflict       : " + info.isModConflict());
        this.writer.println("is move conflict      : " + info.isMoveOrRenameConflict());
        this.writer.println("is property conflict  : " + info.isPropertyConflict());
        this.writer.println(TERMINATOR);
        this.writer.println();
    }
}

